/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.glcm.opatch.common.api.Utility;
import oracle.opatch.ArchiveAction;
import oracle.opatch.CopyAction;
import oracle.opatch.DeleteFile;
import oracle.opatch.JarAction;
import oracle.opatch.JarClassLoader;
import oracle.opatch.MakeAction;
import oracle.opatch.NameValuePair;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.SymbolFailureException;
import oracle.opatch.XMLConverter;
import oracle.opatch.ZipUtilities;
import oracle.opatch.napplyhelper.NApplyDataSerializer;
import oracle.opatch.opatchactions.DeleteAction;
import oracle.opatch.opatchactions.OrderedPatchAction;
import oracle.opatch.opatchlogger.OLogger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ActionsFileParser
extends DefaultHandler {
    protected LinkedList compList = new LinkedList();
    protected int lineNumber = 1;
    protected double actionNum = 0.0;
    protected JarClassLoader oextJarLoader = null;
    protected String patchFilesLocation = null;
    private File actionsFile = null;
    private InputStream actionsStream = null;
    private static HashMap pdtDirMap = new HashMap();
    private PatchObject pObject;
    private boolean isDirectory = false;

    private ActionsFileParser(JarClassLoader oextJarLoader, String patchFilesLocation, PatchObject pObject) {
        this.oextJarLoader = oextJarLoader;
        this.patchFilesLocation = patchFilesLocation;
        this.pObject = pObject;
    }

    public ActionsFileParser(File actionsFile, JarClassLoader oextJarLoader, String patchFilesLocation, PatchObject pObject) {
        this(oextJarLoader, patchFilesLocation, pObject);
        this.actionsFile = actionsFile;
    }

    public ActionsFileParser(InputStream actionsStream, JarClassLoader oextJarLoader, String patchFilesLocation, PatchObject pObject) {
        this(oextJarLoader, patchFilesLocation, pObject);
        this.actionsStream = actionsStream;
    }

    protected LinkedList parseActionsContent() throws RuntimeException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            if (this.actionsFile != null) {
                FileInputStream inputStream = new FileInputStream(this.actionsFile);
                InputStreamReader reader = new InputStreamReader(inputStream);
                InputSource is = new InputSource(reader);
                saxParser.parse(is, (DefaultHandler)this);
            } else if (this.actionsStream != null) {
                saxParser.parse(this.actionsStream, (DefaultHandler)this);
            }
        }
        catch (Exception e2) {
            if (e2 instanceof SymbolFailureException) {
                SymbolFailureException se = new SymbolFailureException("Failed to parse action.xml: " + this.actionsFile.getAbsolutePath() + e2.getMessage());
                se.setStackTrace(e2.getStackTrace());
                throw se;
            }
            StringBuilder errMsgBuff = new StringBuilder(this.actionsFile.getAbsolutePath());
            errMsgBuff.append(" with ").append(e2.getMessage());
            RuntimeException re = new RuntimeException(errMsgBuff.toString());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        return this.compList;
    }

    private String getDefaultCharEncoding() {
        byte[] bArray = new byte[]{119};
        ByteArrayInputStream is = new ByteArrayInputStream(bArray);
        InputStreamReader reader = new InputStreamReader(is);
        return reader.getEncoding();
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    public boolean isActionElement(String name) throws RuntimeException {
        if (name.equals("copy") || name.equals("jar") || name.equals("archive") || name.equals("make") || name.equals("delete") || name.equals("unzip")) {
            return true;
        }
        String className = name + "Action";
        Class<?> actionClass = null;
        try {
            actionClass = Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (actionClass == null) {
                try {
                    String classNamePath = "oracle.opatch.opatchactions." + className;
                    actionClass = Class.forName(classNamePath);
                    return true;
                }
                catch (ClassNotFoundException classNamePath) {
                    // empty catch block
                }
            }
            if (this.oextJarLoader != null && actionClass == null) {
                try {
                    actionClass = this.oextJarLoader.loadClass(className);
                    return true;
                }
                catch (ClassNotFoundException e2) {
                    return false;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("#text")) {
            ++this.lineNumber;
            return;
        }
        if (qName.equals("oneoff_actions")) {
            ++this.lineNumber;
            return;
        }
        if (this.isActionElement(qName)) {
            block146: {
                PatchComponent patchComp = (PatchComponent)this.compList.get(this.compList.size() - 1);
                if (patchComp.isFilter()) {
                    ++this.lineNumber;
                    return;
                }
                if (patchComp.hasSymbol() && OPatchEnv.isSymbolResolveEnabled() && pdtDirMap.get(patchComp) == null) {
                    throw new SAXException("OPatch gets null product directories for symbol " + patchComp.getSymbolName());
                }
                String[] productDirs = (String[])pdtDirMap.get(patchComp);
                ArrayList<String> attributeNames = new ArrayList<String>();
                ArrayList<String> attributeValues = new ArrayList<String>();
                ArrayList<NameValuePair> attributeNameValue = new ArrayList<NameValuePair>();
                int length = attributes.getLength();
                for (int i2 = 0; i2 < length; ++i2) {
                    String name = attributes.getQName(i2);
                    String value = attributes.getValue(i2);
                    NameValuePair nv = new NameValuePair(name, value);
                    attributeNameValue.add(nv);
                }
                StringBuffer rawEntry = new StringBuffer();
                if (!qName.equals("delete") && !qName.equals("unzip")) {
                    rawEntry.append("<");
                    rawEntry.append(qName);
                    rawEntry.append(" ");
                    for (int k2 = 0; k2 < attributeNameValue.size(); ++k2) {
                        String attrName = ((NameValuePair)attributeNameValue.get(k2)).getAttributeName();
                        rawEntry.append(attrName);
                        rawEntry.append("=\"");
                        String value = ((NameValuePair)attributeNameValue.get(k2)).getAttributeValue();
                        String tmp = XMLConverter.getXMLString(value);
                        rawEntry.append(tmp);
                        if (k2 == attributeNameValue.size() - 1) {
                            rawEntry.append("\" />");
                            continue;
                        }
                        rawEntry.append("\" ");
                    }
                }
                String argValue1 = "";
                String argValue2 = "";
                String argValue3 = "";
                String argValue4 = "";
                String argValue5 = "";
                String argValue6 = "";
                String hashValue = "";
                String argValue7 = "";
                String argValue8 = "";
                String argValue9 = "";
                String aName = qName;
                try {
                    if (aName.equals("copy")) {
                        boolean hasFileVersion = false;
                        for (int k3 = 0; k3 < attributeNameValue.size(); ++k3) {
                            NameValuePair nv = (NameValuePair)attributeNameValue.get(k3);
                            if (nv.getAttributeName().equals("name")) {
                                argValue1 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("path")) {
                                argValue2 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("file_name")) {
                                argValue3 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("update_timestamp")) {
                                argValue4 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("file_version")) {
                                hasFileVersion = true;
                                argValue5 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("diagnostic_string")) {
                                argValue6 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("retain_permission")) {
                                argValue7 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("app_dir")) {
                                argValue9 = nv.getAttributeValue();
                                continue;
                            }
                            if (!nv.getAttributeName().equals("shaolue")) continue;
                            hashValue = nv.getAttributeValue();
                        }
                        if (argValue4 == null || argValue4.equals("")) {
                            argValue4 = "false";
                        }
                        if (argValue7 == null || argValue7.equals("")) {
                            argValue7 = "true";
                        }
                        String applicationVersion = "";
                        String copyPath = argValue2;
                        if (this.pObject.getApplicationDirs().size() > 0) {
                            boolean isFirstAppVerDirExist = this.checkFirstAppVerDirExist(argValue9);
                            String string = applicationVersion = isFirstAppVerDirExist ? this.pObject.getApplicationVersion() : "";
                        }
                        if (OPatchEnv.isApplyOrNApplySession()) {
                            copyPath = copyPath.replace("%APP_DIR%", argValue9).replace("%VERSION%", applicationVersion);
                        } else {
                            applicationVersion = this.pObject.getCurrentAppVerDirs().get(argValue9);
                            if (applicationVersion != null && !"".equals(applicationVersion)) {
                                copyPath = copyPath.replace("%APP_DIR%", argValue9).replace("%VERSION%", applicationVersion);
                            }
                        }
                        if (patchComp.hasSymbol() && OPatchEnv.isSymbolResolveEnabled()) {
                            for (int i3 = 0; i3 < productDirs.length; ++i3) {
                                this.actionNum += 1.0;
                                CopyAction copyAction = new CopyAction(patchComp, argValue1, copyPath.replace("%SYMBOL%", productDirs[i3]), patchComp.getName() + File.separator + patchComp.getVersion() + File.separator + patchComp.getSymbolName() + File.separator + argValue3, this.lineNumber, Boolean.valueOf(argValue4), argValue5, argValue6, Boolean.valueOf(argValue7), hasFileVersion);
                                copyAction.setRawActionEntry(rawEntry.toString());
                                copyAction.setHashValue(hashValue);
                                copyAction.setOrder(this.actionNum);
                                patchComp.copyList.add(copyAction);
                            }
                        } else {
                            this.actionNum += 1.0;
                            CopyAction copyAction = new CopyAction(patchComp, argValue1, copyPath, argValue3, this.lineNumber, Boolean.valueOf(argValue4), argValue5, argValue6, Boolean.valueOf(argValue7), hasFileVersion);
                            copyAction.setRawActionEntry(rawEntry.toString());
                            copyAction.setHashValue(hashValue);
                            copyAction.setOrder(this.actionNum);
                            patchComp.copyList.add(copyAction);
                        }
                        break block146;
                    }
                    if (aName.equals("jar")) {
                        for (int k4 = 0; k4 < attributeNameValue.size(); ++k4) {
                            NameValuePair nv = (NameValuePair)attributeNameValue.get(k4);
                            if (nv.getAttributeName().equals("name")) {
                                argValue1 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("path")) {
                                argValue2 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("class_name")) {
                                argValue3 = nv.getAttributeValue();
                                continue;
                            }
                            if (!nv.getAttributeName().equals("shaolue")) continue;
                            hashValue = nv.getAttributeValue();
                        }
                        if (patchComp.hasSymbol()) {
                            for (int i4 = 0; i4 < productDirs.length; ++i4) {
                                this.actionNum += 1.0;
                                JarAction jarAction = new JarAction(patchComp, argValue1, argValue2.replace("%SYMBOL%", productDirs[i4]), patchComp.getName() + File.separator + patchComp.getVersion() + File.separator + patchComp.getSymbolName() + File.separator + argValue3, this.lineNumber);
                                if (patchComp.jarList.contains(jarAction)) {
                                    jarAction.setDuplicate(true);
                                }
                                patchComp.jarList.add(jarAction);
                                jarAction.setHashValue(hashValue);
                                jarAction.setOrder(this.actionNum);
                                jarAction.setRawActionEntry(rawEntry.toString());
                            }
                        } else {
                            this.actionNum += 1.0;
                            JarAction jarAction = new JarAction(patchComp, argValue1, argValue2, argValue3, this.lineNumber);
                            if (patchComp.jarList.contains(jarAction)) {
                                jarAction.setDuplicate(true);
                            }
                            patchComp.jarList.add(jarAction);
                            jarAction.setOrder(this.actionNum);
                            jarAction.setHashValue(hashValue);
                            jarAction.setRawActionEntry(rawEntry.toString());
                        }
                        break block146;
                    }
                    if (aName.equals("archive")) {
                        for (int k5 = 0; k5 < attributeNameValue.size(); ++k5) {
                            NameValuePair nv = (NameValuePair)attributeNameValue.get(k5);
                            if (nv.getAttributeName().equals("name")) {
                                argValue1 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("path")) {
                                argValue2 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("object_name")) {
                                argValue3 = nv.getAttributeValue();
                                continue;
                            }
                            if (!nv.getAttributeName().equals("shaolue")) continue;
                            hashValue = nv.getAttributeValue();
                        }
                        if (patchComp.hasSymbol()) {
                            for (int i5 = 0; i5 < productDirs.length; ++i5) {
                                this.actionNum += 1.0;
                                ArchiveAction archiveAction = new ArchiveAction(patchComp, argValue1, argValue2.replace("%SYMBOL%", productDirs[i5]), patchComp.getName() + File.separator + patchComp.getVersion() + File.separator + patchComp.getSymbolName() + File.separator + argValue3, this.lineNumber);
                                patchComp.archiveList.add(archiveAction);
                                archiveAction.setRawActionEntry(rawEntry.toString());
                                archiveAction.setHashValue(hashValue);
                                archiveAction.setOrder(this.actionNum);
                            }
                        } else {
                            this.actionNum += 1.0;
                            ArchiveAction archiveAction = new ArchiveAction(patchComp, argValue1, argValue2, argValue3, this.lineNumber);
                            patchComp.archiveList.add(archiveAction);
                            archiveAction.setRawActionEntry(rawEntry.toString());
                            archiveAction.setHashValue(hashValue);
                            archiveAction.setOrder(this.actionNum);
                        }
                        break block146;
                    }
                    if (aName.equals("make")) {
                        for (int k6 = 0; k6 < attributeNameValue.size(); ++k6) {
                            NameValuePair nv = (NameValuePair)attributeNameValue.get(k6);
                            if (nv.getAttributeName().equals("make_file")) {
                                argValue2 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("make_target")) {
                                argValue3 = nv.getAttributeValue();
                                continue;
                            }
                            if (!nv.getAttributeName().equals("change_dir")) continue;
                            argValue1 = nv.getAttributeValue();
                        }
                        if (patchComp.hasSymbol()) {
                            for (int i6 = 0; i6 < productDirs.length; ++i6) {
                                MakeAction makeAction = new MakeAction(patchComp, argValue1.replace("%SYMBOL%", productDirs[i6]), argValue2, argValue3, this.lineNumber);
                                patchComp.makeList.add(makeAction);
                                makeAction.setRawActionEntry(rawEntry.toString());
                            }
                        } else {
                            MakeAction makeAction = new MakeAction(patchComp, argValue1, argValue2, argValue3, this.lineNumber);
                            patchComp.makeList.add(makeAction);
                            makeAction.setRawActionEntry(rawEntry.toString());
                        }
                        break block146;
                    }
                    if (aName.equals("unzip")) {
                        NApplyDataSerializer serializer;
                        boolean hasFileVersion = false;
                        for (int k7 = 0; k7 < attributeNameValue.size(); ++k7) {
                            NameValuePair nv = (NameValuePair)attributeNameValue.get(k7);
                            if (nv.getAttributeName().equals("name")) {
                                argValue1 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("path")) {
                                argValue2 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("file_name")) {
                                argValue3 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("file_version")) {
                                hasFileVersion = true;
                                argValue4 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("retain_permission")) {
                                argValue5 = nv.getAttributeValue();
                                continue;
                            }
                            if (!nv.getAttributeName().equals("update_timestamp")) continue;
                            argValue6 = nv.getAttributeValue();
                        }
                        if (argValue6 == null || argValue6.equals("")) {
                            argValue6 = "false";
                        }
                        if (argValue5 == null || argValue5.equals("")) {
                            argValue5 = "true";
                        }
                        argValue2 = PatchObjectUtil.getPlatformDependentPath(argValue2);
                        argValue3 = PatchObjectUtil.getPlatformDependentPath(argValue3);
                        String applicationVersion = this.pObject.getApplicationVersion();
                        String dirPath = new String(argValue2);
                        dirPath = dirPath.equals("%ORACLE_HOME%") ? "" : (patchComp.hasSymbol() ? (dirPath.equals("%ORACLE_HOME%" + File.separator + "%SYMBOL%") ? "" : dirPath.replace("%ORACLE_HOME%" + File.separator, "").replace("%SYMBOL%" + File.separator, "")) : dirPath.replace("%ORACLE_HOME%" + File.separator, ""));
                        String folder = Long.toString(System.currentTimeMillis());
                        String parentLoc = OPatchEnv.getTmpUnzipLocation(folder);
                        String fileLoc = "";
                        if (patchComp.hasSymbol()) {
                            parentLoc = parentLoc + File.separator + patchComp.getName() + File.separator + patchComp.getVersion() + File.separator + patchComp.getSymbolName();
                            fileLoc = this.patchFilesLocation + File.separator + patchComp.getName() + File.separator + patchComp.getVersion() + File.separator + patchComp.getSymbolName() + File.separator + argValue3;
                        } else {
                            fileLoc = this.patchFilesLocation + File.separator + argValue3;
                        }
                        parentLoc = PatchObjectUtil.getPlatformDependentPath(parentLoc);
                        String unzipDir = "";
                        unzipDir = dirPath.equals("") ? parentLoc : parentLoc + File.separator + dirPath;
                        String zipFiles = OPatchEnv.getUnzipActionLocation() + File.separator + "zipfiles.txt";
                        File zipFile = new File(zipFiles);
                        String key = Utility.getSha1sum((File)new File(fileLoc));
                        if (patchComp.hasSymbol()) {
                            key = key + fileLoc.hashCode();
                        }
                        if (zipFile.exists()) {
                            serializer = new NApplyDataSerializer();
                            Map<String, String> fileContent = serializer.deserializeUnzipActionLoc(zipFiles);
                            if (fileContent.containsKey(key)) {
                                parentLoc = fileContent.get(key);
                                parentLoc = PatchObjectUtil.getPlatformDependentPath(parentLoc);
                                unzipDir = dirPath.equals("") ? parentLoc : parentLoc + File.separator + dirPath;
                            } else {
                                ZipUtilities.depressFiles(fileLoc, unzipDir);
                                HashMap<String, String> map = new HashMap<String, String>();
                                map.put(key, parentLoc);
                                serializer.serializeUnzipActionLoc(zipFiles, map);
                            }
                        } else {
                            serializer = new NApplyDataSerializer();
                            ZipUtilities.depressFiles(fileLoc, unzipDir);
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put(key, parentLoc);
                            serializer.serializeUnzipActionLoc(zipFiles, map);
                        }
                        ArrayList<String> fileNameList = this.getFiles(unzipDir, unzipDir + File.separator);
                        StringBuffer unzipRawEntry = new StringBuffer();
                        if (patchComp.hasSymbol() && OPatchEnv.isSymbolResolveEnabled()) {
                            parentLoc = parentLoc.replace(File.separator + patchComp.getName(), "").replace(File.separator + patchComp.getVersion(), "").replace(File.separator + patchComp.getSymbolName(), "");
                            for (int i7 = 0; i7 < productDirs.length; ++i7) {
                                for (String string : fileNameList) {
                                    String string2 = PatchObjectUtil.getPlatformDependentPath(string);
                                    String fileName = "";
                                    fileName = dirPath.equals("") ? string2 : dirPath + File.separator + string2;
                                    String middleDir = new String(string2);
                                    String unzipName = new String(string2);
                                    String path = new String(argValue2);
                                    int index = middleDir.lastIndexOf(File.separator);
                                    if (index != -1) {
                                        middleDir = middleDir.substring(0, index);
                                        unzipName = unzipName.substring(index + 1);
                                        path = path + File.separator + middleDir;
                                    }
                                    unzipRawEntry = this.getUnzipRawEntry(unzipName, path, fileName, argValue5, argValue4, argValue6);
                                    this.actionNum += 1.0;
                                    CopyAction unzipAction = new CopyAction(patchComp, unzipName, path.replace("%SYMBOL%", productDirs[i7]).replace("%VERSION%", applicationVersion), patchComp.getName() + File.separator + patchComp.getVersion() + File.separator + patchComp.getSymbolName() + File.separator + fileName, this.lineNumber, argValue4, Boolean.valueOf(argValue5), hasFileVersion, Boolean.valueOf(argValue6), parentLoc, true);
                                    unzipAction.setRawActionEntry(unzipRawEntry.toString());
                                    patchComp.copyList.add(unzipAction);
                                    unzipAction.setOrder(this.actionNum);
                                }
                            }
                        } else {
                            for (String string : fileNameList) {
                                void var37_118;
                                String string3 = PatchObjectUtil.getPlatformDependentPath(string);
                                String string4 = "";
                                if (dirPath.equals("")) {
                                    String string5 = string3;
                                } else {
                                    String string6 = dirPath + File.separator + string3;
                                }
                                String middleDir = new String(string3);
                                String unzipName = new String(string3);
                                int index = middleDir.lastIndexOf(File.separator);
                                String path = new String(argValue2);
                                if (index != -1) {
                                    middleDir = middleDir.substring(0, index);
                                    unzipName = unzipName.substring(index + 1);
                                    path = path + File.separator + middleDir;
                                }
                                unzipRawEntry = this.getUnzipRawEntry(unzipName, path, (String)var37_118, argValue5, argValue4, argValue6);
                                this.actionNum += 1.0;
                                CopyAction unzipAction = new CopyAction(patchComp, unzipName, path.replace("%VERSION%", applicationVersion), (String)var37_118, this.lineNumber, argValue4, Boolean.valueOf(argValue5), hasFileVersion, Boolean.valueOf(argValue6), parentLoc, true);
                                unzipAction.setRawActionEntry(unzipRawEntry.toString());
                                patchComp.copyList.add(unzipAction);
                                unzipAction.setOrder(this.actionNum);
                            }
                        }
                        break block146;
                    }
                    if (aName.equals("delete")) {
                        boolean hasFileVersion = false;
                        String passedValue = "";
                        for (int k8 = 0; k8 < attributeNameValue.size(); ++k8) {
                            NameValuePair nv = (NameValuePair)attributeNameValue.get(k8);
                            if (nv.getAttributeName().equals("name")) {
                                argValue1 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("path")) {
                                argValue2 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("opt_req")) {
                                argValue3 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("is_directory")) {
                                argValue5 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("is_oneway")) {
                                argValue7 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("file_version")) {
                                hasFileVersion = true;
                                argValue8 = nv.getAttributeValue();
                                continue;
                            }
                            if (nv.getAttributeName().equals("backup_in_zip")) {
                                argValue9 = nv.getAttributeValue();
                                continue;
                            }
                            if (!nv.getAttributeName().equals("is_passed")) continue;
                            passedValue = nv.getAttributeValue();
                        }
                        if (passedValue.equals("")) {
                            passedValue = "false";
                        }
                        if (argValue5 == null || argValue5.equals("")) {
                            argValue5 = "false";
                        }
                        if (argValue7 == null || argValue7.equals("")) {
                            argValue7 = "false";
                        }
                        if (argValue9 == null || argValue9.equals("")) {
                            argValue9 = "false";
                        }
                        boolean required = false;
                        if (argValue3 != null && !argValue3.equals("")) {
                            boolean bl = required = argValue3.equalsIgnoreCase("R");
                        }
                        if (argValue1 != "") {
                            argValue1 = PatchObjectUtil.getPlatformDependentPath(argValue1);
                        }
                        argValue2 = PatchObjectUtil.getPlatformDependentPath(argValue2);
                        boolean isDir = Boolean.valueOf(argValue5);
                        boolean isOneway = Boolean.valueOf(argValue7);
                        boolean backupZip = Boolean.valueOf(argValue9);
                        boolean isPassed = Boolean.valueOf(passedValue);
                        StringBuffer deleteRawEntry = null;
                        ArrayList<Object> fileNameList = new ArrayList();
                        if (isDir && !isPassed) {
                            String dstDir = OPatchEnv.getOracleHome();
                            if (patchComp.hasSymbol()) {
                                String dirInOH = new String(argValue2);
                                for (int i8 = 0; i8 < productDirs.length; ++i8) {
                                    dirInOH = dirInOH.replace("%ORACLE_HOME%" + File.separator, "").replace("%SYMBOL%", productDirs[i8]);
                                    dstDir = PatchObjectUtil.getPlatformDependentPath(dstDir);
                                    String rootDir = new String(dstDir + File.separator + productDirs[i8]);
                                    dstDir = dstDir + File.separator + dirInOH;
                                    if (!fileNameList.isEmpty() || fileNameList.size() != 0) {
                                        fileNameList.clear();
                                    }
                                    fileNameList = ActionsFileParser.getAllDeleteFiles(dstDir, rootDir + File.separator);
                                    for (DeleteFile deleteFile : fileNameList) {
                                        String fileName = deleteFile.getName();
                                        String middleDir = new String(fileName);
                                        argValue6 = fileName;
                                        int index = argValue6.lastIndexOf(new String(File.separator));
                                        if (index != -1) {
                                            if (!deleteFile.isDir()) {
                                                argValue6 = argValue6.substring(index + 1);
                                                middleDir = middleDir.substring(0, index);
                                                middleDir = "%ORACLE_HOME%" + File.separator + "%SYMBOL%" + File.separator + middleDir;
                                            } else {
                                                argValue6 = "";
                                                middleDir = "%ORACLE_HOME%" + File.separator + "%SYMBOL%" + File.separator + middleDir;
                                            }
                                        } else {
                                            middleDir = "%ORACLE_HOME%" + File.separator + "%SYMBOL%" + File.separator + middleDir;
                                            if (deleteFile.isDir()) {
                                                argValue6 = "";
                                            }
                                        }
                                        isDir = middleDir.equals(argValue2) && argValue6.equals("");
                                        fileName = patchComp.getName() + File.separator + patchComp.getVersion() + File.separator + patchComp.getSymbolName() + File.separator + fileName;
                                        deleteRawEntry = new StringBuffer();
                                        deleteRawEntry = this.getDeleteRawEntry(aName, argValue6, middleDir, isOneway, argValue3, argValue8, isDir, backupZip);
                                        this.actionNum += 1.0;
                                        DeleteAction deleteAction = new DeleteAction(patchComp, argValue6, middleDir.replace("%SYMBOL%", productDirs[i8]), required, fileName, isDir, argValue8, hasFileVersion, isOneway, backupZip, this.lineNumber);
                                        deleteAction.setRawActionEntry(deleteRawEntry.toString());
                                        patchComp.deleteList.add(deleteAction);
                                        deleteAction.setOrder(this.actionNum);
                                    }
                                }
                            } else {
                                String dirInOH = new String(argValue2);
                                dirInOH = dirInOH.replace("%ORACLE_HOME%" + File.separator, "");
                                dstDir = PatchObjectUtil.getPlatformDependentPath(dstDir);
                                String rootDir = new String(dstDir);
                                dstDir = dstDir + File.separator + dirInOH;
                                fileNameList = ActionsFileParser.getAllDeleteFiles(dstDir, rootDir + File.separator);
                                for (DeleteFile deleteFile : fileNameList) {
                                    String string;
                                    argValue6 = string = deleteFile.getName();
                                    String middleDir = new String(string);
                                    int index = argValue6.lastIndexOf(new String(File.separator));
                                    if (index != -1) {
                                        if (deleteFile.isDir()) {
                                            argValue6 = "";
                                            middleDir = "%ORACLE_HOME%" + File.separator + middleDir;
                                        } else {
                                            argValue6 = argValue6.substring(index + 1);
                                            middleDir = middleDir.substring(0, index);
                                            middleDir = "%ORACLE_HOME%" + File.separator + middleDir;
                                        }
                                    } else {
                                        middleDir = "%ORACLE_HOME%" + File.separator + middleDir;
                                        if (deleteFile.isDir()) {
                                            argValue6 = "";
                                        }
                                    }
                                    isDir = middleDir.equals(argValue2) && string.equals(dirInOH);
                                    deleteRawEntry = this.getDeleteRawEntry(aName, argValue6, middleDir, isOneway, argValue3, argValue8, isDir, backupZip);
                                    this.actionNum += 1.0;
                                    DeleteAction deleteAction = new DeleteAction(patchComp, argValue6, middleDir, required, string, isDir, argValue8, hasFileVersion, isOneway, backupZip, this.lineNumber);
                                    deleteAction.setRawActionEntry(deleteRawEntry.toString());
                                    patchComp.deleteList.add(deleteAction);
                                    deleteAction.setOrder(this.actionNum);
                                }
                            }
                        } else {
                            argValue4 = new String(argValue2);
                            argValue4 = argValue4.replace("%ORACLE_HOME%" + File.separator, "");
                            if (patchComp.hasSymbol()) {
                                for (int i9 = 0; i9 < productDirs.length; ++i9) {
                                    argValue4 = argValue4.replace("%SYMBOL%" + File.separator, "");
                                    argValue4 = patchComp.getName() + File.separator + patchComp.getVersion() + File.separator + patchComp.getSymbolName() + File.separator + argValue4 + File.separator + argValue1;
                                    deleteRawEntry = this.getDeleteRawEntry(aName, argValue1, argValue2, isOneway, argValue3, argValue8, false, backupZip);
                                    this.actionNum += 1.0;
                                    DeleteAction deleteAction = new DeleteAction(patchComp, argValue1, argValue2.replace("%SYMBOL%", productDirs[i9]), required, argValue4, isDir, argValue8, hasFileVersion, isOneway, backupZip, this.lineNumber);
                                    deleteAction.setRawActionEntry(deleteRawEntry.toString());
                                    patchComp.deleteList.add(deleteAction);
                                    deleteAction.setOrder(this.actionNum);
                                    deleteAction.setRawActionEntry(deleteRawEntry.toString());
                                    patchComp.deleteList.add(deleteAction);
                                    deleteAction.setOrder(this.actionNum);
                                }
                            } else {
                                this.actionNum += 1.0;
                                argValue4 = argValue4 + File.separator + argValue1;
                                deleteRawEntry = this.getDeleteRawEntry(aName, argValue1, argValue2, isOneway, argValue3, argValue8, false, backupZip);
                                DeleteAction deleteAction = new DeleteAction(patchComp, argValue1, argValue2, required, argValue4, isDir, argValue8, hasFileVersion, isOneway, backupZip, this.lineNumber);
                                deleteAction.setRawActionEntry(deleteRawEntry.toString());
                                deleteAction.setOrder(this.actionNum);
                                patchComp.deleteList.add(deleteAction);
                            }
                        }
                        break block146;
                    }
                    for (int k9 = 0; k9 < attributeNameValue.size(); ++k9) {
                        NameValuePair nv = (NameValuePair)attributeNameValue.get(k9);
                        attributeNames.add(nv.getAttributeName());
                        attributeValues.add(nv.getAttributeValue());
                    }
                    String className = aName + "Action";
                    Class<?> actionClass = null;
                    boolean externalClass = false;
                    try {
                        actionClass = Class.forName(className);
                    }
                    catch (ClassNotFoundException isDir) {
                        // empty catch block
                    }
                    if (actionClass == null) {
                        try {
                            String classNamePath = "oracle.opatch.opatchactions." + className;
                            actionClass = Class.forName(classNamePath);
                        }
                        catch (ClassNotFoundException classNamePath) {
                            // empty catch block
                        }
                    }
                    if (this.oextJarLoader != null && actionClass == null) {
                        actionClass = this.oextJarLoader.loadClass(className);
                        externalClass = true;
                    }
                    if (actionClass != null) {
                        Integer lineNumberObject = new Integer(this.lineNumber);
                        Class[] parameterTypes = new Class[]{patchComp.getClass(), attributeNames.getClass(), attributeValues.getClass(), lineNumberObject.getClass()};
                        Object[] parameterArgs = new Object[]{patchComp, attributeNames, attributeValues, lineNumberObject};
                        attributeNames.add("PATCH_FILES_LOCATION_TAG");
                        attributeValues.add(this.patchFilesLocation);
                        Constructor<?> newActionConst = actionClass.getConstructor(parameterTypes);
                        if (patchComp.hasSymbol()) {
                            for (int i10 = 0; i10 < productDirs.length; ++i10) {
                                for (int j2 = 0; j2 < attributeValues.size(); ++j2) {
                                    String value = attributeValues.get(j2).toString();
                                    String name = attributeNames.get(j2).toString();
                                    if (name.equals("file_name") || name.equals("filename") || name.equals("className")) {
                                        attributeValues.set(j2, patchComp.getName() + File.separator + patchComp.getVersion() + File.separator + patchComp.getSymbolName() + File.separator + value);
                                        continue;
                                    }
                                    if (!value.contains("%SYMBOL%")) continue;
                                    attributeValues.set(j2, value.replace("%SYMBOL%", productDirs[i10]));
                                }
                                this.actionNum += 1.0;
                                Object newAction = newActionConst.newInstance(parameterArgs);
                                if (!externalClass) {
                                    patchComp.pluginList.add(newAction);
                                    ((OrderedPatchAction)newAction).setOrder(this.actionNum);
                                } else {
                                    patchComp.externalPluginList.add(newAction);
                                }
                                ((PatchAction)newAction).setRawActionEntry(rawEntry.toString());
                            }
                        } else {
                            this.actionNum += 1.0;
                            Object newAction = newActionConst.newInstance(parameterArgs);
                            if (!externalClass) {
                                patchComp.pluginList.add(newAction);
                                ((OrderedPatchAction)newAction).setOrder(this.actionNum);
                            } else {
                                patchComp.externalPluginList.add(newAction);
                            }
                            ((PatchAction)newAction).setRawActionEntry(rawEntry.toString());
                        }
                        break block146;
                    }
                    StringBuffer buff = new StringBuffer("Class not found \"");
                    buff.append(className);
                    buff.append("\"");
                    ClassNotFoundException ce = new ClassNotFoundException(buff.toString());
                    throw ce;
                }
                catch (Exception e2) {
                    RuntimeException re = new RuntimeException(e2);
                    re.setStackTrace(e2.getStackTrace());
                    SAXException se = new SAXException(re);
                    se.setStackTrace(re.getStackTrace());
                    throw se;
                }
            }
            ++this.lineNumber;
        } else {
            if (attributes == null || attributes.getLength() == 0) {
                RuntimeException re = new RuntimeException("OPatch was not able to find any attributes for an expected component in actions file. Please check patch metadata.");
                throw new SAXException(re.getMessage());
            }
            String name = qName;
            String version = attributes.getValue("version");
            String requireStr = attributes.getValue("opt_req");
            if (version == null || version.equals("")) {
                RuntimeException re = new RuntimeException("Version field of the component \"" + qName + "\" in actions file cannot be <null> or empty. Please check patch metadata.");
                throw new SAXException(re.getMessage());
            }
            if (requireStr == null || requireStr.equals("")) {
                RuntimeException re = new RuntimeException("Required/Optional field of the component \"" + qName + "\" in actions file cannot be <null> or empty. Please check patch metadata.");
                throw new SAXException(re.getMessage());
            }
            boolean required = requireStr.equalsIgnoreCase("R");
            String symbol = attributes.getValue("symbol");
            String[] rawPatchComp = new String[2];
            StringBuffer sb = new StringBuffer();
            sb.append("<");
            sb.append(name);
            sb.append(" ");
            sb.append("version");
            sb.append("=\"");
            sb.append(version);
            sb.append("\"");
            sb.append(" ");
            sb.append("opt_req");
            sb.append("=\"");
            sb.append(requireStr);
            sb.append("\"");
            sb.append(" ");
            if (symbol != null && !symbol.equals("")) {
                sb.append("symbol");
                sb.append("=\"");
                sb.append(symbol);
                sb.append("\" ");
            }
            sb.append(">");
            rawPatchComp[0] = sb.toString();
            sb.delete(0, sb.capacity());
            sb.append("</");
            sb.append(name);
            sb.append(">");
            rawPatchComp[1] = sb.toString();
            PatchComponent patchComp = new PatchComponent(name, version, required);
            if (symbol != null && !symbol.equals("") && OPatchEnv.isSymbolResolveEnabled()) {
                try {
                    patchComp.setSymbolName(symbol);
                    if (!pdtDirMap.containsKey(patchComp)) {
                        String oracleHomePath = OPatchEnv.getOracleHome();
                        pdtDirMap.put(patchComp, patchComp.getProductDirectories(oracleHomePath));
                    } else {
                        patchComp.setProductDirectories((String[])pdtDirMap.get(patchComp));
                    }
                }
                catch (SymbolFailureException ex) {
                    patchComp.setSymbolName(null);
                    if (required) {
                        throw ex;
                    }
                    patchComp.setFilter(true);
                }
            }
            patchComp.setRawActionEntry(rawPatchComp);
            this.compList.add(patchComp);
            ++this.lineNumber;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!(qName.equals("#text") || qName.equals("oneoff_actions") || this.isActionElement(qName))) {
            ++this.lineNumber;
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
    }

    private ArrayList<String> getFiles(String directory, String rootDir) {
        File dir = new File(directory);
        File[] files = dir.listFiles();
        ArrayList<String> fileNameList = new ArrayList<String>();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    fileNameList.addAll(this.getFiles(file.toString(), rootDir));
                    continue;
                }
                String fileName = file.toString().replace(rootDir, "");
                fileNameList.add(fileName);
            }
        }
        if (rootDir.length() - dir.toString().length() != 1) {
            String direc = dir.toString().replace(rootDir, "");
            fileNameList.add(direc);
        }
        return fileNameList;
    }

    private static ArrayList<DeleteFile> getAllDeleteFiles(String directory, String rootDir) {
        File dir = new File(directory);
        File[] files = dir.listFiles();
        ArrayList<DeleteFile> fileNameList = new ArrayList<DeleteFile>();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    fileNameList.addAll(ActionsFileParser.getAllDeleteFiles(file.toString(), rootDir));
                    continue;
                }
                DeleteFile df = new DeleteFile();
                df.setName(file.toString().replace(rootDir, ""));
                df.setDir(false);
                fileNameList.add(df);
            }
        }
        if (rootDir.length() - directory.length() != 1) {
            DeleteFile df = new DeleteFile();
            df.setName(directory.replace(rootDir, ""));
            df.setDir(true);
            fileNameList.add(df);
        }
        return fileNameList;
    }

    private StringBuffer getDeleteRawEntry(String aName, String name, String path, boolean isOneway, String isReq, String fileVersion, boolean isDir, boolean backupZip) {
        StringBuffer deleteRawEntry = new StringBuffer();
        deleteRawEntry.append("<");
        deleteRawEntry.append(aName);
        deleteRawEntry.append(" ");
        if (name != "") {
            deleteRawEntry.append("name");
            deleteRawEntry.append("=\"");
            deleteRawEntry.append(name);
            deleteRawEntry.append("\" ");
        }
        if (fileVersion != null && !fileVersion.equals("")) {
            deleteRawEntry.append("file_version");
            deleteRawEntry.append("=\"");
            deleteRawEntry.append(fileVersion);
            deleteRawEntry.append("\" ");
        }
        deleteRawEntry.append("path");
        deleteRawEntry.append("=\"");
        deleteRawEntry.append(path);
        deleteRawEntry.append("\" ");
        deleteRawEntry.append("is_oneway");
        deleteRawEntry.append("=\"");
        deleteRawEntry.append(isOneway);
        deleteRawEntry.append("\" ");
        deleteRawEntry.append("is_directory");
        deleteRawEntry.append("=\"");
        deleteRawEntry.append(isDir);
        deleteRawEntry.append("\" ");
        if (isDir) {
            deleteRawEntry.append("is_passed");
            deleteRawEntry.append("=\"");
            deleteRawEntry.append(true);
            deleteRawEntry.append("\" ");
        }
        if (backupZip) {
            deleteRawEntry.append("backup_in_zip");
            deleteRawEntry.append("=\"");
            deleteRawEntry.append(backupZip);
            deleteRawEntry.append("\" ");
        }
        deleteRawEntry.append("opt_req");
        deleteRawEntry.append("=\"");
        deleteRawEntry.append(isReq);
        deleteRawEntry.append("\" />");
        return deleteRawEntry;
    }

    private StringBuffer getUnzipRawEntry(String name, String path, String fileName, String perm, String fileVersion, String timeStamp) {
        StringBuffer unzipRawEntry = new StringBuffer();
        unzipRawEntry.append("<");
        unzipRawEntry.append("copy ");
        unzipRawEntry.append("name");
        unzipRawEntry.append("=\"");
        unzipRawEntry.append(name);
        unzipRawEntry.append("\" ");
        unzipRawEntry.append("path");
        unzipRawEntry.append("=\"");
        unzipRawEntry.append(path);
        unzipRawEntry.append("\" ");
        unzipRawEntry.append("file_name");
        unzipRawEntry.append("=\"");
        unzipRawEntry.append(fileName);
        unzipRawEntry.append("\" ");
        unzipRawEntry.append("update_timestamp");
        unzipRawEntry.append("=\"");
        unzipRawEntry.append(timeStamp);
        unzipRawEntry.append("\" ");
        if (fileVersion != null && !fileVersion.equals("")) {
            unzipRawEntry.append("file_version");
            unzipRawEntry.append("=\"");
            unzipRawEntry.append(fileVersion);
            unzipRawEntry.append("\" ");
        }
        unzipRawEntry.append("retain_permission");
        unzipRawEntry.append("=\"");
        unzipRawEntry.append(perm);
        unzipRawEntry.append("\" />");
        return unzipRawEntry;
    }

    private boolean checkFirstAppVerDirExist(String appDir) {
        boolean isSparseCopyType;
        boolean bl = isSparseCopyType = this.pObject.getApplicationDirs().size() > 0;
        if (isSparseCopyType) {
            OLogger.justlog(OLogger.INFO, "ENTERING METHOD: PatchObject::checkFirstAppVerDirExist()");
            File appFile = new File(OPatchEnv.getOracleHome() + File.separator + appDir);
            OLogger.printlnOnLog("The application location is " + appFile.getAbsolutePath());
            if (appFile.exists()) {
                File latestPointerFile = OPatchEnv.getLatestFileWtihStartString(OPatchEnv.getOracleHome(), appDir, "latest-ptr-");
                if (latestPointerFile == null || !latestPointerFile.exists()) {
                    OLogger.printlnOnLog("The latest pointer file doesn't exists.");
                    return false;
                }
                OLogger.printlnOnLog("The latest pointer file is in " + latestPointerFile.getAbsolutePath());
                String fileName = latestPointerFile.getName();
                String firstAppVerDirName = fileName.substring("latest-ptr-".length());
                File firstAppVerFile = new File(appFile.getAbsolutePath() + File.separator + firstAppVerDirName);
                OLogger.printlnOnLog("The location of the first version directory is " + firstAppVerFile.getAbsolutePath());
                if (firstAppVerFile.exists()) {
                    OLogger.printlnOnLog("The first application version directory exists.");
                    return true;
                }
                OLogger.printlnOnLog("The first application version directory doesn't exist.");
                return false;
            }
            OLogger.printlnOnLog("The application directory doesn't exist.");
            return true;
        }
        return false;
    }
}

