/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import oracle.opatch.OPatchEnv;
import oracle.opatch.opatchlogger.OLogger;

public class Bug
implements Comparable,
Cloneable {
    private String id;
    private String description;
    private boolean base;

    private Bug() {
    }

    public Bug(String id, String description) {
        this.id = id;
        this.description = description;
        this.base = true;
    }

    public String getBugID() {
        return this.id;
    }

    public String getDesc() {
        return this.description;
    }

    public boolean isBase() {
        return this.base;
    }

    public void setBase(boolean b2) {
        this.base = b2;
    }

    public boolean equals(Object obj) {
        Bug b2 = (Bug)obj;
        return this.getBugID().equals(b2.getBugID());
    }

    public int compareTo(Object obj) {
        if (obj instanceof Bug) {
            String myID = this.getBugID();
            Bug bObj = (Bug)obj;
            String itsID = bObj.getBugID();
            long myNumericID = 0L;
            long itsNumericID = 0L;
            try {
                myNumericID = Long.parseLong(myID);
                itsNumericID = Long.parseLong(itsID);
            }
            catch (Exception e2) {
                OLogger.printStackTrace(e2);
            }
            int ret = 0;
            ret = myNumericID > itsNumericID ? 1 : (myNumericID < itsNumericID ? -1 : 0);
            String sortOption = OPatchEnv.getLsinv_bug_order();
            if (sortOption.compareToIgnoreCase("desc") == 0) {
                if (ret == 0) {
                    return 0;
                }
                if (ret == 1) {
                    return -1;
                }
                if (ret == -1) {
                    return 1;
                }
            } else {
                return ret;
            }
        }
        return -1;
    }

    public Object clone() {
        String id = this.id;
        String desc = this.description;
        boolean base = this.base;
        Bug bug = new Bug(id, desc);
        return bug;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("[Bug : id= ");
        buff.append(this.id);
        buff.append(", desc= ");
        buff.append(this.description);
        buff.append(", base= ");
        buff.append(this.base);
        buff.append("]");
        return buff.toString();
    }

    public static void main(String[] argv) {
        String id1 = "1";
        String id2 = "2";
        String id3 = "3";
        String d1 = "description 1";
        String d2 = "description 2";
        String d3 = "description 3";
        Bug b1 = new Bug(id1, d1);
        Bug b2 = new Bug(id2, d2);
        Bug b3 = new Bug(id3, d3);
        Bug[] bugs = new Bug[]{b1, b2, b3};
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < bugs.length; ++i2) {
            sb.delete(0, sb.length());
            Bug b4 = bugs[i2];
            sb.append("bug " + b4.getBugID() + ": ");
            sb.append(b4.toString());
            OLogger.debug(sb);
        }
    }
}

