/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import oracle.cluster.common.ClusterException;
import oracle.cluster.common.CommonFactory;
import oracle.cluster.common.ManageableEntityException;
import oracle.cluster.database.Database;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.util.NotExistsException;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OUIReplacer;
import oracle.opatch.PrereqSession;
import oracle.opatch.SystemCall;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.IPMUtil;
import oracle.opatch.ipm.InstalledComponent;
import oracle.opatch.opatchlogger.OLogger;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterOps;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Crs {
    private static String gridHome = "";
    private static ClusterwareInfo info = new ClusterwareInfo();
    private static Crs crsInstance = null;
    private static CrsType type = CrsType.NONE;
    private static HashMap<File, CrsType> homeMap = new HashMap();
    private IIPMReadServices readServices = null;

    private Crs(IIPMReadServices rs) {
        this.readServices = rs;
    }

    public static synchronized Crs getInstance(String runningOracleHome) throws NullPointerException {
        String ctrInvLoc;
        StringBuffer buff = new StringBuffer("Crs::getInstance() running from Oracle Home \"");
        buff.append(runningOracleHome);
        buff.append("\".");
        OLogger.debug(buff);
        if (crsInstance != null) {
            return crsInstance;
        }
        String invPtrLoc = OPatchEnv.getInvPtrLoc();
        boolean badInvPtrFlag = true;
        if (invPtrLoc != null && !invPtrLoc.equals("") && !(ctrInvLoc = OPatchEnv.getCentralInvLoc()).equals("n/a")) {
            badInvPtrFlag = false;
            System.setProperty("oracle.installer.custom_inventory", ctrInvLoc);
        }
        if (badInvPtrFlag) {
            throw new RuntimeException("Oralce Home's central inventory pointer location \"" + OPatchEnv.getUserSpecifiedInvPtrLoc() + "\" is not valid.");
        }
        String ouiLoc = runningOracleHome + File.separator + "oui";
        File ouiPath = new File(ouiLoc);
        if (!ouiPath.exists()) {
            throw new NullPointerException("The Oracle Home opatch runs from is not an OUI based home.");
        }
        try {
            type = Crs.getCrsType(runningOracleHome);
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            throw new RuntimeException("Failed to detect Grid Infrastructure.  " + e2.getMessage());
        }
        IIPMReadServices rs = null;
        if (type != CrsType.NONE && !OPatchEnv.isSrvmUtil()) {
            try {
                rs = PrereqSession.getReadServices(gridHome);
            }
            catch (Throwable t) {
                OLogger.printStackTrace(t);
                throw new RuntimeException("Failed to load home inventory for \"" + gridHome + "\"", t);
            }
        }
        crsInstance = new Crs(rs);
        return crsInstance;
    }

    public IIPMReadServices getGridHomeInventory() {
        return this.readServices;
    }

    public boolean isGridEnv() {
        return type != CrsType.NONE;
    }

    public CrsType getCrsType() {
        return type;
    }

    public String getGridHome() {
        return gridHome;
    }

    private static CrsType getCrsType(String runningOracleHome) throws InstallException {
        StringBuffer buff = new StringBuffer("Crs::getCrsType() called");
        OLogger.debug(buff);
        String ouiLoc = runningOracleHome + File.separator + "oui";
        CrsType crstype = CrsType.NONE;
        String olrLoc = OPatchEnv.getOLRLocation();
        if (OPatchEnv.isWindows() || new File(olrLoc).exists()) {
            if (info.isCRSConfigured(runningOracleHome)) {
                crstype = CrsType.CRS;
                gridHome = info.getCRSHome(new Version());
                homeMap.put(new File(gridHome), crstype);
            } else if (info.isHAConfigured(runningOracleHome)) {
                crstype = CrsType.SIHA;
                gridHome = info.getHAHome(ouiLoc);
                homeMap.put(new File(gridHome), crstype);
            }
        }
        if (crstype != CrsType.CRS && crstype != CrsType.SIHA) {
            try {
                IIPMReadServices readServices = PrereqSession.getReadServices(runningOracleHome);
                if (!readServices.isInventoryLoaded()) {
                    buff = new StringBuffer("Crs::getCrsType() could not load inventory");
                    OLogger.debug(buff);
                    throw new NullPointerException(buff.toString());
                }
                String gridHomeLoc = readServices.findGridHomeLocation();
                if (gridHomeLoc != null) {
                    gridHome = gridHomeLoc;
                    crstype = CrsType.SOFTWARE_INSTALLATION_ONLY;
                    homeMap.put(new File(gridHome), crstype);
                }
            }
            catch (NullPointerException e2) {
                buff = new StringBuffer("GIPatching cannot load inventory from the given Oracle Home.\n");
                buff.append("Possible causes are:\n");
                buff.append("    Oracle Home dir. path does not exist in Central Inventory\n");
                buff.append("    Oracle Home is a symbolic link\n");
                buff.append("    Oracle Home inventory is corrupted");
                throw new RuntimeException(buff.toString(), e2);
            }
            catch (Throwable e3) {
                OLogger.printStackTrace(e3);
                throw new RuntimeException(e3.getMessage(), e3);
            }
        }
        return crstype;
    }

    public CrsType getCrsTypeOfHome(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("Crs::getCrsTypeOfHome() called");
        OLogger.debug(buff);
        File ghome = new File(oracleHomePath);
        if (homeMap.get(ghome) != null) {
            buff = new StringBuffer("CrsType is in homeMap. It is ");
            buff.append((Object)homeMap.get(ghome));
            OLogger.debug(buff);
            return homeMap.get(ghome);
        }
        if (!this.readServices.isInventoryLoaded()) {
            throw new RuntimeException("Home inventory is not loaded.");
        }
        CrsType type = CrsType.NONE;
        if (this.readServices.isGridHome(oracleHomePath)) {
            type = CrsType.SOFTWARE_INSTALLATION_ONLY;
        }
        return type;
    }

    public String getCrsVersion() throws IllegalAccessException {
        if (type == CrsType.NONE) {
            throw new IllegalAccessException("No CRS Enviroment detected on current system.");
        }
        String version = "12.1.0.0.0";
        try {
            if (type == CrsType.CRS) {
                version = info.getCRSReleaseVersionString(gridHome);
            } else if (type == CrsType.SIHA) {
                version = info.getSIHAReleaseVersionString(gridHome);
            } else {
                InstalledComponent[] topComps = this.readServices.getTopLevelInstalledComponents();
                if (topComps.length < 1) {
                    throw new RuntimeException("No top-level component detected in current Oracle Home.");
                }
                version = topComps[0].getVersion();
            }
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
        }
        return version;
    }

    public static HashMap<String, String> getPatchingLevel(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("Crs::getPatchingLevel call");
        OLogger.debug(buff);
        try {
            OPatchSessionHelper.loadRACRelatedLibFile();
            OPatchSessionHelper.loadCRSRelatedLibFiles(oracleHomePath);
        }
        catch (RuntimeException e2) {
            throw new RuntimeException("Failed to load jlib files: " + e2.getMessage(), e2);
        }
        try {
            CommonFactory commonFac = CommonFactory.getInstance();
            oracle.cluster.common.Cluster cluster = commonFac.getCluster();
            HashMap levelMap = cluster.getPatchLevel();
            return levelMap;
        }
        catch (ClusterException e3) {
            RuntimeException re = new RuntimeException("CRS cluster exception happens : " + e3.getMessage());
            re.setStackTrace(e3.getStackTrace());
            OLogger.printStackTrace(e3);
            throw re;
        }
        catch (ManageableEntityException e4) {
            RuntimeException re = new RuntimeException("ManageableEntityException happens : " + e4.getMessage());
            re.setStackTrace(e4.getStackTrace());
            OLogger.printStackTrace(e4);
            throw re;
        }
    }

    public String getLocalNode() {
        int dotPos;
        String local = "";
        try {
            local = this.readServices.getLocalNode();
        }
        catch (Exception e2) {
            throw new RuntimeException("Failed to fetch the local node name by OUI.", e2);
        }
        if ((local == null || "".equals(local)) && (local = IPMUtil.getLocalHostName(false)) != null && (dotPos = local.indexOf(46)) != -1) {
            local = local.substring(0, dotPos);
        }
        return local;
    }

    public String[] getClusterNodeList(String oracleHomePath) {
        String localNode;
        String[] nodes;
        StringBuffer buff;
        block14: {
            buff = new StringBuffer("Crs::getClusterNodeList() called");
            OLogger.debug(buff);
            nodes = new String[]{};
            try {
                if (type != CrsType.CRS || !this.isStackRunning()) {
                    return nodes;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            localNode = "";
            try {
                HashMap nodeMap = info.getClusterNodeActiveRoles(gridHome);
                nodes = new String[nodeMap.keySet().size()];
                nodeMap.keySet().toArray(nodes);
                localNode = Cluster.getLocalNode();
            }
            catch (Exception e2) {
                throw new RuntimeException("Failed to retrieve the clusterware nodes.", e2);
            }
            try {
                if (new File(oracleHomePath).equals(new File(gridHome))) break block14;
                CommonFactory cf = CommonFactory.getInstance();
                oracle.cluster.common.Cluster cluster = cf.getCluster();
                List databases = null;
                try {
                    databases = cluster.fetchDatabases();
                }
                catch (NotExistsException notExistsException) {
                    // empty catch block
                }
                HashSet<String> filterNodes = new HashSet<String>();
                for (int i2 = 0; i2 < nodes.length; ++i2) {
                    if (!OiipgClusterOps.fileExistsOnNode((String)nodes[i2], (String)oracleHomePath)) continue;
                    filterNodes.add(nodes[i2]);
                }
                nodes = new String[filterNodes.size()];
                filterNodes.toArray(nodes);
                if (databases == null) break block14;
                for (Database sdb : databases) {
                    if (!new File(sdb.getOracleHome()).equals(new File(oracleHomePath))) continue;
                    if (!sdb.isClusterDatabase()) {
                        nodes = new String[]{};
                    }
                    break;
                }
            }
            catch (ManageableEntityException e3) {
                throw new RuntimeException("Failed to handle configured databases.", e3);
            }
            catch (OiipgRemoteOpsException e4) {
                throw new RuntimeException("Failed to detect if Oracle Home exists in specific node or not.", e4);
            }
        }
        NodeComparator nc = new NodeComparator();
        buff = new StringBuffer("Local node is \"" + localNode + "\"");
        OLogger.debug(buff);
        nc.setLocalNode(localNode.toLowerCase());
        buff = new StringBuffer("Detected nodes as below: \n");
        for (int i3 = 0; i3 < nodes.length; ++i3) {
            nodes[i3] = nodes[i3].toLowerCase();
            buff.append(nodes[i3] + " ");
        }
        OLogger.debug(buff);
        Arrays.sort(nodes, nc);
        return nodes;
    }

    public boolean isStackRunning() throws IllegalAccessException {
        boolean isStackRunning = false;
        switch (type) {
            case NONE: {
                throw new IllegalAccessException("No CRS Enviroment detected on current system.");
            }
            case CRS: 
            case SIHA: {
                isStackRunning = this.isClusterwareRunning(null);
                break;
            }
        }
        return isStackRunning;
    }

    public boolean isClusterwareRunning(String nodeName) throws IllegalAccessException {
        String localNode;
        boolean isRunning = false;
        if (type != CrsType.CRS && type != CrsType.SIHA) {
            throw new IllegalAccessException("There is no clusterware env detected on current platform.");
        }
        boolean isRoot = false;
        try {
            isRoot = OUIReplacer.isRootAccess(gridHome);
        }
        catch (Exception e1) {
            OLogger.printStackTrace(e1);
            throw new RuntimeException("Failed to check if user is root user.", e1);
        }
        if (nodeName != null && !nodeName.equalsIgnoreCase(localNode = this.getLocalNode()) && isRoot) {
            return SystemCall.isClusterwareUp(gridHome, nodeName);
        }
        String crsVerStr = this.getCrsVersion();
        Version crsV = null;
        try {
            crsV = Version.getVersion((String)crsVerStr);
        }
        catch (ConfigurationException e2) {
            throw new RuntimeException("Failed to get cluster version.", e2);
        }
        try {
            isRunning = nodeName != null && !nodeName.equals("") ? (type == CrsType.CRS ? info.isCRSRunning(gridHome, nodeName, crsV) : info.isHARunning(gridHome, nodeName)) : (type == CrsType.CRS ? info.isCRSRunning(gridHome, crsV) : info.isHARunning(gridHome));
        }
        catch (InstallException installException) {
            // empty catch block
        }
        return isRunning;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NodeComparator
    implements Comparator<String> {
        String localNode = "";

        NodeComparator() {
        }

        @Override
        public int compare(String node1, String node2) {
            if (node1.equalsIgnoreCase(this.localNode)) {
                return -1;
            }
            if (node2.equalsIgnoreCase(this.localNode)) {
                return 1;
            }
            return node1.compareTo(node2);
        }

        protected void setLocalNode(String localNode) {
            this.localNode = localNode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CrsType {
        NONE,
        CRS,
        SIHA,
        SOFTWARE_INSTALLATION_ONLY;

    }
}

