/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.util.ArrayList;
import oracle.opatch.OPatchSession;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.ops.EnvInfo;

public class DisableCasSession
extends OPatchSession {
    protected DisableCasSession(String name, boolean readOnly) {
        super(name, readOnly);
    }

    public void process() {
        EnvInfo info = new EnvInfo();
        ArrayList<File> casJars = info.getCasJars();
        if (null != casJars && !casJars.isEmpty()) {
            for (File jar : casJars) {
                int index;
                String oldName = jar.toString();
                if (jar.getName().startsWith(".") || (index = oldName.lastIndexOf(File.separator)) == -1) continue;
                String newName = oldName.substring(0, index) + File.separator + "." + jar.getName();
                File newFile = new File(newName);
                jar.renameTo(newFile);
                OLogger.justlog(OLogger.INFO, jar.toString() + " has been renamed to " + newName);
            }
        }
        OLogger.justlog(OLogger.INFO, "Complete disablecas.");
    }
}

