/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.util.ArrayList;
import oracle.opatch.OPatchSession;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.ops.EnvInfo;
import oracle.opatch.ops.Feature;
import oracle.opatch.ops.OPS;

public class EnableCasSession
extends OPatchSession {
    protected EnableCasSession(String name, boolean readOnly) {
        super(name, readOnly);
    }

    public void process() {
        EnvInfo info = new EnvInfo();
        ArrayList<File> casJars = info.getCasJars();
        if (null != casJars && !casJars.isEmpty()) {
            for (File jar : casJars) {
                int index;
                String oldName = jar.toString();
                if (!jar.getName().startsWith(".") || (index = oldName.lastIndexOf(File.separator)) == -1) continue;
                String newName = oldName.substring(0, index) + File.separator + jar.getName().substring(1, jar.getName().length());
                File newFile = new File(newName);
                jar.renameTo(newFile);
                OLogger.justlog(OLogger.INFO, jar.toString() + " has been renamed to " + newName);
            }
            OLogger.justlog(OLogger.INFO, " Complete enablecas.");
        } else if (OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
            OLogger.printlnOnLog(OLogger.INFO, " OPatch has already supported cas, no need to enablecas.");
        } else {
            String errMsg = " You are using opatch without cas version, cannot run enablecas.";
            OLogger.printOnConsole(errMsg);
            OLogger.justlog(OLogger.WARNING, errMsg);
            throw new RuntimeException(errMsg);
        }
    }
}

