/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import oracle.opatch.IOPatchSession;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchOverCAS;
import oracle.opatch.cas.CASBranchServices;
import oracle.opatch.opatchlogger.OLogger;

public class IsCasReposPresentSession
implements IOPatchSession {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(String oracleHome) {
        if (OPatchEnv.isHelp()) {
            this.displayHelp();
            return;
        }
        try {
            block6: {
                try {
                    OPatchOverCAS.INSTANCE.initializeCAS(oracleHome);
                    CASBranchServices cas = new CASBranchServices();
                    if (cas.isCasReposPresent()) {
                        CasReposOutput.GOOD.show();
                        break block6;
                    }
                    CasReposOutput.NON_EXIST.show();
                }
                catch (Throwable t) {
                    CasReposOutput.BAD.show();
                    Object var4_5 = null;
                    OPatchOverCAS.INSTANCE.cleanupCAS();
                }
            }
            Object var4_4 = null;
            OPatchOverCAS.INSTANCE.cleanupCAS();
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            OPatchOverCAS.INSTANCE.cleanupCAS();
            throw throwable;
        }
    }

    public void displayHelp() {
        StringBuffer helpM = new StringBuffer("\n");
        String helpFile = "";
        helpFile = "iscasrepospresent_help.txt";
        try {
            String thisLine;
            InputStream is = this.getClass().getResourceAsStream(helpFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((thisLine = br.readLine()) != null) {
                helpM.append(thisLine);
                helpM.append("\n");
            }
            OLogger.log(OLogger.INFO, helpM.toString());
            br.close();
            is.close();
        }
        catch (Exception e2) {
            String msg = OLogger.getString("OUI-67108", new Object[]{helpFile});
            OLogger.println(msg);
        }
    }

    public boolean isOUIBased() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CasReposOutput {
        NON_EXIST(77, "Cas repos does not exist."),
        BAD(55, "Cas repos is invalid."),
        GOOD(0, "Cas repos is validated.");

        private int exitCode;
        private String message;

        private CasReposOutput(int exitCode, String message) {
            this.exitCode = exitCode;
            this.message = message;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void show() {
            OPatchEnv.setOpatchExitCode(this.exitCode);
            OLogger.println(this.message);
        }
    }
}

