/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.opatch.CmdLineParser;
import oracle.opatch.HelpSession;
import oracle.opatch.IOPatchSession;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchProperty;
import oracle.opatch.OPatchSession;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.OUIReplacer;
import oracle.opatch.OnlinePatchException;
import oracle.opatch.StringResource;
import oracle.opatch.Version;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.opatch.ops.Feature;
import oracle.opatch.ops.OPS;
import oracle.sysman.oii.oiix.OiixPathOps;

public class OPatch {
    private static final String ohJavaPropertyOption = "OPatch.ORACLE_HOME";
    private static final String callerPropertyOption = "OPatch.CALLER";
    static final String ILLEGAL_ARGUMENT = "Illegal Argument: ";
    static final String ILLEGAL_ACCESS = "Illegal Access: ";
    static final String INVOCATION_EXCEPTION = "Invocation Exception: ";
    static final int ERROR = 1;
    static final int OK = 0;
    static final int OUI_VERSION_NOTAPPLICABLE_ERROR = 19;
    static String OHList = "";
    static boolean isOHList = false;

    private String getRecommendAction(int exitCode) {
        String recommendActionStr = "";
        String errorCodeStr = "";
        try {
            ResourceBundle rb = ResourceBundle.getBundle("oracle.opatch.OPatchErrorCodeRecommendMsgRes", Locale.getDefault());
            recommendActionStr = rb.getString(exitCode + "");
            return recommendActionStr;
        }
        catch (Exception e2) {
            recommendActionStr = "";
            try {
                InputStream is = this.getClass().getResourceAsStream("opatch_recommend_action.txt");
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String entry = null;
                while ((entry = br.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(entry, ":");
                    if (!st.hasMoreTokens() || exitCode != Integer.parseInt(errorCodeStr = st.nextToken()) || !st.hasMoreTokens()) continue;
                    recommendActionStr = st.nextToken();
                    recommendActionStr = recommendActionStr.trim();
                    break;
                }
                br.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return recommendActionStr;
        }
    }

    private String retrieveOPatchVersion() {
        String fileName = "version.txt";
        String ver = "n/a";
        try {
            InputStream is = this.getClass().getResourceAsStream("version.txt");
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String entry = null;
            while ((entry = br.readLine()) != null) {
                StringTokenizer st;
                if (!entry.startsWith("OPATCH_VERSION") || !(st = new StringTokenizer(entry, ":")).hasMoreTokens()) continue;
                st.nextToken();
                if (!st.hasMoreTokens()) continue;
                ver = st.nextToken();
                ver = ver.trim();
                break;
            }
            br.close();
        }
        catch (Throwable t) {
            StringBuffer buff = new StringBuffer("OPatchEnv::getOPatchVersion() cannot read embed version file " + fileName);
            OLogger.debug(buff);
        }
        return ver;
    }

    protected static void setupEnvironment(String oracleHomePath) {
        StringBuffer ouiLocation = null;
        String cmdOuiLocation = System.getProperty("OPatch.OUI_LOCATION");
        if (cmdOuiLocation == null || cmdOuiLocation.trim().length() == 0) {
            ouiLocation = new StringBuffer(oracleHomePath);
            ouiLocation.append(File.separator);
            ouiLocation.append("oui");
        } else {
            ouiLocation = new StringBuffer(cmdOuiLocation);
        }
        System.setProperty("oracle.installer.oui_loc", ouiLocation.toString());
        System.setProperty("oracle.installer.startup_location", ouiLocation.toString());
        String sLibraryLoc = OiixPathOps.concatPath((String)ouiLocation.toString(), (String)"lib");
        String dirName = OUIReplacer.Platform.getCurrentPlatformDirectoryName();
        sLibraryLoc = OiixPathOps.concatPath((String)sLibraryLoc, (String)dirName);
        sLibraryLoc = OiixPathOps.getNativeForm((String)sLibraryLoc);
        System.setProperty("oracle.installer.library_loc", sLibraryLoc);
        OPatchProperty dummy = new OPatchProperty();
        Properties userProp = dummy.getUserProperty();
        Properties bundledProp = dummy.getBundledProperty();
        Properties mergedProp = OPatchProperty.mergeProperties(userProp, bundledProp);
        OPatchEnv.setOPatchProperties(mergedProp);
    }

    private static void catReleaseDate() {
        String debug = System.getProperties().getProperty("OPatch.DEBUG");
        if (debug != null && debug.equalsIgnoreCase("true")) {
            StringBuffer releaseDate = new StringBuffer("Internal Release Date: ");
            releaseDate.append(Version.getReleaseDate());
            System.out.println(releaseDate.toString());
            StringBuffer hasCasVersion = null;
            hasCasVersion = OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS) ? new StringBuffer("This version of OPatch has CAS.") : new StringBuffer("This version of OPatch has no CAS.");
            System.out.println(hasCasVersion.toString());
        }
    }

    public static void process(String[] args) throws Throwable {
        String oracleHomePath;
        IOPatchSession isession;
        HelpSession INIT;
        block63: {
            String OH;
            OPatch opatch = new OPatch();
            INIT = new HelpSession();
            isession = null;
            oracleHomePath = null;
            String originalCmd = "";
            String commandName = "";
            StringBuffer opatchVersion = new StringBuffer("");
            opatchVersion.append(INIT.getVersion());
            Properties properties = System.getProperties();
            String CALLER = properties.getProperty(callerPropertyOption);
            if (args != null && args.length >= 1) {
                commandName = args[0];
            }
            if (args != null && args.length >= 1) {
                StringBuffer cmdArg = new StringBuffer();
                for (int i2 = 0; i2 < args.length; ++i2) {
                    cmdArg.append(args[i2]).append(" ");
                }
                originalCmd = cmdArg.toString();
                boolean simpleVersionCmd = true;
                boolean versionCmdWithOpt = false;
                for (int i3 = 0; i3 < args.length; ++i3) {
                    if (!args[i3].startsWith("-") || args[i3].length() <= 1) continue;
                    String subArg = args[i3].substring(1);
                    if (subArg.equals("all") || subArg.equals("help") || subArg.equals("h") || subArg.equals("ohs") || subArg.equals("ph") || subArg.equals("v2c")) {
                        simpleVersionCmd = false;
                        continue;
                    }
                    if (!subArg.equals("verbose")) continue;
                    versionCmdWithOpt = true;
                }
                if (args[0].equals("version") && simpleVersionCmd) {
                    StringBuffer version = new StringBuffer("OPatch Version: ");
                    String releaseDate = Version.getReleaseDate();
                    version.append(opatch.retrieveOPatchVersion());
                    String debug = System.getProperties().getProperty("OPatch.DEBUG");
                    if (versionCmdWithOpt || debug != null && debug.equalsIgnoreCase("true")) {
                        version.append("\nOPatch Build Number: ");
                        version.append(Version.getBuildNumber());
                    }
                    System.out.println(version.toString());
                    OPatch.catReleaseDate();
                    System.exit(0);
                }
            }
            if ((OH = properties.getProperty(ohJavaPropertyOption)) != null) {
                oracleHomePath = OH;
            }
            StringBuffer option = new StringBuffer("-");
            option.append("oh");
            String optionOH = option.toString();
            option = new StringBuffer("-");
            option.append("invptrloc");
            String optionInvPtrLoc = option.toString();
            String invPtrLoc = "";
            if (args != null) {
                for (int i4 = 0; i4 < args.length; ++i4) {
                    String arg = args[i4];
                    if (arg == null) continue;
                    if (arg.equals(optionOH)) {
                        String oh;
                        if (i4 + 1 >= args.length || (oh = args[i4 + 1]) == null) continue;
                        if (oh.indexOf(",") != -1) {
                            isOHList = true;
                            OHList = oh;
                            oracleHomePath = oh.split(",")[0].trim();
                        } else {
                            oracleHomePath = oh;
                        }
                        System.setProperty(ohJavaPropertyOption, oracleHomePath);
                        continue;
                    }
                    if (!arg.equalsIgnoreCase(optionInvPtrLoc) || i4 + 1 >= args.length) continue;
                    invPtrLoc = args[i4 + 1];
                }
            }
            if (oracleHomePath == null || oracleHomePath.equals("")) {
                System.out.println("OPatch cannot obtain the ORACLE_HOME value, exiting.");
                System.out.println("(Please set ORACLE_HOME in the environment or use -oh option)");
                System.exit(1);
            }
            if (OPS.INSTANCE.getSupportServices().isSupport(Feature.OUI_BASED)) {
                int i5;
                Vector resDetails;
                PrereqResult resObj;
                PrereqAPI.isNextGenOracleHome(oracleHomePath);
                if (args != null) {
                    boolean customLogFlag = false;
                    for (int argIndex = 0; argIndex < args.length; ++argIndex) {
                        if (!args[argIndex].equalsIgnoreCase("-customLogDir")) continue;
                        if (argIndex + 1 < args.length && !args[argIndex + 1].startsWith("-")) {
                            File custDir;
                            String dirVal = args[argIndex + 1];
                            if (dirVal == null || dirVal.equals("")) {
                                System.out.println("Invalid value for custom log directory");
                                System.exit(1);
                            }
                            if ((custDir = new File(dirVal)).exists() && custDir.isDirectory()) {
                                OPatchEnv.setCustomLogDir(custDir.getAbsolutePath());
                                customLogFlag = true;
                                continue;
                            }
                            System.out.println("Input custom log directory \"" + dirVal + "\" does not exists or not a valid directory.");
                            System.exit(1);
                            continue;
                        }
                        System.out.println("No value provided for custom Log Directory.");
                        System.exit(1);
                    }
                    if (!(!customLogFlag || args[0].equals("-help") || args[0].equals("-h") || args[0].equals("prereq") || args[0].equals("lsinventory") || args[0].equals("lsinv") || args[0].equals("lspatches") || args[0].equals("query"))) {
                        System.out.println("The Option \"-customLogDir\" is supported for prereq, query, lsinventory, and -help only.");
                        System.exit(1);
                    }
                }
                if (invPtrLoc != null && !invPtrLoc.equals("")) {
                    OPatchEnv.setInvPtrLoc(invPtrLoc);
                }
                if ((resObj = PrereqAPI.checkJDKCompatibleOUI(oracleHomePath)).getResult() == PrereqResult.ExecuteStatus.FAILED) {
                    Vector resDetails2 = resObj.getResultDetails();
                    for (int i6 = 0; i6 < resDetails2.size(); ++i6) {
                        System.out.println((String)resDetails2.get(i6));
                    }
                    System.exit(1);
                }
                OPatch.setupEnvironment(oracleHomePath);
                try {
                    boolean isRoot = OUIReplacer.isRootAccess(oracleHomePath);
                    if (isRoot) {
                        System.out.println("The user is root. OPatch cannot continue if the user is root.");
                        System.exit(255);
                    }
                }
                catch (Exception e1) {
                    OLogger.println("Could not check if user is root. " + e1.getMessage());
                    OLogger.printStackTrace(e1);
                    System.exit(255);
                }
                OPatchEnv.setOriginalCommand(originalCmd);
                PrereqResult result = PrereqAPI.isOHPathOK(oracleHomePath);
                if (result.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                    resDetails = result.getResultDetails();
                    for (i5 = 0; i5 < resDetails.size(); ++i5) {
                        System.out.println((String)resDetails.get(i5));
                    }
                    System.exit(1);
                }
                if (!OPatchEnv.isObrepo() && (result = PrereqAPI.isOUIVersionApplicableForOPatch(opatch.retrieveOPatchVersion(), oracleHomePath)).getResult() == PrereqResult.ExecuteStatus.FAILED) {
                    resDetails = result.getResultDetails();
                    for (i5 = 0; i5 < resDetails.size(); ++i5) {
                        System.out.println((String)resDetails.get(i5));
                    }
                    System.exit(19);
                }
                OPatchSessionHelper.updateHistoryFile(oracleHomePath, args);
            }
            if (!commandName.equals("lspatches")) {
                OLogger.printlnres("OUI-67089", new Object[]{INIT.getVersion(), OLogger.getString("OUI-67213", new Object[]{StringResource.COPY_RIGHT_YEAR})});
            }
            try {
                OPatchACL.invokeOLogger(INIT, "initJavaLogger", new Object[]{oracleHomePath, "INFO", "INFO"});
            }
            catch (Exception resObj) {
                // empty catch block
            }
            try {
                if (args.length < 1) {
                    try {
                        OPatchACL.invokeOLogger(INIT, "enableConsoleOutput", null);
                    }
                    catch (Exception resObj) {
                        // empty catch block
                    }
                    OLogger.error("OUI-67014", new Object[]{"No command specified."});
                    INIT.process();
                    return;
                }
                String tempOracleHome = "";
                isession = CmdLineParser.parse(args);
            }
            catch (OnlinePatchException e2) {
                OPatchStateManagerFactory.getInstance().returnToNonChangeState();
                OLogger.println(e2.getMessage());
                OPatchEnv.setOpatchExitCode(OnlinePatchException.getErrorCode());
                throw e2;
            }
            catch (RuntimeException e3) {
                boolean isObrepo;
                if (e3.getMessage().contains(OLogger.getString("OUI-68011"))) {
                    throw e3;
                }
                OLogger.error("OUI-67014", new Object[]{e3.getMessage()});
                String sessionName = OPatchSession.getSessionNameString(args[0]);
                StringBuffer sessionStr = new StringBuffer(" " + sessionName);
                if (OPatchEnv.isBeaHome() && (sessionName.equals("apply") || sessionName.equals("rollback")) && (OPatchEnv.getisAuto() || OPatchEnv.getFMWDomainName() != null)) {
                    sessionStr.append("-fmw");
                }
                String scriptName = (isObrepo = Boolean.parseBoolean(System.getProperties().getProperty("OPatch.OBREPO"))) ? "obrepo" : "opatch";
                OLogger.log(OLogger.INFO, "Please use the option '" + scriptName + sessionStr.toString() + " -help' to get correct syntax");
                if (!OPatchEnv.isOPatchSDKMode()) break block63;
                try {
                    OPatchACL.invokeOLogger(INIT, "enableConsoleOutput", null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e3;
            }
        }
        if (OPatchEnv.isSyntaxError()) {
            OLogger.error("OUI-67014", new Object[]{OPatchEnv.getSyntaxErrorMsg()});
            String sessionName = OPatchSession.getSessionNameString(args[0]);
            StringBuffer sessionStr = new StringBuffer(" " + sessionName);
            if ((sessionName.equals("apply") || sessionName.equals("rollback")) && (OPatchEnv.getisAuto() || OPatchEnv.getFMWDomainName() != null)) {
                sessionStr.append(" ");
                sessionStr.append("-fmw");
                sessionStr.append(" ");
            }
            if (sessionName.equals("lspatches")) {
                OPatchEnv.setOpatchExitCode(2);
            }
            boolean isObrepo = Boolean.parseBoolean(System.getProperties().getProperty("OPatch.OBREPO"));
            if (sessionName.equals("lspatches") && !isObrepo) {
                OPatchEnv.setOpatchExitCode(2);
            }
            String scriptName = isObrepo ? "obrepo" : "opatch";
            OLogger.log(OLogger.INFO, "Please use the option '" + scriptName + sessionStr.toString() + " -help' to get correct syntax");
            if (OPatchEnv.isOPatchSDKMode()) {
                try {
                    OPatchACL.invokeOLogger(INIT, "enableConsoleOutput", null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            throw new UnsupportedOperationException(OLogger.getString("OUI-67014", new Object[]{OPatchEnv.getSyntaxErrorMsg()}));
        }
        if (OPatchEnv.isArgumentError()) {
            OLogger.error("OUI-67135", new Object[]{OPatchEnv.getArgumentErrorMsg()});
            OLogger.log(OLogger.INFO, "Please check the arguments and try again.");
            if (OPatchEnv.isOPatchSDKMode()) {
                try {
                    OPatchACL.invokeOLogger(INIT, "enableConsoleOutput", null);
                }
                catch (IllegalAccessException sessionName) {
                    // empty catch block
                }
            }
            throw new UnsupportedOperationException(OLogger.getString("OUI-67135", new Object[]{OPatchEnv.getArgumentErrorMsg()}));
        }
        if (isession == null) {
            INIT.process();
            return;
        }
        if (isession.isOUIBased()) {
            try {
                OPatchSession.process(isession, args);
            }
            catch (InvocationTargetException e4) {
                System.out.println(INVOCATION_EXCEPTION + e4.getMessage());
                throw e4;
            }
            catch (IllegalAccessException e5) {
                System.out.println(ILLEGAL_ACCESS + e5.getMessage());
                throw e5;
            }
            catch (IllegalArgumentException e6) {
                System.out.println(ILLEGAL_ARGUMENT + e6.getMessage());
                throw e6;
            }
        } else {
            if (OPS.INSTANCE.getSupportServices().isSupport(Feature.OUI_BASED)) {
                OPatchEnv.printOPatchHeader();
            }
            isession.process(oracleHomePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        OPatch opatch;
        int exitCode;
        block14: {
            exitCode = 0;
            opatch = new OPatch();
            try {
                try {
                    OPatch.process(args);
                }
                catch (Throwable t) {
                    try {
                        OLogger.printStackTrace(t);
                    }
                    catch (Throwable tlog) {
                        t.printStackTrace();
                    }
                    exitCode = OPatchEnv.getOpatchExitCode();
                    if (exitCode == 0) {
                        exitCode = 255;
                    }
                    Object var6_4 = null;
                    if (!OPatchEnv.isSrvmUtil()) {
                        OPatchSessionHelper.cleanupPatchUnzipArea();
                        OPatchSessionHelper.cleanupUnzipActionArea();
                    }
                    break block14;
                }
                Object var6_3 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (!OPatchEnv.isSrvmUtil()) {
                    OPatchSessionHelper.cleanupPatchUnzipArea();
                    OPatchSessionHelper.cleanupUnzipActionArea();
                }
                throw throwable;
            }
            if (!OPatchEnv.isSrvmUtil()) {
                OPatchSessionHelper.cleanupPatchUnzipArea();
                OPatchSessionHelper.cleanupUnzipActionArea();
            }
        }
        if (exitCode == 0) {
            exitCode = OPatchEnv.getOpatchExitCode();
        }
        if (exitCode != 0 && OPatchStateManagerFactory.getInstance().getCurrentState().getStateOrder() != 0 && !OPatchEnv.isExitWithUserReq() && !opatch.getRecommendAction(exitCode).equals("")) {
            StringBuffer recommendBuff = new StringBuffer("\nRecommended actions: ");
            recommendBuff.append(opatch.getRecommendAction(exitCode));
            OLogger.println(recommendBuff.toString());
        }
        try {
            OPatchACL.invokeOLogger(opatch, "closeLogFile", null);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        System.exit(exitCode);
    }
}

