/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.util.HashMap;
import oracle.opatch.ExitOPatchException;
import oracle.opatch.NotSupportedOPatchCASOperationException;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchOverCASUtil;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.PatchObject;
import oracle.opatch.cas.CASFileServices;
import oracle.opatch.cas.CASIntegrityServices;
import oracle.opatch.ipm.IIPMRWServices;
import oracle.opatch.ipm.IPM;
import oracle.opatch.napplyhelper.NApplyData;
import oracle.opatch.opatchactions.DeleteAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchsdk.FailedPrereqException;
import oracle.opatch.opatchsdk.OPatchPatchPrereq;
import oracle.opatch.opatchsdk.OPatchTarget;
import oracle.opatch.opatchutil.NApply;
import oracle.opatch.opatchutil.OPatchUtilHelper;
import oracle.opatch.opatchutil.OUSession;
import oracle.opatch.ops.Feature;
import oracle.opatch.ops.OPS;
import oracle.opatch.twophase.ExitTwoPhaseException;
import oracle.opatch.twophase.TwoPhaseOperations;
import oracle.opatch.twophase.TwoPhasePatching;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OPatchOverCAS {
    INSTANCE;

    private boolean init = false;
    private String oh = OPatchEnv.getOracleHome();

    public void initializeCAS(String oracleHomePath) {
        OLogger.debug("ENTERING METHOD: OPatchOverCAS::initializeCAS(String oracleHomePath)");
        CASFileServices cas = new CASFileServices();
        cas.initialize(oracleHomePath);
        OLogger.debug("EXITING METHOD: OPatchOverCAS::initializeCAS(String oracleHomePath)");
    }

    public void cleanupCAS() {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: OPatchOverCAS::cleanupCAS()");
        CASFileServices cas = new CASFileServices();
        cas.getWarnings();
        cas.cleanup();
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: OPatchOverCAS::cleanupCAS()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void prepareTwoPhasePatching(TwoPhaseOperations op) throws ExitTwoPhaseException, NotSupportedOPatchCASOperationException, Exception {
        block24: {
            OLogger.justlog(OLogger.INFO, "ENTERING METHOD: OPatchOverCAS::prepareTwoPhasePatching with operation " + (Object)((Object)op));
            if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
                NotSupportedOPatchCASOperationException re = new NotSupportedOPatchCASOperationException(OLogger.getString("OUI-68200"));
                throw re;
            }
            TwoPhasePatching tp = new TwoPhasePatching();
            CASIntegrityServices cis = new CASIntegrityServices();
            PatchObject[] rollbackPatches = null;
            PatchObject[] applyPatches = null;
            if (op == TwoPhaseOperations.NAPPLY) {
                boolean isSilent;
                boolean isReport;
                NApplyData data;
                block23: {
                    OLogger.justlog(OLogger.INFO, "Started to run NApply Report.");
                    data = new NApplyData();
                    isReport = OPatchEnv.isReport();
                    isSilent = OPatchEnv.isSilent();
                    OPatchEnv.setReport(true);
                    OPatchEnv.setSilent(true);
                    boolean isConsoleOutputDisabled = OLogger.isConsoleOutputDisabled();
                    if (!isConsoleOutputDisabled) {
                        OLogger.disableConsoleOutput(true);
                    }
                    try {
                        try {
                            data = NApply.legacy_process(this.oh);
                        }
                        catch (FailedPrereqException fpe) {
                            fpe.printStackTrace();
                            throw fpe;
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                            Object var12_16 = null;
                            if (isConsoleOutputDisabled) break block23;
                            if (OPatchEnv.isVerbose()) {
                                OLogger.enableConsoleOutput(OLogger.FINE, true);
                                break block23;
                            } else {
                                OLogger.enableConsoleOutput(OLogger.INFO, true);
                            }
                            break block23;
                        }
                        Object var12_15 = null;
                        if (isConsoleOutputDisabled) break block23;
                    }
                    catch (Throwable throwable) {
                        Object var12_17 = null;
                        if (isConsoleOutputDisabled) throw throwable;
                        if (OPatchEnv.isVerbose()) {
                            OLogger.enableConsoleOutput(OLogger.FINE, true);
                            throw throwable;
                        }
                        OLogger.enableConsoleOutput(OLogger.INFO, true);
                        throw throwable;
                    }
                    if (OPatchEnv.isVerbose()) {
                        OLogger.enableConsoleOutput(OLogger.FINE, true);
                    } else {
                        OLogger.enableConsoleOutput(OLogger.INFO, true);
                    }
                }
                OLogger.justlog(OLogger.INFO, "Finished NApply Report, get a list of auto-rollback patches and to-apply patches.");
                if (!this.checkIfPrereqsPassed()) {
                    throw new ExitTwoPhaseException("Some prereqs failed, do not proceed to two-phase patching. ");
                }
                if (data != null) {
                    applyPatches = data.getApPatchObjects();
                    rollbackPatches = data.getArbPatchObjects();
                    OLogger.justlog(OLogger.INFO, "There are " + rollbackPatches.length + " patches to be auto-rollback.");
                    OLogger.justlog(OLogger.INFO, "There are " + applyPatches.length + " patches to be applied.");
                    OPatchEnv.setReport(isReport);
                    OPatchEnv.setSilent(isSilent);
                    if (!OPatchEnv.isOPatchSDKMode()) {
                        DeleteAction.getDoneDeleteActVer().clear();
                    }
                    if (rollbackPatches.length == 0 && applyPatches.length == 0) {
                        throw new ExitTwoPhaseException("There are no patches for OPatch to continue, do not proceed to two-phase patching. ");
                    }
                    OPatchOverCASUtil.validateScripts(this.oh, rollbackPatches, applyPatches);
                    OLogger.println(OLogger.getString("OUI-67910"));
                    OLogger.println("OPatch continues with these patches: " + data.getFinalList());
                    if (!OPatchEnv.proceedWithOperationDefaultYes(new StringBuffer())) {
                        StringBuffer buff = new StringBuffer("NApply stops on user's request.");
                        throw new ExitOPatchException(buff.toString());
                    }
                    OLogger.printlnOnConsole(OLogger.getString("OUI-67911"));
                    this.saveRequiredDataForUseInApply(data);
                    if (!this.init) {
                        this.initializeCAS(this.oh);
                        this.init = true;
                        OPatchEnv.setNeedCASCleanup(true);
                    }
                    this.verifyLastCheckpoint(cis);
                    tp.prepare(rollbackPatches, applyPatches);
                    PatchObject[] raw = OPatchUtilHelper.getPatchesToApply(this.oh, null, OPatchEnv.getNApplySessionName());
                    OPatchOverCASUtil.serializeStatus(this.oh, raw);
                    OLogger.justlog(OLogger.INFO, "Finished OPatch/CAS NApply phase1, saved status.");
                }
                break block24;
            }
            if (op != TwoPhaseOperations.NROLLBACK) {
                StringBuffer tBuff = new StringBuffer("OPatch/CAS only support NApply and NRollback. ");
                tBuff.append("Please specify a valid twophase operation. ");
                OLogger.println(tBuff.toString());
                NotSupportedOPatchCASOperationException re = new NotSupportedOPatchCASOperationException(tBuff.toString());
                throw re;
            }
            String[] patchesToRollback = null;
            OLogger.justlog(OLogger.INFO, "Started to get a list of patches to be n-rolled back.");
            patchesToRollback = OPatchUtilHelper.getPatchesToRollback();
            rollbackPatches = OPatchUtilHelper.getPatchesToRollback(this.oh, patchesToRollback, OPatchEnv.getNRollbackSessionName());
            rollbackPatches = OPatchSessionHelper.sortOnOverlay(rollbackPatches, false);
            OPatchOverCASUtil.validateScripts(this.oh, rollbackPatches, applyPatches);
            OPatchSessionHelper.loadRACRelatedLibFile();
            if (!this.init) {
                this.initializeCAS(this.oh);
                this.init = true;
                OPatchEnv.setNeedCASCleanup(true);
            }
            this.verifyLastCheckpoint(cis);
            tp.prepare(rollbackPatches, applyPatches);
            OPatchOverCASUtil.serializeStatus(this.oh, rollbackPatches);
            OLogger.justlog(OLogger.INFO, "Finished OPatch/CAS NRollback phase1, saved status.");
        }
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: OPatchOverCAS::prepareTwoPhasePatching with operation " + (Object)((Object)op));
    }

    public void commitTwoPhasePatching() throws ExitTwoPhaseException, NotSupportedOPatchCASOperationException, Exception {
        File f2;
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: OPatchOverCAS::commitTwoPhasePatching()");
        if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
            NotSupportedOPatchCASOperationException re = new NotSupportedOPatchCASOperationException(OLogger.getString("OUI-68200"));
            throw re;
        }
        boolean isConsoleOutputDisabled = OLogger.isConsoleOutputDisabled();
        if (OPatchEnv.isOPatchSDKMode()) {
            f2 = new File(OPatchEnv.getPrereqResultFileLoc(this.oh) + File.separator + "phaseone_status_SDK");
            if (!isConsoleOutputDisabled) {
                OLogger.disableConsoleOutput(true);
            }
        } else {
            f2 = new File(OPatchEnv.getPrereqResultFileLoc(this.oh) + File.separator + "phaseone_status_CLI");
        }
        if (!f2.exists()) {
            OLogger.warn("OUI-68204");
            return;
        }
        try {
            TwoPhasePatching tp = new TwoPhasePatching();
            if (!this.init) {
                this.initializeCAS(this.oh);
                this.init = true;
                OPatchEnv.setNeedCASCleanup(true);
            }
            tp.commit();
            IIPMRWServices rwServices = IPM.INSTANCE.getRWServices();
            rwServices.destroy();
        }
        catch (Exception e2) {
            OLogger.justlog(OLogger.INFO, "OPatchOverCAS::commitTwoPhasePatching() error, restore OH: " + e2.getMessage());
            if (e2 instanceof ExitTwoPhaseException) {
                throw (ExitTwoPhaseException)e2;
            }
            try {
                CASIntegrityServices cis = new CASIntegrityServices();
                cis.restore(this.oh);
            }
            catch (Throwable t) {
                OLogger.justlog(OLogger.INFO, "OPatchOverCAS::commitTwoPhasePatching() error: Failed to restore:" + e2.getMessage());
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
            throw e2;
        }
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: OPatchOverCAS::commitTwoPhasePatching()");
    }

    private synchronized boolean checkIfPrereqsPassed() {
        HashMap prereqResults = OUSession.getApplyPrereqResults();
        OLogger.printlnOnLogAndVerbose("checkIfPrereqsPassed:: check if all prereqs passed.");
        for (OPatchPatchPrereq key : prereqResults.keySet()) {
            OPatchTarget.StatusCheck statusCheck;
            if (key.equals(OPatchPatchPrereq.CHECK_IF_ALL_NO_OPERATION_PATCHES) || key.equals(OPatchPatchPrereq.CHECK_IF_SOME_NO_OPERATION_PATCHES) || key.equals(OPatchPatchPrereq.CHECK_NO_OPERATION_PATCHES) || (statusCheck = (OPatchTarget.StatusCheck)prereqResults.get(key)).getStatusCode() != 1) continue;
            StringBuffer tBuff = new StringBuffer("This prereq: ");
            tBuff.append(key.toString());
            tBuff.append(" failed. OPatch won't run CAS napply phase1. ");
            OLogger.printlnOnLogAndVerbose(tBuff.toString());
            return false;
        }
        return true;
    }

    private void saveRequiredDataForUseInApply(NApplyData data) {
        NApplyData newData = new NApplyData();
        newData.setMpo(data.getMpo());
        newData.setApPatchObjects(data.getApPatchObjects());
        newData.setCanGoPatches(data.getCanGoPatches());
        newData.setArbPatchObjects(data.getArbPatchObjects());
        newData.setIsComposite(data.isComposite());
        newData.setCompositeIdenticalPatches(data.getCompositeIdenticalPatches());
        newData.setActivePatch(data.getActivePatch());
        newData.setApOneOffs(data.getApOneOffs());
        OPatchEnv.setNapplyData(newData);
    }

    private void verifyLastCheckpoint(CASIntegrityServices cis) {
        try {
            OLogger.justlog(OLogger.INFO, "OPatchOverCAS::prepareTwoPhasePatching(): Verifying Oracle Home Integrity");
            if (!cis.isLastCheckpointCompleted(this.oh)) {
                OLogger.justlog(OLogger.INFO, "OPatchOverCAS::prepareTwoPhasePatching() error: Verification of Oracle Home integrity failed.");
                throw new ExitOPatchException("Verification of Oracle Home integrity failed. ");
            }
        }
        catch (Throwable th) {
            OLogger.justlog(OLogger.INFO, "OPatchOverCAS::prepareTwoPhasePatching() error: Failed to load last checkpoint:" + th.getMessage());
            throw new ExitOPatchException("Failed to verify Oracle Home integrity. ");
        }
    }
}

