/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import oracle.opatch.ArchiveAction;
import oracle.opatch.Component;
import oracle.opatch.CopyAction;
import oracle.opatch.JarAction;
import oracle.opatch.MakeAction;
import oracle.opatch.NGOUIInventoryFactory;
import oracle.opatch.NGOUIInventoryUtil;
import oracle.opatch.PatchAction;
import oracle.opatch.SymbolFailureException;
import oracle.opatch.XMLConverter;
import oracle.opatch.opatchactions.DeleteAction;
import oracle.opatch.opatchactions.IOrderedAction;
import oracle.opatch.opatchactions.OrderedPatchAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.ops.Feature;
import oracle.opatch.ops.OPS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatchComponent
extends Component
implements Cloneable {
    private String[] rawActionEntry = null;
    String symbolName;
    private String[] dirs = null;
    boolean filter = false;
    boolean required = true;
    boolean excluded = false;
    public LinkedList copyList;
    public LinkedList jarList;
    public LinkedList archiveList;
    LinkedList makeList;
    LinkedList pluginList;
    LinkedList deleteList;
    LinkedList externalPluginList;
    static final LinkedList emptyList = new LinkedList();
    String compLanguage = "";

    public String getSymbolName() {
        return this.symbolName;
    }

    protected void setSymbolName(String symbolName) {
        this.symbolName = symbolName;
    }

    public boolean isFilter() {
        return this.filter;
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    public String[] getProductDirectories(String oracleHomePath) {
        if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.SYMBOL)) {
            throw new SymbolFailureException("\nThe oracle home does not support symbol copy action.");
        }
        if (this.dirs != null) {
            return this.dirs;
        }
        this.dirs = new String[0];
        if (this.hasSymbol() && oracleHomePath != null && !oracleHomePath.equals("")) {
            try {
                NGOUIInventoryUtil util = NGOUIInventoryFactory.getInventoryUtil(oracleHomePath);
                Set dirSet = util.getProductDirectories(this.name, this.version, this.symbolName);
                this.dirs = new String[dirSet.size()];
                Iterator iter = dirSet.iterator();
                int i2 = 0;
                while (iter.hasNext()) {
                    this.dirs[i2++] = iter.next().toString();
                }
            }
            catch (Exception e2) {
                throw new RuntimeException("Failed to get product directories for given symbol", e2);
            }
        }
        return this.dirs;
    }

    protected void setProductDirectories(String[] productDirectories) {
        this.dirs = productDirectories;
    }

    public boolean hasSymbol() {
        return this.symbolName != null && !this.symbolName.equals("");
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.name.length();
        result = 37 * result + this.version.length();
        if (this.hasSymbol()) {
            result = 37 * result + this.symbolName.length();
        }
        return result;
    }

    public boolean equals(Object pc) {
        if (pc instanceof PatchComponent) {
            PatchComponent pComp = (PatchComponent)pc;
            if (this.getName().equals(pComp.getName()) && this.getVersion().equals(pComp.getVersion())) {
                if (this.hasSymbol() && pComp.hasSymbol()) {
                    return this.getSymbolName().equals(pComp.getSymbolName());
                }
                if (!this.hasSymbol() && !pComp.hasSymbol()) {
                    return true;
                }
            }
        }
        return false;
    }

    protected String[] getRawActionEntry() {
        return this.rawActionEntry;
    }

    protected void setRawActionEntry(String[] entry) {
        this.rawActionEntry = entry;
    }

    protected String[] getReversedRawActionEntry() {
        int len = this.rawActionEntry.length;
        String[] convertedStr = new String[len];
        for (int i2 = 0; i2 < len; ++i2) {
            String s = this.rawActionEntry[i2];
            convertedStr[i2] = s = XMLConverter.getXMLString(s);
        }
        return convertedStr;
    }

    public void setExcluded() {
        this.excluded = true;
    }

    public PatchComponent() {
    }

    public PatchComponent(String name, String version, boolean required) {
        this.name = name;
        this.version = version;
        this.required = required;
        this.copyList = new LinkedList();
        this.jarList = new LinkedList();
        this.archiveList = new LinkedList();
        this.makeList = new LinkedList();
        this.pluginList = new LinkedList();
        this.deleteList = new LinkedList();
        this.externalPluginList = new LinkedList();
    }

    public PatchComponent(String name, String version, String symbolName, boolean required) {
        this(name, version, required);
        this.symbolName = symbolName;
    }

    public PatchComponent(String name, String version, boolean required, LinkedList cpList, LinkedList jarList, LinkedList arList, LinkedList mkList, LinkedList pluginList, LinkedList deList, LinkedList externalPluginList) {
        this.name = name;
        this.version = version;
        this.required = required;
        this.copyList = cpList;
        this.jarList = jarList;
        this.archiveList = arList;
        this.makeList = mkList;
        this.pluginList = pluginList;
        this.deleteList = deList;
        this.externalPluginList = externalPluginList;
    }

    public String getID() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setLanguage(String compLanguage) {
        this.compLanguage = compLanguage;
    }

    public String getLanguage() {
        return this.compLanguage;
    }

    protected int actionsSize() {
        int size = this.copyList.size() + this.jarList.size() + this.archiveList.size() + this.makeList.size() + this.pluginList.size() + this.deleteList.size() + this.externalPluginList.size();
        return size;
    }

    public LinkedList getCopyList() {
        return this.copyList;
    }

    public LinkedList getDeleteList() {
        return this.deleteList;
    }

    public LinkedList getJarList() {
        return this.jarList;
    }

    public LinkedList getPluginList() {
        return this.pluginList;
    }

    public LinkedList getExternalPluginList() {
        return this.externalPluginList;
    }

    public LinkedList getArchiveList() throws NullPointerException {
        return this.archiveList;
    }

    public LinkedList getMakeList() throws NullPointerException {
        return this.makeList;
    }

    public PatchAction[] getAllActions() {
        ArrayList actions = new ArrayList();
        actions.addAll(this.copyList);
        actions.addAll(this.jarList);
        actions.addAll(this.archiveList);
        actions.addAll(this.makeList);
        actions.addAll(this.pluginList);
        actions.addAll(this.deleteList);
        actions.addAll(this.externalPluginList);
        PatchAction[] pActions = new PatchAction[actions.size()];
        actions.toArray(pActions);
        return pActions;
    }

    public List<OrderedPatchAction> getOrderedActions() {
        ArrayList<OrderedPatchAction> list = new ArrayList<OrderedPatchAction>();
        list.addAll(this.copyList);
        list.addAll(this.jarList);
        list.addAll(this.archiveList);
        list.addAll(this.pluginList);
        list.addAll(this.deleteList);
        return list;
    }

    public List<OrderedPatchAction> getSnowballOrderedActions() {
        ArrayList<OrderedPatchAction> list = new ArrayList<OrderedPatchAction>();
        list.addAll(this.copyList);
        list.addAll(this.deleteList);
        Collections.sort(list, new Comparator<IOrderedAction>(){

            @Override
            public int compare(IOrderedAction o1, IOrderedAction o2) {
                return (int)(o1.getOrder() - o2.getOrder());
            }
        });
        return list;
    }

    public List<IOrderedAction> getImmediateOrderedActions() {
        ArrayList<IOrderedAction> actions = new ArrayList<IOrderedAction>();
        List<OrderedPatchAction> list = this.getOrderedActions();
        for (OrderedPatchAction ai : list) {
            if (ai.isExecutionDelayed()) continue;
            actions.add(ai);
        }
        Collections.sort(actions, new Comparator<IOrderedAction>(){

            @Override
            public int compare(IOrderedAction o1, IOrderedAction o2) {
                return (int)(o1.getOrder() - o2.getOrder());
            }
        });
        return actions;
    }

    public List<IOrderedAction> getImmediateReverseOrderedActions() {
        ArrayList<IOrderedAction> actions = new ArrayList<IOrderedAction>();
        List<OrderedPatchAction> list = this.getOrderedActions();
        for (OrderedPatchAction ai : list) {
            if (ai.isExecutionDelayed()) continue;
            actions.add(ai);
        }
        Collections.sort(actions, new Comparator<IOrderedAction>(){

            @Override
            public int compare(IOrderedAction o1, IOrderedAction o2) {
                return (int)(-(o1.getOrder() - o2.getOrder()));
            }
        });
        return actions;
    }

    public List<MakeAction> getImmediateMakeActions() {
        ArrayList<MakeAction> list = new ArrayList<MakeAction>();
        for (MakeAction mk : this.getMakeList()) {
            if (mk.isExecutionDelayed()) continue;
            list.add(mk);
        }
        return list;
    }

    public List<PatchAction> getImmediateExternalPluginActions() {
        ArrayList<PatchAction> list = new ArrayList<PatchAction>();
        for (PatchAction ai : this.getExternalPluginList()) {
            if (ai.isExecutionDelayed()) continue;
            list.add(ai);
        }
        return list;
    }

    public boolean isRequired() {
        return this.required;
    }

    protected String getReqOptString() {
        if (this.required) {
            return "R";
        }
        return "O";
    }

    String getRequiredOrOptionalDesc() {
        if (this.required) {
            return "R";
        }
        return "O";
    }

    boolean isExcluded() {
        return this.excluded;
    }

    public String toString() {
        PatchAction action;
        Object obj;
        ListIterator iter;
        StringBuffer buff = new StringBuffer();
        buff.append("[PatchComponent: name= ");
        buff.append(this.name);
        buff.append(", version=");
        buff.append(this.version);
        buff.append(", required=");
        buff.append(this.required);
        buff.append(", language=");
        buff.append(this.getLanguage());
        buff.append(", CopyActions=");
        try {
            iter = this.getCopyList().listIterator();
            if (!iter.hasNext()) {
                buff.append("No Copy Actions,");
            }
            while (iter.hasNext()) {
                obj = iter.next();
                if (obj instanceof CopyAction) {
                    action = (CopyAction)obj;
                    buff.append(((CopyAction)action).toString());
                    buff.append(",");
                    continue;
                }
                buff.append("wrong type,");
            }
        }
        catch (NullPointerException e2) {
            OLogger.printStackTrace(e2);
            buff.append("No Copy Actions,");
        }
        buff.append(" JarActions=");
        try {
            iter = this.getJarList().listIterator();
            if (!iter.hasNext()) {
                buff.append("No Jar Actions,");
            }
            while (iter.hasNext()) {
                obj = iter.next();
                if (obj instanceof JarAction) {
                    action = (JarAction)obj;
                    buff.append(((JarAction)action).toString());
                    buff.append(",");
                    continue;
                }
                buff.append("wrong type,");
            }
        }
        catch (NullPointerException e3) {
            OLogger.printStackTrace(e3);
            buff.append("No Jar Actions,");
        }
        buff.append(" ArchiveActions=");
        try {
            iter = this.getArchiveList().listIterator();
            if (!iter.hasNext()) {
                buff.append("No Archive Actions,");
            }
            while (iter.hasNext()) {
                obj = iter.next();
                if (obj instanceof ArchiveAction) {
                    action = (ArchiveAction)obj;
                    buff.append(((ArchiveAction)action).toString());
                    buff.append(",");
                    continue;
                }
                buff.append("wrong type,");
            }
        }
        catch (NullPointerException e4) {
            OLogger.printStackTrace(e4);
            buff.append("No Archive Actions,");
        }
        buff.append(" DeleteActions=");
        try {
            iter = this.getDeleteList().listIterator();
            if (!iter.hasNext()) {
                buff.append("No Delete Actions,");
            }
            while (iter.hasNext()) {
                obj = iter.next();
                if (obj instanceof DeleteAction) {
                    action = (DeleteAction)obj;
                    buff.append(((DeleteAction)action).toString());
                    buff.append(",");
                    continue;
                }
                buff.append("wrong type,");
            }
        }
        catch (NullPointerException e5) {
            OLogger.printStackTrace(e5);
            buff.append("No Delete Actions,");
        }
        buff.append(" PluginActions =");
        try {
            iter = this.getPluginList().listIterator();
            if (!iter.hasNext()) {
                buff.append("No Plugin Actions,");
            }
            while (iter.hasNext()) {
                obj = iter.next();
                buff.append(((PatchAction)obj).toString());
                buff.append(",");
            }
            iter = this.getExternalPluginList().listIterator();
            if (!iter.hasNext()) {
                buff.append(" No External Plugin Actions,");
            }
            while (iter.hasNext()) {
                obj = iter.next();
                buff.append(((PatchAction)obj).toString());
                buff.append(",");
            }
        }
        catch (NullPointerException e6) {
            OLogger.printStackTrace(e6);
            buff.append("No Plugin Actions,");
        }
        buff.append(" MakeActions=");
        try {
            iter = this.getMakeList().listIterator();
            if (!iter.hasNext()) {
                buff.append("No Make Actions,");
            }
            while (iter.hasNext()) {
                obj = iter.next();
                if (obj instanceof MakeAction) {
                    action = (MakeAction)obj;
                    buff.append(((MakeAction)action).toString());
                    buff.append(",");
                    continue;
                }
                buff.append("wrong type,");
            }
        }
        catch (NullPointerException e7) {
            OLogger.printStackTrace(e7);
            buff.append("No Make Actions,");
        }
        buff.append("\"]");
        return buff.toString();
    }

    public Object clone() {
        String name = this.name;
        String version = this.version;
        boolean required = this.required;
        LinkedList copyList = (LinkedList)this.copyList.clone();
        LinkedList jarList = (LinkedList)this.jarList.clone();
        LinkedList archiveList = (LinkedList)this.archiveList.clone();
        LinkedList makeList = (LinkedList)this.makeList.clone();
        LinkedList pluginList = (LinkedList)this.pluginList.clone();
        LinkedList deleteList = (LinkedList)this.deleteList.clone();
        LinkedList externalPluginList = (LinkedList)this.externalPluginList.clone();
        PatchComponent pc = new PatchComponent(name, version, required, copyList, jarList, archiveList, makeList, pluginList, deleteList, externalPluginList);
        return pc;
    }
}

