/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.patchsdk.OPatchBundlePatchValidatorAndGenerator;
import oracle.opatch.patchsdk.OPatchEngineeredSystemPatchValidatorAndGenerator;
import oracle.opatch.patchsdk.OPatchSingletonPatchValidatorAndGenerator;
import oracle.opatch.patchsdk.PatchFactory;
import oracle.opatch.patchsdk.PatchPackageException;
import oracle.opatch.patchsdk.patchmodel.PatchPackage;

public class PatchPackageGenerator {
    private static PatchFactory pf = new PatchFactory();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PatchPackage getPatchInstance(String patchLocation) throws PatchPackageException {
        if (patchLocation == null || patchLocation.equals("")) {
            return null;
        }
        PatchPackage patch = null;
        boolean isConsoleOutputDisabled = OLogger.isConsoleOutputDisabled();
        try {
            if (!isConsoleOutputDisabled) {
                OLogger.disableConsoleOutput(true);
            }
            patch = pf.getInstance(patchLocation);
            Object var5_3 = null;
            if (isConsoleOutputDisabled) return patch;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (isConsoleOutputDisabled) throw throwable;
            OLogger.enableConsoleOutput(true);
            throw throwable;
        }
        OLogger.enableConsoleOutput(true);
        return patch;
    }

    static {
        pf.addPatchValidatorAndGenerator(new OPatchSingletonPatchValidatorAndGenerator());
        pf.addPatchValidatorAndGenerator(new OPatchEngineeredSystemPatchValidatorAndGenerator());
        pf.addPatchValidatorAndGenerator(new OPatchBundlePatchValidatorAndGenerator());
    }
}

