/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import oracle.opatch.CopyAction;
import oracle.opatch.JarAction;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchObject;
import oracle.opatch.SystemCall;
import oracle.opatch.opatchlogger.OLogger;
import oracle.sysman.nextgen.LibraryRegenerationState;
import oracle.sysman.nextgen.NextGenPatching;
import oracle.sysman.nextgen.NextGenPatchingException;
import oracle.sysman.nextgen.NextGenPatchingFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegenerateLib {
    PatchObject[] patchObjects;
    String oracleHomePath;
    Set<String> fileNameSet;

    RegenerateLib(PatchObject patchObject, String oracleHomePath) {
        this.patchObjects = new PatchObject[1];
        this.patchObjects[0] = patchObject;
        this.patchObjects = this.patchObjects;
        this.oracleHomePath = oracleHomePath;
        this.fileNameSet = new HashSet<String>();
    }

    RegenerateLib(PatchObject[] patchObjects, String oracleHomePath) {
        this.patchObjects = patchObjects;
        this.oracleHomePath = oracleHomePath;
        this.fileNameSet = new HashSet<String>();
    }

    public void regenerate() {
        OLogger.debug("RegenerateLib::regenerate()");
        for (PatchObject po : this.patchObjects) {
            this.addJarActionList(po.getAllJarActionForRLib());
            this.addCopyActionList(po.getAllCopyActionForRLib());
        }
        StringBuffer ts = new StringBuffer("Files proceed for library regeneration checking are ");
        OLogger.logTime(ts);
        ArrayList<File> fileList = new ArrayList<File>();
        for (String fileName : this.fileNameSet) {
            fileList.add(new File(fileName));
            ts = new StringBuffer(fileName + " is added at ");
            OLogger.logTime(ts);
        }
        File oracleHome = new File(this.oracleHomePath);
        boolean isRegenerationNeeded = false;
        NextGenPatching nextgenPatching = null;
        LibraryRegenerationState libraryRegenerationState = null;
        try {
            nextgenPatching = NextGenPatchingFactory.getNextGenPatching((File)oracleHome);
            libraryRegenerationState = nextgenPatching.checkRegenerateLibraries(fileList);
            isRegenerationNeeded = libraryRegenerationState.isRegenerationNeeded();
            if (isRegenerationNeeded) {
                OPatchEnv.setRegenerationNeeded();
            }
        }
        catch (NextGenPatchingException ngpEx) {
            RuntimeException re = new RuntimeException("Check if library regeneration is needed with error message: " + ngpEx.getMessage(), ngpEx);
            re.setStackTrace(ngpEx.getStackTrace());
            throw re;
        }
        catch (Throwable t) {
            OLogger.println("Library regeneration check has failed. OPatch needs to restore the system.");
            RuntimeException re = new RuntimeException("(Throwable) Check if library regeneration is needed with error message: " + t.getMessage(), t);
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        if (!isRegenerationNeeded) {
            OLogger.onlyLogInfo("OUI-68017");
        } else {
            OLogger.onlyLogInfo("OUI-68018");
            Set librariesToRegenerate = libraryRegenerationState.getLibrariesToRegenerate();
            try {
                this.backUpLibrariesForRestore(librariesToRegenerate);
            }
            catch (Throwable t) {
                RuntimeException re = new RuntimeException("Backup libraries to be regenerated failed with error message \"" + t.getMessage() + "\"", t);
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
            if (librariesToRegenerate != null) {
                for (File file : librariesToRegenerate) {
                    OLogger.onlyLogInfo("OUI-68019", new Object[]{file.getAbsolutePath()});
                }
            }
            try {
                nextgenPatching.regenerateLibraries(oracleHome, fileList);
            }
            catch (NextGenPatchingException ngpEx) {
                OPatchEnv.setRLibSuccess(false);
                RuntimeException re = new RuntimeException(ngpEx.getMessage(), ngpEx);
                re.setStackTrace(ngpEx.getStackTrace());
                throw re;
            }
        }
    }

    private void addJarActionList(ListIterator jarActions) {
        while (jarActions.hasNext()) {
            Object p2 = jarActions.next();
            if (!(p2 instanceof JarAction)) continue;
            JarAction jarAct = (JarAction)p2;
            StringBuffer dst = new StringBuffer();
            dst.append(jarAct.getJarPath());
            dst.append(File.separator);
            dst.append(jarAct.getJarName());
            String[] splitNames = dst.toString().split(":");
            this.fileNameSet.add(splitNames[0]);
        }
    }

    private void addCopyActionList(ListIterator copyActions) {
        while (copyActions.hasNext()) {
            Object p2 = copyActions.next();
            if (!(p2 instanceof CopyAction)) continue;
            CopyAction cpAct = (CopyAction)p2;
            String fileName = cpAct.getPath() + File.separator + cpAct.getCopyName();
            this.fileNameSet.add(fileName);
        }
    }

    private void backUpLibrariesForRestore(Set<File> files) {
        if (files == null || !this.setupLibraryStorage()) {
            return;
        }
        String loc = OPatchEnv.getRLibBackupDir();
        for (File f2 : files) {
            StringBuilder dst = new StringBuilder(loc);
            dst.append(f2.getAbsolutePath().substring(this.oracleHomePath.length()));
            SystemCall.copyFile(f2, new File(dst.toString()));
        }
    }

    private boolean setupLibraryStorage() {
        String loc = OPatchEnv.getRLibBackupDir();
        File f2 = new File(loc);
        StringBuffer buff = new StringBuffer("Try to mkdir on \"");
        buff.append(f2);
        buff.append("\"");
        OLogger.debug(buff);
        if (f2.exists() || f2.mkdirs()) {
            return true;
        }
        buff = new StringBuffer("Unable to setup backup location for library restore at ");
        buff.append(loc);
        buff.append("\".");
        buff.append("\nOPatch will skip backing up libraries.");
        OLogger.warn("OUI-67124", new Object[]{buff.toString()});
        return false;
    }

    public static void restoreLibraries(String oracleHomePath, String cookedPatchID) {
        File src = new File(OPatchEnv.getRLibBackupDir());
        if (!src.exists()) {
            OLogger.info("OUI-67209");
            return;
        }
        if (SystemCall.copyRecurse(src, new File(oracleHomePath), true, false)) {
            OLogger.info("OUI-67209");
            throw new RuntimeException("Restore: Copying of regenerated libraries from backup area failed");
        }
        SystemCall.deleteRecurse(oracleHomePath, cookedPatchID, src, true);
    }
}

