/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.opatch.CustomizedActionResults;
import oracle.opatch.ICustomizedActionResults;
import oracle.opatch.ICustomizedActions;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchObject;
import oracle.opatch.SparseCopyContext;
import oracle.opatch.SystemCall;
import oracle.opatch.opatchlogger.OLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseCopyPostCustomizedAction
implements ICustomizedActions {
    private List<SparseCopyContext> sccs;
    private String oracleHomePath;
    private PatchObject pObject;

    public SparseCopyPostCustomizedAction(List<SparseCopyContext> sccs, String oracleHomePath, PatchObject pObject) {
        this.sccs = sccs;
        this.oracleHomePath = oracleHomePath;
        this.pObject = pObject;
    }

    @Override
    public ICustomizedActionResults run() {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: SparseCopyPostCustomizedAction::run()");
        ArrayList<String> removeList = new ArrayList<String>();
        for (SparseCopyContext scc : this.sccs) {
            if (!scc.isFirstAppVerDirExist()) continue;
            File oldAppVerFile = scc.getOldAppVerDir();
            if (oldAppVerFile != null && scc.isDeleteOldDirectory() && oldAppVerFile.exists()) {
                OLogger.printlnOnLog(MessageFormat.format("Delete old aplication version file: {0}", oldAppVerFile.getAbsolutePath()));
                String oldAppVerDir = oldAppVerFile.getAbsolutePath();
                String relativeOldAppVerDir = oldAppVerDir.substring(this.oracleHomePath.length() + 1);
                ArrayList<File> allFileInOldAppDir = new ArrayList<File>();
                this.listDirectory(oldAppVerFile, allFileInOldAppDir);
                boolean removeFlag = this.deleteOldAppVerDir(oldAppVerFile, scc);
                if (removeFlag) {
                    OLogger.printlnOnLog(MessageFormat.format("Add all the files in old aplication version file to remove list: {0}", relativeOldAppVerDir));
                    for (File file : allFileInOldAppDir) {
                        String relativePath = file.getAbsolutePath().substring(this.oracleHomePath.length() + 1);
                        OLogger.printlnOnLog(MessageFormat.format("Add file {0} to remove list", relativePath));
                        removeList.add(relativePath);
                    }
                }
            }
            if (scc.getCurrentAppVerDir() != scc.getNewAppVerFromPatchDir()) {
                File oldPriorAppPtrFile = scc.getPriorAppPtrFile();
                File newPriorAppPtrFile = this.deleteAndCreatePriorAppPtrFile(scc);
                if (oldPriorAppPtrFile != null) {
                    OLogger.printlnOnLog(MessageFormat.format("The old prior pointer file is: {0}", oldPriorAppPtrFile.getAbsolutePath()));
                    removeList.add(oldPriorAppPtrFile.getAbsolutePath().substring(this.oracleHomePath.length() + 1));
                }
                if (newPriorAppPtrFile != null) {
                    OLogger.printlnOnLog(MessageFormat.format("The new prior pointer file is: {0}", newPriorAppPtrFile.getAbsolutePath()));
                }
            }
            File oldLatestAppPtrFile = scc.getLatestAppPtrFile();
            File newLatestAppPtrFile = this.deleteAndCreateLatestAppPtrFile(scc);
            if (oldLatestAppPtrFile != null) {
                OLogger.printlnOnLog(MessageFormat.format("The old latest pointer file is: {0}", oldLatestAppPtrFile.getAbsolutePath()));
                OLogger.printlnOnLog(MessageFormat.format("The new latest pointer file is: {0}", newLatestAppPtrFile.getAbsolutePath()));
                removeList.add(oldLatestAppPtrFile.getAbsolutePath().substring(this.oracleHomePath.length() + 1));
                continue;
            }
            OLogger.printlnOnLog(MessageFormat.format("The new latest pointer file is: {0}", newLatestAppPtrFile.getAbsolutePath()));
        }
        CustomizedActionResults actionResults = new CustomizedActionResults(null, removeList);
        return actionResults;
    }

    private boolean deleteOldAppVerDir(File oldAppVerDir, SparseCopyContext scc) {
        OLogger.justlog(OLogger.INFO, "deleteOldAppVerDir::delete old application version directory");
        String oldAppVerPath = oldAppVerDir.getAbsolutePath();
        String relativeOldAppVerPath = oldAppVerPath.substring(this.oracleHomePath.length() + 1);
        try {
            if (oldAppVerDir.exists() && !this.isWorkingDir(relativeOldAppVerPath, scc)) {
                SystemCall.deleteRecurse(oldAppVerDir, true);
                return true;
            }
        }
        catch (Exception e2) {
            OLogger.println("OPatch failed to remove old application version directory " + oldAppVerPath);
        }
        return false;
    }

    public boolean isWorkingDir(String relativePath, SparseCopyContext scc) {
        Map<String, String> workingDirs = OPatchEnv.getApplicationWorkingDirectory();
        String relativeWorkingDir = workingDirs.get(scc.getApplicationDir());
        OLogger.printlnOnLog(MessageFormat.format("isWorkingDir::compare the relative path of old application version directory {0} with working directory {1}", relativePath, relativeWorkingDir));
        return relativePath.equals(relativeWorkingDir);
    }

    private File deleteAndCreatePriorAppPtrFile(SparseCopyContext scc) {
        OLogger.justlog(OLogger.INFO, "deleteAndCreatePriorAppPtrFile::Delete <prior-app-ptr-file> pointer file, and create a new one using the unique patchid and date-timestamp extracted from the <latest-app-ptr-file>");
        File priorAppPtrFile = scc.getPriorAppPtrFile();
        if (priorAppPtrFile != null && priorAppPtrFile.exists()) {
            try {
                priorAppPtrFile.delete();
            }
            catch (Exception e2) {
                RuntimeException re = new RuntimeException("OPatch failed to delete prior application pointer file " + priorAppPtrFile.getAbsolutePath());
                throw re;
            }
        }
        String fileName = "prior-ptr-" + scc.getCurrentAppVerDir().getName();
        priorAppPtrFile = new File(this.oracleHomePath + File.separator + scc.getApplicationDir() + File.separator + fileName);
        try {
            if (!priorAppPtrFile.exists()) {
                priorAppPtrFile.createNewFile();
            }
            return priorAppPtrFile;
        }
        catch (Exception e3) {
            RuntimeException re = new RuntimeException("OPatch failed to create prior application pointer file " + priorAppPtrFile.getAbsolutePath());
            throw re;
        }
    }

    private File deleteAndCreateLatestAppPtrFile(SparseCopyContext scc) {
        OLogger.justlog(OLogger.INFO, "deleteAndCreateLatestAppPtrFile::Delete the <latest-app-ptr-file> pointer file, create a new <latest-app-ptr-file> pointer file with the newly generated unique patchid and date-timestamp corresponding to the new-app-ver-from-patch-dir> directory");
        File latestAppPtrFile = scc.getLatestAppPtrFile();
        if (latestAppPtrFile != null && latestAppPtrFile.exists()) {
            try {
                latestAppPtrFile.delete();
            }
            catch (Exception e2) {
                RuntimeException re = new RuntimeException("OPatch failed to delete latest application pointer file " + latestAppPtrFile.getAbsolutePath());
                throw re;
            }
        }
        String fileName = "latest-ptr-" + this.pObject.getApplicationVersion();
        latestAppPtrFile = new File(this.oracleHomePath + File.separator + scc.getApplicationDir() + File.separator + fileName);
        try {
            if (!latestAppPtrFile.exists()) {
                latestAppPtrFile.createNewFile();
            }
            return latestAppPtrFile;
        }
        catch (Exception e3) {
            RuntimeException re = new RuntimeException("OPatch failed to create latest application pointer file " + latestAppPtrFile.getAbsolutePath());
            throw re;
        }
    }

    public void listDirectory(File dir, List<File> list) {
        if (!dir.exists()) {
            OLogger.printlnOnLog("File " + dir.getAbsolutePath() + " doesn't exist.");
        } else if (dir.isFile()) {
            dir.getAbsolutePath();
            list.add(dir);
        } else {
            list.add(dir);
            File[] files = dir.listFiles();
            for (int i2 = 0; i2 < files.length; ++i2) {
                this.listDirectory(files[i2], list);
            }
        }
    }
}

