/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.automation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import oracle.opatch.automation.AutomationXMLException;
import oracle.opatch.automation.AutomationXMLValidationException;
import oracle.opatch.automation.jaxb.ActionType;
import oracle.opatch.automation.jaxb.Automation;
import oracle.opatch.automation.jaxb.PatchingPhase;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutomationHelper {
    private static final AutomationHelper thisObj = new AutomationHelper();
    private final Schema schema;
    private final JAXBContext jbc;

    private AutomationHelper() {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            this.schema = sf.newSchema(this.getClass().getResource("/oracle/opatch/automation/xsd/automation.xsd"));
        }
        catch (SAXException ex) {
            throw new AutomationXMLException("Automation Schema is not valid", ex);
        }
        try {
            this.jbc = JAXBContext.newInstance((String)"oracle.opatch.automation.jaxb", (ClassLoader)this.getClass().getClassLoader());
        }
        catch (JAXBException ex) {
            throw new AutomationXMLException("Failed to get JAXB context", ex);
        }
    }

    public static AutomationHelper getInstance() {
        return thisObj;
    }

    public Automation readAutomation(File xmlFile, boolean validate) throws AutomationXMLValidationException {
        try {
            return this.readAutomation(this.getFileContent(xmlFile), validate);
        }
        catch (IOException e2) {
            throw new AutomationXMLValidationException(null, e2);
        }
    }

    public Automation readAutomation(InputStream stream, boolean validate) throws AutomationXMLValidationException {
        try {
            return this.readAutomation(this.getContent(stream), validate);
        }
        catch (IOException e2) {
            throw new AutomationXMLValidationException(null, e2);
        }
    }

    public Automation readAutomation(String content, boolean validate) throws AutomationXMLValidationException {
        Object obj;
        if (validate) {
            Validator v = this.schema.newValidator();
            try {
                v.validate(new StreamSource(new StringReader(content)));
            }
            catch (SAXException ex) {
                throw new AutomationXMLValidationException("Error validating automation", ex);
            }
            catch (IOException ex) {
                throw new AutomationXMLValidationException("Error reading automation", ex);
            }
        }
        Unmarshaller unmarshal = null;
        try {
            unmarshal = this.jbc.createUnmarshaller();
        }
        catch (JAXBException ex) {
            throw new AutomationXMLException("Error creating unmarshaller", ex);
        }
        try {
            JAXBElement root = unmarshal.unmarshal((Source)new StreamSource(new StringReader(content)), Automation.class);
            obj = root.getValue();
        }
        catch (JAXBException ex) {
            throw new AutomationXMLValidationException("Error unmarshalling automation", (Exception)((Object)ex));
        }
        if (!(obj instanceof Automation)) {
            throw new AutomationXMLException("Error: The file does not contain valid Automation XML!", null);
        }
        return (Automation)obj;
    }

    private String getFileContent(File file) throws IOException {
        assert (file != null);
        assert (file.isFile());
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new FileReader(file));
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line + "\n");
        }
        br.close();
        return sb.toString();
    }

    private String getContent(InputStream is) throws IOException {
        assert (is != null);
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line + "\n");
        }
        br.close();
        return sb.toString();
    }

    public static List<ActionType> getActionOrContextList(PatchingPhase p2) {
        return AutomationHelper.getActions(p2);
    }

    public static List<ActionType> getActions(PatchingPhase p2) {
        if (p2 == null) {
            return new ArrayList<ActionType>();
        }
        List<JAXBElement<? extends ActionType>> jaxbElements = p2.getAction();
        ArrayList<ActionType> result = new ArrayList<ActionType>();
        for (JAXBElement<? extends ActionType> jaxbElement : jaxbElements) {
            result.add((ActionType)jaxbElement.getValue());
        }
        return result;
    }
}

