/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import oracle.opatch.OPatchEnv;
import oracle.opatch.conflicttextualinterpreter.ConflictMapUtil;
import oracle.opatch.conflicttextualinterpreter.GraphHelper;
import oracle.opatch.conflicttextualinterpreter.IConflictMap;
import oracle.opatch.conflicttextualinterpreter.INPatchPlan;
import oracle.opatch.conflicttextualinterpreter.IPatch;
import oracle.opatch.conflicttextualinterpreter.NPatchRelation;
import oracle.opatch.conflicttextualinterpreter.NPatchRelations;
import oracle.opatch.conflicttextualinterpreter.OracleHomeConflictMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetResolution {
    private static SetResolution instance = null;
    private Collection<IPatch> markList;
    private Collection<IPatch> removedList = new ArrayList<IPatch>();
    private Collection<IPatch> sortedList = null;
    private HashMap<IPatch, NPatchRelations> reasonMap;
    private boolean cleanRecursive = false;
    private boolean recursiveRemove = false;

    private SetResolution() {
        this.markList = new ArrayList<IPatch>();
        this.reasonMap = new HashMap();
    }

    public static SetResolution getInstance() {
        if (instance == null) {
            instance = new SetResolution();
        }
        return instance;
    }

    public static void releaseResolution() {
        instance = null;
    }

    public HashMap getReasonMap() {
        return this.reasonMap;
    }

    public Collection getRemovedList() {
        return this.removedList;
    }

    public void mark(IPatch patch, NPatchRelations relations) {
        if (relations != null) {
            this.reasonMap.put(patch, relations);
        }
        this.markList.add(patch);
    }

    public void resolve(IConflictMap map, INPatchPlan plan) {
        Collection<IPatch> sortedList = this.topologicalSort(map);
        this.resolve(map, plan, sortedList);
        if (this.cleanRecursive) {
            this.resolve(map, plan, sortedList);
        }
        this.cleanRecursive = false;
    }

    protected void resolve(IConflictMap map, INPatchPlan plan, Collection<IPatch> sortedList) {
        for (IPatch p2 : sortedList) {
            if (!this.markList.contains(p2)) continue;
            if (p2.isComposite()) {
                if (p2.isInOh()) {
                    if (!map.getRelations(p2).getSubsetPSU().isEmpty()) {
                        this.recursiveRemove = true;
                        if (!this.canRemove(map, p2)) {
                            this.recursiveRemove = false;
                            continue;
                        }
                        this.recursiveRemove = false;
                    }
                    plan.addIgnoredPatches(p2);
                } else {
                    if (map.getRelations(p2).getLowerPSUs().isEmpty() && !this.canRemove(map, p2)) continue;
                    plan.addNotNeededPatches(p2);
                }
                ConflictMapUtil.delete(map, p2);
                this.markList.remove(p2);
                this.removedList.add(p2);
                continue;
            }
            if (!this.canRemove(map, p2)) continue;
            if (p2.isInOh()) {
                if (p2.isActive()) {
                    Map<String, String> toInActivePatchMap;
                    plan.addAutoRollbackPatches(p2);
                    if (OracleHomeConflictMap.getInstance() != null && (toInActivePatchMap = OracleHomeConflictMap.getInstance().getToInActivePatchMap()).containsKey(p2.getPatchId())) {
                        toInActivePatchMap.remove(p2.getPatchId());
                    }
                }
            } else {
                plan.addNotNeededPatches(p2);
            }
            ConflictMapUtil.delete(map, p2);
            this.markList.remove(p2);
            this.removedList.add(p2);
        }
    }

    private boolean canRemove(IConflictMap map, IPatch p2) {
        Collection<String> prereqIds = p2.getBeingPrereqsID();
        Collection<String> overlayIds = p2.getBeingOverlaysID();
        ArrayList<IPatch> relativePatches = new ArrayList<IPatch>();
        ArrayList<IPatch> bePrereqPatches = new ArrayList<IPatch>();
        if (p2.isComposite()) {
            Iterator<Object> subPatchIds = new HashSet();
            prereqIds = new HashSet<String>();
            for (IPatch subPatch : p2.getSubPatches()) {
                subPatchIds.add(subPatch.getPatchId());
                prereqIds.addAll(subPatch.getBeingPrereqsID());
            }
            subPatchIds.add(p2.getPatchId());
            prereqIds.addAll(p2.getBeingPrereqsID());
            prereqIds.removeAll((Collection<?>)((Object)subPatchIds));
        }
        for (String prereqID : prereqIds) {
            Collection prereqs = map.getPatches(prereqID);
            for (IPatch prereq : prereqs) {
                bePrereqPatches.add(prereq);
                if (p2.isActive()) {
                    relativePatches.add(prereq);
                }
                if (!p2.isECPB()) continue;
                prereq.setActive();
            }
        }
        for (String overlayId : overlayIds) {
            Collection overlays = map.getPatches(overlayId);
            for (IPatch overlay : overlays) {
                relativePatches.add(overlay);
                if (!p2.isECPB()) continue;
                overlay.setActive();
            }
        }
        if (p2.isInOh()) {
            if (p2.removeInactiveSubset()) {
                for (NPatchRelation supersetRel : map.getRelations(p2).getSupersets()) {
                    IPatch subsetPatch = supersetRel.to();
                    if (subsetPatch.isComposite() || !subsetPatch.isInOh()) continue;
                    boolean needRemoveSubsetPatch = true;
                    for (NPatchRelation subsetRel : map.getRelations(subsetPatch).getSubsets()) {
                        IPatch supersetPatch = subsetRel.to();
                        if (supersetPatch.equals(p2) || this.removedList.contains(supersetPatch)) continue;
                        needRemoveSubsetPatch = false;
                    }
                    if (!needRemoveSubsetPatch) continue;
                    this.cleanRecursive = true;
                    this.markList.add(subsetPatch);
                    if (this.canRemove(map, subsetPatch)) continue;
                    return false;
                }
            }
            if (relativePatches.isEmpty() || this.removedList.containsAll(relativePatches)) {
                return true;
            }
            if (OPatchEnv.isOptimize() || this.recursiveRemove) {
                this.cleanRecursive = true;
                for (IPatch relativePatch : relativePatches) {
                    if (relativePatch.isInOh()) {
                        this.markList.add(relativePatch);
                        if (this.canRemove(map, relativePatch)) continue;
                        return false;
                    }
                    return false;
                }
                return true;
            }
        } else {
            NPatchRelations reason = this.reasonMap.get(p2);
            if (!(reason == null || reason.getWorses().isEmpty() && reason.getDuplicates().isEmpty())) {
                return true;
            }
            if (bePrereqPatches.isEmpty() || this.removedList.containsAll(bePrereqPatches)) {
                return true;
            }
            for (IPatch bePrereqPatch : bePrereqPatches) {
                if (bePrereqPatch.isInOh() || this.removedList.contains(bePrereqPatch)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Collection<IPatch> topologicalSort(IConflictMap map) {
        GraphHelper graphHelper = new GraphHelper();
        ArrayList<IPatch> patches = new ArrayList<IPatch>();
        patches.addAll(map.getPi());
        patches.addAll(map.getPoh());
        Collection sortedPatches = graphHelper.topologicalSort(patches);
        return sortedPatches;
    }
}

