/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.ipm;

import com.oracle.cie.gdr.external.DirectoryMap;
import com.oracle.cie.gdr.external.Distribution;
import com.oracle.cie.gdr.external.Mapping;
import com.oracle.cie.gdr.external.OracleHomeInventory;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.glcm.opatch.common.api.ComponentCheckResult;
import oracle.glcm.opatch.common.api.PatchCheckResults;
import oracle.glcm.opatch.common.api.PatchInventory;
import oracle.glcm.opatch.common.api.Result;
import oracle.opatch.ArchiveAction;
import oracle.opatch.Bug;
import oracle.opatch.CopyAction;
import oracle.opatch.JarAction;
import oracle.opatch.NGOUIInventoryFactory;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSDK;
import oracle.opatch.OUIReplacer;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchComponentCheckResult;
import oracle.opatch.PatchComponentCheckResultImpl;
import oracle.opatch.PatchComponentMissing;
import oracle.opatch.PatchComponentMissingLang;
import oracle.opatch.PatchComponentMissingProductDirectories;
import oracle.opatch.PatchComponentMissingSymbol;
import oracle.opatch.PatchComponentVersionMismatch;
import oracle.opatch.PatchInventory;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchingModel;
import oracle.opatch.Platform;
import oracle.opatch.UpdateComponent;
import oracle.opatch.ipm.CookedInventory;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.IPMUtil;
import oracle.opatch.ipm.InstalledComponent;
import oracle.opatch.ipm.OHILock;
import oracle.opatch.ipm.RawInventory;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchutil.CommonAPIUtil;
import oracle.sysman.nextgen.NextGenPatching;
import oracle.sysman.nextgen.NextGenPatchingFactory;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiFileMapFileEntry;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallOneoffInvEntry;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiReleaseLevels;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiix.OiixLanguage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IPMReadServices
implements IIPMReadServices {
    private static IPMReadServices instance = null;
    protected static OHILock lock = null;
    protected static RawInventory rawInventory = null;
    protected static CookedInventory cookedInventory = null;
    protected static Map<PatchObject, PatchCheckResults> applyPatchCheckResultsMap = new HashMap<PatchObject, PatchCheckResults>();
    protected static Map<PatchObject, PatchCheckResults> rollbackPatchCheckResultsMap = new HashMap<PatchObject, PatchCheckResults>();
    protected static Map<PatchObject, Map<PatchComponent, PatchComponentCheckResult>> applyAnalyzedPatches = new HashMap<PatchObject, Map<PatchComponent, PatchComponentCheckResult>>();
    protected static Map<PatchObject, Map<PatchComponent, PatchComponentCheckResult>> rollbackAnalyzedPatches = new HashMap<PatchObject, Map<PatchComponent, PatchComponentCheckResult>>();

    protected IPMReadServices() {
    }

    protected static synchronized IPMReadServices getInstance() {
        if (instance == null) {
            instance = new IPMReadServices();
        }
        return instance;
    }

    @Override
    public void lock(String oracleHomePath) throws RuntimeException {
        if (lock != null) {
            OLogger.debug(new StringBuffer("IPMReadServices::init() IIPMReadServices has been already initialized"));
        } else {
            try {
                lock = OHILock.lock(oracleHomePath, true);
            }
            catch (Throwable e2) {
                OLogger.debug(new StringBuffer("Unable to acquire OHI Read Lock: "));
                RuntimeException re = new RuntimeException(e2.getMessage());
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
        }
    }

    @Override
    public void release() {
        if (lock != null) {
            lock.release();
            lock = null;
        }
    }

    @Override
    public void destroy() {
        this.release();
        if (cookedInventory != null) {
            cookedInventory.clearInventory();
            cookedInventory = null;
        }
        if (rawInventory != null) {
            rawInventory.clearInventory();
            rawInventory = null;
        }
        instance = null;
    }

    private boolean isLockedAsRO() {
        return lock != null && !lock.isWriterLock();
    }

    @Override
    public boolean isLocked() {
        return lock != null;
    }

    protected CookedInventory getCookedInventory() throws RuntimeException {
        StringBuffer buff = new StringBuffer("IPMReadServices::getCookedInventory()");
        OLogger.debug(buff);
        if (cookedInventory == null) {
            try {
                if (rawInventory == null) {
                    if (this.isLocked()) {
                        rawInventory = RawInventory.getInstance(lock.getOracleHomePath(), lock.getCurrentOUISession(), false);
                        PatchingModel.returnModelCode(lock.getOracleHomePath());
                    } else {
                        throw new RuntimeException("IPMReadServices or IPMRWServices has not been initialized");
                    }
                }
                cookedInventory = CookedInventory.getInstance(rawInventory);
            }
            catch (Throwable t) {
                buff = new StringBuffer("IPMReadServices::getCookedInventory() gets an error: ");
                buff.append(t.getMessage());
                OLogger.debug(buff);
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
        }
        return cookedInventory;
    }

    protected RawInventory getRawInventory() {
        StringBuffer buff = new StringBuffer("IPMReadServices::getRawInventory()");
        OLogger.debug(buff);
        if (rawInventory == null) {
            if (this.isLocked()) {
                try {
                    rawInventory = RawInventory.getInstance(lock.getOracleHomePath(), lock.getCurrentOUISession(), false);
                    PatchingModel.returnModelCode(lock.getOracleHomePath());
                }
                catch (Throwable t) {
                    buff = new StringBuffer("IPMReadServices::getRawInventory() gets an error: ");
                    buff.append(t.getMessage());
                    OLogger.debug(buff);
                    RuntimeException re = new RuntimeException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    throw re;
                }
            } else {
                throw new RuntimeException("IPMReadServices or IPMRWServices has not been initialized");
            }
        }
        return rawInventory;
    }

    @Override
    public void reloadInventory() throws RuntimeException {
        StringBuffer buff = new StringBuffer("IPMReadServices::clear()");
        OLogger.debug(buff);
        rawInventory = this.getRawInventory().reload();
        cookedInventory = this.getCookedInventory().reload(rawInventory);
    }

    @Override
    public boolean isInInventory(OneOffEntry entry) {
        return false;
    }

    @Override
    @Deprecated
    public void haveComponents(UpdateComponent[] componentsToCheck) throws RuntimeException {
    }

    @Override
    @Deprecated
    public PatchComponent[] haveComponents(PatchComponent[] componentsToCheck) throws RuntimeException {
        StringBuffer buff = new StringBuffer("IPMReadServices::haveComponents()");
        OLogger.debug(buff);
        if (componentsToCheck == null) {
            buff.append(" gets a null parameter componentsToCheck");
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
        if (componentsToCheck.length == 0) {
            buff.append(" gets an empty list.  Nothing to do, return empty list back.");
            OLogger.debug(buff);
            return componentsToCheck;
        }
        int size = componentsToCheck.length;
        PatchComponent[] presentComponents = new PatchComponent[size];
        buff = new StringBuffer("  there are ");
        buff.append(size);
        buff.append(" components to check.");
        OLogger.debug(buff);
        for (int i2 = 0; i2 < size; ++i2) {
            PatchComponentMissing missingPC;
            PatchComponent pc = componentsToCheck[i2];
            if (pc == null) {
                buff = new StringBuffer("IPMReadServices::haveComponents() gets a null entry inside array componentsToCheck");
                OLogger.debug(buff);
                throw new RuntimeException(buff.toString());
            }
            String compName = pc.getID();
            String searchVersion = pc.getVersion();
            boolean required = pc.isRequired();
            buff = new StringBuffer("  Patch Component (component to check) is \"");
            buff.append(compName);
            buff.append("\", \"");
            buff.append(searchVersion);
            buff.append("\", required = \"");
            buff.append(required);
            buff.append("\"");
            OLogger.debug(buff);
            OiiiCompInstallID refCid = new OiiiCompInstallID(compName, new OiiiVersion(searchVersion), OUIReplacer.Platform.getCurrentPlatformVector(), new OiiiVersion("0.0.0.0.0"), 1, 2, OiiiReleaseLevels.DefaultReleaseLevel());
            OiiiVersion oVersion = null;
            Vector oLang = new Vector();
            int oracleHomeIndex = this.getIndex();
            Vector compEntries = this.getRawInventory().getCompInvEntries(compName, oracleHomeIndex);
            if (compEntries == null) {
                buff = new StringBuffer("IPMReadServices::haveComponents() : ");
                buff.append("the home has no inventory");
                OLogger.debug(buff);
                throw new RuntimeException(buff.toString());
            }
            if (compEntries.size() == 0) {
                missingPC = new PatchComponentMissing(compName, searchVersion, required);
                presentComponents[i2] = missingPC;
                continue;
            }
            buff = new StringBuffer("IPMReadServices::haveComponents() : ");
            buff.append("getRawInventory().getCompInvEntries() on \"");
            buff.append(compName);
            buff.append("\", homeIndex = \"");
            buff.append(oracleHomeIndex);
            buff.append("\" returns ");
            buff.append(compEntries.size());
            buff.append(" components.");
            OLogger.debug(buff);
            for (int j2 = 0; j2 < compEntries.size(); ++j2) {
                OiiiVersion comVersion = null;
                OiiiVersion orgVersion = null;
                OiiiCompInstallID id = null;
                OiiiInstallCompInvEntry cie = (OiiiInstallCompInvEntry)compEntries.elementAt(j2);
                if (cie != null) {
                    id = cie.getCompInstallID();
                    oLang = cie.getLanguages();
                    if (id != null) {
                        orgVersion = id.getVersion();
                        buff = new StringBuffer("    \nProcess installed component \"");
                        buff.append(id.getName());
                        buff.append("\", version \"");
                        if (IPMReadServices.checkIfMiniPatchsetFunctional()) {
                            if (cie.getPatchInvEntry() != null) {
                                comVersion = id.getVersion();
                                buff.append(comVersion);
                            } else {
                                comVersion = cie.getHighestCompVersion();
                                id.setVersion(comVersion);
                                buff.append(comVersion);
                            }
                        } else {
                            comVersion = id.getVersion();
                            buff.append(comVersion.getVerString());
                        }
                        buff.append("\"");
                        OLogger.debug(buff);
                        if (id.getCompType() == 1 || id.getCompType() == 2) {
                            buff = new StringBuffer("    Check installed product: ");
                            buff.append("name=\"");
                            buff.append(id.getName());
                            buff.append("\", ver=\"");
                            buff.append(comVersion);
                            buff.append("\"");
                            OLogger.debug(buff);
                            buff = new StringBuffer("    Installed Comp >< Patch Comp: \n");
                            buff.append("      Installed Comp Version later than Patch Comp = ");
                            buff.append(comVersion.laterThan(refCid.getVersion()));
                            buff.append("\n");
                            buff.append("      Installed Comp can replace Patch Comp = ");
                            buff.append(id.canReplace(refCid, OUIReplacer.Platform.getCurrentPlatform()));
                            OLogger.debug(buff);
                            boolean installedIDEqualOrLater = comVersion.equals(refCid.getVersion()) || comVersion.laterThan(refCid.getVersion());
                            buff = new StringBuffer("      Install Comp Version equals ");
                            buff.append("or is later than Patch Comp: ");
                            buff.append(installedIDEqualOrLater);
                            OLogger.debug(buff);
                            if (installedIDEqualOrLater && id.canReplace(refCid, OUIReplacer.Platform.getCurrentPlatform()) && (oVersion == null || cie.getVersion().laterThan(oVersion))) {
                                buff = new StringBuffer("    Found a laterThan ");
                                buff.append("(or the same) of \"");
                                buff.append(searchVersion);
                                buff.append("\" as \"");
                                buff.append(cie.getVersion());
                                buff.append("\".  Save this version \"");
                                oVersion = comVersion;
                                buff.append(oVersion);
                                buff.append("\"");
                                OLogger.debug(buff);
                            }
                        } else {
                            buff = new StringBuffer("   It's not of type OiiiCompType.COMPONENT or OiiiCompType.COMPONENT, skip.");
                            OLogger.debug(buff);
                        }
                    } else {
                        buff = new StringBuffer("IPMReadServices::haveComponents() ");
                        buff.append("got a null OiiiCompInstallID from InstalledComponent entry.");
                        OLogger.debug(buff);
                    }
                } else {
                    buff = new StringBuffer("IPMReadServices::haveComponents() ");
                    buff.append("got a null OiiiCompInvEntry cie entry.");
                    OLogger.debug(buff);
                }
                id.setVersion(orgVersion);
            }
            if (oVersion != null) {
                String foundVersion = oVersion.getVerString();
                if (searchVersion.equals(foundVersion)) {
                    boolean isSnowBall;
                    buff = new StringBuffer("inventoryHasThisComponent(): component/version found");
                    buff.append("\nBut, let's check if it is language compatible");
                    OLogger.debug(buff);
                    Vector patchLangs = OiixLanguage.strToVect((String)pc.getLanguage());
                    boolean bl = isSnowBall = PatchingModel.returnModelCode(this.getRawInventory().getOracleHomePath()) == 2;
                    if (patchLangs != null && patchLangs.size() != 0 && isSnowBall) {
                        if (oLang.containsAll(patchLangs)) {
                            presentComponents[i2] = pc;
                            continue;
                        }
                        PatchComponentMissingLang missingLangPC = new PatchComponentMissingLang(compName, foundVersion, required, pc.getLanguage(), oLang);
                        presentComponents[i2] = missingLangPC;
                        continue;
                    }
                    if (pc.hasSymbol()) {
                        boolean symbolExists = false;
                        Set<String> productDirectories = this.getProductDirectories(pc.getSymbolName());
                        if (productDirectories != null && !productDirectories.isEmpty()) {
                            symbolExists = true;
                        }
                        if (!symbolExists) {
                            PatchComponentMissingSymbol missingSymbol = new PatchComponentMissingSymbol(compName, searchVersion, pc.getSymbolName(), required);
                            presentComponents[i2] = missingSymbol;
                            continue;
                        }
                        if (pc.getProductDirectories(this.getRawInventory().getOracleHomePath()) == null || pc.getProductDirectories(this.getRawInventory().getOracleHomePath()).length == 0) {
                            PatchComponentMissingProductDirectories missingPD = new PatchComponentMissingProductDirectories(compName, searchVersion, pc.getSymbolName(), required);
                            presentComponents[i2] = missingPD;
                            continue;
                        }
                    }
                    presentComponents[i2] = pc;
                    continue;
                }
                buff = new StringBuffer("inventoryHasThisComponent() found the component with higher version: ");
                buff.append("searchVersion = \"");
                buff.append(searchVersion);
                buff.append("\", foundVersion = \"");
                buff.append(foundVersion);
                buff.append("\" --> declare not found then.");
                PatchComponentVersionMismatch higherPC = new PatchComponentVersionMismatch(compName, searchVersion, foundVersion, required);
                presentComponents[i2] = higherPC;
                continue;
            }
            missingPC = new PatchComponentMissing(compName, searchVersion, required);
            presentComponents[i2] = missingPC;
        }
        return presentComponents;
    }

    private Map<PatchComponent, PatchComponentCheckResult> getPatchComponentCheckResults(List<PatchComponent> patchComponents) {
        HashMap<PatchComponent, PatchComponentCheckResult> result = new HashMap<PatchComponent, PatchComponentCheckResult>();
        if (patchComponents == null || patchComponents.size() == 0) {
            return result;
        }
        for (PatchComponent pc : patchComponents) {
            String compName = pc.getID();
            String searchVersion = pc.getVersion();
            boolean required = pc.isRequired();
            PatchComponentCheckResultImpl pcResult = new PatchComponentCheckResultImpl(pc);
            if (compName.equals("oracle.nextgen.metadata")) {
                pcResult.setResult(Result.PROCESS_COMPONENT);
                pcResult.setDetails(OLogger.getString("OUI-67405", new Object[]{pc.getID(), pc.getVersion()}));
                result.put(pc, pcResult);
                continue;
            }
            OiiiCompInstallID refCid = new OiiiCompInstallID(compName, new OiiiVersion(searchVersion), OUIReplacer.Platform.getCurrentPlatformVector(), new OiiiVersion("0.0.0.0.0"), 1, 2, OiiiReleaseLevels.DefaultReleaseLevel());
            OiiiVersion oVersion = null;
            Vector oLang = new Vector();
            int oracleHomeIndex = this.getIndex();
            Vector compEntries = this.getRawInventory().getCompInvEntries(compName, oracleHomeIndex);
            if (compEntries == null) {
                throw new RuntimeException("Home has no inventory");
            }
            if (compEntries.size() == 0) {
                if (pc.isRequired()) {
                    pcResult.setResult(Result.ERR_NOT_FOUND);
                    pcResult.setDetails(OLogger.getString("OUI-67402", new Object[]{pc.getID(), pc.getVersion()}));
                } else {
                    pcResult.setResult(Result.IGNORE_NOT_FOUND);
                    pcResult.setDetails(OLogger.getString("OUI-67403", new Object[]{pc.getID(), pc.getVersion()}));
                }
                result.put(pc, pcResult);
                continue;
            }
            for (int j2 = 0; j2 < compEntries.size(); ++j2) {
                OiiiVersion comVersion = null;
                OiiiVersion orgVersion = null;
                OiiiCompInstallID id = null;
                OiiiInstallCompInvEntry cie = (OiiiInstallCompInvEntry)compEntries.elementAt(j2);
                if (cie != null) {
                    id = cie.getCompInstallID();
                    oLang = cie.getLanguages();
                    if (id != null) {
                        orgVersion = id.getVersion();
                        if (IPMReadServices.checkIfMiniPatchsetFunctional()) {
                            if (cie.getPatchInvEntry() != null) {
                                comVersion = id.getVersion();
                            } else {
                                comVersion = cie.getHighestCompVersion();
                                id.setVersion(comVersion);
                            }
                        } else {
                            comVersion = id.getVersion();
                        }
                        if (id.getCompType() == 1 || id.getCompType() == 2) {
                            boolean installedIDEqualOrLater;
                            boolean bl = installedIDEqualOrLater = comVersion.equals(refCid.getVersion()) || comVersion.laterThan(refCid.getVersion());
                            if (installedIDEqualOrLater && id.canReplace(refCid, OUIReplacer.Platform.getCurrentPlatform()) && (oVersion == null || cie.getVersion().laterThan(oVersion))) {
                                oVersion = comVersion;
                            }
                        }
                    }
                }
                id.setVersion(orgVersion);
            }
            if (oVersion != null) {
                String foundVersion = oVersion.getVerString();
                if (searchVersion.equals(foundVersion)) {
                    boolean isSnowBall;
                    Vector patchLangs = OiixLanguage.strToVect((String)pc.getLanguage());
                    boolean bl = isSnowBall = PatchingModel.returnModelCode(this.getRawInventory().getOracleHomePath()) == 2;
                    if (patchLangs != null && patchLangs.size() != 0 && isSnowBall) {
                        if (oLang.containsAll(patchLangs)) {
                            pcResult.setResult(Result.PROCESS_COMPONENT);
                            pcResult.setDetails(OLogger.getString("OUI-67405", new Object[]{pc.getID(), pc.getVersion()}));
                            result.put(pc, pcResult);
                            continue;
                        }
                        if (required) {
                            pcResult.setResult(Result.ERR_NOT_FOUND);
                            pcResult.setDetails(OLogger.getString("OUI-67402", new Object[]{pc.getID(), pc.getVersion()}));
                        } else {
                            pcResult.setResult(Result.IGNORE_NOT_FOUND);
                            pcResult.setDetails(OLogger.getString("OUI-67403", new Object[]{pc.getID(), pc.getVersion()}));
                        }
                        pcResult.setDetails("");
                        result.put(pc, pcResult);
                        continue;
                    }
                    if (pc.hasSymbol()) {
                        boolean symbolExists = false;
                        Set<String> productDirectories = this.getProductDirectories(pc.getSymbolName());
                        if (productDirectories != null && !productDirectories.isEmpty()) {
                            symbolExists = true;
                        }
                        if (!symbolExists) {
                            if (required) {
                                pcResult.setResult(Result.ERR_NOT_FOUND);
                                pcResult.setDetails(OLogger.getString("OUI-67402", new Object[]{pc.getID(), pc.getVersion()}));
                            } else {
                                pcResult.setResult(Result.IGNORE_NOT_FOUND);
                                pcResult.setDetails(OLogger.getString("OUI-67403", new Object[]{pc.getID(), pc.getVersion()}));
                            }
                            pcResult.setDetails("");
                            result.put(pc, pcResult);
                            continue;
                        }
                        if (pc.getProductDirectories(this.getRawInventory().getOracleHomePath()) == null || pc.getProductDirectories(this.getRawInventory().getOracleHomePath()).length == 0) {
                            if (required) {
                                pcResult.setResult(Result.ERR_NOT_FOUND);
                                pcResult.setDetails(OLogger.getString("OUI-67402", new Object[]{pc.getID(), pc.getVersion()}));
                            } else {
                                pcResult.setResult(Result.IGNORE_NOT_FOUND);
                                pcResult.setDetails(OLogger.getString("OUI-67403", new Object[]{pc.getID(), pc.getVersion()}));
                            }
                            pcResult.setDetails("");
                            result.put(pc, pcResult);
                            continue;
                        }
                    }
                    pcResult.setResult(Result.PROCESS_COMPONENT);
                    pcResult.setDetails(OLogger.getString("OUI-67405", new Object[]{pc.getID(), pc.getVersion()}));
                    result.put(pc, pcResult);
                    continue;
                }
                pcResult.setResult(Result.VERSION_MISMATCH);
                pcResult.setDetails(OLogger.getString("OUI-67404", new Object[]{pc.getID(), foundVersion, searchVersion}));
                result.put(pc, pcResult);
                continue;
            }
            if (required) {
                pcResult.setResult(Result.ERR_NOT_FOUND);
                pcResult.setDetails(OLogger.getString("OUI-67402", new Object[]{pc.getID(), pc.getVersion()}));
            } else {
                pcResult.setResult(Result.IGNORE_NOT_FOUND);
                pcResult.setDetails(OLogger.getString("OUI-67403", new Object[]{pc.getID(), pc.getVersion()}));
            }
            result.put(pc, pcResult);
        }
        return result;
    }

    @Override
    public PatchCheckResults getPatchCheckResults(PatchObject patchObject, boolean rollback) throws RuntimeException {
        if (IPMUtil.isNextGenUpgradePatchingSupported()) {
            PatchCheckResults result = null;
            PatchCheckResults patchCheckResults = result = rollback ? rollbackPatchCheckResultsMap.get(patchObject) : applyPatchCheckResultsMap.get(patchObject);
            if (result != null) {
                return result;
            }
            try {
                NextGenPatching ngp = NextGenPatchingFactory.getNextGenPatching((File)new File(this.getOracleHomePath()));
                result = ngp.getPatchCheckResults(CommonAPIUtil.getInstance().getCommonAPIPatch(patchObject), rollback);
                for (ComponentCheckResult comp : result.getComponentCheckResults().values()) {
                    if (!comp.getResult().isNotEvaluated()) continue;
                    throw new RuntimeException("NextGen couldn't evaluate patch component check");
                }
                if (rollback) {
                    rollbackPatchCheckResultsMap.put(patchObject, result);
                } else {
                    applyPatchCheckResultsMap.put(patchObject, result);
                }
                return result;
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
        return null;
    }

    @Override
    public Map<PatchComponent, PatchComponentCheckResult> analyzePatchComponents(PatchObject patchObject, boolean rollback) {
        Map<PatchComponent, PatchComponentCheckResult> result;
        Map<PatchComponent, PatchComponentCheckResult> map = result = rollback ? rollbackAnalyzedPatches.get(patchObject) : applyAnalyzedPatches.get(patchObject);
        if (result != null) {
            return result;
        }
        result = new HashMap<PatchComponent, PatchComponentCheckResult>();
        if (IPMUtil.isNextGenUpgradePatchingSupported()) {
            PatchCheckResults pcr = this.getPatchCheckResults(patchObject, rollback);
            Map ccr = pcr.getComponentCheckResults();
            ArrayList<PatchComponent> ngProcessComps = new ArrayList<PatchComponent>();
            HashMap<String, ArrayList<PatchComponent>> lookupMap = new HashMap<String, ArrayList<PatchComponent>>();
            for (PatchComponent pc : patchObject.getPatchComponents()) {
                ArrayList<PatchComponent> pcs = (ArrayList<PatchComponent>)lookupMap.get(pc.getName() + "_" + pc.getVersion());
                if (pcs == null) {
                    pcs = new ArrayList<PatchComponent>();
                    pcs.add(pc);
                    lookupMap.put(pc.getName() + "_" + pc.getVersion(), pcs);
                    continue;
                }
                pcs.add(pc);
            }
            for (Map.Entry entry : ccr.entrySet()) {
                PatchInventory.Component comp = (PatchInventory.Component)entry.getKey();
                List pcs = (List)lookupMap.get(comp.getName() + "_" + comp.getVersion());
                ComponentCheckResult cResult = (ComponentCheckResult)entry.getValue();
                if (pcs == null) continue;
                if (cResult.getResult().isProcessComponent()) {
                    ngProcessComps.addAll(pcs);
                    continue;
                }
                for (PatchComponent pc : pcs) {
                    result.put(pc, this.toPatchComponentCheckResult(cResult, pc));
                }
            }
            Map<PatchComponent, PatchComponentCheckResult> furtherProcessedComps = this.getPatchComponentCheckResults(ngProcessComps);
            result.putAll(furtherProcessedComps);
        } else {
            PatchComponent[] pcs = patchObject.getPatchComponents();
            if (pcs != null) {
                List<PatchComponent> pcsAsList = Arrays.asList(pcs);
                result = this.getPatchComponentCheckResults(pcsAsList);
            }
        }
        if (rollback) {
            rollbackAnalyzedPatches.put(patchObject, result);
        } else {
            applyAnalyzedPatches.put(patchObject, result);
        }
        return result;
    }

    private PatchComponentCheckResult toPatchComponentCheckResult(ComponentCheckResult cResult, PatchComponent pc) {
        PatchComponentCheckResultImpl pcResult = new PatchComponentCheckResultImpl(pc);
        pcResult.setResult(cResult.getResult());
        if (pcResult.getResult().isNotEvaluated()) {
            pcResult.setDetails(OLogger.getString("OUI-67401", new Object[]{pc.getID(), pc.getVersion()}));
        } else if (pcResult.getResult().isErrNotFound()) {
            pcResult.setDetails(OLogger.getString("OUI-67402", new Object[]{pc.getID(), pc.getVersion()}));
        } else if (pcResult.getResult().isIgnoreNotFound()) {
            pcResult.setDetails(OLogger.getString("OUI-67403", new Object[]{pc.getID(), pc.getVersion()}));
        } else if (pcResult.getResult().isProcessComponent()) {
            pcResult.setDetails(OLogger.getString("OUI-67405", new Object[]{pc.getID(), pc.getVersion()}));
        } else if (pcResult.getResult().isProcessingNotRequired()) {
            pcResult.setDetails(OLogger.getString("OUI-67406", new Object[]{pc.getID(), pc.getVersion()}));
        } else {
            pcResult.setDetails(OLogger.getString("OUI-67404", new Object[]{pc.getID(), pc.getVersion()}));
        }
        return pcResult;
    }

    @Override
    public Map<PatchComponent, PatchComponentCheckResult> analyzeRequiredPatchComponents(PatchObject patchObject, boolean rollback) {
        Map<PatchComponent, PatchComponentCheckResult> analyzed = this.analyzePatchComponents(patchObject, rollback);
        HashMap<PatchComponent, PatchComponentCheckResult> result = new HashMap<PatchComponent, PatchComponentCheckResult>();
        for (Map.Entry<PatchComponent, PatchComponentCheckResult> entry : analyzed.entrySet()) {
            if (!entry.getKey().isRequired()) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Override
    public Map<PatchComponent, PatchComponentCheckResult> analyzeOptionalPatchComponents(PatchObject patchObject, boolean rollback) {
        Map<PatchComponent, PatchComponentCheckResult> analyzed = this.analyzePatchComponents(patchObject, rollback);
        HashMap<PatchComponent, PatchComponentCheckResult> result = new HashMap<PatchComponent, PatchComponentCheckResult>();
        for (Map.Entry<PatchComponent, PatchComponentCheckResult> entry : analyzed.entrySet()) {
            if (entry.getKey().isRequired()) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Override
    public Map<PatchObject, Map<PatchComponent, PatchComponentCheckResult>> analyzePatchComponents(List<PatchObject> patchObjs, boolean rollback) {
        HashMap<PatchObject, Map<PatchComponent, PatchComponentCheckResult>> result = new HashMap<PatchObject, Map<PatchComponent, PatchComponentCheckResult>>();
        if (patchObjs == null || patchObjs.size() == 0) {
            return result;
        }
        for (PatchObject patchObj : patchObjs) {
            result.put(patchObj, this.analyzePatchComponents(patchObj, rollback));
        }
        return result;
    }

    private Set<String> getProductDirectories(String symbol) throws RuntimeException {
        Collection distributions;
        StringBuffer buff = new StringBuffer("IPMReadServices::getProductDirectories()");
        HashSet<String> productDirectories = new HashSet<String>();
        OracleHomeInventory gdrInv = null;
        try {
            gdrInv = NGOUIInventoryFactory.getOracleHomeInventory(this.getRawInventory().getOracleHomePath());
        }
        catch (Exception e2) {
            buff = new StringBuffer("IPMReadServices::getProductDirectories() can't get the GDR inventory.");
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString(), e2);
        }
        try {
            distributions = gdrInv.getInstalledDistributions();
        }
        catch (Exception e3) {
            buff = new StringBuffer("IPMReadServices::getProductDirectories() failed to get installed distributions.");
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString(), e3);
        }
        for (Distribution distribution : distributions) {
            List mappings;
            DirectoryMap directoryMap = distribution.getDirectoryMap();
            try {
                mappings = directoryMap.getMappings(new String[]{symbol});
            }
            catch (Exception e4) {
                buff = new StringBuffer("IPMReadServices::getProductDirectories() failed to get symbol mappings.");
                OLogger.debug(buff);
                throw new RuntimeException(buff.toString(), e4);
            }
            if (mappings == null || mappings.isEmpty()) continue;
            for (Mapping mapping : mappings) {
                productDirectories.add(mapping.getDirectory());
            }
        }
        return productDirectories;
    }

    @Override
    public OneOffEntry[] getInstalledPatches() throws RuntimeException {
        return this.getCookedInventory().getInstalledPatches();
    }

    @Override
    public OneOffEntry[] getAllInstalledPatches() throws RuntimeException {
        return this.getCookedInventory().getAllInstalledPatches();
    }

    @Override
    public OneOffEntry[] getInactivePatches() throws RuntimeException {
        return this.getCookedInventory().getInactivePatches();
    }

    @Override
    public InstalledComponent[] getInstalledComponents() throws RuntimeException {
        return this.getCookedInventory().getInstalledComponents();
    }

    @Override
    public InstalledComponent[] getTopLevelInstalledComponents() throws RuntimeException {
        return this.getCookedInventory().getTopLevelInstalledComponents();
    }

    @Override
    public boolean isDesiredHome() throws RuntimeException {
        return this.getCookedInventory().isDesiredHome();
    }

    @Override
    public InstalledComponent[] getNextGenInstalledDistributions() {
        return this.getCookedInventory().getNextGenInstalledDistributions();
    }

    @Override
    public InstalledComponent[] getNextGenInstalledComponents() {
        return this.getCookedInventory().getNextGenInstalledComponents();
    }

    @Override
    public Vector getHomes() throws RuntimeException {
        return this.getRawInventory().getHomes();
    }

    @Override
    public String getGUID(String oracleHomePath) throws RuntimeException {
        return this.getRawInventory().getGUID(oracleHomePath);
    }

    @Override
    public OPatchSDK.OracleHome[] getOracleHomes() throws RuntimeException {
        return this.getRawInventory().getOracleHomes();
    }

    @Override
    public boolean isOracleHomeInfoExist() throws RuntimeException {
        return this.getRawInventory().isOracleHomeInfoExist();
    }

    @Override
    public boolean isCRSHome() throws RuntimeException {
        return this.getRawInventory().isCRSHome();
    }

    @Override
    public String getOracleHomeName() throws RuntimeException {
        return this.getRawInventory().getOracleHomeName();
    }

    @Override
    public String getLocalNode() throws RuntimeException {
        return this.getRawInventory().getLocalNode();
    }

    @Override
    public Integer getARUID() throws RuntimeException {
        return this.getRawInventory().getARUID();
    }

    @Override
    public String getARUIDDescription() throws RuntimeException {
        return this.getRawInventory().getARUIDDescription();
    }

    @Override
    public String getLocation() throws RuntimeException {
        return this.getRawInventory().getLocation();
    }

    @Override
    public Vector getNodeList() throws RuntimeException {
        return this.getRawInventory().getNodeList();
    }

    protected Integer getIndex() throws RuntimeException {
        this.getRawInventory();
        return RawInventory.getIndex();
    }

    @Override
    public String getAdditionalOracleHomeProperty(String propertyName) throws RuntimeException {
        return this.getRawInventory().getAdditionalOracleHomeProperty(propertyName);
    }

    @Override
    public boolean isCRSHomePresent() throws RuntimeException {
        OiiiOracleHomeInfo home = this.getCRSHome();
        return home != null;
    }

    @Override
    public String findCRSHomeLocation() throws RuntimeException {
        OiiiOracleHomeInfo home = this.getCRSHome();
        if (home != null) {
            return home.getLocation();
        }
        return null;
    }

    @Override
    public String findCRSHomeName() throws RuntimeException {
        OiiiOracleHomeInfo home = this.getCRSHome();
        if (home != null) {
            return home.getName();
        }
        return null;
    }

    private OiiiOracleHomeInfo getCRSHome() {
        Vector homes = this.getHomes();
        for (int i2 = 0; i2 < homes.size(); ++i2) {
            OiiiOracleHomeInfo home = (OiiiOracleHomeInfo)homes.get(i2);
            if (!home.isCRSHome()) continue;
            return home;
        }
        return null;
    }

    @Override
    public String findGridHomeLocation() throws RuntimeException {
        Vector homes = this.getHomes();
        for (int i2 = 0; i2 < homes.size(); ++i2) {
            OiiiOracleHomeInfo home = (OiiiOracleHomeInfo)homes.get(i2);
            if (!IPMUtil.isGridHome(home.getLocation())) continue;
            return home.getLocation();
        }
        return null;
    }

    @Override
    public boolean isGridHome(String oracleHomePath) throws RuntimeException {
        Vector homes = this.getHomes();
        for (Object home : homes) {
            OiiiOracleHomeInfo oh = (OiiiOracleHomeInfo)home;
            if (!oh.getLocation().equals(oracleHomePath) || !IPMUtil.isGridHome(oracleHomePath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getOracleHomePath() throws RuntimeException {
        return this.getRawInventory().getOracleHomePath();
    }

    @Override
    public String getXMLInvLocation(String patchID) throws RuntimeException {
        return this.getRawInventory().getXMLInvLocation(patchID);
    }

    @Override
    public OneOffEntry getLatestTranslationPatch(String patchID, String language) throws RuntimeException {
        OneOffEntry[] oneoffList = this.getInstalledPatches();
        for (int i2 = 0; i2 < oneoffList.length; ++i2) {
            String origPatchID = oneoffList[i2].getPatchID();
            String oneOffLanguage = oneoffList[i2].getPatchLanguage();
            if (!oneoffList[i2].couldBeTranslation() || !oneOffLanguage.equals(language) || !origPatchID.equals(patchID)) continue;
            return oneoffList[i2];
        }
        return null;
    }

    private static boolean checkIfMiniPatchsetFunctional() {
        if (OPatchEnv.isNextGen()) {
            return false;
        }
        try {
            Class<?> chkClass = Class.forName("oracle.sysman.oii.oiii.OiiiInstallMiniPatchsetInvEntry");
            if (chkClass != null) {
                chkClass = Class.forName("oracle.sysman.oii.oiii.OiiiInstallInventory");
                Method[] methods = chkClass.getMethods();
                boolean foundFlag = false;
                for (int i2 = 0; i2 < methods.length; ++i2) {
                    if (!methods[i2].getName().equals("isComponentInPatchSetUpdate")) continue;
                    foundFlag = true;
                    break;
                }
                return foundFlag;
            }
            return false;
        }
        catch (ClassNotFoundException e2) {
            return false;
        }
    }

    @Override
    public OneOffEntry getPatchFromInv(String patchID, String upi) throws RuntimeException {
        OneOffEntry[] oneoffList = this.getInstalledPatches();
        for (int i2 = 0; i2 < oneoffList.length; ++i2) {
            if (!oneoffList[i2].getPSENumber().equals(upi) || !oneoffList[i2].getID().equals(patchID)) continue;
            return oneoffList[i2];
        }
        return null;
    }

    @Override
    public void populatePatchInventoryAndComps(String oracleHome, String patchID, PatchInventory patchInventory, LinkedList compsList) throws RuntimeException {
        OiiiInstallOneoffInvEntry oEntry = null;
        try {
            oEntry = this.getRawInventory().getOneoffInvEntry(patchID, new Vector(), "", this.getRawInventory().getOracleHomeName());
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        Vector bugsFixedVector = oEntry.getBugs();
        for (int bIter = 0; bIter < bugsFixedVector.size(); ++bIter) {
            Bug bug = new Bug((String)bugsFixedVector.get(bIter), "No description available.");
            patchInventory.bugsToFix.add(bug);
        }
        patchInventory.patchID = patchID;
        patchInventory.setCreationTime("", "", "", "", "");
        patchInventory.setRawCreationDate("");
        patchInventory.setFormatCreationDate("");
        Platform platform = new Platform("Generic", "0");
        patchInventory.supportedPlatforms.add(platform);
        Vector files = oEntry.getFilesPatched();
        PatchComponent patchComp = new PatchComponent("Unknown", "0.0", true);
        for (int j2 = 0; j2 < files.size(); ++j2) {
            OiiiFileMapFileEntry entry = (OiiiFileMapFileEntry)files.get(j2);
            String child = entry.getFilePath();
            String parent = entry.getOwnerFilePath();
            String parentDirPath = entry.getParentDirPath();
            StringBuffer buff = null;
            if (parent != null) {
                buff = new StringBuffer("Processing entry - Parent :");
                buff.append(parent);
                buff.append("   child :\n");
                buff.append(child);
                OLogger.debug(buff);
                if (parent.endsWith(File.separator)) {
                    parent = parent.substring(0, parent.length() - 1);
                }
                int index = parent.lastIndexOf(File.separator);
                String name = "";
                String path = "";
                if (index != -1) {
                    name = parent.substring(index + 1);
                    path = parent.substring(oracleHome.length(), index);
                }
                if (!child.startsWith(File.separator)) {
                    child = File.separator + child;
                }
                String childName = path + File.separator + name + child;
                try {
                    buff = new StringBuffer("Adding entry; ");
                    buff.append("name: \"");
                    buff.append(name);
                    buff.append("\" path: \"");
                    buff.append(path);
                    buff.append("\" child: \"");
                    buff.append(childName);
                    buff.append("\"\n");
                    OLogger.printlnOnLog(buff.toString());
                    if (childName.endsWith("o") && name.endsWith("a")) {
                        ArchiveAction aa = new ArchiveAction(null, name, path, childName, j2);
                        aa.setBuiltFrom101Home(true);
                        patchComp.archiveList.add(aa);
                        continue;
                    }
                    JarAction ja = new JarAction(null, name, path, childName, j2);
                    ja.setBuiltFrom101Home(true);
                    patchComp.jarList.add(ja);
                    continue;
                }
                catch (Exception e3) {
                    RuntimeException re = new RuntimeException(e3.getMessage());
                    re.setStackTrace(e3.getStackTrace());
                    throw re;
                }
            }
            if (parentDirPath != null) {
                int index;
                buff = new StringBuffer("Processing entry - ParentDirPath : ");
                buff.append(parentDirPath);
                buff.append("   child : ");
                buff.append(child);
                OLogger.debug(buff);
                String name = "";
                String path = parentDirPath;
                if (child.endsWith(File.separator)) {
                    child = child.substring(0, child.length() - 1);
                }
                if ((index = child.lastIndexOf(File.separator)) != -1) {
                    name = child.substring(index + 1);
                }
                String fileName = path + File.separator + name;
                try {
                    buff = new StringBuffer("Adding entry; ");
                    buff.append("name: \"");
                    buff.append(name);
                    buff.append("\" path: \"");
                    buff.append(path);
                    buff.append("\" fileName: \"");
                    buff.append(fileName);
                    buff.append("\"\n");
                    OLogger.printlnOnLog(buff.toString());
                    CopyAction ca = new CopyAction(null, name, path, fileName, j2);
                    ca.setBuiltFrom101Home(true);
                    patchComp.copyList.add(ca);
                    continue;
                }
                catch (Exception e4) {
                    RuntimeException re = new RuntimeException(e4.getMessage());
                    re.setStackTrace(e4.getStackTrace());
                    throw re;
                }
            }
            RuntimeException re = new RuntimeException("Unable to get the files touched entry properly.");
            throw re;
        }
        compsList.add(patchComp);
    }

    @Override
    public boolean isInventoryLoaded() {
        return rawInventory != null;
    }

    @Override
    public void loadInventory(String oracleHomePath) throws RuntimeException {
        if (rawInventory != null && !this.getOracleHomePath().equals(oracleHomePath)) {
            StringBuffer buff = new StringBuffer("IPMReadServices::loadInventory() is called for different OH");
            OLogger.debug(buff);
            rawInventory = null;
            cookedInventory = null;
        }
        this.getRawInventory();
    }

    @Override
    public OneOffEntry[] getInactivePSUTrain() throws RuntimeException {
        return this.getCookedInventory().getInactivePSUTrain();
    }

    @Override
    public OneOffEntry[] getInstalledPatchesIncludeInactive() throws RuntimeException {
        return this.getCookedInventory().getInstalledPatchesIncludeInactive();
    }

    public static void destroyObject() {
        applyAnalyzedPatches.clear();
        applyPatchCheckResultsMap.clear();
        rollbackAnalyzedPatches.clear();
        rollbackPatchCheckResultsMap.clear();
        cookedInventory = null;
        rawInventory = null;
        instance = null;
    }
}

