/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.napplyhelper;

import java.util.Vector;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.OneOffEntry;
import oracle.opatch.napplyhelper.NApplyData;
import oracle.opatch.napplyhelper.NapplyProcessHelper;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.CheckConflictAdapter;
import oracle.opatch.opatchprereq.ConflictMatrixOutput;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.opatch.opatchprereq.PrereqSet;
import oracle.opatch.opatchsdk.OPatchPatchPrereq;
import oracle.opatch.opatchutil.OUSession;

public class CheckIntraConflict {
    private NApplyData data;
    private OneOffEntry[] patchesToApply;

    public CheckIntraConflict(NApplyData data) {
        this.data = data;
    }

    public void doIntraCheck(String oracleHomePath, NApplyData data) {
        this.getResult(oracleHomePath, data);
        this.processIntra(data);
    }

    private void getResult(String oracleHomePath, NApplyData data) {
        StringBuffer dBuff = new StringBuffer("N-Apply: check Intra-conflict ");
        OLogger.debug(dBuff);
        dBuff = new StringBuffer("N-Apply: calling CheckConflictAdapter.checkConflictAmongPatchesWithDetail()");
        OLogger.debug(dBuff);
        OLogger.printlnOnLog("Checking conflict among patches...");
        this.patchesToApply = data.getPatchesToApply();
        CheckConflictAdapter adapter = new CheckConflictAdapter();
        ConflictMatrixOutput intraOutput = adapter.checkConflictAmongPatchesWithDetail(oracleHomePath, this.patchesToApply);
        data.setIntraOutput(intraOutput);
        data.setCheckConflictAdapter(adapter);
        OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_CONFLICT_AMONG_PATCHES, data.getIntraOutput());
    }

    private void processIntra(NApplyData data) {
        ConflictMatrixOutput intraOutput = data.getIntraOutput();
        PrereqResult.ExecuteStatus intraStatus = intraOutput.getResult();
        if (intraStatus == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
            OLogger.log("Conflict checking amongst patches is NOT EXECUTED", new Object[0]);
            StringBuffer dBuff = new StringBuffer("PrereqAPI.checkConflictAmongPatchesWithDetail() returns NOT_EXECUTED.");
            OLogger.debug(dBuff);
            Vector detail = intraOutput.getResultDetails();
            dBuff = new StringBuffer("N-Apply: calling PrereqProcessHelper.processPrereqNotExecuted");
            OLogger.debug(dBuff);
            NapplyProcessHelper.processPrereqNotExecuted(detail);
        } else if (intraStatus == PrereqResult.ExecuteStatus.FAILED) {
            OLogger.log("Conflict checking amongst patches is FAILED", new Object[0]);
            this.processFail(data);
        } else {
            OLogger.log("Conflict checking amongst patches PASSED", new Object[0]);
            this.processSucceed(data);
        }
    }

    private void processSucceed(NApplyData data) {
        ConflictMatrixOutput intraOutput = data.getIntraOutput();
        StringBuffer dBuff = new StringBuffer("PrereqAPI.checkConflictAmongPatchesWithDetail() returns SUCCEED.");
        OLogger.debug(dBuff);
        PrereqSet patchesThatCanGoNow = new PrereqSet(intraOutput.getListOfPatchesThatCanGoNow());
        PrereqSet patchesNotNeeded = new PrereqSet(intraOutput.getListOfPatchesNotNeeded());
        String msg = "";
        boolean composite = false;
        if (patchesThatCanGoNow.size() == 0) {
            dBuff = new StringBuffer("N-Apply: patchesThatCanGoNow's size = 0 ");
            OLogger.debug(dBuff);
            if (patchesNotNeeded.size() != 0) {
                dBuff = new StringBuffer("N-Apply: patchesNotNeeded's size != 0 ");
                OLogger.debug(dBuff);
                StringBuffer buff = new StringBuffer("");
                for (int i2 = 0; i2 < patchesNotNeeded.size(); ++i2) {
                    buff.append("   ");
                    buff.append(patchesNotNeeded.getElement(i2).getID());
                }
                OLogger.warn("OUI-67302", new Object[]{buff.toString()});
            }
            msg = OLogger.getString("OUI-67305");
            RuntimeException re = new RuntimeException(msg);
            OPatchStateManagerFactory.getInstance().setErrorCode(218);
            throw re;
        }
        dBuff = new StringBuffer("N-Apply: patchesThatCanGoNow's size > 0 ");
        OLogger.debug(dBuff);
        data.setNotNeedPatches(patchesNotNeeded);
        data.setCanGoPatches(patchesThatCanGoNow);
    }

    private void processFail(NApplyData data) {
        ConflictMatrixOutput intraOutput = data.getIntraOutput();
        CheckConflictAdapter adapter = data.getCheckConflictAdapter();
        if (adapter.isConflictStatusCode()) {
            PrereqSet patchesToBeMerged = new PrereqSet(intraOutput.getListOfPatchesToBeMerged());
            StringBuffer dBuff = new StringBuffer("PrereqAPI.checkConflictAmongPatchesWithDetail() returns FAILED.");
            OLogger.debug(dBuff);
            Vector detail = intraOutput.getResultDetails();
            String msg = intraOutput.getConflictDetailsString();
            OLogger.println(msg);
            dBuff = new StringBuffer("N-Apply: patchesToBeMerged's size != 0 ");
            OLogger.debug(dBuff);
            StringBuffer buff = new StringBuffer("");
            OLogger.println("");
            for (int i2 = 0; i2 < patchesToBeMerged.size(); ++i2) {
                buff.append("   ");
                String id = patchesToBeMerged.getElement(i2).getID();
                buff.append(id);
                if (data.getModelCode() != 2) continue;
                if (patchesToBeMerged.getElement(i2).getPatchType().equals("snowball")) {
                    OLogger.println("Patch \"" + id + "\" is a \"" + "Fusion Applications" + "\" patch.");
                    continue;
                }
                if (!patchesToBeMerged.getElement(i2).getPatchType().equals("singleton")) continue;
                OLogger.println("Patch \"" + id + "\" is a \"" + "singleton" + "\" patch.");
            }
            OLogger.warn("OUI-67301", new Object[]{buff.toString()});
            String errorMsg = "Intra-conflict checking failed in apply incoming patches";
            throw new RuntimeException(errorMsg);
        }
        throw new RuntimeException(adapter.getPrereqErrorMessage());
    }
}

