/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.napplyhelper;

import java.util.ArrayList;
import oracle.opatch.InitReadMeAction;
import oracle.opatch.InitScriptAction;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.PatchObject;
import oracle.opatch.Rules;
import oracle.opatch.napplyhelper.NApplyData;
import oracle.opatch.napplyhelper.NapplyProcessHelper;
import oracle.opatch.opatchlogger.OLogger;

public class RunConsolidatedScripts {
    private NApplyData data;

    public RunConsolidatedScripts(NApplyData data) {
        this.data = data;
    }

    public void runScripts(String oracleHomePath, NApplyData data) {
        int i2;
        ArrayList<InitReadMeAction> rollbackInitReadMes = new ArrayList<InitReadMeAction>();
        ArrayList<NapplyProcessHelper.InitScriptBuff> rollbackInitScripts = new ArrayList<NapplyProcessHelper.InitScriptBuff>();
        PatchObject[] arbPatchObjects = data.getArbPatchObjects();
        for (int i3 = 0; i3 < arbPatchObjects.length; ++i3) {
            PatchObject po = arbPatchObjects[i3];
            String id = po.getPatchID();
            String eachCookedID = po.getCookedPatchID();
            String prevAppliedPatchLocation = OPatchEnv.getPatchBackupDirectoryPath(oracleHomePath, eachCookedID);
            String initReadMeLoc = PatchObject.getInitReadMeFilePath(prevAppliedPatchLocation);
            String initScriptLoc = PatchObject.getInitScriptFilePath(prevAppliedPatchLocation);
            po.setInitReadMeAction(new InitReadMeAction(initReadMeLoc));
            po.setInitScriptAction(new InitScriptAction(initScriptLoc));
            InitReadMeAction initRead = po.getInitReadMeAction();
            InitScriptAction initScript = po.getInitScriptAction();
            try {
                if (initRead != null && !initRead.isNoOp()) {
                    InitReadMeAction i1 = (InitReadMeAction)initRead.clone();
                    rollbackInitReadMes.add(i1);
                }
                if (initScript == null || initScript.isNoOp()) continue;
                InitScriptAction i22 = (InitScriptAction)initScript.clone();
                NapplyProcessHelper.InitScriptBuff initBuff = new NapplyProcessHelper.InitScriptBuff(i22, id);
                rollbackInitScripts.add(initBuff);
                continue;
            }
            catch (CloneNotSupportedException e2) {
                StringBuffer buff = new StringBuffer("NApply not able to clone auto-rollback Init Actions: ");
                buff.append(e2.getMessage());
                throw new RuntimeException(buff.toString());
            }
        }
        StringBuffer dBuff = new StringBuffer("N-Apply: run all Init-scripts of auto-rollback");
        OLogger.debug(dBuff);
        for (i2 = 0; i2 < rollbackInitReadMes.size(); ++i2) {
            InitReadMeAction readme = (InitReadMeAction)rollbackInitReadMes.get(i2);
            readme.process();
        }
        for (i2 = 0; i2 < rollbackInitScripts.size(); ++i2) {
            NapplyProcessHelper.InitScriptBuff initBuff = (NapplyProcessHelper.InitScriptBuff)rollbackInitScripts.get(i2);
            InitScriptAction script = initBuff.a;
            String patchID = initBuff.patchID;
            String arg = OPatchSessionHelper.getInitScriptActionArgumentForRollBack(patchID);
            int initReturnVal = script.process(arg, "rollback", patchID);
            if (initReturnVal == 0) continue;
            String initMsg = OLogger.getString("OUI-67133", new Object[]{"INIT", Integer.toString(initReturnVal)});
            OLogger.warn("OUI-67133", new Object[]{"INIT", Integer.toString(initReturnVal)});
            if (Rules.shouldContinueInCaseOfPrePostError("")) continue;
            RuntimeException initRe = new RuntimeException(initMsg);
            throw initRe;
        }
    }
}

