/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import oracle.opatch.opatchfafmw.FMWContext;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.OPatchStepAdapter;
import oracle.opatch.opatchfafmw.Operation;
import oracle.opatch.opatchfafmw.SOAComposite;
import oracle.opatch.opatchfafmw.SOACompositeManager;
import oracle.opatch.opatchfafmw.Util;
import oracle.opatch.opatchfafmw.rb.RB;
import oracle.opatch.opatchsdk.OPatchFAStep;

final class CheckSOACompositeUndeploy
implements Operation {
    CheckSOACompositeUndeploy() {
    }

    public void run(FMWContext c2) {
        SOACompositeManager scm = c2.getDomain().getSOACompositeManager();
        String[] compRevs = c2.getCompRevisionToUndeploy();
        String prevDefaultRevision = compRevs[0];
        String revision = compRevs[1];
        String list = "";
        OPatchStepAdapter prereqStep = null;
        String errorMsg = "";
        try {
            list = Util.norm(scm.listDeployedComposites());
        }
        catch (Throwable t) {
            prereqStep = new OPatchStepAdapter(OPatchFAStep.GET_LIST_OF_SOA_COMPOSITES);
            prereqStep.setSuccess(false);
            prereqStep.setStepDescription("Try to get list of deployed SOA Composites");
            errorMsg = "OPatch was not able to get the list of deployed SOA Composites.";
            if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
            }
            prereqStep.setErrorMessage(errorMsg);
            RuntimeException re = new RuntimeException(t);
            prereqStep.setExceptionObject(re);
            c2.getContextBuilder().setFailedPrereqStep(prereqStep);
            throw re;
        }
        if (Logger.debug) {
            Logger.debug("Details of deployed SOA Composites\n" + list);
        }
        if ("".equals(list)) {
            Logger.warn(RB.Entry.UNDEPLOY_NO_COMPOSITES_CONFIGURED, new Object[0]);
            c2.clearSOAComposite();
            prereqStep = new OPatchStepAdapter(OPatchFAStep.CHECK_SOA_COMPOSITES_CONFIGURED);
            prereqStep.setSuccess(false);
            prereqStep.setStepDescription("Check if SOA Composites are configured for redeployment");
            prereqStep.setErrorMessage("No SOA Composites are configured. Composites will not be redeployed during deployment operation");
            c2.getContextBuilder().setFailedPrereqStep(prereqStep);
            return;
        }
        SOAComposite sc = c2.getSOAComposite();
        String name = sc.getName();
        String compositeDN = "default/" + name + '!' + revision;
        try {
            Logger.logi("Check if the input revision of the composite is deployed [" + compositeDN + "]");
            if (!scm.isDeployed(compositeDN)) {
                throw new RuntimeException("The composite \"" + name + "\" with revision \"" + revision + "\" is not deployed. Current Operation cannot be performed.");
            }
            Logger.logi("Input revision of the composite is deployed");
        }
        catch (Throwable t) {
            OPatchStepAdapter isDeployedStep = new OPatchStepAdapter(OPatchFAStep.CHECK_COMPOSITE_DEPLOYED);
            isDeployedStep.setStepDescription("Find if the composite revision is deployed");
            isDeployedStep.setSuccess(false);
            errorMsg = t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError ? "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set." : t.getMessage();
            if (errorMsg != null) {
                isDeployedStep.setErrorMessage(errorMsg);
            }
            RuntimeException re = new RuntimeException(t);
            isDeployedStep.setExceptionObject(re);
            c2.getContextBuilder().setFailedPrereqStep(isDeployedStep);
            throw re;
        }
        String prevCompositeDN = "default/" + name + '!' + prevDefaultRevision;
        try {
            Logger.logi("Check if the previous default revision of the composite is present in the system [" + prevCompositeDN + "]");
            if (!scm.isDeployed(prevCompositeDN)) {
                throw new RuntimeException("The composite \"" + name + "\" with revision \"" + prevDefaultRevision + "\" is not present in the system. Current Operation cannot be performed.");
            }
            Logger.logi("previous default revision of the composite is present in the system");
        }
        catch (Throwable t) {
            OPatchStepAdapter isDeployedStep = new OPatchStepAdapter(OPatchFAStep.CHECK_COMPOSITE_DEPLOYED);
            isDeployedStep.setStepDescription("Find if the previous default revision is present");
            isDeployedStep.setSuccess(false);
            errorMsg = t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError ? "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set." : t.getMessage();
            if (errorMsg != null) {
                isDeployedStep.setErrorMessage(errorMsg);
            }
            RuntimeException re = new RuntimeException(t);
            isDeployedStep.setExceptionObject(re);
            c2.getContextBuilder().setFailedPrereqStep(isDeployedStep);
            throw re;
        }
    }
}

