/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import java.io.File;
import oracle.fabric.deploy.jaxb2.UpdateType;
import oracle.opatch.OPatchEnv;
import oracle.opatch.opatchfafmw.FMWContext;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.OPatchSOAStep;
import oracle.opatch.opatchfafmw.OPatchStepAdapter;
import oracle.opatch.opatchfafmw.Operation;
import oracle.opatch.opatchfafmw.SOAComposite;
import oracle.opatch.opatchfafmw.SOACompositeManager;
import oracle.opatch.opatchfafmw.SOATimeoutException;
import oracle.opatch.opatchfafmw.Util;
import oracle.opatch.opatchfafmw.rb.RB;
import oracle.opatch.opatchsdk.OPatchFAStep;

final class DeploySOAComposite
implements Operation {
    DeploySOAComposite() {
    }

    /*
     * Loose catch block
     */
    public void run(FMWContext c2) {
        String name;
        String defaultRevAfterDeploy;
        SOAComposite sc;
        SOACompositeManager scm;
        String newCompositeDN;
        String compositeDN;
        boolean undeploy;
        boolean enableEdn;
        String errorMsg;
        block123: {
            errorMsg = "";
            enableEdn = false;
            undeploy = false;
            boolean report = OPatchEnv.isReport();
            compositeDN = "";
            newCompositeDN = "";
            scm = c2.getDomain().getSOACompositeManager();
            sc = c2.getSOAComposite();
            defaultRevAfterDeploy = "";
            if (sc == null) {
                return;
            }
            String path = sc.getPath();
            name = sc.getName();
            String revision = sc.getRevision();
            if (!Util.existFile(path)) {
                errorMsg = Logger.getString(RB.Entry.SOA_COMPOSITE_NOT_EXIST, path, name);
                RuntimeException re = new RuntimeException(errorMsg);
                OPatchStepAdapter existFileStep = new OPatchStepAdapter(OPatchFAStep.CHECK_PATH_EXISTS);
                existFileStep.setStepDescription("Check SOA Composite exists");
                existFileStep.setErrorMessage(errorMsg);
                existFileStep.setExceptionObject(re);
                existFileStep.setSuccess(false);
                c2.getContextBuilder().addExecutionStep(existFileStep);
                Logger.loge(errorMsg);
                throw re;
            }
            if (report) {
                OPatchSOAStep connectPromptStep = new OPatchSOAStep(OPatchFAStep.SOA_WLST_SERVER_CONNECT);
                connectPromptStep.setStepDescription("[Connects WLST to a WebLogic Server instance as online model, this step is need by following WLST commands but not done here]");
                connectPromptStep.setSuccess(true);
                c2.getContextBuilder().addExecutionStep(connectPromptStep);
            }
            String defaultRevision = "";
            OPatchStepAdapter defaultRevStep = new OPatchStepAdapter(OPatchFAStep.SOA_GET_DEFAULT_REVISION);
            defaultRevStep.setStepDescription("Get Default Revision of the composite");
            try {
                defaultRevision = scm.getDefaultRevision(name);
                defaultRevStep.setSuccess(true);
                c2.getContextBuilder().addExecutionStep(defaultRevStep);
            }
            catch (Throwable t) {
                errorMsg = "Error in getting default Revision of the composite.";
                if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                    errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
                }
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                defaultRevStep.setSuccess(false);
                defaultRevStep.setErrorMessage(errorMsg);
                defaultRevStep.setExceptionObject(re);
                c2.getContextBuilder().addExecutionStep(defaultRevStep);
                Logger.loge(errorMsg);
                Logger.loge(re);
                throw re;
            }
            Logger.logi("[SOA COMPOSITE] Default revision of composite before deployment [" + defaultRevision + "]");
            sc.setDefaultRevisionBeforeDeploy(defaultRevision);
            String tempLocation = Util.getTempLocation(c2.getTempLocation(), name);
            Logger.logi("Temporary Location used to store jars generated in SOA Deployment steps [" + tempLocation + "]");
            String s = tempLocation + System.getProperty("file.separator") + "sca_" + name + "_rev" + defaultRevision + "-";
            String composite = s + "composite.jar";
            String customization = s + "customization.jar";
            String property = s + "property.jar";
            String runtime = s + "runtime.jar";
            String plan = s + "configplan.xml";
            String log = s + "mergelog.xml";
            String result = s + "result.jar";
            Util.deleteFile(composite);
            Util.deleteFile(customization);
            Util.deleteFile(property);
            Util.deleteFile(runtime);
            Util.deleteFile(plan);
            Util.deleteFile(log);
            Util.deleteFile(result);
            Logger.logi("Path where the jar is taken is -> " + path);
            String jarName = new File(path).getName();
            String jarWithPlan = tempLocation + System.getProperty("file.separator") + jarName;
            Util.deleteFile(jarWithPlan);
            if (!Util.copyFile(path, jarWithPlan)) {
                errorMsg = "OPatch was not able to copy composite jar to the temporary location";
                Logger.loge(errorMsg);
                RuntimeException re1 = new RuntimeException(errorMsg);
                OPatchStepAdapter copyFileStep = new OPatchStepAdapter(OPatchFAStep.COPY_JAR_TO_TEMP_LOCATION);
                copyFileStep.setStepDescription("Copy composite Jar to temporary location");
                copyFileStep.setSuccess(false);
                copyFileStep.setErrorMessage(errorMsg);
                copyFileStep.setExceptionObject(re1);
                c2.getContextBuilder().addExecutionStep(copyFileStep);
                throw re1;
            }
            compositeDN = "default/" + name + '!' + defaultRevision;
            newCompositeDN = "default/" + name + '!' + revision;
            Logger.logi("[SOA COMPOSITE] Export composite ");
            OPatchSOAStep exportStep = new OPatchSOAStep(OPatchFAStep.SOA_EXPORT_COMPOSITE);
            exportStep.setStepDescription("Export composite.");
            exportStep.setUpdateType(UpdateType.NONE.name());
            exportStep.setSarFile(composite);
            exportStep.setRevision(defaultRevision);
            exportStep.setCompositeName(name);
            try {
                scm.exportComposite(UpdateType.NONE, compositeDN, composite);
                exportStep.setSuccess(true);
                c2.getContextBuilder().addExecutionStep(exportStep);
            }
            catch (Throwable t) {
                errorMsg = "Error in export composite for [" + compositeDN + "].";
                if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                    errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
                }
                exportStep.setSuccess(false);
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                exportStep.setExceptionObject(re);
                exportStep.setErrorMessage(errorMsg);
                c2.getContextBuilder().addExecutionStep(exportStep);
                Logger.loge(errorMsg);
                Logger.loge(re);
                throw re;
            }
            if (Util.existFile(composite)) {
                Logger.logi("[SOA COMPOSITE] Check JDev customizations");
                OPatchStepAdapter jdevCustStep = new OPatchStepAdapter(OPatchFAStep.SOA_JDEV_CUSTOMIZATION_CHECK);
                jdevCustStep.setStepDescription("Check JDev customizations");
                try {
                    if (scm.isJdevCustomizationRequired(composite, jarWithPlan)) {
                        errorMsg = Logger.getString(RB.Entry.SOA_COMPOSITE_JDEV_CUST, defaultRevision, name, sc.getPath());
                        throw new Exception(errorMsg);
                    }
                    jdevCustStep.setSuccess(true);
                    c2.getContextBuilder().addExecutionStep(jdevCustStep);
                }
                catch (Throwable t) {
                    errorMsg = "Error in executing JDev customizations API.";
                    if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                        errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
                    }
                    jdevCustStep.setSuccess(false);
                    jdevCustStep.setErrorMessage(errorMsg);
                    RuntimeException re = new RuntimeException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    jdevCustStep.setExceptionObject(re);
                    c2.getContextBuilder().addExecutionStep(jdevCustStep);
                    Logger.loge(errorMsg);
                    Logger.loge(re);
                    throw re;
                }
                Logger.logi("[SOA COMPOSITE] Extract plan");
                OPatchSOAStep extractPlanStep = new OPatchSOAStep(OPatchFAStep.SOA_EXTRACT_PLAN);
                extractPlanStep.setStepDescription("Extract Plan");
                extractPlanStep.setSarFile(composite);
                extractPlanStep.setConfigPlan(plan);
                try {
                    scm.extractPlan(composite, plan);
                    extractPlanStep.setSuccess(true);
                    c2.getContextBuilder().addExecutionStep(extractPlanStep);
                }
                catch (Throwable t) {
                    errorMsg = "Error in Extract plan step.";
                    if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                        errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
                    }
                    extractPlanStep.setSuccess(false);
                    RuntimeException re = new RuntimeException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    extractPlanStep.setExceptionObject(re);
                    extractPlanStep.setErrorMessage(errorMsg);
                    c2.getContextBuilder().addExecutionStep(extractPlanStep);
                    Logger.loge(errorMsg);
                    Logger.loge(re);
                    throw re;
                }
            }
            Logger.logw("[SOA COMPOSITE] Skip JDev customizations check as no composite is exported.");
            Logger.logw("[SOA COMPOSITE] Skip Extract plan as no composite is exported.");
            String msg = "Could not find soa composite jar";
            OPatchStepAdapter checkCompositeJar = new OPatchStepAdapter(OPatchFAStep.CHECK_SOA_COMPOSITE_JAR);
            checkCompositeJar.setStepDescription("check if composite jar is generated");
            checkCompositeJar.setSuccess(false);
            checkCompositeJar.setErrorMessage(msg);
            c2.getContextBuilder().addExecutionStep(checkCompositeJar);
            Logger.loge(msg);
            throw new RuntimeException(msg);
            Logger.logi("[SOA COMPOSITE] Export updates");
            OPatchSOAStep exportUpdateStep = new OPatchSOAStep(OPatchFAStep.SOA_EXPORT_UPDATES);
            exportUpdateStep.setStepDescription("Export updates");
            exportUpdateStep.setUpdateType(UpdateType.ALL.name());
            exportUpdateStep.setJarFile(customization);
            exportUpdateStep.setCompositeName(name);
            exportUpdateStep.setRevision(defaultRevision);
            try {
                scm.exportUpdates(UpdateType.ALL, compositeDN, customization);
                exportUpdateStep.setSuccess(true);
                c2.getContextBuilder().addExecutionStep(exportUpdateStep);
            }
            catch (Throwable t) {
                errorMsg = "Error in exporting updates.";
                if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                    errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
                }
                exportUpdateStep.setSuccess(false);
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                exportUpdateStep.setExceptionObject(re);
                exportUpdateStep.setErrorMessage(errorMsg);
                c2.getContextBuilder().addExecutionStep(exportUpdateStep);
                Logger.loge(errorMsg);
                Logger.loge(re);
                throw re;
            }
            if (Util.existFile(plan)) {
                Logger.logi("[SOA COMPOSITE] Attach plan");
                OPatchSOAStep attachPlanStep = new OPatchSOAStep(OPatchFAStep.SOA_ATTACH_PLAN);
                attachPlanStep.setStepDescription("Attach plan");
                attachPlanStep.setSarFile(jarWithPlan);
                attachPlanStep.setConfigPlan(plan);
                try {
                    scm.attachPlan(jarWithPlan, plan, true);
                    attachPlanStep.setSuccess(true);
                    c2.getContextBuilder().addExecutionStep(attachPlanStep);
                }
                catch (Throwable t) {
                    errorMsg = "Error in attaching plan.";
                    if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                        errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
                    }
                    attachPlanStep.setSuccess(false);
                    RuntimeException re = new RuntimeException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    attachPlanStep.setExceptionObject(re);
                    attachPlanStep.setErrorMessage(errorMsg);
                    c2.getContextBuilder().addExecutionStep(attachPlanStep);
                    Logger.loge(errorMsg);
                    Logger.loge(re);
                    throw re;
                }
            } else {
                Logger.logi(" Skip Attach Plan step as no plan file exists.");
            }
            if (Util.existFile(customization)) {
                Logger.logi("[SOA COMPOSITE] Merge updates");
                OPatchSOAStep mergeUpdatesStep = new OPatchSOAStep(OPatchFAStep.SOA_MERGE_UPDATES);
                mergeUpdatesStep.setStepDescription("Merge Updates");
                mergeUpdatesStep.setLogFile(log);
                mergeUpdatesStep.setResultJarfile(result);
                mergeUpdatesStep.setR1SarFile(composite);
                mergeUpdatesStep.setR2SarFile(jarWithPlan);
                mergeUpdatesStep.setR1modJarFile(customization);
                try {
                    scm.mergeUpdates(result, composite, jarWithPlan, customization, log);
                    if (!Util.existFile(result)) {
                        errorMsg = "OPatch was not able to merge updates using SOA's merge tool. Details are: result=";
                        if (result != null) {
                            errorMsg = errorMsg + result;
                        }
                        errorMsg = errorMsg + ", composite=";
                        if (composite != null) {
                            errorMsg = errorMsg + composite;
                        }
                        errorMsg = errorMsg + ", jarWithPlan=";
                        if (jarWithPlan != null) {
                            errorMsg = errorMsg + jarWithPlan;
                        }
                        errorMsg = errorMsg + ", customization=";
                        if (customization != null) {
                            errorMsg = errorMsg + customization;
                        }
                        errorMsg = errorMsg + ", log=";
                        if (log != null) {
                            errorMsg = errorMsg + log;
                        }
                        errorMsg = errorMsg + " (DeploySOAComposite::run(FMWContext)).";
                        throw new Exception(errorMsg);
                    }
                    mergeUpdatesStep.setSuccess(true);
                    c2.getContextBuilder().addExecutionStep(mergeUpdatesStep);
                }
                catch (Throwable t) {
                    errorMsg = "Error in Merge Updates.";
                    if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                        errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
                    }
                    mergeUpdatesStep.setSuccess(false);
                    mergeUpdatesStep.setErrorMessage(errorMsg);
                    RuntimeException re = new RuntimeException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    mergeUpdatesStep.setExceptionObject(re);
                    c2.getContextBuilder().addExecutionStep(mergeUpdatesStep);
                    Logger.loge(errorMsg);
                    Logger.loge(re);
                    throw re;
                }
            } else {
                Logger.logi("Skip Merge update as there are no run-time customizations");
            }
            Logger.logi("[SOA COMPOSITE] Disable EDN Events Delivery");
            OPatchSOAStep disableEdnEventsStep = new OPatchSOAStep(OPatchFAStep.SOA_DISABLE_EDN_EVENTS);
            disableEdnEventsStep.setStepDescription("Disable EDN Events Delivery");
            try {
                if (!report) {
                    scm.disableEDNEvents();
                    enableEdn = true;
                } else {
                    disableEdnEventsStep.setStepDescription("[Skip] Disable EDN Events Delivery");
                }
                disableEdnEventsStep.setSuccess(true);
                c2.getContextBuilder().addExecutionStep(disableEdnEventsStep);
            }
            catch (Throwable t) {
                errorMsg = "Error in Disable EDN Events Delivery.";
                if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                    errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
                }
                disableEdnEventsStep.setSuccess(false);
                disableEdnEventsStep.setErrorMessage(errorMsg);
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                disableEdnEventsStep.setExceptionObject(re);
                c2.getContextBuilder().addExecutionStep(disableEdnEventsStep);
                Logger.loge(errorMsg);
                Logger.loge(re);
                enableEdn = true;
                throw re;
            }
            if (!Util.existFile(plan)) {
                Logger.logi("[SOA COMPOSITE] Deployment without config plan.");
                plan = null;
            } else {
                Logger.logi("[SOA COMPOSITE] Deployment with config plan.");
            }
            Logger.logi("[SOA COMPOSITE] Deploying SOA composite [" + newCompositeDN + "]");
            OPatchSOAStep deployStep = new OPatchSOAStep(OPatchFAStep.SOA_DEPLOY_COMPOSITE);
            deployStep.setStepDescription("Deploy Composite");
            deployStep.setSarFile(jarWithPlan);
            try {
                if (!report && !scm.deployComposite(jarWithPlan, null)) {
                    errorMsg = "OPatch was not able to deploy the composite [" + newCompositeDN + "]";
                    throw new Exception(errorMsg);
                }
                deployStep.setSuccess(true);
                if (!report) {
                    OPatchStepAdapter timeoutStep = new OPatchStepAdapter(OPatchFAStep.CHECK_SOA_SERVER_REQUEST_RESPONSE);
                    timeoutStep.setStepDescription("Check for timeout related issues in SOA deployment requests");
                    timeoutStep.setSuccess(true);
                    c2.getContextBuilder().addExecutionStep(timeoutStep);
                } else {
                    deployStep.setStepDescription("[Skip] Deploy Composite");
                }
                c2.getContextBuilder().addExecutionStep(deployStep);
            }
            catch (SOATimeoutException t) {
                errorMsg = "Timeout occurred when deploying SOA composite [" + newCompositeDN + "]. No SOA artifact recovery will be initiated.";
                OPatchStepAdapter deployTimeOutStep = new OPatchStepAdapter(OPatchFAStep.CHECK_SOA_SERVER_REQUEST_RESPONSE);
                deployTimeOutStep.setStepDescription("Check for timeout related issues in SOA deployment requests");
                deployTimeOutStep.setSuccess(false);
                RuntimeException re = new RuntimeException(t);
                deployTimeOutStep.setExceptionObject(re);
                c2.getContextBuilder().addExecutionStep(deployTimeOutStep);
                Logger.loge(errorMsg);
                Logger.loge(re);
                enableEdn = true;
                throw re;
            }
            catch (Throwable t) {
                errorMsg = "Error in deploying SOA composite [" + newCompositeDN + "].";
                if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                    errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
                }
                deployStep.setErrorMessage(errorMsg);
                deployStep.setSuccess(false);
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                deployStep.setExceptionObject(re);
                c2.getContextBuilder().addExecutionStep(deployStep);
                Logger.loge(errorMsg);
                Logger.loge(re);
                enableEdn = true;
                throw re;
            }
            OPatchSOAStep impUpdatesStep = new OPatchSOAStep(OPatchFAStep.SOA_IMPORT_UPDATES);
            impUpdatesStep.setJarFile(result);
            impUpdatesStep.setCompositeName(name);
            impUpdatesStep.setRevision(revision);
            if (!report && Util.existFile(result)) {
                Logger.logi("[SOA COMPOSITE] Import updates to the SOA Composite [" + newCompositeDN + "]");
                impUpdatesStep.setStepDescription("Import Updates");
                try {
                    scm.importUpdates(null, newCompositeDN, result);
                    impUpdatesStep.setSuccess(true);
                    c2.getContextBuilder().addExecutionStep(impUpdatesStep);
                }
                catch (Throwable t) {
                    errorMsg = "Error in import updates to the SOA composite [" + newCompositeDN + "]";
                    impUpdatesStep.setSuccess(false);
                    impUpdatesStep.setErrorMessage(errorMsg);
                    RuntimeException re = new RuntimeException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    impUpdatesStep.setExceptionObject(re);
                    c2.getContextBuilder().addExecutionStep(impUpdatesStep);
                    Logger.loge(errorMsg);
                    Logger.loge(re);
                    enableEdn = true;
                    undeploy = true;
                    throw re;
                }
            } else {
                if (report) {
                    impUpdatesStep.setStepDescription("[Skip] Import Updates");
                    impUpdatesStep.setSuccess(true);
                    c2.getContextBuilder().addExecutionStep(impUpdatesStep);
                }
                Logger.logi("Skip Import Updates to the SOA composite.");
            }
            Logger.logi("[SOA COMPOSITE] Assign default to the new composite [" + newCompositeDN + "]");
            OPatchSOAStep assignDefaultStep = new OPatchSOAStep(OPatchFAStep.SOA_ASSIGN_DEFAULT_COMPOSITE);
            assignDefaultStep.setStepDescription("Assign default to new composite");
            assignDefaultStep.setCompositeName(name);
            assignDefaultStep.setRevision(revision);
            try {
                if (!report) {
                    scm.assignDefaultComposite(newCompositeDN);
                } else {
                    assignDefaultStep.setStepDescription("[Skip] Assign default to new composite");
                }
                assignDefaultStep.setSuccess(true);
                c2.getContextBuilder().addExecutionStep(assignDefaultStep);
            }
            catch (Throwable t) {
                errorMsg = "Error in assigning 'default' to the SOA Composite [" + newCompositeDN + "].";
                if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                    errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
                }
                assignDefaultStep.setSuccess(false);
                assignDefaultStep.setErrorMessage(errorMsg);
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                assignDefaultStep.setExceptionObject(re);
                c2.getContextBuilder().addExecutionStep(assignDefaultStep);
                Logger.loge(errorMsg);
                Logger.loge(re);
                enableEdn = true;
                undeploy = true;
                throw re;
            }
            boolean defaulCompositeRetired = scm.isRetired(compositeDN);
            if (defaulCompositeRetired) {
                Logger.logi("[SOA COMPOSITE] Retire Previous revision of the composite [" + compositeDN + "]");
            } else {
                Logger.logi("Skip retiring previous revision of the composite [" + compositeDN + "] as it was already retired.");
            }
            OPatchSOAStep retireStep = new OPatchSOAStep(OPatchFAStep.SOA_RETIRE_PREVIOUS_COMPOSITE);
            retireStep.setStepDescription("Retire previous revision of the composite");
            retireStep.setCompositeName(name);
            retireStep.setRevision(defaultRevision);
            try {
                if (!report) {
                    if (defaulCompositeRetired) {
                        retireStep.setStepDescription("Skip retiring previous revision of the composite as it was already retired.");
                    } else {
                        scm.retireComposite(compositeDN);
                    }
                } else {
                    retireStep.setStepDescription("[Skip] Retire previous revision of the composite");
                }
                retireStep.setSuccess(true);
                c2.getContextBuilder().addExecutionStep(retireStep);
            }
            catch (Throwable t) {
                errorMsg = "Error in retiring previous revision of the composite [" + compositeDN + "].";
                if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                    errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
                }
                retireStep.setSuccess(false);
                retireStep.setErrorMessage(errorMsg);
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                retireStep.setExceptionObject(re);
                c2.getContextBuilder().addExecutionStep(retireStep);
                Logger.loge(errorMsg);
                Logger.loge(re);
                enableEdn = true;
                undeploy = true;
                throw re;
            }
            Logger.logi("[SOA COMPOSITE] Enable EDN Events Delivery.");
            OPatchSOAStep enableEdnStep = new OPatchSOAStep(OPatchFAStep.SOA_ENABLE_EDN_EVENTS);
            enableEdnStep.setStepDescription("Enable EDN Events Delivery");
            try {
                if (!report) {
                    scm.enableEDNEvents();
                } else {
                    enableEdnStep.setStepDescription("[Skip] Enable EDN Events Delivery");
                }
                enableEdnStep.setSuccess(true);
                enableEdn = false;
                c2.getContextBuilder().addExecutionStep(enableEdnStep);
            }
            catch (Throwable t) {
                errorMsg = "Error in Enable EDN Events Delivery API.";
                if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                    errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
                }
                enableEdnStep.setSuccess(false);
                enableEdnStep.setErrorMessage(errorMsg);
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                enableEdnStep.setExceptionObject(re);
                c2.getContextBuilder().addRecoveryStep(enableEdnStep);
                enableEdn = false;
                Logger.loge(errorMsg);
                Logger.loge(re);
                throw re;
            }
            Object var39_73 = null;
            if (undeploy) {
                Logger.logi("[SOA COMPOSITE] Recovery: Undeploy SOA Composite [" + newCompositeDN + "]");
                OPatchStepAdapter undeployStep = new OPatchStepAdapter(OPatchFAStep.SOA_UNDEPLOY_COMPOSITE);
                undeployStep.setStepDescription("Undeploy Composite");
                try {
                    scm.undeployComposite(newCompositeDN);
                    undeployStep.setSuccess(true);
                    c2.getContextBuilder().addRecoveryStep(undeployStep);
                }
                catch (Throwable t) {
                    errorMsg = "Error in undeploying Composite [" + newCompositeDN + "].";
                    if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                        errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
                    }
                    undeployStep.setSuccess(false);
                    undeployStep.setErrorMessage(errorMsg);
                    RuntimeException re = new RuntimeException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    undeployStep.setExceptionObject(re);
                    c2.getContextBuilder().addRecoveryStep(undeployStep);
                    Logger.loge(errorMsg);
                    Logger.loge(re);
                    enableEdn = true;
                }
                Logger.logi("[SOA COMPOSITE] Recovery: Assign default to previous composite [" + compositeDN + "]");
                OPatchStepAdapter recoveryAssignDefaultStep = new OPatchStepAdapter(OPatchFAStep.SOA_ASSIGN_DEFAULT_COMPOSITE);
                recoveryAssignDefaultStep.setStepDescription("Assign default to the previous composite [" + compositeDN + "]");
                try {
                    scm.assignDefaultComposite(compositeDN);
                    recoveryAssignDefaultStep.setSuccess(true);
                    c2.getContextBuilder().addRecoveryStep(recoveryAssignDefaultStep);
                }
                catch (Throwable t) {
                    errorMsg = "Error in assign default to the composite [" + compositeDN + "].";
                    if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                        errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
                    }
                    recoveryAssignDefaultStep.setSuccess(false);
                    recoveryAssignDefaultStep.setErrorMessage(errorMsg);
                    RuntimeException re = new RuntimeException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    recoveryAssignDefaultStep.setExceptionObject(re);
                    c2.getContextBuilder().addRecoveryStep(recoveryAssignDefaultStep);
                    Logger.loge(errorMsg);
                    Logger.loge(re);
                    enableEdn = true;
                    throw re;
                }
            }
            Object var45_87 = null;
            OPatchStepAdapter prereqStep = c2.getContextBuilder().getFailedPrereqStep();
            if (prereqStep != null && !prereqStep.isSuccess()) {
                return;
            }
            if (!enableEdn) break block123;
            Logger.logi("[SOA COMPOSITE] Enable EDN Events Delivery.");
            OPatchStepAdapter recoveryEnableEdnStep = new OPatchStepAdapter(OPatchFAStep.SOA_ENABLE_EDN_EVENTS);
            recoveryEnableEdnStep.setStepDescription("Enable EDN Events Delivery");
            try {
                scm.enableEDNEvents();
                recoveryEnableEdnStep.setSuccess(true);
                c2.getContextBuilder().addRecoveryStep(recoveryEnableEdnStep);
            }
            catch (Throwable t) {
                errorMsg = "Error in executing enableEDNEvents API.";
                if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                    errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
                }
                recoveryEnableEdnStep.setSuccess(false);
                recoveryEnableEdnStep.setErrorMessage(errorMsg);
                RuntimeException exObj = new RuntimeException(t.getMessage());
                exObj.setStackTrace(t.getStackTrace());
                recoveryEnableEdnStep.setExceptionObject(exObj);
                c2.getContextBuilder().addRecoveryStep(recoveryEnableEdnStep);
                Logger.loge(errorMsg);
                Logger.loge(exObj);
                throw exObj;
            }
        }
        Logger.logi("[SOA COMPOSITE] Get default revision after deploy call");
        OPatchStepAdapter defaultRevStep2 = new OPatchStepAdapter(OPatchFAStep.SOA_GET_DEFAULT_REVISION);
        defaultRevStep2.setStepDescription("Get default revision after deploy call");
        try {
            defaultRevAfterDeploy = scm.getDefaultRevision(name);
            defaultRevStep2.setSuccess(true);
            c2.getContextBuilder().addExecutionStep(defaultRevStep2);
            c2.getContextBuilder().addRecoveryStep(defaultRevStep2);
            sc.setDefaultRevisionAfterDeploy(defaultRevAfterDeploy);
        }
        catch (Throwable t) {
            errorMsg = "Error in getting default Composite Revision after deploy call.";
            if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
            }
            defaultRevStep2.setSuccess(false);
            defaultRevStep2.setErrorMessage(errorMsg);
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            defaultRevStep2.setExceptionObject(re);
            c2.getContextBuilder().addExecutionStep(defaultRevStep2);
            c2.getContextBuilder().addRecoveryStep(defaultRevStep2);
            Logger.loge(errorMsg);
            Logger.loge(re);
            throw re;
        }
        {
            catch (Throwable t) {
                RuntimeException recEx = new RuntimeException(t.getMessage());
                recEx.setStackTrace(t.getStackTrace());
                throw recEx;
            }
        }
        catch (Throwable throwable) {
            Object var45_88 = null;
            OPatchStepAdapter prereqStep = c2.getContextBuilder().getFailedPrereqStep();
            if (prereqStep != null && !prereqStep.isSuccess()) {
                return;
            }
            if (enableEdn) {
                Logger.logi("[SOA COMPOSITE] Enable EDN Events Delivery.");
                OPatchStepAdapter recoveryEnableEdnStep = new OPatchStepAdapter(OPatchFAStep.SOA_ENABLE_EDN_EVENTS);
                recoveryEnableEdnStep.setStepDescription("Enable EDN Events Delivery");
                try {
                    scm.enableEDNEvents();
                    recoveryEnableEdnStep.setSuccess(true);
                    c2.getContextBuilder().addRecoveryStep(recoveryEnableEdnStep);
                }
                catch (Throwable t) {
                    errorMsg = "Error in executing enableEDNEvents API.";
                    if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                        errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
                    }
                    recoveryEnableEdnStep.setSuccess(false);
                    recoveryEnableEdnStep.setErrorMessage(errorMsg);
                    RuntimeException exObj = new RuntimeException(t.getMessage());
                    exObj.setStackTrace(t.getStackTrace());
                    recoveryEnableEdnStep.setExceptionObject(exObj);
                    c2.getContextBuilder().addRecoveryStep(recoveryEnableEdnStep);
                    Logger.loge(errorMsg);
                    Logger.loge(exObj);
                    throw exObj;
                }
            }
            Logger.logi("[SOA COMPOSITE] Get default revision after deploy call");
            defaultRevStep2 = new OPatchStepAdapter(OPatchFAStep.SOA_GET_DEFAULT_REVISION);
            defaultRevStep2.setStepDescription("Get default revision after deploy call");
            try {
                defaultRevAfterDeploy = scm.getDefaultRevision(name);
                defaultRevStep2.setSuccess(true);
                c2.getContextBuilder().addExecutionStep(defaultRevStep2);
                c2.getContextBuilder().addRecoveryStep(defaultRevStep2);
                sc.setDefaultRevisionAfterDeploy(defaultRevAfterDeploy);
            }
            catch (Throwable t) {
                errorMsg = "Error in getting default Composite Revision after deploy call.";
                if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                    errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
                }
                defaultRevStep2.setSuccess(false);
                defaultRevStep2.setErrorMessage(errorMsg);
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                defaultRevStep2.setExceptionObject(re);
                c2.getContextBuilder().addExecutionStep(defaultRevStep2);
                c2.getContextBuilder().addRecoveryStep(defaultRevStep2);
                Logger.loge(errorMsg);
                Logger.loge(re);
                throw re;
            }
            Logger.logi("[SOA COMPOSITE] Default revision after deployment [" + defaultRevAfterDeploy + "]");
            throw throwable;
        }
        {
            catch (Throwable t1) {
                RuntimeException re = new RuntimeException(t1.getMessage());
                re.setStackTrace(t1.getStackTrace());
                throw re;
            }
        }
        catch (Throwable throwable) {
            block126: {
                Object var39_74 = null;
                if (undeploy) {
                    Logger.logi("[SOA COMPOSITE] Recovery: Undeploy SOA Composite [" + newCompositeDN + "]");
                    OPatchStepAdapter undeployStep = new OPatchStepAdapter(OPatchFAStep.SOA_UNDEPLOY_COMPOSITE);
                    undeployStep.setStepDescription("Undeploy Composite");
                    try {
                        scm.undeployComposite(newCompositeDN);
                        undeployStep.setSuccess(true);
                        c2.getContextBuilder().addRecoveryStep(undeployStep);
                    }
                    catch (Throwable t) {
                        errorMsg = "Error in undeploying Composite [" + newCompositeDN + "].";
                        if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                            errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
                        }
                        undeployStep.setSuccess(false);
                        undeployStep.setErrorMessage(errorMsg);
                        RuntimeException re = new RuntimeException(t.getMessage());
                        re.setStackTrace(t.getStackTrace());
                        undeployStep.setExceptionObject(re);
                        c2.getContextBuilder().addRecoveryStep(undeployStep);
                        Logger.loge(errorMsg);
                        Logger.loge(re);
                        enableEdn = true;
                    }
                    Logger.logi("[SOA COMPOSITE] Recovery: Assign default to previous composite [" + compositeDN + "]");
                    OPatchStepAdapter recoveryAssignDefaultStep = new OPatchStepAdapter(OPatchFAStep.SOA_ASSIGN_DEFAULT_COMPOSITE);
                    recoveryAssignDefaultStep.setStepDescription("Assign default to the previous composite [" + compositeDN + "]");
                    try {
                        scm.assignDefaultComposite(compositeDN);
                        recoveryAssignDefaultStep.setSuccess(true);
                        c2.getContextBuilder().addRecoveryStep(recoveryAssignDefaultStep);
                    }
                    catch (Throwable t) {
                        errorMsg = "Error in assign default to the composite [" + compositeDN + "].";
                        if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                            errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
                        }
                        recoveryAssignDefaultStep.setSuccess(false);
                        recoveryAssignDefaultStep.setErrorMessage(errorMsg);
                        RuntimeException re = new RuntimeException(t.getMessage());
                        re.setStackTrace(t.getStackTrace());
                        recoveryAssignDefaultStep.setExceptionObject(re);
                        c2.getContextBuilder().addRecoveryStep(recoveryAssignDefaultStep);
                        Logger.loge(errorMsg);
                        Logger.loge(re);
                        enableEdn = true;
                        throw re;
                    }
                }
                Object var45_89 = null;
                OPatchStepAdapter prereqStep = c2.getContextBuilder().getFailedPrereqStep();
                if (prereqStep != null && !prereqStep.isSuccess()) {
                    return;
                }
                if (!enableEdn) break block126;
                Logger.logi("[SOA COMPOSITE] Enable EDN Events Delivery.");
                OPatchStepAdapter recoveryEnableEdnStep = new OPatchStepAdapter(OPatchFAStep.SOA_ENABLE_EDN_EVENTS);
                recoveryEnableEdnStep.setStepDescription("Enable EDN Events Delivery");
                try {
                    scm.enableEDNEvents();
                    recoveryEnableEdnStep.setSuccess(true);
                    c2.getContextBuilder().addRecoveryStep(recoveryEnableEdnStep);
                }
                catch (Throwable t) {
                    errorMsg = "Error in executing enableEDNEvents API.";
                    if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                        errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
                    }
                    recoveryEnableEdnStep.setSuccess(false);
                    recoveryEnableEdnStep.setErrorMessage(errorMsg);
                    RuntimeException exObj = new RuntimeException(t.getMessage());
                    exObj.setStackTrace(t.getStackTrace());
                    recoveryEnableEdnStep.setExceptionObject(exObj);
                    c2.getContextBuilder().addRecoveryStep(recoveryEnableEdnStep);
                    Logger.loge(errorMsg);
                    Logger.loge(exObj);
                    throw exObj;
                }
            }
            Logger.logi("[SOA COMPOSITE] Get default revision after deploy call");
            defaultRevStep2 = new OPatchStepAdapter(OPatchFAStep.SOA_GET_DEFAULT_REVISION);
            defaultRevStep2.setStepDescription("Get default revision after deploy call");
            try {
                defaultRevAfterDeploy = scm.getDefaultRevision(name);
                defaultRevStep2.setSuccess(true);
                c2.getContextBuilder().addExecutionStep(defaultRevStep2);
                c2.getContextBuilder().addRecoveryStep(defaultRevStep2);
                sc.setDefaultRevisionAfterDeploy(defaultRevAfterDeploy);
            }
            catch (Throwable t) {
                errorMsg = "Error in getting default Composite Revision after deploy call.";
                if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                    errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
                }
                defaultRevStep2.setSuccess(false);
                defaultRevStep2.setErrorMessage(errorMsg);
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                defaultRevStep2.setExceptionObject(re);
                c2.getContextBuilder().addExecutionStep(defaultRevStep2);
                c2.getContextBuilder().addRecoveryStep(defaultRevStep2);
                Logger.loge(errorMsg);
                Logger.loge(re);
                throw re;
            }
            {
                catch (Throwable t) {
                    RuntimeException recEx = new RuntimeException(t.getMessage());
                    recEx.setStackTrace(t.getStackTrace());
                    throw recEx;
                }
            }
            catch (Throwable throwable2) {
                Object var45_90 = null;
                OPatchStepAdapter prereqStep = c2.getContextBuilder().getFailedPrereqStep();
                if (prereqStep != null && !prereqStep.isSuccess()) {
                    return;
                }
                if (enableEdn) {
                    Logger.logi("[SOA COMPOSITE] Enable EDN Events Delivery.");
                    OPatchStepAdapter recoveryEnableEdnStep = new OPatchStepAdapter(OPatchFAStep.SOA_ENABLE_EDN_EVENTS);
                    recoveryEnableEdnStep.setStepDescription("Enable EDN Events Delivery");
                    try {
                        scm.enableEDNEvents();
                        recoveryEnableEdnStep.setSuccess(true);
                        c2.getContextBuilder().addRecoveryStep(recoveryEnableEdnStep);
                    }
                    catch (Throwable t) {
                        errorMsg = "Error in executing enableEDNEvents API.";
                        if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                            errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
                        }
                        recoveryEnableEdnStep.setSuccess(false);
                        recoveryEnableEdnStep.setErrorMessage(errorMsg);
                        RuntimeException exObj = new RuntimeException(t.getMessage());
                        exObj.setStackTrace(t.getStackTrace());
                        recoveryEnableEdnStep.setExceptionObject(exObj);
                        c2.getContextBuilder().addRecoveryStep(recoveryEnableEdnStep);
                        Logger.loge(errorMsg);
                        Logger.loge(exObj);
                        throw exObj;
                    }
                }
                Logger.logi("[SOA COMPOSITE] Get default revision after deploy call");
                defaultRevStep2 = new OPatchStepAdapter(OPatchFAStep.SOA_GET_DEFAULT_REVISION);
                defaultRevStep2.setStepDescription("Get default revision after deploy call");
                try {
                    defaultRevAfterDeploy = scm.getDefaultRevision(name);
                    defaultRevStep2.setSuccess(true);
                    c2.getContextBuilder().addExecutionStep(defaultRevStep2);
                    c2.getContextBuilder().addRecoveryStep(defaultRevStep2);
                    sc.setDefaultRevisionAfterDeploy(defaultRevAfterDeploy);
                }
                catch (Throwable t) {
                    errorMsg = "Error in getting default Composite Revision after deploy call.";
                    if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                        errorMsg = errorMsg + " " + "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
                    }
                    defaultRevStep2.setSuccess(false);
                    defaultRevStep2.setErrorMessage(errorMsg);
                    RuntimeException re = new RuntimeException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    defaultRevStep2.setExceptionObject(re);
                    c2.getContextBuilder().addExecutionStep(defaultRevStep2);
                    c2.getContextBuilder().addRecoveryStep(defaultRevStep2);
                    Logger.loge(errorMsg);
                    Logger.loge(re);
                    throw re;
                }
                Logger.logi("[SOA COMPOSITE] Default revision after deployment [" + defaultRevAfterDeploy + "]");
                throw throwable2;
            }
            Logger.logi("[SOA COMPOSITE] Default revision after deployment [" + defaultRevAfterDeploy + "]");
            throw throwable;
        }
        Logger.logi("[SOA COMPOSITE] Default revision after deployment [" + defaultRevAfterDeploy + "]");
    }
}

