/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchprereq;

import oracle.opatch.OPatchEnv;
import oracle.opatch.OneOffEntry;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.ConflictMatrixOutput;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.opatch.opatchprereq.PrereqSet;

public class ConflictOutput
extends PrereqResult {
    private boolean interConflict = false;
    private PrereqSet patchesToGoIn = new PrereqSet();
    private PrereqSet patchesHavingConflicts = new PrereqSet();
    private PrereqSet patchesNotNeeded = new PrereqSet();
    private PrereqSet patchesToRollback = new PrereqSet();
    private String subPatchConflictDetail;

    protected void setSubPatchConflictDetail(String subPatchConflictDetail) {
        this.subPatchConflictDetail = subPatchConflictDetail;
    }

    ConflictOutput() {
    }

    protected void update(PrereqSet pToGo, PrereqSet pHavingConflict, PrereqSet pNotNeeded, PrereqSet pRollback) {
        this.interConflict = true;
        this.patchesToGoIn = pToGo;
        this.patchesHavingConflicts = pHavingConflict;
        this.patchesHavingConflicts.sort();
        this.patchesNotNeeded = pNotNeeded;
        this.patchesNotNeeded.sort();
        this.patchesToRollback = pRollback;
        if (this.patchesHavingConflicts.size() != 0 || this.patchesNotNeeded.size() != 0 || this.patchesToRollback.size() != 0) {
            this.setResult(PrereqResult.ExecuteStatus.FAILED);
        } else {
            this.setResult(PrereqResult.ExecuteStatus.PASSED);
        }
    }

    protected void update(boolean isIgnoreConflict, boolean isIgnoreDuplicate, boolean isIgnoreSubset) {
        PrereqSet properSubsetHandList;
        boolean calledFromOUI = Boolean.getBoolean("oracle.opatch.opatchprereq.calledFromOUI");
        OLogger.printlnOnLog(OLogger.INFO, "Called from oracle.opatch.opatchprereq.ConflictOUtput::update()");
        OLogger.printlnOnLog(OLogger.INFO, "Is it called from OUI? : " + calledFromOUI);
        if (!calledFromOUI) {
            return;
        }
        PrereqSet finalPatchList = this.patchesToGoIn;
        OLogger.printlnOnLog(OLogger.INFO, "ConflictOutput::Update() has 'ignoreConflict'->" + isIgnoreConflict + ", 'ignore" + "Duplicate'->" + isIgnoreDuplicate + ", 'ignoreSubset'->" + isIgnoreSubset + "");
        PrereqResult.ExecuteStatus oldRes = this.getResult();
        boolean isModifiedToFail = false;
        ConflictOutput newResultObj = new ConflictOutput();
        newResultObj.setResult(oldRes);
        if (this.patchesHavingConflicts.size() != 0) {
            OLogger.printlnOnLog(OLogger.INFO, "There are conflicting patches.");
            if (isIgnoreConflict) {
                if (OPatchEnv.isForceConflict()) {
                    finalPatchList = finalPatchList.delete(this.patchesToRollback);
                    finalPatchList = finalPatchList.add(this.patchesHavingConflicts);
                }
                OLogger.printlnOnLog(OLogger.INFO, "Conflict between patches needs to be ignored.");
                newResultObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            } else {
                isModifiedToFail = true;
            }
        }
        if ((properSubsetHandList = this.patchesNotNeeded.delete(this.patchesToRollback)).size() != 0) {
            OLogger.printlnOnLog(OLogger.INFO, "There are subset patches.");
            if (isIgnoreSubset && !isModifiedToFail) {
                OLogger.printlnOnLog(OLogger.INFO, "Subset patches needs to be ignored.");
                newResultObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            } else {
                newResultObj.setResult(oldRes);
                isModifiedToFail = true;
            }
        }
        if (this.patchesToGoIn.isIntersect(this.patchesToRollback)) {
            OLogger.printlnOnLog(OLogger.INFO, "There are duplicate patches.");
            if (isIgnoreDuplicate && !isModifiedToFail) {
                finalPatchList = finalPatchList.delete(this.patchesToRollback);
                OLogger.printlnOnLog(OLogger.INFO, "Duplicate Patches needs to be ignored");
                newResultObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            }
        }
        if (this.patchesToRollback.isIntersect(this.patchesNotNeeded) || this.patchesToGoIn.isIntersect(this.patchesToRollback)) {
            OLogger.printlnOnLog(OLogger.INFO, "There are superset patches");
            if (!isModifiedToFail) {
                OLogger.printlnOnLog(OLogger.INFO, "Superset patches needs to be ignored");
                newResultObj.setResult(PrereqResult.ExecuteStatus.PASSED);
            } else {
                newResultObj.setResult(oldRes);
            }
        }
        if (finalPatchList.size() == 0) {
            newResultObj.setResult(PrereqResult.ExecuteStatus.FAILED);
        }
        this.setResult(newResultObj.getResult());
    }

    protected void update(PrereqSet pToGo, PrereqSet pHavingConflict, PrereqSet pNotNeeded) {
        this.interConflict = false;
        this.patchesToGoIn = pToGo;
        this.patchesHavingConflicts = pHavingConflict;
        this.patchesHavingConflicts.sort();
        this.patchesNotNeeded = pNotNeeded;
        this.patchesNotNeeded.sort();
        this.patchesToRollback = new PrereqSet();
        if (this.patchesHavingConflicts.size() != 0 || this.patchesNotNeeded.size() != 0) {
            this.setResult(PrereqResult.ExecuteStatus.FAILED);
        } else {
            this.setResult(PrereqResult.ExecuteStatus.PASSED);
        }
    }

    public OneOffEntry[] getListOfPatchesToBeMerged() {
        return this.patchesHavingConflicts.getAllElements();
    }

    public OneOffEntry[] getListOfPatchesThatCanGoNow() {
        return this.patchesToGoIn.getAllElements();
    }

    public OneOffEntry[] getListOfPatchesNotNeeded() {
        return this.patchesNotNeeded.getAllElements();
    }

    public OneOffEntry[] getListOfPatchesThatNeedToBeRollback() {
        return this.patchesToRollback.getAllElements();
    }

    protected void setListOfPatchesToBeMerged(OneOffEntry[] oneOffs) {
        this.patchesHavingConflicts = new PrereqSet(oneOffs);
        this.patchesHavingConflicts.sort();
    }

    protected void setListOfPatchesThatCanGoNow(OneOffEntry[] oneOffs) {
        this.patchesToGoIn = new PrereqSet(oneOffs);
    }

    protected void setListOfPatchesNotNeeded(OneOffEntry[] oneOffs) {
        this.patchesNotNeeded = new PrereqSet(oneOffs);
        this.patchesNotNeeded.sort();
    }

    protected void setListOfPatchesThatNeedToBeRollback(OneOffEntry[] oneOffs) {
        this.patchesToRollback = new PrereqSet(oneOffs);
    }

    public String toString() {
        int i2;
        StringBuffer buff = new StringBuffer(super.toString());
        buff.append("\nSummary of Conflict Analysis:\n");
        OneOffEntry[] patchesToBeMerged = this.getListOfPatchesToBeMerged();
        OneOffEntry[] patchesNotNeeded = this.getListOfPatchesNotNeeded();
        OneOffEntry[] patchesThatCanGoNow = this.getListOfPatchesThatCanGoNow();
        OneOffEntry[] patchesToBeRollbacked = this.getListOfPatchesThatNeedToBeRollback();
        boolean calledFromOUI = Boolean.getBoolean("oracle.opatch.opatchprereq.calledFromOUI");
        boolean shouldDisplayConflict = !OPatchEnv.isIgnoreConflict() && !OPatchEnv.isForceConflict();
        shouldDisplayConflict = shouldDisplayConflict || !calledFromOUI;
        OLogger.debug("Should display conflict? " + shouldDisplayConflict);
        boolean shouldDisplaySubset = !OPatchEnv.isSkipSubset();
        shouldDisplaySubset = shouldDisplaySubset || !calledFromOUI;
        OLogger.debug("Should display subset? " + shouldDisplaySubset);
        boolean shouldRemoveDuplicates = OPatchEnv.isSkipDuplicate();
        shouldRemoveDuplicates = shouldRemoveDuplicates && calledFromOUI;
        OLogger.debug("Should remove duplicates? " + shouldRemoveDuplicates);
        OLogger.debug("Initial 'to Go' Patches -> " + this.patchesToGoIn.toString());
        OLogger.debug("Initial 'to Rollback' patches -> " + this.patchesToRollback.toString());
        OLogger.debug("Initial 'conflict' patches -> " + this.patchesHavingConflicts.toString());
        PrereqSet goIn = null;
        PrereqSet getOut = null;
        if (patchesThatCanGoNow.length != 0) {
            if (OPatchEnv.isIgnoreConflict() && calledFromOUI) {
                goIn = this.patchesToGoIn.delete(this.patchesHavingConflicts);
                patchesThatCanGoNow = goIn.getAllElements();
                OLogger.debug("Modified 'to Go' list after Skip Conflict -> " + this.patchesToGoIn.toString());
            }
            if (OPatchEnv.isForceConflict() && calledFromOUI) {
                if (this.patchesHavingConflicts.isIntersect(this.patchesToRollback)) {
                    PrereqSet conflictHandPatches = this.patchesHavingConflicts.delete(this.patchesToRollback);
                    this.patchesToGoIn = this.patchesToGoIn.add(conflictHandPatches);
                    ConflictMatrixOutput intraOutput = PrereqAPI.checkConflictAmongPatchesWithDetail(OPatchEnv.getOracleHome(), conflictHandPatches.getAllElements());
                    PrereqSet intraConflictPatches = new PrereqSet(intraOutput.getListOfPatchesToBeMerged());
                    this.patchesToGoIn = this.patchesToGoIn.delete(intraConflictPatches);
                } else {
                    this.patchesToGoIn = this.patchesToGoIn.delete(this.patchesHavingConflicts);
                }
                OLogger.debug("Modified 'to Go' list after Force Conflict -> " + this.patchesToGoIn.toString());
                patchesThatCanGoNow = this.patchesToGoIn.getAllElements();
            }
            if (shouldRemoveDuplicates && calledFromOUI) {
                getOut = this.patchesToRollback.delete(this.patchesToGoIn);
                goIn = null;
                this.patchesToGoIn = goIn = this.patchesToGoIn.delete(this.patchesToRollback);
                this.patchesToRollback = getOut;
                OLogger.debug("Modified 'to Go' list after Remove Duplicates -> " + this.patchesToGoIn.toString());
                OLogger.debug("Modified 'to rollback' list after Remove Duplicates -> " + this.patchesToRollback.toString());
                patchesToBeRollbacked = getOut.getAllElements();
                patchesThatCanGoNow = goIn.getAllElements();
            }
            if (patchesThatCanGoNow.length != 0) {
                buff.append("\nPatches that can be applied now without any conflicts are : \n");
            }
            for (i2 = 0; i2 < patchesThatCanGoNow.length; ++i2) {
                buff.append(patchesThatCanGoNow[i2].getID());
                if (i2 + 1 == patchesThatCanGoNow.length) {
                    buff.append("\n");
                    continue;
                }
                buff.append(", ");
            }
            if (patchesThatCanGoNow.length == 0 && calledFromOUI) {
                buff.append("\nThere are no patches that can be applied now.\n");
            }
        } else {
            if (OPatchEnv.isForceConflict() && calledFromOUI) {
                if (this.patchesHavingConflicts.isIntersect(this.patchesToRollback)) {
                    this.patchesToGoIn = this.patchesToGoIn.add(this.patchesHavingConflicts);
                    this.patchesToGoIn = this.patchesToGoIn.delete(this.patchesToRollback);
                    ConflictMatrixOutput intraOutput = PrereqAPI.checkConflictAmongPatchesWithDetail(OPatchEnv.getOracleHome(), this.patchesHavingConflicts.delete(this.patchesToRollback).getAllElements());
                    PrereqSet intraConflictPatches = new PrereqSet(intraOutput.getListOfPatchesToBeMerged());
                    this.patchesToGoIn = this.patchesToGoIn.delete(intraConflictPatches);
                } else {
                    this.patchesToGoIn = this.patchesToGoIn.delete(this.patchesHavingConflicts);
                }
                OLogger.debug("Modified 'to Go' list after Force Conflict -> " + this.patchesToGoIn.toString());
                patchesThatCanGoNow = this.patchesToGoIn.getAllElements();
            }
            if (patchesThatCanGoNow.length != 0) {
                buff.append("\nPatches that can be applied now without any conflicts are : \n");
            }
            for (i2 = 0; i2 < patchesThatCanGoNow.length; ++i2) {
                buff.append(patchesThatCanGoNow[i2].getID());
                if (i2 + 1 == patchesThatCanGoNow.length) {
                    buff.append("\n");
                    continue;
                }
                buff.append(", ");
            }
            if (this.patchesToGoIn.size() == 0) {
                buff.append("\nThere are no patches that can be applied now.\n");
            }
        }
        if (patchesToBeMerged.length != 0 && shouldDisplayConflict) {
            buff.append("\nFollowing patches have conflicts. Please contact Oracle Support and get the merged patch of the patches : \n");
            for (i2 = 0; i2 < patchesToBeMerged.length; ++i2) {
                buff.append(patchesToBeMerged[i2].getID());
                if (i2 + 1 == patchesToBeMerged.length) {
                    buff.append("\n");
                    continue;
                }
                buff.append(", ");
            }
            if (this.subPatchConflictDetail != null) {
                buff.append(this.subPatchConflictDetail);
            }
        }
        if (patchesNotNeeded.length != 0 && shouldDisplaySubset) {
            buff.append("\nFollowing patches are not required, ");
            buff.append("as they are subset of the patches in Oracle Home or subset of the patches in the given list : \n");
            for (i2 = 0; i2 < patchesNotNeeded.length; ++i2) {
                buff.append(patchesNotNeeded[i2].getID());
                if (i2 + 1 == patchesNotNeeded.length) {
                    buff.append("\n");
                    continue;
                }
                buff.append(", ");
            }
        }
        if (patchesToBeRollbacked.length != 0) {
            if (!OPatchEnv.isForceConflict() && calledFromOUI) {
                getOut = this.patchesToRollback.delete(this.patchesHavingConflicts);
                OLogger.debug("Modified 'to rollback' list if there is no force conflict -> " + this.patchesToRollback.toString());
                patchesToBeRollbacked = getOut.getAllElements();
            }
            if (patchesToBeRollbacked.length != 0) {
                buff.append("\nFollowing patches will be rolled back from Oracle Home on application of the patches in the given list : \n");
                for (i2 = 0; i2 < patchesToBeRollbacked.length; ++i2) {
                    buff.append(patchesToBeRollbacked[i2].getID());
                    if (i2 + 1 == patchesToBeRollbacked.length) {
                        buff.append("\n");
                        continue;
                    }
                    buff.append(", ");
                }
            }
        }
        return buff.toString();
    }
}

