/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchprereq;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.ExitOPatchException;
import oracle.opatch.OneOffEntry;
import oracle.opatch.conflicttextualinterpreter.selectbetterpatch.BuildRelationPatchMap;
import oracle.opatch.conflicttextualinterpreter.selectbetterpatch.SelectBetterPatchOneOffEngine;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PrereqSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrereqFilterDuplicatePatch {
    public static OneOffEntry[] filterDupPi(OneOffEntry[] pIs) {
        StringBuffer buff = new StringBuffer("PrereqFilterDuplicatePatch::filterDupPi()");
        if (pIs == null || pIs.length == 0) {
            String msg = "Empty List of incoming patches.";
            buff.setLength(0);
            OLogger.debug(buff.append(msg));
            return null;
        }
        ArrayList<Object> res = new ArrayList();
        res = PrereqFilterDuplicatePatch.divideComposite(pIs);
        OneOffEntry[] oneoff = new OneOffEntry[((ArrayList)res.get(0)).size()];
        OneOffEntry[] comp = new OneOffEntry[((ArrayList)res.get(1)).size()];
        if (res != null) {
            if (((ArrayList)res.get(0)).size() != 0) {
                ((ArrayList)res.get(0)).toArray(oneoff);
            }
            if (((ArrayList)res.get(1)).size() != 0) {
                ((ArrayList)res.get(1)).toArray(comp);
            }
            if (oneoff != null && oneoff.length != 0) {
                oneoff = PrereqFilterDuplicatePatch.filter(oneoff);
            }
            if (comp != null && comp.length != 0) {
                comp = PrereqFilterDuplicatePatch.filter(comp);
            }
            return PrereqFilterDuplicatePatch.mergeSorted(oneoff, comp);
        }
        return null;
    }

    public static OneOffEntry[] addBackCompositeSubPatches(OneOffEntry[] pIs, OneOffEntry[] pIsFiltered) {
        StringBuffer buff = new StringBuffer("PrereqFilterDuplicatePatch::addBackCompositeSubPatches() called");
        if (pIs == null || pIs.length == 0) {
            String msg = "Empty List of incoming patches";
            buff.setLength(0);
            OLogger.debug(buff.append(msg));
            return null;
        }
        ArrayList<OneOffEntry> pIsFilteredList = new ArrayList<OneOffEntry>();
        boolean needAddBack = false;
        for (OneOffEntry pIFiltered : pIsFiltered) {
            if (pIFiltered.getIsComposite()) {
                needAddBack = true;
            }
            pIsFilteredList.add(pIFiltered);
        }
        if (!needAddBack) {
            return pIsFiltered;
        }
        for (OneOffEntry pI : pIs) {
            if (pIsFilteredList.contains(pI) || !pI.getIsComposite()) continue;
            pIsFilteredList.add(pI);
        }
        return pIsFilteredList.toArray(pIsFiltered);
    }

    private static OneOffEntry[] mergeSorted(OneOffEntry[] oneoff, OneOffEntry[] comp) {
        if (oneoff == null || oneoff.length == 0) {
            return comp;
        }
        if (comp == null || comp.length == 0) {
            return oneoff;
        }
        int oLength = oneoff.length;
        int cLength = comp.length;
        OneOffEntry[] mergedArr = new OneOffEntry[oLength + cLength];
        int index = 0;
        int oneoffIndex = 0;
        if (comp[cLength - 1].getID().compareTo(oneoff[oLength - 1].getID()) > 0) {
            OneOffEntry entry;
            int n2;
            OneOffEntry[] oneOffEntryArray = oneoff;
            int n3 = oneOffEntryArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                mergedArr[index] = entry = oneOffEntryArray[n2];
                ++index;
            }
            oneOffEntryArray = comp;
            n3 = oneOffEntryArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                mergedArr[index] = entry = oneOffEntryArray[n2];
                ++index;
            }
        } else if (comp[cLength - 1].getID().compareTo(oneoff[0].getID()) < 0) {
            OneOffEntry entry;
            int n4;
            OneOffEntry[] oneOffEntryArray = comp;
            int n5 = oneOffEntryArray.length;
            for (n4 = 0; n4 < n5; ++n4) {
                mergedArr[index] = entry = oneOffEntryArray[n4];
                ++index;
            }
            oneOffEntryArray = oneoff;
            n5 = oneOffEntryArray.length;
            for (n4 = 0; n4 < n5; ++n4) {
                mergedArr[index] = entry = oneOffEntryArray[n4];
                ++index;
            }
        } else {
            while (oneoff[oneoffIndex].getID().compareTo(comp[cLength - 1].getID()) <= 0) {
                ++oneoffIndex;
            }
            while (index < oneoffIndex) {
                mergedArr[index] = oneoff[index];
                ++index;
            }
            OneOffEntry[] oneOffEntryArray = comp;
            int n6 = oneOffEntryArray.length;
            for (int i2 = 0; i2 < n6; ++i2) {
                OneOffEntry entry;
                mergedArr[index] = entry = oneOffEntryArray[i2];
                ++index;
            }
            for (int i3 = oneoffIndex; i3 < oLength; ++i3) {
                mergedArr[index] = oneoff[i3];
                ++index;
            }
        }
        return mergedArr;
    }

    private static OneOffEntry[] filter(OneOffEntry[] pIs) {
        StringBuffer buff = new StringBuffer("PrereqFilterDuplicatePatch::filter()");
        PrereqSet outputPi = new PrereqSet();
        if (pIs == null || pIs.length == 0) {
            String msg = "Empty List of incoming patches.";
            buff.setLength(0);
            OLogger.debug(buff.append(msg));
            return null;
        }
        try {
            HashMap langHm = PrereqFilterDuplicatePatch.getLangPatchGroup(pIs);
            for (Map.Entry entry : langHm.entrySet()) {
                ArrayList langPatches = (ArrayList)entry.getValue();
                OneOffEntry[] originLangPatches = new OneOffEntry[langPatches.size()];
                langPatches.toArray(originLangPatches);
                BuildRelationPatchMap build = new BuildRelationPatchMap();
                HashMap idenHm = build.buildIdenticalPiMap(originLangPatches);
                PrereqSet cangoList = PrereqFilterDuplicatePatch.getFilteredPatches(idenHm);
                HashMap dupHm = build.buildDuplicatePiMap(cangoList.getAllElements());
                cangoList = PrereqFilterDuplicatePatch.getFilteredPatches(dupHm);
                outputPi = outputPi.add(cangoList);
            }
        }
        catch (ExitOPatchException e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        catch (Throwable t) {
            RuntimeException e3 = new RuntimeException(t.getMessage());
            e3.setStackTrace(t.getStackTrace());
            throw e3;
        }
        OneOffEntry[] output = outputPi.getAllElements();
        PrereqFilterDuplicatePatch.sort(output);
        return output;
    }

    private static ArrayList<ArrayList<OneOffEntry>> divideComposite(OneOffEntry[] pIs) {
        ArrayList<ArrayList<OneOffEntry>> newPi = new ArrayList<ArrayList<OneOffEntry>>();
        ArrayList singleton = new ArrayList();
        ArrayList<OneOffEntry> composite = new ArrayList<OneOffEntry>();
        ArrayList<OneOffEntry> piList = new ArrayList<OneOffEntry>();
        if (pIs == null || pIs.length == 0) {
            return null;
        }
        for (OneOffEntry entry : pIs) {
            piList.add(entry);
        }
        ArrayList comp = CompositePatchObject.determineCompositeIndices(pIs);
        if (comp != null && comp.size() != 0) {
            for (int i2 = ((Integer)comp.get(0)).intValue(); i2 <= (Integer)comp.get(1); ++i2) {
                composite.add(pIs[i2]);
            }
            piList.removeAll(composite);
        }
        singleton = piList;
        newPi.add(singleton);
        newPi.add(composite);
        return newPi;
    }

    private static HashMap getLangPatchGroup(OneOffEntry[] pIs) {
        StringBuffer buff = new StringBuffer("PrereqFilterDuplicatePatch::GetLangPatchGroup()");
        OLogger.debug(buff);
        if (pIs == null || pIs.length == 0) {
            String msg = "Empty List of incoming patches.";
            OLogger.debug(buff.append(msg));
            return null;
        }
        HashMap<String, ArrayList> langHm = new HashMap<String, ArrayList>();
        for (int i2 = 0; i2 < pIs.length; ++i2) {
            ArrayList list;
            String langPi = pIs[i2].getPatchLanguage();
            if ("".equals(langPi)) {
                langPi = "en";
            }
            if (langHm.containsKey(langPi)) {
                list = (ArrayList)langHm.get(langPi);
                list.add(pIs[i2]);
                langHm.put(langPi, list);
                continue;
            }
            list = new ArrayList();
            list.add(pIs[i2]);
            langHm.put(langPi, list);
        }
        return langHm;
    }

    private static PrereqSet getFilteredPatches(HashMap hm) {
        PrereqSet cangoList = new PrereqSet();
        StringBuffer buff = new StringBuffer("PrereqFilterDuplicatePatch::getFilteredPatches()");
        OLogger.debug(buff);
        for (Object value : hm.values()) {
            ArrayList dupPatches = (ArrayList)value;
            OneOffEntry[] toFilterPatches = new OneOffEntry[dupPatches.size()];
            dupPatches.toArray(toFilterPatches);
            if (toFilterPatches.length == 1) {
                buff.setLength(0);
                buff.append("No duplicate patches found.").append("\nAdd this patch to cango list: ");
                buff.append("[").append(toFilterPatches[0].getID()).append("]");
                OLogger.debug(buff);
                cangoList.add(toFilterPatches[0]);
                continue;
            }
            if (toFilterPatches.length <= 1) continue;
            buff.setLength(0);
            buff.append("\nPatches [ ");
            for (int i2 = 0; i2 < toFilterPatches.length; ++i2) {
                OneOffEntry p2 = toFilterPatches[i2];
                buff.append(p2.getID());
                if (i2 == toFilterPatches.length - 1) continue;
                buff.append(", ");
            }
            buff.append(" ] are duplicate patches. \n");
            HashMap type = PrereqFilterDuplicatePatch.getPatchingTypes(toFilterPatches);
            if (type.get("snowball") != null && type.get("singleton") == null) {
                buff.append("\nThese patches are all snowball. ").append("Install Pi. Let the file versions decide which files get updated");
                OLogger.println(buff.toString());
                for (int i3 = 0; i3 < toFilterPatches.length; ++i3) {
                    cangoList.add(toFilterPatches[i3]);
                }
                continue;
            }
            if (type.get("snowball") == null && type.get("singleton") != null) {
                buff.append("\nThese patches are all singleton. ").append("Continue with best patch: ");
                try {
                    SelectBetterPatchOneOffEngine eng = new SelectBetterPatchOneOffEngine();
                    OneOffEntry bestPatch = eng.selectBetterPatchAmongPatches(toFilterPatches);
                    buff.append("[ ").append(bestPatch.getID()).append(" ]");
                    OLogger.println(buff.toString());
                    cangoList.add(bestPatch);
                    continue;
                }
                catch (Throwable t) {
                    throw new RuntimeException("OPatch was not able to get valid Pi. " + t.getMessage(), t);
                }
            }
            if (type.get("snowball") != null && type.get("singleton") != null) {
                buff.append("\nOPatch doesn't support mixed patch types. \n");
                throw new ExitOPatchException(buff.toString());
            }
            buff.append("\nOPatch is unable to get patch types from incoming patches. \n");
            throw new ExitOPatchException(buff.toString());
        }
        return cangoList;
    }

    private static HashMap getPatchingTypes(OneOffEntry[] pIs) {
        HashMap<String, ArrayList> typeHm = new HashMap<String, ArrayList>();
        for (OneOffEntry pi : pIs) {
            ArrayList list;
            String type = pi.getPatchType();
            if (type == "") {
                type = "singleton";
            }
            if (typeHm.containsKey(type)) {
                list = (ArrayList)typeHm.get(type);
                list.add(pi);
                typeHm.put(type, list);
                continue;
            }
            list = new ArrayList();
            list.add(pi);
            typeHm.put(type, list);
        }
        return typeHm;
    }

    private static void sort(OneOffEntry[] pIs) {
        if (pIs.length <= 1) {
            return;
        }
        for (int i2 = 1; i2 < pIs.length; ++i2) {
            OneOffEntry value = pIs[i2];
            for (int j2 = i2; j2 > 0 && pIs[j2 - 1].getID().compareTo(value.getID()) > 0; --j2) {
                pIs[j2] = pIs[j2 - 1];
            }
            pIs[j2] = value;
        }
    }
}

