/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.twophase;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.CopyAction;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchObject;
import oracle.opatch.opatchactions.DeleteAction;
import oracle.opatch.opatchutil.NApply;
import oracle.opatch.opatchutil.OPatchUtilHelper;
import oracle.opatch.twophase.PhaseOneOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NApplyOperator
extends PhaseOneOperator {
    @Override
    public String getPrefix() {
        String aCache = OPatchEnv.getPrereqResultFileLoc(OPatchEnv.getOracleHome()) + File.separator + "napply.key";
        return aCache;
    }

    @Override
    public String getKeyPostfix() {
        return "napply";
    }

    @Override
    public Map<Path, String> modify(String soh, PatchObject[] piList) throws Exception {
        OPatchUtilHelper.setAutoRollbackOneOffs(new OneOffEntry[0]);
        NApply.legacy_process_binary(soh, piList);
        HashMap<Path, String> remove = new HashMap<Path, String>();
        for (PatchObject patch : piList) {
            String fileName;
            Path filePath;
            ListIterator das = patch.getAllIncludedDeleteActions();
            ListIterator cas = patch.getAllTruelyIncludedCopyActions();
            while (das.hasNext()) {
                boolean isDir;
                DeleteAction da = (DeleteAction)das.next();
                if (da.isSnowBallDeleteAction()) {
                    if (!da.isAppliedOK() || (isDir = Files.isDirectory(filePath = Paths.get(fileName = da.getRelativePath(), new String[0]), new LinkOption[0]))) continue;
                    remove.put(filePath, fileName);
                    continue;
                }
                fileName = da.getRelativePath();
                filePath = Paths.get(fileName, new String[0]);
                isDir = Files.isDirectory(filePath, new LinkOption[0]);
                if (isDir) continue;
                remove.put(filePath, fileName);
            }
            while (cas.hasNext()) {
                CopyAction ca = (CopyAction)cas.next();
                if (ca.isSnowBallCopyAction()) {
                    if (!ca.isAppliedOK() || !remove.containsKey(filePath = Paths.get(fileName = ca.getFilename(), new String[0]))) continue;
                    remove.remove(filePath);
                    continue;
                }
                fileName = ca.getFilename();
                filePath = Paths.get(fileName, new String[0]);
                if (!remove.containsKey(filePath)) continue;
                remove.remove(filePath);
            }
        }
        return remove;
    }

    @Override
    public PatchObject[] buildInputPatchList(PatchObject patch, PatchObject[] patchList) {
        if (patch.getIsComposite()) {
            if (patch.isActiveCompositeSubPatch()) {
                String patchLoc = patch.getPatchLocation();
                String topCompositeLoc = new File(patchLoc).getParent();
                return CompositePatchObject.getCompositeSubPatches(topCompositeLoc);
            }
            return new PatchObject[0];
        }
        return new PatchObject[]{patch};
    }

    @Override
    public List<PatchObject> getScriptsSavePatchList(PatchObject p2, PatchObject[] piList) {
        return new ArrayList<PatchObject>(Arrays.asList(p2));
    }
}

