/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.twophase;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import oracle.opatch.CopyAction;
import oracle.opatch.InitReadMeAction;
import oracle.opatch.InitScriptAction;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchObject;
import oracle.opatch.PostReadMeAction;
import oracle.opatch.PostScriptAction;
import oracle.opatch.PreReadMeAction;
import oracle.opatch.PreScriptAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchutil.NRollback;
import oracle.opatch.twophase.PhaseOneOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NRollbackOperator
extends PhaseOneOperator {
    @Override
    public Map<Path, String> modify(String soh, PatchObject[] rollbackPatch) {
        String[] patchesToRollback = new String[rollbackPatch.length];
        for (int i2 = 0; i2 < rollbackPatch.length; ++i2) {
            patchesToRollback[i2] = rollbackPatch[i2].getPatchID();
        }
        NRollback.legacy_process(soh, patchesToRollback);
        this.setPatchActions(OPatchEnv.getOracleHome(), rollbackPatch);
        HashMap<Path, String> remove = new HashMap();
        remove = this.getRemovedFiles(OPatchEnv.getOracleHome(), rollbackPatch);
        return remove;
    }

    @Override
    public String getPrefix() {
        return OPatchEnv.getPrereqResultFileLoc(OPatchEnv.getOracleHome()) + File.separator + "nrollback.key";
    }

    @Override
    public String getKeyPostfix() {
        return "nrollback";
    }

    @Override
    public PatchObject[] buildInputPatchList(PatchObject patch, PatchObject[] patchList) {
        if (patch.getIsComposite()) {
            if (patch.isActiveCompositeSubPatch()) {
                ArrayList<PatchObject> piPatches = new ArrayList<PatchObject>();
                for (PatchObject p2 : patchList) {
                    if (!p2.getIsComposite()) continue;
                    piPatches.add(p2);
                }
                return piPatches.toArray(new PatchObject[piPatches.size()]);
            }
            return new PatchObject[0];
        }
        return new PatchObject[]{patch};
    }

    @Override
    public List<PatchObject> getScriptsSavePatchList(PatchObject p2, PatchObject[] piList) {
        return new ArrayList<PatchObject>(Arrays.asList(piList));
    }

    private void setPatchActions(String oracleHomePath, PatchObject[] patches) {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: NRollbackOperator::setPatchActions (String oracleHomePath, PatchObject[] patches)");
        for (PatchObject po : patches) {
            String cookedPatchID = po.getCookedPatchID();
            String prevAppliedPatchLocation = OPatchEnv.getPatchBackupDirectoryPath(oracleHomePath, cookedPatchID);
            String preReadMeLoc = PatchObject.getPreReadMeFilePath(prevAppliedPatchLocation);
            String postReadMeLoc = PatchObject.getPostReadMeFilePath(prevAppliedPatchLocation);
            String initReadMeLoc = PatchObject.getInitReadMeFilePath(prevAppliedPatchLocation);
            String initScriptLoc = PatchObject.getInitScriptFilePath(prevAppliedPatchLocation);
            String preScriptLoc = PatchObject.getPreScriptFilePath(prevAppliedPatchLocation);
            String postScriptLoc = PatchObject.getPostScriptFilePath(prevAppliedPatchLocation);
            po.setInitReadMeAction(new InitReadMeAction(initReadMeLoc));
            po.setInitScriptAction(new InitScriptAction(initScriptLoc));
            po.setPreReadMeAction(new PreReadMeAction(preReadMeLoc));
            po.setPreScriptAction(new PreScriptAction(preScriptLoc));
            String c1 = this.readScriptContent(postReadMeLoc);
            String newPostReadMeLoc = this.writeScriptContent(c1, po, ".newpost.readme.");
            String c2 = this.readScriptContent(postScriptLoc);
            String newPostScriptLoc = this.writeScriptContent(c2, po, ".newpost.");
            po.setPostReadMeAction(new PostReadMeAction(newPostReadMeLoc));
            po.setPostScriptAction(new PostScriptAction(newPostScriptLoc));
        }
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: NRollbackOperator::setPatchActions (String oracleHomePath, PatchObject[] patches)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readScriptContent(String scriptLoc) {
        block11: {
            OLogger.justlog(OLogger.INFO, "ENTERING METHOD: NRollbackOperator::readScriptContent (String scriptLoc)");
            sb = new StringBuffer();
            scriptFile = new File(scriptLoc);
            br = null;
            try {
                br = new BufferedReader(new InputStreamReader(new FileInputStream(scriptFile)));
                line = "";
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append("\n");
                }
                var8_8 = null;
                if (br == null) break block11;
                ** GOTO lbl52
            }
            catch (FileNotFoundException e) {
                OLogger.printlnOnLog(MessageFormat.format("OPatch cannot find scripts content under {0}:", new Object[]{scriptLoc}));
                var6_16 = null;
                var8_9 = null;
                if (br == null) return var6_16;
                try {
                    br.close();
                    return var6_16;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return var6_16;
            }
            catch (Exception e) {
                OLogger.printlnOnLog(MessageFormat.format("OPatch fails to read scripts content from {0}:", new Object[]{scriptLoc}));
                var6_17 = null;
                var8_10 = null;
                if (br == null) return var6_17;
                ** try [egrp 2[TRYBLOCK] [6 : 159->167)] { 
lbl37:
                // 1 sources

                br.close();
                return var6_17;
lbl39:
                // 1 sources

                catch (Exception e) {
                    e.printStackTrace();
                }
                return var6_17;
            }
            {
                catch (Throwable var7_18) {
                    var8_11 = null;
                    if (br == null) throw var7_18;
                    ** try [egrp 2[TRYBLOCK] [6 : 159->167)] { 
lbl47:
                    // 1 sources

                    br.close();
                    throw var7_18;
lbl49:
                    // 1 sources

                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    throw var7_18;
                }
lbl52:
                // 1 sources

                ** try [egrp 2[TRYBLOCK] [6 : 159->167)] { 
lbl53:
                // 1 sources

                br.close();
lbl55:
                // 1 sources

                catch (Exception e) {}
                e.printStackTrace();
            }
        }
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: NRollbackOperator::readScriptContent (String scriptLoc)");
        return sb.toString();
    }

    private String writeScriptContent(String content, PatchObject po, String postfix) {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: NRollbackOperator::writeScriptContent (String content, PatchObject po, String postfix)");
        String newLoc = "";
        if (content == null) {
            return "";
        }
        try {
            newLoc = this.getNewScriptLoc(po, postfix);
            OLogger.justlog(OLogger.INFO, MessageFormat.format("OPatch is re-writing scripts to {0}:", newLoc));
            File file = new File(newLoc);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fw = new FileWriter(file.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(content);
            bw.close();
        }
        catch (IOException e2) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch fails to write scripts content under {0}:", newLoc));
            return "";
        }
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: NRollbackOperator::writeScriptContent (String content, PatchObject po, String postfix)");
        return newLoc;
    }

    public String getNewScriptLoc(PatchObject po, String script) {
        StringBuffer buff = new StringBuffer(this.getPrefix());
        buff.append(".");
        buff.append(po.getPatchID());
        buff.append(script);
        buff.append(this.getPostfix());
        return buff.toString();
    }

    private Map<Path, String> getRemovedFiles(String oh, PatchObject[] patches) {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: NRollbackOperator::getRemovedFiles(String oh, PatchObject[] patches)");
        if (patches == null || patches.length == 0) {
            return new HashMap<Path, String>();
        }
        HashMap<Path, String> remove = new HashMap<Path, String>();
        Map<Object, Object> sameFileMap = new HashMap();
        for (PatchObject po : patches) {
            String loc = OPatchEnv.getPatchFilemapInfoLoc(oh, po.getPatchID());
            loc = loc.substring(oh.length() + 1, loc.length());
            Path pLoc = Paths.get(loc, new String[0]);
            remove.put(pLoc, loc);
            OLogger.justlog(OLogger.INFO, MessageFormat.format("Removing installed oneoff entry: adding \"{0}\" to remove list. \n", loc));
            String cookedPatchID = po.getCookedPatchID();
            String ps = OPatchEnv.getPatchStorageName() + File.separator + cookedPatchID;
            Path pPs = Paths.get(ps, new String[0]);
            remove.put(pPs, ps);
            OLogger.justlog(OLogger.INFO, MessageFormat.format("Removing backup area, adding \"{0}\" to remove list. \n", ps));
            ListIterator cIter = po.getAllIncludedCopyActions();
            sameFileMap = CopyAction.getSrcFileInUnchangedFileList(oh, cookedPatchID);
            while (cIter.hasNext()) {
                CopyAction a2 = (CopyAction)cIter.next();
                String f2 = a2.getFilename();
                Boolean isInUnchangedFile = false;
                String src = this.getRollbackFile(oh, f2, cookedPatchID);
                String dst = a2.getParentFilePath(oh);
                File srcFile = new File(src);
                if (sameFileMap.containsKey(f2)) {
                    isInUnchangedFile = true;
                }
                if (srcFile.exists() && srcFile.canRead()) {
                    OLogger.justlog(OLogger.INFO, MessageFormat.format("The copy file \"{0}\" exists in .patch_storage, do not remove. \n", src));
                    continue;
                }
                if (srcFile.exists() && !srcFile.canRead()) {
                    String notReadableMsg = MessageFormat.format("The copy file \"{0}\" exists in .patch_storage, but it's not readable. \n", src);
                    OLogger.justlog(OLogger.INFO, notReadableMsg);
                    throw new RuntimeException(notReadableMsg);
                }
                if (!srcFile.exists() && isInUnchangedFile.booleanValue()) {
                    OLogger.justlog(OLogger.INFO, MessageFormat.format("The copy file \"{0}\" doesn't exist in .patch_storage, but it exists in unchanged_files.txt, do not remove. \n", src));
                    continue;
                }
                OLogger.justlog(OLogger.INFO, MessageFormat.format("The copy file \"{0}\" doesn't exist in .patch_storage, to be removed. \n", src));
                StringBuffer srcFileName = new StringBuffer(src);
                dst = dst.substring(oh.length() + 1, dst.length());
                Path pd = Paths.get(dst, new String[0]);
                remove.put(pd, dst);
                OLogger.justlog(OLogger.INFO, MessageFormat.format("Removing newly created file, adding \"{0}\" to remove list. \n", dst));
            }
        }
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: NRollbackOperator::getRemovedFiles(String oh, PatchObject[] patches)");
        return remove;
    }

    private String getRollbackFile(String oh, String copyFile, String cookedPatchID) {
        StringBuffer buff = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oh, cookedPatchID));
        buff.append(File.separator);
        buff.append(copyFile);
        String file = buff.toString();
        return file;
    }
}

