/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import java.util.ArrayList;
import oracle.opatch.opatchsdk.OPatchExecutedArtifact;
import oracle.opatch.opatchsdk.OPatchFAAutomationAction;
import oracle.opatch.opatchsdk.OPatchPatch;

public class FAExecutionContext {
    private OPatchPatch patch = null;
    private OPatchExecutedArtifact[] artifact = new OPatchExecutedArtifact[0];

    protected FAExecutionContext() {
    }

    protected FAExecutionContext(OPatchPatch patch) {
        this.patch = patch;
    }

    protected void setOPatchPatch(OPatchPatch patch) {
        this.patch = patch;
    }

    public OPatchPatch getPatch() {
        return this.patch;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("\n");
        if (this.patch == null) {
            buff.append("[Patch ID: (n/a)\n");
        } else {
            buff.append("[Patch ID: " + this.patch.getPatchLanguageId() + ",\n");
        }
        if (this.artifact == null || this.artifact.length == 0) {
            buff.append("No Executed Artifacts]");
        } else {
            OPatchExecutedArtifact[] artifacts = this.getExecutedArtifactsList();
            buff.append("Executed Artifacts: \n");
            for (int i = 0; i < artifacts.length; ++i) {
                buff.append(artifacts[i].toString());
                if (i == artifacts.length - 1) continue;
                buff.append("\n");
                buff.append("------------------------------------------------------------------------------------------------------");
                buff.append("\n");
            }
            buff.append("]");
        }
        return buff.toString();
    }

    public OPatchExecutedArtifact[] getExecutedArtifactsList() {
        return this.artifact;
    }

    public OPatchExecutedArtifact getLastExecutedArtifact(OPatchFAAutomationAction faAction) {
        OPatchExecutedArtifact[] ex = this.getExecutedArtifactsList();
        if (ex == null || ex.length == 0) {
            return null;
        }
        for (int i = ex.length - 1; i >= 0; --i) {
            OPatchFAAutomationAction exAction = ex[i].getArtifactAction();
            if (exAction != faAction) continue;
            return ex[i];
        }
        return null;
    }

    protected void addArtifact(OPatchExecutedArtifact ae) {
        ArrayList<OPatchExecutedArtifact> artifactArrList = new ArrayList<OPatchExecutedArtifact>();
        for (int i = 0; i < this.artifact.length; ++i) {
            artifactArrList.add(this.artifact[i]);
        }
        if (ae != null) {
            artifactArrList.add(ae);
        }
        this.artifact = new OPatchExecutedArtifact[artifactArrList.size()];
        artifactArrList.toArray(this.artifact);
    }
}

