/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.opatch.ArchiveAction;
import oracle.opatch.Bug;
import oracle.opatch.ChecksumEntity;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.CopyAction;
import oracle.opatch.JarAction;
import oracle.opatch.MakeAction;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchVersionSpecific;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObject;
import oracle.opatch.Platform;
import oracle.opatch.TargetEntity;
import oracle.opatch.WLSPatch;
import oracle.opatch.fmwpatchverbs.DeployActionEl;
import oracle.opatch.fmwpatchverbs.LifecycleActionEl;
import oracle.opatch.opatchactions.DeleteAction;
import oracle.opatch.opatchactions.hotpatchAction;
import oracle.opatch.opatchactions.onewaycopyAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PQSession;
import oracle.opatch.opatchsdk.OPatchAbstractPatch;
import oracle.opatch.opatchsdk.OPatchAction;
import oracle.opatch.opatchsdk.OPatchArchiveAction;
import oracle.opatch.opatchsdk.OPatchAutomationAction;
import oracle.opatch.opatchsdk.OPatchBIPDeployAction;
import oracle.opatch.opatchsdk.OPatchBug;
import oracle.opatch.opatchsdk.OPatchCommandAction;
import oracle.opatch.opatchsdk.OPatchComponent;
import oracle.opatch.opatchsdk.OPatchCopyAction;
import oracle.opatch.opatchsdk.OPatchDeleteAction;
import oracle.opatch.opatchsdk.OPatchDeployAction;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchFAAutomationAction;
import oracle.opatch.opatchsdk.OPatchInterviewAction;
import oracle.opatch.opatchsdk.OPatchJarAction;
import oracle.opatch.opatchsdk.OPatchLifeCycleAction;
import oracle.opatch.opatchsdk.OPatchMakeAction;
import oracle.opatch.opatchsdk.OPatchOnewayCopyAction;
import oracle.opatch.opatchsdk.OPatchOnlineAction;
import oracle.opatch.opatchsdk.OPatchPatchLanguage;
import oracle.opatch.opatchsdk.OPatchPatchModel;
import oracle.opatch.opatchsdk.OPatchPatchType;
import oracle.opatch.opatchsdk.OPatchPlatform;
import oracle.opatch.opatchsdk.OPatchSOADeployAction;
import oracle.opatch.opatchsdk.OPatchSOARbDeployAction;
import oracle.opatch.opatchsdk.OPatchTargetEntity;
import oracle.opatch.opatchsdk.OPatchWLSPrereqPatch;
import oracle.opatch.opatchsdk.SQLPatchStartupMode;
import oracle.opatch.opatchutil.OUSession;
import oracle.opatch.patchsdk.OPatchZipStringResource;
import oracle.opatch.patchverbs.AutomationElement;
import oracle.opatch.patchverbs.CommandActionEl;
import oracle.opatch.patchverbs.InterviewEl;
import oracle.opatch.patchverbs.ParserObject;
import oracle.sysman.oii.oiii.OiiiVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OPatchPatch
extends OPatchAbstractPatch
implements Comparable {
    protected OneOffEntry patch = null;
    protected PatchObject po = null;
    private String oracleHomePath = null;

    private OPatchPatch() {
    }

    protected OPatchPatch(OneOffEntry oneOff) {
        this.patch = oneOff;
    }

    public OneOffEntry getOneOffEntry() {
        return this.patch;
    }

    protected String getOracleHome() {
        return this.oracleHomePath;
    }

    protected void setOracleHome(String oracleHomePath) {
        this.oracleHomePath = oracleHomePath;
    }

    private static ByteArrayInputStream readBytes(ZipEntry ze, ZipInputStream zStream) throws Exception {
        int off = 0;
        int len = -1;
        byte[] data = new byte[(int)ze.getSize()];
        while ((len = zStream.read(data, off, (int)ze.getSize() - off)) > 0) {
            off += len;
        }
        ByteArrayInputStream iStream = new ByteArrayInputStream(data);
        return iStream;
    }

    public OPatchPatch(ZipInputStream zStream) throws OPatchException {
        try {
            ParserObject pb;
            if (zStream == null) {
                throw new OPatchException("The input stream of OPatch compatible patch is <null>. Please check input.");
            }
            ZipEntry ze = null;
            boolean topLevel = true;
            String patchID = "";
            ByteArrayInputStream invStream = null;
            ByteArrayInputStream actionStream = null;
            ByteArrayInputStream automationStream = null;
            ByteArrayInputStream applyAutomationStream = null;
            ByteArrayInputStream rollbackAutomationStream = null;
            ByteArrayInputStream deployStream = null;
            ByteArrayInputStream checksumStream = null;
            while ((ze = zStream.getNextEntry()) != null) {
                if (topLevel) {
                    String realPatchID;
                    patchID = ze.getName();
                    int divZeName = patchID.indexOf("/");
                    patchID = realPatchID = patchID.substring(0, divZeName);
                    topLevel = false;
                    continue;
                }
                String invEntry = PatchObject.getInventoryWithOutXMLFilePath((String)patchID).replace('\\', '/');
                String invXMLEntry = PatchObject.getInventoryFilePath((String)patchID).replace('\\', '/');
                String actionsEntry = PatchObject.getActionWithOutXMLFilePath((String)patchID).replace('\\', '/');
                String actionsXMLEntry = PatchObject.getActionFilePath((String)patchID).replace('\\', '/');
                String automationXMLEntry = PatchObject.getAutomationFilePath((String)patchID).replace('\\', '/');
                String applyAutomationXMLEntry = PatchObject.getApplyAutomationFilePath((String)patchID).replace('\\', '/');
                String rollbackAutomationXMLEntry = PatchObject.getRollbackAutomationFilePath((String)patchID).replace('\\', '/');
                String deployXMLEntry = PatchObject.getDeployFilePath((String)patchID).replace('\\', '/');
                String checksumXMLEntry = PatchObject.getChecksumFilePath((String)patchID).replace('\\', '/');
                String entryName = ze.getName();
                if (entryName.equals(invXMLEntry) || entryName.equals(invEntry)) {
                    invStream = OPatchPatch.readBytes(ze, zStream);
                }
                if (entryName.equals(actionsXMLEntry) || entryName.equals(actionsEntry)) {
                    actionStream = OPatchPatch.readBytes(ze, zStream);
                }
                if (entryName.equals(automationXMLEntry)) {
                    automationStream = OPatchPatch.readBytes(ze, zStream);
                }
                if (entryName.equals(applyAutomationXMLEntry)) {
                    applyAutomationStream = OPatchPatch.readBytes(ze, zStream);
                }
                if (entryName.equals(rollbackAutomationXMLEntry)) {
                    rollbackAutomationStream = OPatchPatch.readBytes(ze, zStream);
                }
                if (entryName.equals(deployXMLEntry)) {
                    deployStream = OPatchPatch.readBytes(ze, zStream);
                }
                if (!entryName.equals(checksumXMLEntry)) continue;
                checksumStream = OPatchPatch.readBytes(ze, zStream);
            }
            if (invStream == null || actionStream == null) {
                throw new OPatchException("The inventory (or) actions stream of a patch cannot be <null>. Please check inventory / actions metadata files of the stream.");
            }
            PatchObject po = new PatchObject(invStream, actionStream, null);
            ArrayList<ParserObject> parsers = new ArrayList<ParserObject>();
            if (automationStream != null) {
                pb = OPatchVersionSpecific.loadAutomationFileStream(automationStream);
                pb.setFileName("automation.xml");
                parsers.add(pb);
            }
            if (applyAutomationStream != null) {
                pb = OPatchVersionSpecific.loadAutomationFileStream(applyAutomationStream);
                pb.setFileName("apply_automation.xml");
                parsers.add(pb);
            }
            if (rollbackAutomationStream != null) {
                pb = OPatchVersionSpecific.loadAutomationFileStream(rollbackAutomationStream);
                pb.setFileName("rollback_automation.xml");
                parsers.add(pb);
            }
            po.setParserObject(parsers);
            if (deployStream != null) {
                po.loadDeployStream(deployStream);
            }
            if (checksumStream != null) {
                po.loadChecksumStream(checksumStream);
            }
            this.patch = po.toOneOffEntry("");
            this.po = po;
        }
        catch (Exception e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
    }

    public OPatchPatch(String patchLocation) throws OPatchException {
        if (patchLocation == null) {
            throw new OPatchException("Not able to create OPatchPatch object. Please check if patch location \"" + patchLocation + "\" is valid.");
        }
        try {
            PatchObject applyPatch = PatchObject.getInstance((String)patchLocation);
            PatchObject.markPatchObjectAsStarred((String)patchLocation);
            this.patch = applyPatch.toOneOffEntry("");
            this.po = applyPatch;
        }
        catch (Exception e) {
            String msg = "Not able to create OPatch patch object with the given \"" + patchLocation + "\". Please check patch metadata. Details:" + e.getMessage();
            OPatchException oe = new OPatchException(msg);
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
    }

    public static void getPatchToLocation(ZipInputStream zStream, String patchLoc) throws OPatchException {
        try {
            if (zStream == null) {
                throw new OPatchException("The input stream of OPatch compatible patch is <null>. Please check input.");
            }
            File patchLocPath = new File(patchLoc);
            if (!patchLocPath.exists()) {
                patchLocPath.mkdirs();
            }
            ZipEntry ze = null;
            while ((ze = zStream.getNextEntry()) != null) {
                String extractPath = patchLoc + File.separator + ze.getName();
                if (ze.isDirectory()) {
                    File e = new File(extractPath);
                    if (e.exists()) continue;
                    e.mkdirs();
                    continue;
                }
                File entryFile = new File(extractPath);
                if (entryFile.exists()) {
                    entryFile.delete();
                }
                FileOutputStream fos = new FileOutputStream(extractPath);
                byte[] data = new byte[1024];
                int count = 0;
                while ((count = zStream.read(data)) != -1) {
                    fos.write(data, 0, count);
                }
                fos.flush();
                fos.close();
            }
            zStream.close();
        }
        catch (Exception e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
    }

    public static OPatchPatch[] getPatchesNoSymbolResolve(ZipInputStream zStream) throws Exception {
        OPatchPatch[] oPatchPatchArray;
        boolean symbolResolveEnabled = OPatchEnv.isSymbolResolveEnabled();
        OPatchEnv.setSymbolResolveEnabled((boolean)false);
        try {
            oPatchPatchArray = OPatchPatch.getPatches(zStream);
            Object var4_4 = null;
        }
        catch (Exception e) {
            try {
                OLogger.error((String)"Error loading patch..");
                OLogger.printStackTrace((Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                OPatchEnv.setSymbolResolveEnabled((boolean)symbolResolveEnabled);
                throw throwable;
            }
        }
        OPatchEnv.setSymbolResolveEnabled((boolean)symbolResolveEnabled);
        return oPatchPatchArray;
    }

    public static OPatchPatch[] getPatchesNoSymbolResolve(String patchLoc) throws OPatchException {
        OPatchPatch[] oPatchPatchArray;
        boolean symbolResolveEnabled = OPatchEnv.isSymbolResolveEnabled();
        OPatchEnv.setSymbolResolveEnabled((boolean)false);
        try {
            oPatchPatchArray = OPatchPatch.getPatches(patchLoc);
            Object var4_4 = null;
        }
        catch (OPatchException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                OPatchEnv.setSymbolResolveEnabled((boolean)symbolResolveEnabled);
                throw throwable;
            }
        }
        OPatchEnv.setSymbolResolveEnabled((boolean)symbolResolveEnabled);
        return oPatchPatchArray;
    }

    public static OPatchPatch[] getPatches(String patchLoc) throws OPatchException {
        OUSession.resetPHBaseDir();
        OPatchEnv.setUserSuppliedPatchIDs((String[])new String[0]);
        OUSession.phbasedir((String)patchLoc);
        String[] validLocs = new String[]{};
        try {
            validLocs = OUSession.parsePatchLocs((Object)new OPatchPatch());
        }
        catch (Exception e) {
            OPatchException oe = new OPatchException("Specified patch location is not the unzip location of the zip patch file.  " + e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        OPatchPatch[] patches = new OPatchPatch[]{};
        ArrayList<OPatchPatch> validPatches = new ArrayList<OPatchPatch>();
        for (int i = 0; i < validLocs.length; ++i) {
            OPatchPatch tmp = null;
            try {
                if (PQSession.isComposite((String)validLocs[i])) {
                    File[] subFiles = new File(validLocs[i]).listFiles();
                    for (int j = 0; j < subFiles.length; ++j) {
                        if (!subFiles[j].isDirectory()) continue;
                        tmp = new OPatchPatch(subFiles[j].getAbsolutePath());
                        validPatches.add(tmp);
                    }
                    continue;
                }
                tmp = new OPatchPatch(validLocs[i]);
                validPatches.add(tmp);
                continue;
            }
            catch (OPatchException e) {
                OLogger.printStackTrace((Throwable)e);
                throw e;
            }
        }
        patches = new OPatchPatch[validPatches.size()];
        validPatches.toArray(patches);
        return patches;
    }

    public static OPatchPatch[] getPatches(ZipInputStream zStream) {
        OPatchPatch[] patches = new OPatchPatch[]{};
        try {
            if (zStream == null) {
                throw new OPatchException("The input stream of OPatch compatible patch is <null>. Please check input.");
            }
            HashMap<String, ByteArrayInputStream> actionStreamMap = new HashMap<String, ByteArrayInputStream>();
            HashMap<String, ByteArrayInputStream> invStreamMap = new HashMap<String, ByteArrayInputStream>();
            HashMap<String, ByteArrayInputStream> autoStreamMap = new HashMap<String, ByteArrayInputStream>();
            HashMap<String, ByteArrayInputStream> applyAutoStreamMap = new HashMap<String, ByteArrayInputStream>();
            HashMap<String, ByteArrayInputStream> rollbackAutoStreamMap = new HashMap<String, ByteArrayInputStream>();
            HashMap<String, ByteArrayInputStream> deployStreamMap = new HashMap<String, ByteArrayInputStream>();
            HashMap<String, ByteArrayInputStream> cksumStreamMap = new HashMap<String, ByteArrayInputStream>();
            HashMap<String, PatchObject> patchesMap = new HashMap<String, PatchObject>();
            ByteArrayInputStream tmpStream = null;
            ZipEntry ze = null;
            boolean topLevel = true;
            String topDirName = "";
            while ((ze = zStream.getNextEntry()) != null) {
                PatchObject po;
                if (topLevel) {
                    String dirName;
                    topDirName = ze.getName();
                    int divZeName = topDirName.indexOf("/");
                    topDirName = dirName = topDirName.substring(0, divZeName);
                    topLevel = false;
                    continue;
                }
                String patternStr = "((" + topDirName + ")(/(\\d+)(/custom/server/(\\d+))?)?)";
                String etcConfig = File.separator + "etc" + File.separator + "config" + File.separator;
                etcConfig = etcConfig.replace('\\', '/');
                String actionPtrnStr = patternStr + etcConfig + "actions(\\.xml)?";
                String invPtrnStr = patternStr + etcConfig + "inventory(\\.xml)?";
                String autoPtrnStr = patternStr + etcConfig + "automation.xml";
                String applyAutoPtrnStr = patternStr + etcConfig + "apply_automation.xml";
                String rollbackAutoPtrnStr = patternStr + etcConfig + "rollback_automation.xml";
                String depPtrnStr = patternStr + etcConfig + "deploy.xml";
                String checkPtrnStr = patternStr + etcConfig + "checksum.xml";
                Pattern actionPattern = Pattern.compile(actionPtrnStr);
                Pattern invPattern = Pattern.compile(invPtrnStr);
                Pattern autoPattern = Pattern.compile(autoPtrnStr);
                Pattern applyAutoPattern = Pattern.compile(applyAutoPtrnStr);
                Pattern rollbackAutoPattern = Pattern.compile(rollbackAutoPtrnStr);
                Pattern depPattern = Pattern.compile(depPtrnStr);
                Pattern checkPattern = Pattern.compile(checkPtrnStr);
                String entryName = ze.getName();
                Matcher actionMatcher = actionPattern.matcher(entryName);
                Matcher invMatcher = invPattern.matcher(entryName);
                Matcher autoMatcher = autoPattern.matcher(entryName);
                Matcher applyAutoMatcher = applyAutoPattern.matcher(entryName);
                Matcher rollbackAutoMatcher = rollbackAutoPattern.matcher(entryName);
                Matcher depMatcher = depPattern.matcher(entryName);
                Matcher checkMatcher = checkPattern.matcher(entryName);
                if (actionMatcher.matches()) {
                    tmpStream = OPatchPatch.readBytes(ze, zStream);
                    if (invStreamMap.get(actionMatcher.group(1)) != null) {
                        ByteArrayInputStream invStream = (ByteArrayInputStream)invStreamMap.get(actionMatcher.group(1));
                        po = new PatchObject((InputStream)invStream, (InputStream)tmpStream, null);
                        patchesMap.put(actionMatcher.group(1), po);
                        invStreamMap.remove(actionMatcher.group(1));
                    } else {
                        actionStreamMap.put(actionMatcher.group(1), tmpStream);
                    }
                }
                if (invMatcher.matches()) {
                    tmpStream = OPatchPatch.readBytes(ze, zStream);
                    if (actionStreamMap.get(invMatcher.group(1)) != null) {
                        ByteArrayInputStream actionStream = (ByteArrayInputStream)actionStreamMap.get(invMatcher.group(1));
                        po = new PatchObject((InputStream)tmpStream, (InputStream)actionStream, null);
                        patchesMap.put(invMatcher.group(1), po);
                        actionStreamMap.remove(invMatcher.group(1));
                    } else {
                        invStreamMap.put(invMatcher.group(1), tmpStream);
                    }
                }
                if (autoMatcher.matches()) {
                    autoStreamMap.put(autoMatcher.group(1), OPatchPatch.readBytes(ze, zStream));
                }
                if (applyAutoMatcher.matches()) {
                    applyAutoStreamMap.put(applyAutoMatcher.group(1), OPatchPatch.readBytes(ze, zStream));
                }
                if (rollbackAutoMatcher.matches()) {
                    rollbackAutoStreamMap.put(rollbackAutoMatcher.group(1), OPatchPatch.readBytes(ze, zStream));
                }
                if (depMatcher.matches()) {
                    deployStreamMap.put(depMatcher.group(1), OPatchPatch.readBytes(ze, zStream));
                }
                if (!checkMatcher.matches()) continue;
                cksumStreamMap.put(checkMatcher.group(1), OPatchPatch.readBytes(ze, zStream));
            }
            for (String key : patchesMap.keySet()) {
                ParserObject pb;
                PatchObject po = (PatchObject)patchesMap.get(key);
                ArrayList<ParserObject> parsers = new ArrayList<ParserObject>();
                if (autoStreamMap.get(key) != null) {
                    pb = OPatchVersionSpecific.loadAutomationFileStream((InputStream)((ByteArrayInputStream)autoStreamMap.get(key)));
                    pb.setFileName("automation.xml");
                    parsers.add(pb);
                }
                if (applyAutoStreamMap.get(key) != null) {
                    pb = OPatchVersionSpecific.loadAutomationFileStream((InputStream)((ByteArrayInputStream)applyAutoStreamMap.get(key)));
                    pb.setFileName("apply_automation.xml");
                    parsers.add(pb);
                }
                if (rollbackAutoStreamMap.get(key) != null) {
                    pb = OPatchVersionSpecific.loadAutomationFileStream((InputStream)((ByteArrayInputStream)rollbackAutoStreamMap.get(key)));
                    pb.setFileName("rollback_automation.xml");
                    parsers.add(pb);
                }
                po.setParserObject(parsers);
                if (deployStreamMap.get(key) != null) {
                    po.loadDeployStream((InputStream)((ByteArrayInputStream)deployStreamMap.get(key)));
                }
                if (cksumStreamMap.get(key) == null) continue;
                po.loadChecksumStream((InputStream)((ByteArrayInputStream)cksumStreamMap.get(key)));
            }
            PatchObject[] pos = new PatchObject[patchesMap.values().size()];
            patchesMap.values().toArray(pos);
            patches = new OPatchPatch[pos.length];
            for (int i = 0; i < patches.length; ++i) {
                patches[i] = new OPatchPatch(pos[i].toOneOffEntry(""));
                patches[i].po = pos[i];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            patches = new OPatchPatch[]{};
        }
        return patches;
    }

    public static Map getPatches(Map map) {
        HashMap patchesMap = (HashMap)map.get(OPatchZipStringResource.PATCHESMAP);
        HashMap opatchPatchesMap = new HashMap();
        Set entrySet = patchesMap.entrySet();
        for (Map.Entry entry : entrySet) {
            PatchObject po = (PatchObject)entry.getValue();
            OPatchPatch opp = new OPatchPatch(po.toOneOffEntry(""));
            opp.po = po;
            opatchPatchesMap.put(entry.getKey(), opp);
        }
        return opatchPatchesMap;
    }

    public static InputStream getInputStream(ZipInputStream zStream, String relPath) throws OPatchException {
        try {
            if (zStream == null) {
                throw new OPatchException("The input stream of OPatch compatible patch is <null>. Please check input.");
            }
            ZipEntry ze = null;
            boolean topLevel = true;
            String patchID = "";
            String combineName = "";
            boolean isActionFile = false;
            boolean isInvFile = false;
            ByteArrayInputStream invStream = null;
            ByteArrayInputStream actionStream = null;
            ByteArrayInputStream specifiedStream = null;
            while ((ze = zStream.getNextEntry()) != null) {
                if (topLevel) {
                    String realPatchID;
                    patchID = ze.getName();
                    int divZeName = patchID.indexOf("/");
                    patchID = realPatchID = patchID.substring(0, divZeName);
                    topLevel = false;
                    while (relPath.startsWith(File.separator)) {
                        relPath = relPath.substring(1);
                    }
                    combineName = patchID + File.separator + relPath;
                    combineName = combineName.replace('\\', '/');
                    continue;
                }
                String invEntry = PatchObject.getInventoryWithOutXMLFilePath((String)patchID).replace('\\', '/');
                String invXMLEntry = PatchObject.getInventoryFilePath((String)patchID).replace('\\', '/');
                String actionsEntry = PatchObject.getActionWithOutXMLFilePath((String)patchID).replace('\\', '/');
                String actionsXMLEntry = PatchObject.getActionFilePath((String)patchID).replace('\\', '/');
                String entryName = ze.getName();
                if (entryName.equals(invXMLEntry) || entryName.equals(invEntry)) {
                    invStream = OPatchPatch.readBytes(ze, zStream);
                }
                if (entryName.equals(actionsXMLEntry) || entryName.equals(actionsEntry)) {
                    actionStream = OPatchPatch.readBytes(ze, zStream);
                }
                if (!entryName.equals(combineName)) continue;
                if (combineName.equals(invXMLEntry) || combineName.equals(invEntry)) {
                    specifiedStream = invStream;
                    invStream.mark(invStream.available() + 1);
                    isInvFile = true;
                    continue;
                }
                if (combineName.equals(actionsXMLEntry) || combineName.equals(actionsEntry)) {
                    specifiedStream = actionStream;
                    actionStream.mark(actionStream.available() + 1);
                    isActionFile = true;
                    continue;
                }
                specifiedStream = OPatchPatch.readBytes(ze, zStream);
            }
            if (invStream == null || actionStream == null) {
                throw new OPatchException("The inventory (or) actions stream of a patch cannot be <null>. Please check inventory / actions metadata files of the stream.");
            }
            new PatchObject(invStream, actionStream, null);
            if (specifiedStream == null) {
                throw new OPatchException("Specified file \"" + relPath + "\" does not exist in the zip patch file.");
            }
            if (isInvFile || isActionFile) {
                specifiedStream.reset();
            }
            return specifiedStream;
        }
        catch (Exception e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
    }

    protected String getLogTimeStamp() {
        StringBuffer timeStampDir = new StringBuffer(this.getPatchId());
        timeStampDir.append("_");
        timeStampDir.append(this.patch.getInitDateStr());
        return timeStampDir.toString();
    }

    public OPatchAction[] getActions(OPatchComponent oc) throws OPatchException {
        try {
            PatchAction[] pa = oc.getCoreComponent().getAllActions();
            OPatchAction[] oa = this.getOPatchActions(pa);
            return oa;
        }
        catch (Exception e) {
            String msg = "Not able to get the actions for OPatchPatch object.";
            OPatchException oe = new OPatchException(msg);
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
    }

    @Override
    public OPatchAction[] getActions() throws OPatchException {
        try {
            PatchAction[] pa = this.patch.getPatchActions();
            OPatchAction[] oa = this.getOPatchActions(pa);
            return oa;
        }
        catch (Exception e) {
            String msg = "Not able to get the actions for OPatchPatch object.";
            OPatchException oe = new OPatchException(msg);
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
    }

    private OPatchAction[] getOPatchActions(PatchAction[] pa) throws Exception {
        OPatchAction[] oa = new OPatchAction[pa.length];
        for (int i = 0; i < pa.length; ++i) {
            if (pa[i] instanceof CopyAction) {
                CopyAction ca = (CopyAction)pa[i];
                OPatchCopyAction oca = new OPatchCopyAction(ca);
                oa[i] = oca;
            } else if (pa[i] instanceof JarAction) {
                JarAction ja = (JarAction)pa[i];
                OPatchJarAction oja = new OPatchJarAction(ja);
                oa[i] = oja;
            } else if (pa[i] instanceof ArchiveAction) {
                ArchiveAction aa = (ArchiveAction)pa[i];
                OPatchArchiveAction oaa = new OPatchArchiveAction(aa);
                oa[i] = oaa;
            } else if (pa[i] instanceof MakeAction) {
                MakeAction ma = (MakeAction)pa[i];
                OPatchMakeAction oma = new OPatchMakeAction(ma);
                oa[i] = oma;
            } else if (pa[i] instanceof onewaycopyAction) {
                onewaycopyAction oc = (onewaycopyAction)pa[i];
                OPatchOnewayCopyAction ooca = new OPatchOnewayCopyAction(oc);
                oa[i] = ooca;
            } else if (pa[i] instanceof hotpatchAction) {
                hotpatchAction hp = (hotpatchAction)pa[i];
                OPatchOnlineAction ooa = new OPatchOnlineAction(hp);
                oa[i] = ooa;
            } else if (pa[i] instanceof DeleteAction) {
                DeleteAction da = (DeleteAction)pa[i];
                OPatchDeleteAction oda = new OPatchDeleteAction(da);
                oa[i] = oda;
            } else {
                throw new Exception("The patch action is not suppported in OPatchSDK.");
            }
            oa[i].setLineNumber(pa[i].getLineNumber());
            oa[i].setOracleHome(this.getOracleHome());
        }
        return oa;
    }

    protected ChecksumEntity[] getChecksumList() {
        return this.patch.getChecksumList();
    }

    @Override
    public OPatchBug[] getBugs() {
        Bug[] b = this.patch.getBugsFixed();
        OPatchBug[] ob = new OPatchBug[b.length];
        for (int i = 0; i < b.length; ++i) {
            ob[i] = new OPatchBug(b[i]);
        }
        return ob;
    }

    @Override
    public String[] getAllInterviewKeys() throws OPatchException {
        String[] allKeys = new String[]{};
        try {
            ParserObject p = this.getAutomationParserObject();
            if (p != null) {
                allKeys = p.getAllInterviewKeys();
            }
        }
        catch (RuntimeException e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        return allKeys;
    }

    @Override
    public String[] getMandatoryInterviewKeys() throws OPatchException {
        String[] mandatoryKeys = new String[]{};
        try {
            ArrayList parserObjects = this.patch.getParserObject();
            ParserObject p = null;
            if (parserObjects != null) {
                p = (ParserObject)parserObjects.get(0);
            }
            if (p != null) {
                mandatoryKeys = p.getRequiredInterviewKeys();
            }
        }
        catch (RuntimeException e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        return mandatoryKeys;
    }

    @Override
    public Properties getPatchInterviewList() throws OPatchException {
        Properties prop = null;
        try {
            ParserObject p = this.getAutomationParserObject();
            if (p != null) {
                prop = p.getInterviewList();
            }
        }
        catch (RuntimeException e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        return prop;
    }

    public ParserObject getAutomationParserObject() {
        ArrayList parsers = this.patch.getParserObject();
        for (ParserObject p : parsers) {
            if (!p.getFileName().equals("automation.xml")) continue;
            return p;
        }
        return null;
    }

    public ArrayList<ParserObject> getApplyRollbackAutomationParserObject() {
        ArrayList parsers = this.patch.getParserObject();
        ArrayList<ParserObject> results = null;
        for (ParserObject p : parsers) {
            if (!p.getFileName().equals("rollback_automation.xml") && !p.getFileName().equals("apply_automation.xml")) continue;
            if (results == null) {
                results = new ArrayList<ParserObject>();
            }
            results.add(p);
        }
        return results;
    }

    @Override
    public OPatchComponent[] getComponentsAffected() {
        PatchComponent[] oc = this.patch.getOptionalComponents();
        PatchComponent[] rc = this.patch.getRequiredComponents();
        PatchComponent[] pc = new PatchComponent[oc.length + rc.length];
        int pcIndex = 0;
        for (int ocIndex = 0; ocIndex < oc.length; ++ocIndex) {
            pc[pcIndex] = oc[ocIndex];
            ++pcIndex;
        }
        for (int rcIndex = 0; rcIndex < rc.length; ++rcIndex) {
            pc[pcIndex] = rc[rcIndex];
            ++pcIndex;
        }
        OPatchComponent[] ocWrapper = new OPatchComponent[pc.length];
        for (int i = 0; i < ocWrapper.length; ++i) {
            ocWrapper[i] = new OPatchComponent(pc[i]);
        }
        return ocWrapper;
    }

    @Override
    public Date getCreationTime() throws OPatchException {
        String strZone;
        String strDate = this.patch.getCreationDate() == null ? "" : this.patch.getCreationDate();
        String string = strZone = this.patch.getCreationZone() == null ? "" : this.patch.getCreationZone();
        if (strDate.equals("")) {
            throw new OPatchException("Unable to get the created date for the patch.");
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("dd MMM yyyy, HH:mm:ss", Locale.ENGLISH);
            strDate = strDate.replaceAll("hrs", "");
            sdf.setTimeZone(TimeZone.getTimeZone(strZone));
            Date dateObj = sdf.parse(strDate);
            return dateObj;
        }
        catch (Exception e) {
            e.printStackTrace();
            String msg = "Not able to parse the created date to get Date object.";
            OPatchException oe = new OPatchException(msg);
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
    }

    public String getCookedPatchID() {
        return this.patch.getCookedPatchID();
    }

    @Override
    public Date getAppliedDate() throws OPatchException {
        if (this.oracleHomePath == null || this.oracleHomePath.equals("")) {
            throw new OPatchException("This patch is not a representation of an installed patch in the Oracle Home.");
        }
        return this.patch.getAppliedDate() == null ? new Date() : this.patch.getAppliedDate();
    }

    @Override
    public String[] getExecutablesAffected() {
        return this.patch.getExecutables();
    }

    @Override
    public OPatchAction[] getOptionalActions() throws OPatchException {
        try {
            ArrayList<PatchAction> actionsList = new ArrayList<PatchAction>();
            PatchComponent[] comps = this.patch.getOptionalComponents();
            for (int i = 0; i < comps.length; ++i) {
                actionsList.addAll(Arrays.asList(comps[i].getAllActions()));
            }
            PatchAction[] pa = actionsList.toArray(new PatchAction[actionsList.size()]);
            OPatchAction[] oa = this.getOPatchActions(pa);
            return oa;
        }
        catch (Exception e) {
            String msg = "Not able to get the optional actions for OPatchPatch object.";
            OPatchException oe = new OPatchException(msg);
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
    }

    public int compareTo(Object p) {
        OPatchPatch op = (OPatchPatch)p;
        OneOffEntry oe = op.patch;
        return this.patch.compareTo((Object)oe);
    }

    public int hashCode() {
        return this.patch.hashCode();
    }

    public boolean equals(Object o) {
        OPatchPatch op = (OPatchPatch)o;
        OneOffEntry oe = op.patch;
        return this.patch.equals((Object)oe) && this.getUniquePatchIdentifier().equals(op.getUniquePatchIdentifier());
    }

    @Override
    public OPatchComponent[] getOptionalComponents() {
        PatchComponent[] pc = this.patch.getOptionalComponents();
        OPatchComponent[] ocWrapper = new OPatchComponent[pc.length];
        for (int i = 0; i < ocWrapper.length; ++i) {
            ocWrapper[i] = new OPatchComponent(pc[i]);
        }
        return ocWrapper;
    }

    @Override
    public String getPatchId() {
        return this.patch.getPatchID() == null ? "" : this.patch.getPatchID();
    }

    @Override
    public String getPatchLanguageId() {
        return this.patch.getID() == null ? "" : this.patch.getID();
    }

    public String getPatchTripletId() {
        return this.patch.getTripletID() == null ? "" : this.patch.getTripletID();
    }

    @Override
    public String getPatchDescription() {
        return this.patch.getPatchDesc() == null ? "" : this.patch.getPatchDesc();
    }

    @Override
    public String getPatchLocation() {
        return this.patch.getRelativePatchLocation() == null ? "" : this.patch.getRelativePatchLocation();
    }

    @Override
    public Locale getPatchLanguage() {
        String lang = this.patch.getPatchLanguage();
        if (lang == null || lang.equals("") || lang.equals("en")) {
            return null;
        }
        return OPatchPatchLanguage.getLangLocale(lang);
    }

    @Override
    public OPatchPatchModel getPatchModel() {
        return OPatchPatchModel.getObjectRepresentation(this.patch.getPatchModel());
    }

    @Override
    public OPatchPatchType getPatchType() {
        return OPatchPatchType.getObjectRepresentation(this.patch.getPatchType());
    }

    @Override
    public OPatchPlatform[] getPlatforms() {
        Platform[] p = this.patch.getSupportedPlatforms();
        OPatchPlatform[] op = new OPatchPlatform[p.length];
        for (int i = 0; i < op.length; ++i) {
            op[i] = new OPatchPlatform(p[i]);
        }
        return op;
    }

    @Override
    public String getProductFamily() {
        return this.patch.getProductFamily();
    }

    @Override
    public OPatchAction[] getRequiredActions() throws OPatchException {
        try {
            ArrayList<PatchAction> actionsList = new ArrayList<PatchAction>();
            PatchComponent[] comps = this.patch.getRequiredComponents();
            for (int i = 0; i < comps.length; ++i) {
                actionsList.addAll(Arrays.asList(comps[i].getAllActions()));
            }
            PatchAction[] pa = actionsList.toArray(new PatchAction[actionsList.size()]);
            OPatchAction[] oa = this.getOPatchActions(pa);
            return oa;
        }
        catch (Exception e) {
            String msg = "Not able to get the required actions for OPatchPatch object.";
            OPatchException oe = new OPatchException(msg);
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
    }

    @Override
    public OPatchComponent[] getRequiredComponents() {
        PatchComponent[] pc = this.patch.getRequiredComponents();
        OPatchComponent[] ocWrapper = new OPatchComponent[pc.length];
        for (int i = 0; i < ocWrapper.length; ++i) {
            ocWrapper[i] = new OPatchComponent(pc[i]);
        }
        return ocWrapper;
    }

    public OPatchInterviewAction[] getInterviewElements() throws OPatchException {
        ArrayList<OPatchInterviewAction> automationMetadata = new ArrayList<OPatchInterviewAction>();
        ParserObject parser = this.getAutomationParserObject();
        OPatchInterviewAction[] autoAction = new OPatchInterviewAction[]{};
        if (parser == null) {
            return new OPatchInterviewAction[0];
        }
        try {
            AutomationElement[] elements = parser.getListOfElements();
            OPatchAutomationAction[] interviewAction = new OPatchAutomationAction[]{};
            for (int i = 0; i < elements.length; ++i) {
                if (!(elements[i] instanceof InterviewEl)) continue;
                OPatchInterviewAction interview = new OPatchInterviewAction(elements[i]);
                automationMetadata.add(interview);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String msg = "Not able to get interview  automation elements of the patch.";
            OPatchException oe = new OPatchException(msg);
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        autoAction = new OPatchInterviewAction[automationMetadata.size()];
        automationMetadata.toArray(autoAction);
        return autoAction;
    }

    public OPatchCommandAction[] getCommandActions() throws OPatchException {
        ArrayList<OPatchCommandAction> automationMetadata = new ArrayList<OPatchCommandAction>();
        ParserObject parser = this.getAutomationParserObject();
        OPatchCommandAction[] cAction = new OPatchCommandAction[]{};
        if (parser == null) {
            return new OPatchCommandAction[0];
        }
        try {
            AutomationElement[] elements = parser.getListOfElements();
            for (int i = 0; i < elements.length; ++i) {
                if (!(elements[i] instanceof CommandActionEl)) continue;
                CommandActionEl cael = (CommandActionEl)elements[i];
                OPatchCommandAction oca = new OPatchCommandAction((AutomationElement)cael);
                automationMetadata.add(oca);
            }
        }
        catch (Exception e) {
            String msg = "OPatch was not able to get Command Action automation elements of the patch.";
            OPatchException oe = new OPatchException(msg);
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        cAction = new OPatchCommandAction[automationMetadata.size()];
        automationMetadata.toArray(cAction);
        return cAction;
    }

    public OPatchFAAutomationAction[] getFAAutomationMetadata() throws OPatchException {
        ArrayList<OPatchFAAutomationAction> automationMetadata = new ArrayList<OPatchFAAutomationAction>();
        ParserObject parser = this.getAutomationParserObject();
        OPatchFAAutomationAction[] autoAction = new OPatchFAAutomationAction[]{};
        if (parser == null) {
            return new OPatchFAAutomationAction[0];
        }
        try {
            AutomationElement[] elements = parser.getListOfElements();
            for (int i = 0; i < elements.length; ++i) {
                if (elements[i] instanceof DeployActionEl) {
                    OPatchDeployAction soa;
                    DeployActionEl dael = (DeployActionEl)elements[i];
                    if (dael.isSOACompDeploy()) {
                        soa = new OPatchSOADeployAction(elements[i]);
                        automationMetadata.add(soa);
                        continue;
                    }
                    if (dael.isSOARbDeploy()) {
                        soa = new OPatchSOARbDeployAction(elements[i]);
                        automationMetadata.add(soa);
                        continue;
                    }
                    if (!dael.isBIPDeploy()) continue;
                    OPatchBIPDeployAction bip = new OPatchBIPDeployAction(elements[i]);
                    automationMetadata.add(bip);
                    continue;
                }
                if (!(elements[i] instanceof LifecycleActionEl)) continue;
                OPatchLifeCycleAction lifeCycle = new OPatchLifeCycleAction(elements[i]);
                automationMetadata.add(lifeCycle);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String msg = "Not able to get FA/FMW automation elements of the patch.";
            OPatchException oe = new OPatchException(msg);
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        autoAction = new OPatchFAAutomationAction[automationMetadata.size()];
        automationMetadata.toArray(autoAction);
        return autoAction;
    }

    @Override
    public String[] getPrereqBugIDs() {
        return this.patch.getPrereqBugIDs();
    }

    @Override
    public boolean isAutoPatch() {
        return this.patch.isAuto();
    }

    @Override
    public boolean isInstanceShutdownPatch() {
        return this.patch.isInstanceShutdown();
    }

    @Override
    public boolean isOnlinePatch() {
        return this.patch.isOnlinePatch();
    }

    @Override
    public boolean isPatchSetUpdate() {
        return this.patch.isMiniPatchSet();
    }

    @Override
    public boolean isRollbackable() {
        return this.patch.isRollbackable();
    }

    @Override
    public boolean isRollingPatch() {
        return this.patch.isRolling();
    }

    @Override
    public boolean isTranslatable() {
        return this.patch.isTranslatable();
    }

    public boolean isSqlPatch() {
        return this.patch.isSqlPatch();
    }

    public SQLPatchStartupMode getSqlPatchDatabaseStartupMode() throws OPatchException {
        if (this.isSqlPatch()) {
            String modeStr = this.patch.getSqlPatchDatabaseStartupMode();
            if (modeStr.equals(SQLPatchStartupMode.UPGRADE.toString())) {
                return SQLPatchStartupMode.UPGRADE;
            }
            if (modeStr.equals(SQLPatchStartupMode.NORMAL.toString())) {
                return SQLPatchStartupMode.NORMAL;
            }
            throw new OPatchException("The Database Startup Mode of SQL Patch must be \"upgrade\" or \"normal\"");
        }
        throw new OPatchException("The input patch is not a sql patch.So can't get the database startup mode.");
    }

    @Override
    public String getUniquePatchIdentifier() {
        return this.patch.getPSENumber() == null ? "" : this.patch.getPSENumber();
    }

    public OiiiVersion getMinimumOPatchVersion() {
        String minOPatchVersion = this.patch.getMinOPatchVersion();
        if (minOPatchVersion == null || minOPatchVersion.equals("")) {
            return null;
        }
        OiiiVersion ov = new OiiiVersion(minOPatchVersion);
        return ov;
    }

    @Override
    public OPatchWLSPrereqPatch[] getWlsPrereqPatchIDs() {
        WLSPatch[] wp = this.patch.getWlsPrereqPatchIDs();
        OPatchWLSPrereqPatch[] owpp = new OPatchWLSPrereqPatch[wp.length];
        for (int i = 0; i < owpp.length; ++i) {
            owpp[i] = new OPatchWLSPrereqPatch(wp[i]);
        }
        return owpp;
    }

    public OPatchTargetEntity[] getTargetEntities() {
        TargetEntity[] te = this.patch.getTargetEntities();
        OPatchTargetEntity[] ote = new OPatchTargetEntity[te.length];
        for (int i = 0; i < ote.length; ++i) {
            ote[i] = new OPatchTargetEntity(te[i]);
        }
        return ote;
    }

    @Override
    public String[] getPrereqPatchIDs() {
        return this.patch.getPrereqPatchIDs();
    }

    public String getESysPatchID() {
        return this.patch.getESysPatchID();
    }

    @Override
    public String[] getOverLayPatchIDs() {
        return this.patch.getOverLayPatchIDs();
    }

    @Override
    public String getInstanceShutdownMessage() {
        return this.patch.getInstanceShutdownMessage() == null ? "" : this.patch.getInstanceShutdownMessage();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        OiiiVersion ov = this.getMinimumOPatchVersion();
        if (ov != null) {
            sb.append("\n getMinimumOPatchVersion      = " + this.getMinimumOPatchVersion());
        }
        try {
            ChecksumEntity[] cke;
            ParserObject parser = this.getAutomationParserObject();
            if (parser != null) {
                sb.append(parser.toString());
            }
            if ((cke = this.getChecksumList()) != null && cke.length != 0) {
                sb.append(" Checksum contents:");
                for (int i = 0; i < cke.length; ++i) {
                    sb.append(cke[i].toString());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return sb.toString();
    }

    public boolean isComposite() {
        boolean isComposite = this.patch.getIsComposite();
        return isComposite && this.patch.getID().equals(this.patch.getActiveConstituent());
    }

    protected String getActiveConstituent() {
        return this.patch.getIsComposite() ? this.patch.getActiveConstituent() : "";
    }

    public List<String> getSubPatchIds() {
        String patchId = this.getPatchId();
        String patchLoc = this.getPatchLocation();
        ArrayList<String> arr = new ArrayList<String>();
        if (this.isComposite()) {
            String[] subPatchIds;
            String compositeXMLLoc = this.patch.getCompositeFileLocation();
            for (String subPatchId : subPatchIds = CompositePatchObject.getConstituentList((String)compositeXMLLoc)) {
                if (subPatchId.equals(patchId)) continue;
                arr.add(subPatchId);
            }
        }
        return arr;
    }

    public boolean isPrereqAndOverlayOn(OPatchPatch patch) {
        String[] prereqs;
        String patchId = patch.getPatchId();
        for (String prereqId : prereqs = this.getPrereqPatchIDs()) {
            if (!prereqId.equals(patchId)) continue;
            return true;
        }
        return false;
    }

    public PatchObject getPo() {
        return this.po;
    }
}

