/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchOverCAS;
import oracle.opatch.OPatchSession;
import oracle.opatch.cas.CASIntegrityServices;
import oracle.opatch.opatchlogger.OLogger;

public class CheckIntegritySession
extends OPatchSession {
    protected CheckIntegritySession(String name, boolean readOnly) {
        super(name, readOnly);
    }

    public void process(String oracleHomePath) throws RuntimeException {
        if (OPatchEnv.isHelp()) {
            this.displayHelp();
            return;
        }
        OPatchOverCAS.INSTANCE.initializeCAS(oracleHomePath);
        CASIntegrityServices is = new CASIntegrityServices();
        boolean isCompleted = false;
        try {
            try {
                OLogger.println(MessageFormat.format("Verifying integrity for Oracle Home \"{0}\" ", oracleHomePath));
                isCompleted = is.isLastCheckpointCompleted(oracleHomePath);
            }
            catch (Throwable e2) {
                RuntimeException re = new RuntimeException(e2.getMessage());
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            OLogger.println(MessageFormat.format("Integrity check {0}.", isCompleted ? "passed" : "failed"));
            OPatchOverCAS.INSTANCE.cleanupCAS();
            throw throwable;
        }
        OLogger.println(MessageFormat.format("Integrity check {0}.", isCompleted ? "passed" : "failed"));
        OPatchOverCAS.INSTANCE.cleanupCAS();
    }

    public void displayHelp() {
        StringBuffer helpM = new StringBuffer("\n");
        String helpFile = "";
        helpFile = "checkintegrity_help.txt";
        try {
            String thisLine;
            InputStream is = this.getClass().getResourceAsStream(helpFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((thisLine = br.readLine()) != null) {
                helpM.append(thisLine);
                helpM.append("\n");
            }
            OLogger.println(helpM.toString());
        }
        catch (Exception e2) {
            String msg = OLogger.getString("OUI-67108", new Object[]{helpFile});
            OLogger.println(msg);
        }
    }
}

