/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.opatch.AttachSession;
import oracle.opatch.CleanupSession;
import oracle.opatch.CmdLineHelper;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.CreateSession;
import oracle.opatch.DestroySession;
import oracle.opatch.DetachSession;
import oracle.opatch.IOPatchSession;
import oracle.opatch.IsCasReposPresentSession;
import oracle.opatch.ListSession;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchCmdLineParser;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchProperty;
import oracle.opatch.OPatchSession;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OPatchVersionSpecific;
import oracle.opatch.OUIReplacer;
import oracle.opatch.OUIVersion;
import oracle.opatch.PrereqSession;
import oracle.opatch.StringResource;
import oracle.opatch.SynchSession;
import oracle.opatch.SystemCall;
import oracle.opatch.TagbranchSession;
import oracle.opatch.UtilSession;
import oracle.opatch.ZOPErrorMessage;
import oracle.opatch.ZipUtilities;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PQSession;
import oracle.opatch.opatchutil.OUSession;
import oracle.opatch.opatchutil.SrvmUtil;
import oracle.opatch.ops.Feature;
import oracle.opatch.ops.OPS;

public class CmdLineParser {
    public static String getOracleHomePath(String[] args) {
        return "";
    }

    private static void initRuntimeOptions(OPatchCmdLineParser parser) {
        try {
            CmdLineParser.initRuntimeOptions("oracle.opatch.opatchutil.OUSession", parser, StringResource.UTIL_PACKAGE_CLASS_CMDLINEOPTIONS_CLASSNAME, StringResource.UTIL_OPTIONS, StringResource.UTIL_LITERAL_OPTIONS);
            CmdLineParser.initRuntimeOptions("oracle.opatch.opatchprereq.PQSession", parser, StringResource.PREREQ_PACKAGE_CLASS_CMDLINEOPTIONS_CLASSNAME, StringResource.PREREQ_OPTIONS, StringResource.PREREQ_LITERAL_OPTIONS);
        }
        catch (SecurityException e2) {
            OLogger.println("CmdLineParser::initRuntimeOptions(): failed to load run-time options, SecurityException: ");
            OLogger.println(e2.getMessage());
        }
        catch (ClassNotFoundException e3) {
            OLogger.println("CmdLineParser::initRuntimeOptions(): failed to load run-time options, ClassNotFoundException: ");
            OLogger.println(e3.getMessage());
        }
        catch (ParseException e4) {
            OLogger.println("CmdLineParser::initRuntimeOptions(): failed to load run-time options, ParseException: ");
            OLogger.println(e4.getMessage());
        }
    }

    private static void initRuntimeOptions(String classEntryPoint, OPatchCmdLineParser parser, String[] classNames, OPatchCmdLineParser.Option[][] options, String[][] literalOptions) throws SecurityException, ClassNotFoundException, ParseException {
        StringBuffer buff = new StringBuffer("CmdLineParser::initRuntimeOptions()");
        OLogger.debug(buff);
        try {
            OPatchCmdLineParser.Option[] runtimeStringOptions = new OPatchCmdLineParser.Option[]{};
            for (int i2 = 0; i2 < classNames.length; ++i2) {
                String className = classNames[i2];
                buff = new StringBuffer(" Checking on class ");
                buff.append(className);
                OLogger.debug(buff);
                Class<?> runtimeClass = Class.forName(className);
                buff = new StringBuffer(" Get list of fields defined in the class ");
                buff.append(className);
                OLogger.debug(buff);
                Field[] fields = runtimeClass != null ? runtimeClass.getFields() : new Field[]{};
                int len = fields != null ? fields.length : 0;
                buff = new StringBuffer(" There are ");
                buff.append(len);
                buff.append(" fields defined in this class.");
                OLogger.debug(buff);
                runtimeStringOptions = new OPatchCmdLineParser.Option[len];
                options[i2] = new OPatchCmdLineParser.Option[len];
                literalOptions[i2] = new String[len];
                for (int j2 = 0; j2 < len; ++j2) {
                    String name;
                    Field field = fields[j2];
                    literalOptions[i2][j2] = name = field.getName();
                    buff = new StringBuffer("   adding option \"");
                    buff.append(name);
                    buff.append("\"");
                    OLogger.debug(buff);
                }
            }
            CmdLineHelper.loadRuntimeOption(classEntryPoint, parser, literalOptions, options);
        }
        catch (SecurityException e2) {
            throw e2;
        }
        catch (ClassNotFoundException e3) {
            throw e3;
        }
        catch (ParseException e4) {
            throw e4;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IOPatchSession parse(String[] args) throws RuntimeException {
        boolean isUtilReadOnly;
        String sType;
        String arg;
        block533: {
            boolean hasBundle;
            boolean hasFile;
            boolean hasEtc;
            String[] subDirs;
            File tmpPatchLocation;
            String tmpPatchLoc;
            block554: {
                boolean isHelp;
                String[] otherArgs;
                OPatchCmdLineParser.Option tagId;
                OPatchCmdLineParser.Option viewDir;
                OPatchCmdLineParser.Option viewId;
                OPatchCmdLineParser.Option patchid;
                OPatchCmdLineParser parser;
                block558: {
                    block557: {
                        block556: {
                            block555: {
                                block553: {
                                    block552: {
                                        block551: {
                                            block550: {
                                                String[] idDefn;
                                                String utilOption;
                                                boolean switchToUtil;
                                                block532: {
                                                    ArrayList<String> newPatchIDs;
                                                    ArrayList<String> compositeList;
                                                    String[] patchIDs;
                                                    String oracleHomePath;
                                                    block549: {
                                                        String entry;
                                                        int j2;
                                                        boolean hasFile2;
                                                        boolean hasEtc2;
                                                        String[] subDirs2;
                                                        String cPath;
                                                        boolean patchLocSpecified;
                                                        String compositeXmlLocation;
                                                        File compositeFile;
                                                        String compositeFilePath;
                                                        OPatchCmdLineParser.Option idFile;
                                                        OPatchCmdLineParser.Option skipDuplicate;
                                                        OPatchCmdLineParser.Option skipSubset;
                                                        OPatchCmdLineParser.Option phase_two;
                                                        block547: {
                                                            block548: {
                                                                block546: {
                                                                    Vector<String> supportedCommands;
                                                                    Vector<String> printCommands;
                                                                    OPatchCmdLineParser.Option patchlocfile;
                                                                    OPatchCmdLineParser.Option patchlocdir;
                                                                    block538: {
                                                                        String s;
                                                                        String[] splittedStr;
                                                                        String conn;
                                                                        int cIter;
                                                                        String[] dbNodes;
                                                                        String[] dbPasswords;
                                                                        String[] dbUserNames;
                                                                        String pID;
                                                                        String debugStr;
                                                                        OPatchCmdLineParser.Option all_subpatches;
                                                                        OPatchCmdLineParser.Option lsp_qfile;
                                                                        OPatchCmdLineParser.Option lsp_required;
                                                                        OPatchCmdLineParser.Option lsp_verify;
                                                                        OPatchCmdLineParser.Option lsp_bugs;
                                                                        OPatchCmdLineParser.Option sid;
                                                                        OPatchCmdLineParser.Option sqlScript;
                                                                        OPatchCmdLineParser.Option runSql;
                                                                        OPatchCmdLineParser.Option connStr;
                                                                        OPatchCmdLineParser.Option cfs;
                                                                        OPatchCmdLineParser.Option suppliedNodes;
                                                                        OPatchCmdLineParser.Option remoteNodes;
                                                                        OPatchCmdLineParser.Option localNode;
                                                                        OPatchCmdLineParser.Option logLevel;
                                                                        OPatchCmdLineParser.Option patchloc;
                                                                        OPatchCmdLineParser.Option maxLockingWait;
                                                                        OPatchCmdLineParser.Option retry;
                                                                        OPatchCmdLineParser.Option delay;
                                                                        block534: {
                                                                            int i2;
                                                                            ArrayList<String> patchIds;
                                                                            StringTokenizer tk;
                                                                            Pattern pattern;
                                                                            block537: {
                                                                                String s2;
                                                                                block535: {
                                                                                    block536: {
                                                                                        String patchSortOption;
                                                                                        String[] fileNames;
                                                                                        int i3;
                                                                                        String mwHome;
                                                                                        File f2;
                                                                                        boolean notSupportedCommand;
                                                                                        boolean notUtil;
                                                                                        StringBuffer dbuff = new StringBuffer("OPatchSession::parse() on ");
                                                                                        if (args != null) {
                                                                                            for (int i4 = 0; i4 < args.length; ++i4) {
                                                                                                if (args[i4] != null) {
                                                                                                    dbuff.append("\"").append(args[i4]).append("\",");
                                                                                                    continue;
                                                                                                }
                                                                                                dbuff.append("(null),");
                                                                                            }
                                                                                            dbuff.append("\n");
                                                                                        }
                                                                                        OLogger.debug(dbuff);
                                                                                        switchToUtil = false;
                                                                                        OPatchEnv.setCompositeRollback(false);
                                                                                        OPatchEnv.setSyntaxError(false, "");
                                                                                        parser = new OPatchCmdLineParser();
                                                                                        OPatchCmdLineParser.Option help = parser.addBooleanOption("help");
                                                                                        OPatchCmdLineParser.Option helpShort = parser.addBooleanOption("h");
                                                                                        OPatchCmdLineParser.Option fmwHelpOption = parser.addBooleanOption("fmw");
                                                                                        OPatchCmdLineParser.Option oracleHome = parser.addStringOption("oh");
                                                                                        OPatchCmdLineParser.Option jreLoc = parser.addStringOption("jre");
                                                                                        OPatchCmdLineParser.Option jdkLoc = parser.addStringOption("jdk");
                                                                                        OPatchCmdLineParser.Option verbose = parser.addBooleanOption("verbose");
                                                                                        OPatchCmdLineParser.Option silent = parser.addBooleanOption("silent");
                                                                                        OPatchCmdLineParser.Option invPtrLoc = parser.addStringOption("invptrloc");
                                                                                        delay = parser.addIntegerOption("delay");
                                                                                        retry = parser.addIntegerOption("retry");
                                                                                        OPatchCmdLineParser.Option isPatchsetUpdate = parser.addBooleanOption("is_patchset_update");
                                                                                        OPatchCmdLineParser.Option isUpdateComponents = parser.addBooleanOption("get_update_components");
                                                                                        maxLockingWait = parser.addIntegerOption("maxwait");
                                                                                        OPatchCmdLineParser.Option force = parser.addBooleanOption("force");
                                                                                        OPatchCmdLineParser.Option forceConflict = parser.addBooleanOption("force_conflict");
                                                                                        OPatchCmdLineParser.Option optimize = parser.addBooleanOption("optimize");
                                                                                        OPatchCmdLineParser.Option autoRollbackSubsets = parser.addBooleanOption("autorollback_subsets");
                                                                                        OPatchCmdLineParser.Option phase_one = parser.addBooleanOption("phase_one");
                                                                                        phase_two = parser.addBooleanOption("phase_two");
                                                                                        OPatchCmdLineParser.Option scriptsenabledforopatchovercas = parser.addBooleanOption("allow.patch.script.execution");
                                                                                        OPatchCmdLineParser.Option local = parser.addBooleanOption("local");
                                                                                        OPatchCmdLineParser.Option minimize_downtime = parser.addBooleanOption("minimize_downtime");
                                                                                        OPatchCmdLineParser.Option all_node = parser.addBooleanOption("all_nodes");
                                                                                        OPatchCmdLineParser.Option nolink = parser.addBooleanOption("no_relink");
                                                                                        OPatchCmdLineParser.Option noPostScriptOpt = parser.addBooleanOption("no_post_script");
                                                                                        OPatchCmdLineParser.Option noPreScriptOpt = parser.addBooleanOption("no_pre_script");
                                                                                        OPatchCmdLineParser.Option nopatchgen = parser.addBooleanOption("no_patchgen");
                                                                                        OPatchCmdLineParser.Option preopt = parser.addStringOption("pre");
                                                                                        OPatchCmdLineParser.Option postopt = parser.addStringOption("post");
                                                                                        OPatchCmdLineParser.Option initopt = parser.addStringOption("init");
                                                                                        OPatchCmdLineParser.Option initoptend = parser.addBooleanOption("opatch_init_end");
                                                                                        OPatchCmdLineParser.Option preoptend = parser.addBooleanOption("opatch_pre_end");
                                                                                        OPatchCmdLineParser.Option postoptend = parser.addBooleanOption("opatch_post_end");
                                                                                        OPatchCmdLineParser.Option cfgFile = parser.addStringOption("configFile");
                                                                                        patchid = parser.addStringOption("id");
                                                                                        patchloc = parser.addStringOption("ph");
                                                                                        patchlocdir = parser.addStringOption("phbasedir");
                                                                                        patchlocfile = parser.addStringOption("phbasefile");
                                                                                        OPatchCmdLineParser.Option lsinv_all = parser.addBooleanOption("all");
                                                                                        OPatchCmdLineParser.Option version_all = parser.addBooleanOption("all");
                                                                                        OPatchCmdLineParser.Option version_v2c = parser.addStringOption("v2c");
                                                                                        OPatchCmdLineParser.Option version_ohs = parser.addRawStringOption("ohs");
                                                                                        OPatchCmdLineParser.Option util_all = parser.addBooleanOption("allhomes");
                                                                                        OPatchCmdLineParser.Option query_all = parser.addBooleanOption("all");
                                                                                        OPatchCmdLineParser.Option gi_all = parser.addBooleanOption("all");
                                                                                        OPatchCmdLineParser.Option lsinv_detail = parser.addBooleanOption("detail");
                                                                                        OPatchCmdLineParser.Option lsinv_details = parser.addBooleanOption("details");
                                                                                        OPatchCmdLineParser.Option trans_patch = parser.addBooleanOption("translation_patch");
                                                                                        OPatchCmdLineParser.Option lsinv_patch = parser.addStringOption("patch");
                                                                                        OPatchCmdLineParser.Option lsinv_patch_id = parser.addStringOption("patch_id");
                                                                                        OPatchCmdLineParser.Option lsinv_inactive = parser.addBooleanOption("inactive");
                                                                                        OPatchCmdLineParser.Option lsinv_last_update = parser.addBooleanOption("last_update");
                                                                                        OPatchCmdLineParser.Option lsinv_xml = parser.addStringOption("xml");
                                                                                        OPatchCmdLineParser.Option lsinv_xmldiff = parser.addBooleanOption("xmldiff");
                                                                                        OPatchCmdLineParser.Option lsinv_match = parser.addBooleanOption("match");
                                                                                        OPatchCmdLineParser.Option report = parser.addBooleanOption("report");
                                                                                        logLevel = parser.addStringTegerOption("loglevel");
                                                                                        OPatchCmdLineParser.Option version = parser.addStringOption("version");
                                                                                        OPatchCmdLineParser.Option customLogDir = parser.addStringOption("customLogDir");
                                                                                        OPatchCmdLineParser.Option isAuto = parser.addBooleanOption("auto");
                                                                                        OPatchCmdLineParser.Option mw_home = parser.addStringOption("mw_home");
                                                                                        OPatchCmdLineParser.Option profile_mask = parser.addStringOption("profile_mask");
                                                                                        OPatchCmdLineParser.Option targetList = parser.addRawStringOption("targets");
                                                                                        OPatchCmdLineParser.Option cmdTargetType = parser.addStringOption("target_type");
                                                                                        OPatchCmdLineParser.Option compositeName = parser.addStringOption("name");
                                                                                        OPatchCmdLineParser.Option compositeRev = parser.addStringOption("revision");
                                                                                        OPatchCmdLineParser.Option domainname = parser.addStringOption("domain");
                                                                                        OPatchCmdLineParser.Option domainDir = parser.addStringOption("domaindir");
                                                                                        OPatchCmdLineParser.Option baseconfigPlan = parser.addBooleanOption("base_config_plan");
                                                                                        OPatchCmdLineParser.Option generateSteps = parser.addBooleanOption("generateSteps");
                                                                                        OPatchCmdLineParser.Option analyze = parser.addBooleanOption("analyze");
                                                                                        OPatchCmdLineParser.Option norestart = parser.addBooleanOption("norestart");
                                                                                        OPatchCmdLineParser.Option database = parser.addStringOption("database");
                                                                                        OPatchCmdLineParser.Option nonrolling = parser.addBooleanOption("nonrolling");
                                                                                        OPatchCmdLineParser.Option interactive = parser.addBooleanOption("interactive");
                                                                                        OPatchCmdLineParser.Option reboot = parser.addBooleanOption("reboot");
                                                                                        OPatchCmdLineParser.Option embedded = parser.addStringOption("embedded");
                                                                                        OPatchCmdLineParser.Option errorOnConflict = parser.addBooleanOption("error_on_conflict");
                                                                                        OPatchCmdLineParser.Option ignoreConflict = parser.addBooleanOption("emsc");
                                                                                        OPatchCmdLineParser.Option noSuperset = parser.addBooleanOption("no_bug_superset");
                                                                                        skipSubset = parser.addBooleanOption("skip_subset");
                                                                                        skipDuplicate = parser.addBooleanOption("skip_duplicate");
                                                                                        OPatchCmdLineParser.Option ignoreMissingComp = parser.addBooleanOption("emsm");
                                                                                        OPatchCmdLineParser.Option groupByDate = parser.addBooleanOption("group_by_date");
                                                                                        localNode = parser.addStringOption("local_node");
                                                                                        remoteNodes = parser.addStringOption("remote_nodes");
                                                                                        suppliedNodes = parser.addStringOption("supplied_nodes");
                                                                                        cfs = parser.addBooleanOption("cfs");
                                                                                        OPatchCmdLineParser.Option createRacFile = parser.addBooleanOption("createracFile");
                                                                                        OPatchCmdLineParser.Option patchChecksum = parser.addBooleanOption("patch_checksum");
                                                                                        OPatchCmdLineParser.Option ocmrf = parser.addStringOption("ocmrf");
                                                                                        OPatchCmdLineParser.Option propertyFile = parser.addStringOption("property_file");
                                                                                        idFile = parser.addStringOption("idfile");
                                                                                        connStr = parser.addStringOption("connectstring");
                                                                                        runSql = parser.addBooleanOption("runsql");
                                                                                        OPatchCmdLineParser.Option sortByBugsFixed = parser.addStringOption("bugs_fixed");
                                                                                        sqlScript = parser.addStringOption("sqlscript");
                                                                                        OPatchCmdLineParser.Option ptlSchema = parser.addStringOption("ptlschema");
                                                                                        OPatchCmdLineParser.Option ptlPassword = parser.addStringOption("ptlp2");
                                                                                        OPatchCmdLineParser.Option ptlConnect = parser.addStringOption("ptlconnect");
                                                                                        sid = parser.addStringOption("sid");
                                                                                        OPatchCmdLineParser.Option isRollingPatch = parser.addBooleanOption("is_rolling_patch");
                                                                                        OPatchCmdLineParser.Option isPortalPatch = parser.addBooleanOption("is_portal_patch");
                                                                                        OPatchCmdLineParser.Option isSqlAction = parser.addBooleanOption("has_sql");
                                                                                        OPatchCmdLineParser.Option isOnlinePatch = parser.addBooleanOption("is_online_patch");
                                                                                        OPatchCmdLineParser.Option online = parser.addBooleanOption("online");
                                                                                        OPatchCmdLineParser.Option isAutoPatch = parser.addBooleanOption("is_auto_patch");
                                                                                        OPatchCmdLineParser.Option isTranslatablePatch = parser.addBooleanOption("is_translatable_patch");
                                                                                        OPatchCmdLineParser.Option isProductFamily = parser.addBooleanOption("get_product_family");
                                                                                        OPatchCmdLineParser.Option isPatchModel = parser.addBooleanOption("get_patching_model");
                                                                                        OPatchCmdLineParser.Option isPatchLanguage = parser.addBooleanOption("get_patch_language");
                                                                                        OPatchCmdLineParser.Option isBaseBug = parser.addBooleanOption("get_base_bug");
                                                                                        OPatchCmdLineParser.Option isDate = parser.addBooleanOption("get_date");
                                                                                        OPatchCmdLineParser.Option isComponent = parser.addBooleanOption("get_component");
                                                                                        OPatchCmdLineParser.Option isOs = parser.addBooleanOption("get_os");
                                                                                        OPatchCmdLineParser.Option isPatchType = parser.addBooleanOption("get_patch_type");
                                                                                        OPatchCmdLineParser.Option isSqlPatch = parser.addBooleanOption("is_sql_patch");
                                                                                        OPatchCmdLineParser.Option isFMWRollingPatch = parser.addBooleanOption("is_fmw_rolling_patch");
                                                                                        OPatchCmdLineParser.Option isFMWFeatureBearingPatch = parser.addBooleanOption("is_feature_bearing_patch");
                                                                                        OPatchCmdLineParser.Option isEngSystemPatch = parser.addBooleanOption("is_system_patch");
                                                                                        OPatchCmdLineParser.Option ouiLoc = parser.addStringOption("oui_loc");
                                                                                        OPatchCmdLineParser.Option updateComponent = parser.addStringOption("component");
                                                                                        OPatchCmdLineParser.Option updateVersion = parser.addStringOption("version");
                                                                                        lsp_bugs = parser.addBooleanOption("bugs");
                                                                                        lsp_verify = parser.addBooleanOption("verify");
                                                                                        lsp_required = parser.addBooleanOption("required");
                                                                                        lsp_qfile = parser.addStringOption("qfile");
                                                                                        all_subpatches = parser.addBooleanOption("all_subpatches");
                                                                                        OPatchCmdLineParser.Option prereq_result = parser.addStringOption("prereq_result");
                                                                                        String ohJavaPropertyOption = "OPatch.ORACLE_HOME";
                                                                                        Properties sysProps = System.getProperties();
                                                                                        String OH = sysProps.getProperty(ohJavaPropertyOption);
                                                                                        OPatchCmdLineParser.Option swLibrary = parser.addStringOption("swlib");
                                                                                        viewId = parser.addStringOption("view_id");
                                                                                        viewDir = parser.addStringOption("view_dir");
                                                                                        tagId = parser.addStringOption("tag_id");
                                                                                        OPatchCmdLineParser.Option pruneSpace = parser.addBooleanOption("prune_space");
                                                                                        OPatchCmdLineParser.Option maxMem = parser.addStringOption("max_mem");
                                                                                        arg = args[0];
                                                                                        dbuff = new StringBuffer("Argument is \"");
                                                                                        dbuff.append(arg).append("\"");
                                                                                        OLogger.debug(dbuff);
                                                                                        boolean isObrepo = Boolean.parseBoolean(System.getProperties().getProperty("OPatch.OBREPO"));
                                                                                        if (OUSession.checkMethod(arg) && !isObrepo) {
                                                                                            switchToUtil = true;
                                                                                        }
                                                                                        printCommands = new Vector<String>();
                                                                                        supportedCommands = new Vector<String>();
                                                                                        InputStream is = null;
                                                                                        is = OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS) && isObrepo ? new CmdLineParser().getClass().getResourceAsStream("support_obrepo_cmds.txt") : new CmdLineParser().getClass().getResourceAsStream("support_opatch_cmds.txt");
                                                                                        BufferedReader br = new BufferedReader(new InputStreamReader(is));
                                                                                        String thisLine = "";
                                                                                        try {
                                                                                            int k2;
                                                                                            OLogger.debug(new StringBuffer(" Add commands for Help"));
                                                                                            while ((thisLine = br.readLine()) != null) {
                                                                                                printCommands.add(thisLine);
                                                                                                OLogger.debug(new StringBuffer(" add command \"" + thisLine + "\""));
                                                                                            }
                                                                                            OLogger.debug(new StringBuffer(" Add supported commands for validation"));
                                                                                            if (!isObrepo) {
                                                                                                for (k2 = 0; k2 < OPatchVersionSpecific.AVAILABLE_MAIN_CMDS.length; ++k2) {
                                                                                                    supportedCommands.add(OPatchVersionSpecific.AVAILABLE_MAIN_CMDS[k2]);
                                                                                                    OLogger.debug(new StringBuffer(" add command \"" + OPatchVersionSpecific.AVAILABLE_MAIN_CMDS[k2] + "\""));
                                                                                                }
                                                                                            }
                                                                                            if (OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS) && isObrepo) {
                                                                                                for (k2 = 0; k2 < OPatchVersionSpecific.AVAILABLE_ZDT_CMDS.length; ++k2) {
                                                                                                    supportedCommands.add(OPatchVersionSpecific.AVAILABLE_ZDT_CMDS[k2]);
                                                                                                    OLogger.debug(new StringBuffer(" add zdt command \"" + OPatchVersionSpecific.AVAILABLE_ZDT_CMDS[k2] + "\""));
                                                                                                }
                                                                                            }
                                                                                            if (OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
                                                                                                supportedCommands.add("checkintegrity");
                                                                                                supportedCommands.add("restoreintegrity");
                                                                                            }
                                                                                            supportedCommands.add("-help");
                                                                                            supportedCommands.add("-h");
                                                                                            if (!isObrepo) {
                                                                                                supportedCommands.add("-fmw");
                                                                                            }
                                                                                        }
                                                                                        catch (Exception k3) {
                                                                                            // empty catch block
                                                                                        }
                                                                                        boolean bl = notUtil = !switchToUtil;
                                                                                        if (arg.toLowerCase().equals("iscasrepospresent")) {
                                                                                            arg = arg.toLowerCase();
                                                                                        }
                                                                                        boolean bl2 = notSupportedCommand = !supportedCommands.contains(arg);
                                                                                        if (notUtil) {
                                                                                            dbuff = new StringBuffer(" Not a command that can be mapped to Util Session.");
                                                                                            OLogger.debug(dbuff);
                                                                                        }
                                                                                        if (notSupportedCommand) {
                                                                                            dbuff = new StringBuffer(" This command is not supported.");
                                                                                            OLogger.debug(dbuff);
                                                                                        }
                                                                                        if (notUtil && notSupportedCommand) {
                                                                                            StringBuffer errMsg = new StringBuffer("Unrecognized Command or Option");
                                                                                            errMsg.append(" (").append(arg).append(")");
                                                                                            errMsg.append(": 1st argument must be one of the following:\n");
                                                                                            Enumeration eOPatchCmds = printCommands.elements();
                                                                                            while (true) {
                                                                                                if (!eOPatchCmds.hasMoreElements()) {
                                                                                                    OPatchEnv.setSyntaxError(true, errMsg.toString());
                                                                                                    return null;
                                                                                                }
                                                                                                errMsg.append("   ").append(eOPatchCmds.nextElement()).append("\n");
                                                                                            }
                                                                                        }
                                                                                        if (arg.equals("-fmw")) {
                                                                                            OPatchEnv.setSessionType("fmw");
                                                                                        } else if (arg.equals("-help") || arg.equals("-h")) {
                                                                                            OPatchEnv.setSessionType("help");
                                                                                        } else if (switchToUtil) {
                                                                                            OPatchEnv.setSessionType("util");
                                                                                        } else {
                                                                                            OPatchEnv.setSessionType(arg);
                                                                                        }
                                                                                        CmdLineParser.initRuntimeOptions(parser);
                                                                                        try {
                                                                                            parser.parse(args);
                                                                                        }
                                                                                        catch (OPatchCmdLineParser.OptionException e2) {
                                                                                            StringBuffer errMsg = new StringBuffer("Unrecognized Command or Option");
                                                                                            errMsg.append(": failed to parse arguments \"");
                                                                                            errMsg.append(e2.getMessage());
                                                                                            errMsg.append("\"");
                                                                                            OPatchEnv.setSyntaxError(true, errMsg.toString());
                                                                                            return null;
                                                                                        }
                                                                                        debugStr = sysProps.getProperty("OPatch.DEBUG");
                                                                                        if (parser.getOptionValue(isPatchsetUpdate) != null) {
                                                                                            OPatchEnv.setPatchsetUpdate(true);
                                                                                            OPatchEnv.queryAll(false);
                                                                                        }
                                                                                        if (parser.getOptionValue(isUpdateComponents) != null) {
                                                                                            OPatchEnv.setUpdateComponent(true);
                                                                                            OPatchEnv.queryAll(false);
                                                                                        }
                                                                                        if (parser.getOptionValue(isRollingPatch) != null) {
                                                                                            OPatchEnv.showRollingPatch(true);
                                                                                            OPatchEnv.queryAll(false);
                                                                                        }
                                                                                        if (parser.getOptionValue(isPortalPatch) != null) {
                                                                                            OPatchEnv.showPortalPatch(true);
                                                                                            OPatchEnv.queryAll(false);
                                                                                        }
                                                                                        if (parser.getOptionValue(isOnlinePatch) != null) {
                                                                                            OPatchEnv.setOnline(true);
                                                                                            OPatchEnv.showOnlinePatch(true);
                                                                                            OPatchEnv.queryAll(false);
                                                                                        }
                                                                                        if (parser.getOptionValue(online) != null) {
                                                                                            OPatchEnv.setOnline(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(isComponent) != null) {
                                                                                            OPatchEnv.showComponent(true);
                                                                                            OPatchEnv.queryAll(false);
                                                                                        }
                                                                                        if (parser.getOptionValue(isBaseBug) != null) {
                                                                                            OPatchEnv.showBaseBug(true);
                                                                                            OPatchEnv.queryAll(false);
                                                                                        }
                                                                                        if (parser.getOptionValue(isAutoPatch) != null) {
                                                                                            OPatchEnv.setAutoPatch(true);
                                                                                            OPatchEnv.queryAll(false);
                                                                                        }
                                                                                        if (parser.getOptionValue(isPatchModel) != null) {
                                                                                            OPatchEnv.setPatchModel(true);
                                                                                            OPatchEnv.queryAll(false);
                                                                                        }
                                                                                        if (parser.getOptionValue(isTranslatablePatch) != null) {
                                                                                            OPatchEnv.setTranslatablePatch(true);
                                                                                            OPatchEnv.queryAll(false);
                                                                                        }
                                                                                        if (parser.getOptionValue(isPatchLanguage) != null) {
                                                                                            OPatchEnv.setPatchLanguage(true);
                                                                                            OPatchEnv.queryAll(false);
                                                                                        }
                                                                                        if (parser.getOptionValue(isOs) != null) {
                                                                                            OPatchEnv.showOS(true);
                                                                                            OPatchEnv.queryAll(false);
                                                                                        }
                                                                                        if (parser.getOptionValue(isSqlPatch) != null) {
                                                                                            OPatchEnv.showSqlPatch(true);
                                                                                            OPatchEnv.queryAll(false);
                                                                                        }
                                                                                        if (parser.getOptionValue(isFMWRollingPatch) != null) {
                                                                                            OPatchEnv.showFMWRollingPatch(true);
                                                                                            OPatchEnv.queryAll(false);
                                                                                        }
                                                                                        if (parser.getOptionValue(isFMWFeatureBearingPatch) != null) {
                                                                                            OPatchEnv.showFMWFeatureBearingPatch(true);
                                                                                            OPatchEnv.queryAll(false);
                                                                                        }
                                                                                        if (parser.getOptionValue(isPatchType) != null) {
                                                                                            OPatchEnv.showPatchType(true);
                                                                                            OPatchEnv.queryAll(false);
                                                                                        }
                                                                                        if (parser.getOptionValue(isEngSystemPatch) != null) {
                                                                                            OPatchEnv.showEngSystemPatch(true);
                                                                                            OPatchEnv.queryAll(false);
                                                                                        }
                                                                                        if (parser.getOptionValue(isProductFamily) != null) {
                                                                                            OPatchEnv.showProductFamily(true);
                                                                                            OPatchEnv.queryAll(false);
                                                                                        }
                                                                                        if (parser.getOptionValue(isDate) != null) {
                                                                                            OPatchEnv.showDate(true);
                                                                                            OPatchEnv.queryAll(false);
                                                                                        }
                                                                                        if (parser.getOptionValue(isSqlAction) != null) {
                                                                                            OPatchEnv.showSqlPresence(true);
                                                                                            OPatchEnv.queryAll(false);
                                                                                        }
                                                                                        if (parser.getOptionValue(query_all) != null) {
                                                                                            OPatchEnv.queryAll(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(patchChecksum) != null) {
                                                                                            OPatchEnv.setPatchChecksum(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(sortByBugsFixed) != null) {
                                                                                            String sortOption = (String)parser.getOptionValue(sortByBugsFixed);
                                                                                            OPatchEnv.setSortByBugsFixed(true);
                                                                                            OPatchEnv.setLsinv_bug_order(sortOption);
                                                                                        }
                                                                                        if (parser.getOptionValue(help) != null) {
                                                                                            OPatchEnv.setHelp(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(helpShort) != null) {
                                                                                            OPatchEnv.setHelp(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(trans_patch) != null) {
                                                                                            OPatchEnv.setTransPatch(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(fmwHelpOption) != null) {
                                                                                            if (!OPatchEnv.getSessionType().equals("fmw")) {
                                                                                                if (parser.getOptionValue(help) == null && parser.getOptionValue(helpShort) == null) {
                                                                                                    OPatchEnv.setArgumentError(true, "'fmw' option can be given only with 'help' (or) 'h' option.");
                                                                                                    return null;
                                                                                                }
                                                                                                OPatchEnv.setFmwHelp(true);
                                                                                            } else {
                                                                                                OPatchEnv.setFmwHelp(true);
                                                                                            }
                                                                                        }
                                                                                        if ((debugStr == null || debugStr.compareToIgnoreCase("true") != 0) && parser.getOptionValue(verbose) != null) {
                                                                                            OPatchEnv.setVerbose(true);
                                                                                            try {
                                                                                                OPatchACL.invokeOLogger(new CmdLineParser(), "setLogLevel", new Object[]{OLogger.FINE});
                                                                                                OPatchACL.invokeOLogger(new CmdLineParser(), "setLogFileLevel", new Object[]{OLogger.FINE});
                                                                                            }
                                                                                            catch (IllegalAccessException e3) {
                                                                                                RuntimeException rt = new RuntimeException(e3.getMessage());
                                                                                                rt.setStackTrace(e3.getStackTrace());
                                                                                                throw rt;
                                                                                            }
                                                                                        }
                                                                                        if (parser.getOptionValue(updateComponent) != null) {
                                                                                            OPatchEnv.setUpdateComponent((String)parser.getOptionValue(updateComponent));
                                                                                        }
                                                                                        if (parser.getOptionValue(updateVersion) != null) {
                                                                                            OPatchEnv.setUpdateVersion((String)parser.getOptionValue(updateVersion));
                                                                                        }
                                                                                        if (parser.getOptionValue(isAuto) != null) {
                                                                                            if (!(debugStr != null && debugStr.compareToIgnoreCase("true") == 0 || OPatchEnv.isVerbose())) {
                                                                                                try {
                                                                                                    OPatchACL.invokeOLogger(new CmdLineParser(), "setLogLevel", new Object[]{OLogger.CONFIG});
                                                                                                    OPatchACL.invokeOLogger(new CmdLineParser(), "setLogFileLevel", new Object[]{OLogger.CONFIG});
                                                                                                }
                                                                                                catch (IllegalAccessException e4) {
                                                                                                    RuntimeException rt = new RuntimeException(e4.getMessage());
                                                                                                    rt.setStackTrace(e4.getStackTrace());
                                                                                                    throw rt;
                                                                                                }
                                                                                            }
                                                                                            OPatchEnv.setAutoMode();
                                                                                        }
                                                                                        if (parser.getOptionValue(version) != null) {
                                                                                            String uVersion = (String)parser.getOptionValue(version);
                                                                                            OPatchEnv.setUserInputVersion(uVersion);
                                                                                        }
                                                                                        if (parser.getOptionValue(domainDir) != null) {
                                                                                            String correctDomainDir = (String)parser.getOptionValue(domainDir);
                                                                                            f2 = new File(correctDomainDir);
                                                                                            if (f2.exists() && f2.isDirectory()) {
                                                                                                try {
                                                                                                    correctDomainDir = f2.getCanonicalPath();
                                                                                                }
                                                                                                catch (IOException ioe) {
                                                                                                    dbuff = new StringBuffer("Exception while getting canonical Domain dir ");
                                                                                                    OLogger.debug(dbuff.append(ioe));
                                                                                                    correctDomainDir = (String)parser.getOptionValue(domainDir);
                                                                                                }
                                                                                                OPatchEnv.setFMWDomainDir(correctDomainDir);
                                                                                            } else {
                                                                                                OPatchEnv.setArgumentError(true, "Please specify a valid domain directory. The given directory \"" + correctDomainDir + "\" is invalid.");
                                                                                                return null;
                                                                                            }
                                                                                        }
                                                                                        if (parser.getOptionValue(customLogDir) != null) {
                                                                                            String custLogDirVal = (String)parser.getOptionValue(customLogDir);
                                                                                            f2 = new File(custLogDirVal);
                                                                                            if (f2.exists() && f2.isDirectory()) {
                                                                                                OPatchEnv.setCustomLogDir(f2.getAbsolutePath());
                                                                                            } else {
                                                                                                OPatchEnv.setArgumentError(true, "Please Specify a valid custom log directory. The given directory \"" + custLogDirVal + "\" is invalid.");
                                                                                                return null;
                                                                                            }
                                                                                        }
                                                                                        if (parser.getOptionValue(swLibrary) != null) {
                                                                                            String swLibraryVal = (String)parser.getOptionValue(swLibrary);
                                                                                            f2 = new File(swLibraryVal);
                                                                                            if (f2.exists() && f2.isDirectory() && f2.canRead()) {
                                                                                                OPatchEnv.setSwLibraryDir(f2.getAbsolutePath());
                                                                                            } else {
                                                                                                OPatchEnv.setArgumentError(true, "Please Specify a valid software library directory. The given directory \"" + swLibraryVal + "\" is invalid.");
                                                                                                return null;
                                                                                            }
                                                                                        }
                                                                                        if (parser.getOptionValue(viewId) != null) {
                                                                                            String viewIdVal = (String)parser.getOptionValue(viewId);
                                                                                            OPatchEnv.setCasViewId(viewIdVal);
                                                                                        }
                                                                                        if (parser.getOptionValue(viewDir) != null) {
                                                                                            String viewPathVal = (String)parser.getOptionValue(viewDir);
                                                                                            OPatchEnv.setCasViewPath(viewPathVal);
                                                                                        }
                                                                                        if (parser.getOptionValue(tagId) != null) {
                                                                                            String tagIdVal = (String)parser.getOptionValue(tagId);
                                                                                            OPatchEnv.setCasTagId(tagIdVal);
                                                                                        }
                                                                                        if (parser.getOptionValue(pruneSpace) != null) {
                                                                                            OPatchEnv.setPruneSpace(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(maxMem) != null) {
                                                                                            String maxMemVal = (String)parser.getOptionValue(maxMem);
                                                                                            OPatchEnv.setMaxMem(maxMemVal);
                                                                                        }
                                                                                        if (parser.getOptionValue(baseconfigPlan) != null) {
                                                                                            OPatchEnv.setBaseConfigPlan(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(mw_home) != null) {
                                                                                            mwHome = (String)parser.getOptionValue(mw_home);
                                                                                            OPatchEnv.setCmdMiddlewareHome(mwHome);
                                                                                            OPatchEnv.setBeaHome(true);
                                                                                        } else if (OPS.INSTANCE.getSupportServices().isSupport(Feature.OUI_BASED)) {
                                                                                            mwHome = OUIReplacer.getEnv("MW_HOME");
                                                                                            if (mwHome != null && !mwHome.equals("")) {
                                                                                                OPatchEnv.setEnvMiddlewareHome(mwHome);
                                                                                            }
                                                                                            if (mwHome == null || mwHome.equals("")) {
                                                                                                mwHome = sysProps.getProperty("OPatch.MW_HOME");
                                                                                            }
                                                                                            if (mwHome != null && !mwHome.equals("")) {
                                                                                                OPatchEnv.setBeaHome(true);
                                                                                            }
                                                                                        }
                                                                                        if (OPatchEnv.isBeaHome()) {
                                                                                            String wlsHome = sysProps.getProperty("OPatch.WL_HOME");
                                                                                            if (wlsHome == null) {
                                                                                                wlsHome = "";
                                                                                            }
                                                                                            OPatchEnv.setWlsHome(wlsHome);
                                                                                        }
                                                                                        if (parser.getOptionValue(profile_mask) != null) {
                                                                                            OPatchEnv.setProfileMask((String)parser.getOptionValue(profile_mask));
                                                                                        }
                                                                                        if (parser.getOptionValue(targetList) != null) {
                                                                                            String tl = (String)parser.getOptionValue(targetList);
                                                                                            StringTokenizer tk2 = new StringTokenizer(tl, ",");
                                                                                            HashSet<String> mstargets = new HashSet<String>();
                                                                                            i3 = 0;
                                                                                            while (tk2.hasMoreTokens()) {
                                                                                                String target_elem = tk2.nextToken();
                                                                                                mstargets.add(target_elem);
                                                                                                ++i3;
                                                                                            }
                                                                                            OPatchEnv.setFMWTargetList(mstargets);
                                                                                        }
                                                                                        if (parser.getOptionValue(cmdTargetType) != null) {
                                                                                            String targetType = (String)parser.getOptionValue(cmdTargetType);
                                                                                            if (!targetType.equalsIgnoreCase("fmwServer")) {
                                                                                                StringBuffer ebuff = new StringBuffer("\nThe value \"" + targetType + "\" specified for the \"target_type\" option is not valid. Please check the command help for a list of valid values.\n");
                                                                                                OPatchEnv.setArgumentError(true, ebuff.toString());
                                                                                                return null;
                                                                                            }
                                                                                            OPatchEnv.setFMWCmdTargetType(targetType);
                                                                                        } else {
                                                                                            OPatchEnv.setFMWCmdTargetType("fmwServer");
                                                                                        }
                                                                                        if (parser.getOptionValue(compositeName) != null) {
                                                                                            OPatchEnv.setFMWCompositeName((String)parser.getOptionValue(compositeName));
                                                                                        }
                                                                                        if (parser.getOptionValue(compositeRev) != null) {
                                                                                            OPatchEnv.setFMWCompositeRevision((String)parser.getOptionValue(compositeRev));
                                                                                        }
                                                                                        if (parser.getOptionValue(domainname) != null) {
                                                                                            OPatchEnv.setFMWDomainName((String)parser.getOptionValue(domainname));
                                                                                        }
                                                                                        if (parser.getOptionValue(cfgFile) != null) {
                                                                                            OPatchEnv.setConfigFile((String)parser.getOptionValue(cfgFile));
                                                                                        }
                                                                                        if (parser.getOptionValue(idFile) != null) {
                                                                                            StringBuffer buff;
                                                                                            String idFileLoc;
                                                                                            String copyIdFileAbsLoc = idFileLoc = (String)parser.getOptionValue(idFile);
                                                                                            File idFileObj = new File(idFileLoc);
                                                                                            if (idFileObj == null) {
                                                                                                buff = new StringBuffer("\nThe file location of option \"" + idFile + "\"  is invalid.\n");
                                                                                                OPatchEnv.setArgumentError(true, buff.toString());
                                                                                                return null;
                                                                                            }
                                                                                            if (!idFileObj.exists() || !idFileObj.canRead()) {
                                                                                                buff = new StringBuffer("\nThe file location of option \"" + idFile + "\"  does not exist or is not readable.\n");
                                                                                                OPatchEnv.setArgumentError(true, buff.toString());
                                                                                                return null;
                                                                                            }
                                                                                            if (idFileObj.isDirectory()) {
                                                                                                buff = new StringBuffer("\nThe input location of option \"" + idFile + "\" is a directory. Please specify a file with\n");
                                                                                                buff.append("absolute path\n");
                                                                                                OPatchEnv.setArgumentError(true, buff.toString());
                                                                                                return null;
                                                                                            }
                                                                                            try {
                                                                                                idFileLoc = idFileObj.getCanonicalPath();
                                                                                            }
                                                                                            catch (Exception e5) {
                                                                                                idFileLoc = copyIdFileAbsLoc;
                                                                                            }
                                                                                            try {
                                                                                                String idFileContent = OPatchSessionHelper.readTextFile(idFileLoc);
                                                                                                String[] rollbackIds = idFileContent.split("[\\s|,]");
                                                                                                ArrayList<String> patchIds2 = new ArrayList<String>();
                                                                                                for (int i5 = 0; i5 < rollbackIds.length; ++i5) {
                                                                                                    String id = rollbackIds[i5].trim();
                                                                                                    if (id == null || id.equals("") || patchIds2.contains(id = id.replaceAll("/", "_"))) continue;
                                                                                                    patchIds2.add(id);
                                                                                                }
                                                                                                String[] pIDs = new String[patchIds2.size()];
                                                                                                patchIds2.toArray(pIDs);
                                                                                                OPatchEnv.setUserSuppliedPatchIDs(pIDs);
                                                                                            }
                                                                                            catch (RuntimeException e6) {
                                                                                                buff = new StringBuffer("\nUnable to parse file \"" + idFileLoc + "\" for rollback ids.\n");
                                                                                                OPatchEnv.setArgumentError(true, buff.toString());
                                                                                                return null;
                                                                                            }
                                                                                        }
                                                                                        if (parser.getOptionValue(ptlSchema) != null) {
                                                                                            OPatchEnv.setPtlSchema((String)parser.getOptionValue(ptlSchema));
                                                                                        }
                                                                                        if (parser.getOptionValue(ptlPassword) != null) {
                                                                                            OPatchEnv.setPtlPassword((String)parser.getOptionValue(ptlPassword));
                                                                                        }
                                                                                        if (parser.getOptionValue(ptlConnect) != null) {
                                                                                            OPatchEnv.setPtlConnect((String)parser.getOptionValue(ptlConnect));
                                                                                        }
                                                                                        if (parser.getOptionValue(silent) != null) {
                                                                                            OPatchEnv.setSilent(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(force) != null) {
                                                                                            OPatchEnv.setForce(true);
                                                                                            OPatchEnv.setForceConflict(true);
                                                                                            OLogger.printlnOnLog("implicitly set '-force_conflict' when '-force' present");
                                                                                        }
                                                                                        if (parser.getOptionValue(forceConflict) != null) {
                                                                                            OPatchEnv.setForceConflict(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(optimize) != null) {
                                                                                            OPatchEnv.setOptimize(true);
                                                                                            OLogger.printlnOnLog("implicitly set '-force_conflict', '-force' when '-optimize' present");
                                                                                        }
                                                                                        if (parser.getOptionValue(autoRollbackSubsets) != null) {
                                                                                            OPatchEnv.setAutoRollbackSubsets(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(phase_one) != null) {
                                                                                            if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
                                                                                                OPatchEnv.setArgumentError(true, "The given two-phase option is invalid in the environment that is not CAS-enabled.");
                                                                                                return null;
                                                                                            }
                                                                                            OPatchEnv.setCASPhase1();
                                                                                        }
                                                                                        if (parser.getOptionValue(phase_two) != null) {
                                                                                            if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
                                                                                                OPatchEnv.setArgumentError(true, "The given two-phase option is invalid in the environment that is not CAS-enabled.");
                                                                                                return null;
                                                                                            }
                                                                                            OPatchEnv.setCASPhase2();
                                                                                        }
                                                                                        if (parser.getOptionValue(scriptsenabledforopatchovercas) != null) {
                                                                                            if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
                                                                                                OPatchEnv.setArgumentError(true, "The given two-phase option is invalid in the environment that is not CAS-enabled.");
                                                                                                return null;
                                                                                            }
                                                                                            OPatchEnv.setScriptsEnabledforCAS(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(local) != null) {
                                                                                            OPatchEnv.setLocal(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(minimize_downtime) != null) {
                                                                                            OPatchEnv.setMinDowntime(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(all_node) != null) {
                                                                                            OPatchEnv.setAllNode(true);
                                                                                        } else {
                                                                                            OPatchEnv.setLocal(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(nolink) != null) {
                                                                                            OPatchEnv.setNolink(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(nopatchgen) != null) {
                                                                                            OPatchEnv.setNoPatchgen(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(version_all) != null) {
                                                                                            OPatchEnv.setVersionAll(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(version_v2c) != null) {
                                                                                            String v2cStr = (String)parser.getOptionValue(version_v2c);
                                                                                            String[] v2cNumberStrs = new String[]{};
                                                                                            v2cNumberStrs = v2cStr.split("\\.");
                                                                                            if (v2cNumberStrs.length > 5) {
                                                                                                OPatchEnv.setArgumentError(true, "Please specify a valid version. The given version " + v2cStr + " is invalid.");
                                                                                                return null;
                                                                                            }
                                                                                            for (int i6 = 0; i6 < v2cNumberStrs.length; ++i6) {
                                                                                                try {
                                                                                                    Integer.parseInt(v2cNumberStrs[i6]);
                                                                                                    continue;
                                                                                                }
                                                                                                catch (NumberFormatException e7) {
                                                                                                    OPatchEnv.setArgumentError(true, "Please specify a valid version. The given version " + v2cStr + " is invalid.");
                                                                                                    return null;
                                                                                                }
                                                                                            }
                                                                                            OPatchEnv.setVersionV2c(v2cStr);
                                                                                        }
                                                                                        if (parser.getOptionValue(version_ohs) != null) {
                                                                                            String ohsStr = (String)parser.getOptionValue(version_ohs);
                                                                                            String[] oracleHomeStrs = new String[]{};
                                                                                            oracleHomeStrs = ohsStr.split(",");
                                                                                            String[] trimHomes = new String[oracleHomeStrs.length];
                                                                                            for (i3 = 0; i3 < oracleHomeStrs.length; ++i3) {
                                                                                                trimHomes[i3] = oracleHomeStrs[i3].trim();
                                                                                            }
                                                                                            OPatchEnv.setVersionOhs(trimHomes);
                                                                                        }
                                                                                        if (parser.getOptionValue(lsinv_all) != null && (parser.getOptionValue(lsinv_detail) != null || parser.getOptionValue(lsinv_details) != null)) {
                                                                                            String varMsg = "";
                                                                                            if (parser.getOptionValue(lsinv_detail) != null && parser.getOptionValue(lsinv_details) != null) {
                                                                                                varMsg = "detail details";
                                                                                            } else if (parser.getOptionValue(lsinv_detail) != null) {
                                                                                                varMsg = "detail";
                                                                                            } else if (parser.getOptionValue(lsinv_details) != null) {
                                                                                                varMsg = "details";
                                                                                            }
                                                                                            String errorMsg = OLogger.getString("OUI-67222", new Object[]{"all", varMsg});
                                                                                            OPatchEnv.setSyntaxError(true, errorMsg);
                                                                                            return null;
                                                                                        }
                                                                                        if (parser.getOptionValue(lsinv_all) != null) {
                                                                                            OPatchEnv.setLsinv_all(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(util_all) != null) {
                                                                                            OPatchEnv.setUtil_all(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(lsinv_detail) != null || parser.getOptionValue(lsinv_details) != null) {
                                                                                            if (parser.getOptionValue(lsinv_detail) != null && parser.getOptionValue(lsinv_details) != null) {
                                                                                                String errorMsg = OLogger.getString("OUI-67222", new Object[]{"detail", "details"});
                                                                                                OPatchEnv.setSyntaxError(true, errorMsg);
                                                                                                return null;
                                                                                            }
                                                                                            OPatchEnv.setLsinv_detail(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(lsinv_xml) != null) {
                                                                                            String fileLoc = (String)parser.getOptionValue(lsinv_xml);
                                                                                            if (!OPatchEnv.isHelp()) {
                                                                                                String[] fileNames2 = parser.getRemainingArgs();
                                                                                                if (fileNames2.length != 1) {
                                                                                                    OPatchEnv.setArgumentError(true, "-xml option must be followed by one xml filename.");
                                                                                                    return null;
                                                                                                }
                                                                                                if (fileLoc.equals("-help") || fileLoc.equals("-h")) {
                                                                                                    OPatchEnv.setHelp(true);
                                                                                                } else {
                                                                                                    if (!fileLoc.endsWith(".xml")) {
                                                                                                        OPatchEnv.setArgumentError(true, "In 'opatch lsinv -xml <xmlFile>', the -xml option must be followed by a .xml file.");
                                                                                                        return null;
                                                                                                    }
                                                                                                    File file = new File(fileLoc);
                                                                                                    if (file.exists() && !file.isDirectory()) {
                                                                                                        if (!OPatchEnv.isForce()) {
                                                                                                            StringBuffer buff = new StringBuffer("Cannot use file \"");
                                                                                                            buff.append(fileLoc);
                                                                                                            buff.append("\" to generate XML output.\n");
                                                                                                            buff.append("Specify path/filename ");
                                                                                                            buff.append("and make sure filename doesn't exist.");
                                                                                                            OPatchEnv.setArgumentError(true, buff.toString());
                                                                                                            return null;
                                                                                                        }
                                                                                                        StringBuffer buff = new StringBuffer("File \"");
                                                                                                        buff.append(fileLoc);
                                                                                                        buff.append("\" exists.  OPatch will over-write existing content.");
                                                                                                        OLogger.println(buff.toString());
                                                                                                    } else if (file.exists() && file.isDirectory()) {
                                                                                                        StringBuffer buff = new StringBuffer("Cannot use directory \"");
                                                                                                        buff.append(fileLoc);
                                                                                                        buff.append("\" to generate XML output.\n");
                                                                                                        buff.append("Specify both path/filename and ");
                                                                                                        buff.append("make sure filename doesn't exist.");
                                                                                                        OPatchEnv.setArgumentError(true, buff.toString());
                                                                                                        return null;
                                                                                                    }
                                                                                                    OPatchEnv.setLsinv_xml(true);
                                                                                                    OPatchEnv.setLsinv_xml_loc(fileLoc);
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                        if ((fileNames = parser.getRemainingArgs()) != null && fileNames.length > 0 && fileNames[0].equals("compare")) {
                                                                                            OPatchEnv.setXMLCompare(true);
                                                                                            if (OPatchEnv.isHelp()) {
                                                                                                OPatchEnv.setSessionType("compare");
                                                                                            }
                                                                                            if (parser.getRemainingArgs().length == 3) {
                                                                                                OPatchEnv.setXMLCompare_loc1(fileNames[1]);
                                                                                                OPatchEnv.setXMLCompare_loc2(fileNames[2]);
                                                                                                OPatchEnv.setSessionType("compare");
                                                                                            } else if (!OPatchEnv.isHelp()) {
                                                                                                OPatchEnv.setArgumentError(true, "'opatch compare' must be followed by two xml files generated by 'lsinv -xml' command.");
                                                                                                return null;
                                                                                            }
                                                                                        }
                                                                                        if (parser.getOptionValue(lsinv_patch) != null) {
                                                                                            OPatchEnv.setLsinv_patch(true);
                                                                                            patchSortOption = (String)parser.getOptionValue(lsinv_patch);
                                                                                            OPatchEnv.setLsinv_patch_order(patchSortOption);
                                                                                        }
                                                                                        if (parser.getOptionValue(lsinv_patch_id) != null) {
                                                                                            OPatchEnv.setLsinv_patch_id(true);
                                                                                            patchSortOption = (String)parser.getOptionValue(lsinv_patch_id);
                                                                                            OPatchEnv.setLsinv_patch_id_order(patchSortOption);
                                                                                        }
                                                                                        if (parser.getOptionValue(prereq_result) != null) {
                                                                                            OPatchEnv.setPrereqResult((String)parser.getOptionValue(prereq_result));
                                                                                        }
                                                                                        if (parser.getOptionValue(lsinv_inactive) != null) {
                                                                                            OPatchEnv.setLsinv_inactive(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(lsinv_last_update) != null) {
                                                                                            OPatchEnv.setLsinv_last_update_checked(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(lsinv_match) != null) {
                                                                                            OPatchEnv.setLsInv_match(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(groupByDate) != null) {
                                                                                            OPatchEnv.setGroupByDate(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(norestart) != null) {
                                                                                            OPatchEnv.setNoRestart();
                                                                                        }
                                                                                        if (parser.getOptionValue(generateSteps) != null) {
                                                                                            OPatchEnv.setGenerateSteps(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(nonrolling) != null) {
                                                                                            OPatchEnv.setNonrolling();
                                                                                        }
                                                                                        if (parser.getOptionValue(reboot) != null) {
                                                                                            OPatchEnv.setReboot(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(interactive) != null) {
                                                                                            OPatchEnv.setInteractive();
                                                                                        }
                                                                                        if (parser.getOptionValue(report) != null || parser.getOptionValue(analyze) != null) {
                                                                                            OPatchEnv.setReport(true);
                                                                                            OPatchEnv.setCreateRacFile(false);
                                                                                        } else {
                                                                                            OPatchEnv.setReport(false);
                                                                                        }
                                                                                        if (parser.getOptionValue(createRacFile) != null) {
                                                                                            OPatchEnv.setCreateRacFile(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(noSuperset) != null) {
                                                                                            OPatchEnv.setNoBugSuperset(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(skipSubset) != null) {
                                                                                            OPatchEnv.setSkipSubset(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(skipDuplicate) != null) {
                                                                                            OPatchEnv.setSkipDuplicate(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(ignoreConflict) != null) {
                                                                                            OPatchEnv.setIgnoreConflict(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(ignoreMissingComp) != null) {
                                                                                            OPatchEnv.setIgnoreMissingComponent(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(preoptend) != null) {
                                                                                            // empty if block
                                                                                        }
                                                                                        if (parser.getOptionValue(postoptend) != null) {
                                                                                            // empty if block
                                                                                        }
                                                                                        if (parser.getOptionValue(initoptend) != null) {
                                                                                            // empty if block
                                                                                        }
                                                                                        if (parser.getOptionValue(gi_all) != null) {
                                                                                            OPatchEnv.setGIPatchingAll(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(oracleHome) != null) {
                                                                                            OPatchEnv.setCmdOracleHome((String)parser.getOptionValue(oracleHome));
                                                                                        } else {
                                                                                            try {
                                                                                                String oh = OUIReplacer.getEnv("ORACLE_HOME");
                                                                                                if (oh != null) {
                                                                                                    OPatchEnv.setEnvOracleHome(oh);
                                                                                                }
                                                                                            }
                                                                                            catch (Throwable t) {
                                                                                                StringBuffer tBuff = new StringBuffer("This Oracle Home is not OUI based.");
                                                                                                tBuff.append(" Please use -oh option to specify the oracle home to work on. ");
                                                                                                OLogger.println(tBuff.toString());
                                                                                                OPatchEnv.setArgumentError(true, tBuff.toString());
                                                                                                return null;
                                                                                            }
                                                                                        }
                                                                                        boolean ocmrfSet = false;
                                                                                        if (parser.getOptionValue(ocmrf) != null) {
                                                                                            ocmrfSet = true;
                                                                                            String ocmResp = (String)parser.getOptionValue(ocmrf);
                                                                                            File f3 = new File(ocmResp);
                                                                                            if (f3 == null) {
                                                                                                OPatchEnv.setArgumentError(true, "Given 'ocmrf' string is not recognised as a file.");
                                                                                                return null;
                                                                                            }
                                                                                            String absRespFile = null;
                                                                                            try {
                                                                                                absRespFile = f3.getCanonicalPath();
                                                                                            }
                                                                                            catch (IOException e8) {
                                                                                                StringBuffer errorMessage = new StringBuffer("Unable to get canonical path for the 'ocmrf' file\n");
                                                                                                errorMessage.append(e8.getMessage());
                                                                                                OPatchEnv.setArgumentError(true, errorMessage.toString());
                                                                                                return null;
                                                                                            }
                                                                                            f3 = new File(absRespFile);
                                                                                            if (!f3.exists()) {
                                                                                                OPatchEnv.setArgumentError(true, "Given 'ocmrf' file does not exists.");
                                                                                                return null;
                                                                                            }
                                                                                            if (f3.isDirectory()) {
                                                                                                OPatchEnv.setArgumentError(true, "Given 'ocmrf' file is a directory and not a file.");
                                                                                                return null;
                                                                                            }
                                                                                            OPatchEnv.setOCMResponseFileLoc(absRespFile);
                                                                                        }
                                                                                        if (OPS.INSTANCE.getSupportServices().isSupport(Feature.OUI_BASED)) {
                                                                                            String emdRoot = "";
                                                                                            boolean isOUIOkForEmdRoot = OUIVersion.isOUIGoodForErrEnvVar("10.2.0.4.0");
                                                                                            if (OPatchEnv.isWindows() && !isOUIOkForEmdRoot) {
                                                                                                OLogger.debug(new StringBuffer("Falling back to checking EMDROOT without OUI help..."));
                                                                                                SystemCall.ExecReturn ret = SystemCall.runtimeExec("cmd /C \"echo %EMDROOT%\"");
                                                                                                String retMsg = ret.getNormalMessage();
                                                                                                retMsg = retMsg.trim();
                                                                                                emdRoot = retMsg.equalsIgnoreCase("%EMDROOT%") ? "" : retMsg;
                                                                                            } else {
                                                                                                OLogger.debug(new StringBuffer("Checking EMDROOT using OUI's API..."));
                                                                                                emdRoot = OUIReplacer.getEnv("EMDROOT");
                                                                                            }
                                                                                            if (emdRoot != null && !emdRoot.equals("")) {
                                                                                                OPatchEnv.setEmOcmFlag(true);
                                                                                                if (ocmrfSet) {
                                                                                                    OPatchEnv.setEmOcmFlag(false);
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                        if (parser.getOptionValue(embedded) != null) {
                                                                                            String eCaller = (String)parser.getOptionValue(embedded);
                                                                                            if (eCaller.equalsIgnoreCase("installer")) {
                                                                                                OLogger.println("Embedded caller is installer");
                                                                                                OPatchEnv.setEmOcmFlag(true);
                                                                                            } else if (eCaller.equalsIgnoreCase("em")) {
                                                                                                OLogger.println("Embedded caller is em");
                                                                                                OPatchEnv.setEmOcmFlag(true);
                                                                                            }
                                                                                            if (ocmrfSet) {
                                                                                                OPatchEnv.setEmOcmFlag(false);
                                                                                            }
                                                                                        }
                                                                                        if (parser.getOptionValue(propertyFile) != null) {
                                                                                            try {
                                                                                                OPatchEnv.setPropertyFile((String)parser.getOptionValue(propertyFile));
                                                                                                OPatchProperty dummy = new OPatchProperty();
                                                                                                Properties userProp = dummy.getUserProperty();
                                                                                                Properties bundledProp = dummy.getBundledProperty();
                                                                                                Properties mergedProp = OPatchProperty.mergeProperties(userProp, bundledProp);
                                                                                                OPatchEnv.setOPatchProperties(mergedProp);
                                                                                            }
                                                                                            catch (Exception e9) {
                                                                                                OPatchEnv.setArgumentError(true, e9.getMessage());
                                                                                                return null;
                                                                                            }
                                                                                        }
                                                                                        if (parser.getOptionValue(connStr) != null) {
                                                                                            String s3 = (String)parser.getOptionValue(connStr);
                                                                                            StringTokenizer tk3 = new StringTokenizer(s3, " ,");
                                                                                            int manyConnectionsGiven = tk3.countTokens();
                                                                                            if (manyConnectionsGiven <= 0) {
                                                                                                OPatchEnv.setArgumentError(true, "Empty connect string provided.");
                                                                                                return null;
                                                                                            }
                                                                                            int size = tk3.countTokens();
                                                                                            ArrayList<String> connStrs = new ArrayList<String>();
                                                                                            int i7 = 0;
                                                                                            while (tk3.hasMoreTokens()) {
                                                                                                pID = tk3.nextToken();
                                                                                                if (!connStrs.contains(pID)) {
                                                                                                    connStrs.add(pID);
                                                                                                }
                                                                                                ++i7;
                                                                                            }
                                                                                            String[] sids = new String[connStrs.size()];
                                                                                            dbUserNames = new String[connStrs.size()];
                                                                                            dbPasswords = new String[connStrs.size()];
                                                                                            dbNodes = new String[connStrs.size()];
                                                                                            for (cIter = 0; cIter < connStrs.size(); ++cIter) {
                                                                                                conn = (String)connStrs.get(cIter);
                                                                                                splittedStr = conn.split(":");
                                                                                                if (splittedStr.length == 0) {
                                                                                                    OPatchEnv.setArgumentError(true, "Empty connect string provided.");
                                                                                                    return null;
                                                                                                }
                                                                                                if (splittedStr.length == 1) {
                                                                                                    if ("".equals(splittedStr[0])) {
                                                                                                        OPatchEnv.setArgumentError(true, "Empty SID cannot be a part of connect string.");
                                                                                                        return null;
                                                                                                    }
                                                                                                    sids[cIter] = splittedStr[0];
                                                                                                    dbUserNames[cIter] = "";
                                                                                                    dbPasswords[cIter] = "";
                                                                                                    dbNodes[cIter] = "";
                                                                                                } else if (splittedStr.length == 2) {
                                                                                                    if ("".equals(splittedStr[0])) {
                                                                                                        OPatchEnv.setArgumentError(true, "Empty SID cannot be a part of connect string.");
                                                                                                        return null;
                                                                                                    }
                                                                                                    sids[cIter] = splittedStr[0];
                                                                                                    dbUserNames[cIter] = splittedStr[1];
                                                                                                    dbPasswords[cIter] = "";
                                                                                                    dbNodes[cIter] = "";
                                                                                                } else if (splittedStr.length == 3) {
                                                                                                    if ("".equals(splittedStr[0])) {
                                                                                                        OPatchEnv.setArgumentError(true, "Empty SID cannot be a part of connect string.");
                                                                                                        return null;
                                                                                                    }
                                                                                                    sids[cIter] = splittedStr[0];
                                                                                                    dbUserNames[cIter] = splittedStr[1];
                                                                                                    dbPasswords[cIter] = splittedStr[2];
                                                                                                    dbNodes[cIter] = "";
                                                                                                } else if (splittedStr.length == 4) {
                                                                                                    if ("".equals(splittedStr[0])) {
                                                                                                        OPatchEnv.setArgumentError(true, "Empty SID cannot be a part of connect string.");
                                                                                                        return null;
                                                                                                    }
                                                                                                    sids[cIter] = splittedStr[0];
                                                                                                    dbUserNames[cIter] = splittedStr[1];
                                                                                                    dbPasswords[cIter] = splittedStr[2];
                                                                                                    dbNodes[cIter] = splittedStr[3];
                                                                                                }
                                                                                                if (dbUserNames[cIter].equals("") || !dbPasswords[cIter].equals("")) continue;
                                                                                                OPatchEnv.setArgumentError(true, "Empty password cannot be part of 'connectString' option since username is not empty.");
                                                                                                return null;
                                                                                            }
                                                                                            OPatchEnv.setDBSids(sids);
                                                                                            OPatchEnv.setDBUsers(dbUserNames);
                                                                                            OPatchEnv.setDBPasswds(dbPasswords);
                                                                                            OPatchEnv.setDBNodes(dbNodes);
                                                                                        }
                                                                                        if (parser.getOptionValue(jreLoc) != null) {
                                                                                            OPatchEnv.setJreLoc((String)parser.getOptionValue(jreLoc));
                                                                                            OPatchEnv.setJreOptionSpecified(true);
                                                                                        } else {
                                                                                            StringBuffer tmpB = new StringBuffer(OPatchEnv.getOracleHome());
                                                                                            tmpB.append(File.separator);
                                                                                            tmpB.append(StringResource.JRE_DIRECTORY);
                                                                                            OPatchEnv.setJreLoc(tmpB.toString());
                                                                                        }
                                                                                        if (parser.getOptionValue(jdkLoc) != null) {
                                                                                            String loc = (String)parser.getOptionValue(jdkLoc);
                                                                                            if (!OPatchEnv.isJarCommandAvailable(loc)) {
                                                                                                String msg = OLogger.getString("OUI-67118", new Object[]{loc});
                                                                                                OPatchEnv.setArgumentError(true, msg);
                                                                                                return null;
                                                                                            }
                                                                                            OPatchEnv.setJdkLoc(loc);
                                                                                        } else {
                                                                                            try {
                                                                                                if (OPatchEnv.isBeaHome()) {
                                                                                                    String javaHome = OUIReplacer.getEnv("JAVA_HOME");
                                                                                                    OPatchEnv.setJdkLoc(javaHome);
                                                                                                } else {
                                                                                                    StringBuffer tmpB = new StringBuffer(OPatchEnv.getOracleHome());
                                                                                                    tmpB.append(File.separator);
                                                                                                    tmpB.append("jdk");
                                                                                                    OPatchEnv.setJdkLoc(tmpB.toString());
                                                                                                }
                                                                                            }
                                                                                            catch (Throwable t) {
                                                                                                StringBuffer tBuff = new StringBuffer("This Oracle Home is not OUI based.");
                                                                                                tBuff.append(" Please use -jdk option to specify the java to be used. ");
                                                                                                OLogger.println(tBuff.toString());
                                                                                                OPatchEnv.setArgumentError(true, tBuff.toString());
                                                                                                return null;
                                                                                            }
                                                                                        }
                                                                                        if (parser.getOptionValue(invPtrLoc) != null) {
                                                                                            OPatchEnv.setInvPtrLoc((String)parser.getOptionValue(invPtrLoc));
                                                                                            OPatchEnv.setInvPtrLocSpecified();
                                                                                        }
                                                                                        if (parser.getOptionValue(noPostScriptOpt) != null) {
                                                                                            OPatchEnv.setNoPostScriptOpt(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(noPreScriptOpt) != null) {
                                                                                            OPatchEnv.setNoPreScriptOpt(true);
                                                                                        }
                                                                                        if (parser.getOptionValue(preopt) != null) {
                                                                                            OPatchEnv.setPreopt((String)parser.getOptionValue(preopt));
                                                                                        }
                                                                                        if (parser.getOptionValue(postopt) != null) {
                                                                                            OPatchEnv.setPostopt((String)parser.getOptionValue(postopt));
                                                                                        }
                                                                                        if (parser.getOptionValue(initopt) != null) {
                                                                                            OPatchEnv.setInitopt((String)parser.getOptionValue(initopt));
                                                                                        }
                                                                                        if (parser.getOptionValue(patchid) == null) break block534;
                                                                                        if (arg.equals("napply") && parser.getOptionValue(phase_one) != null) {
                                                                                            OPatchEnv.setSyntaxError(true, "\"-id\" option is invalid with \"napply -phase_one\". Please check the command help for correct format.\n");
                                                                                            return null;
                                                                                        }
                                                                                        pattern = Pattern.compile("[0-9]+(/[a-zA-Z]+(_[a-zA-Z]+)*)?");
                                                                                        s2 = (String)parser.getOptionValue(patchid);
                                                                                        tk = new StringTokenizer(s2, " ,");
                                                                                        int manyPatchesGiven = tk.countTokens();
                                                                                        if (manyPatchesGiven < 1) break block535;
                                                                                        if (manyPatchesGiven != 1) break block536;
                                                                                        if (!OPatchEnv.isOPatchSDKMode()) {
                                                                                            Matcher matcher = pattern.matcher(s2);
                                                                                            if (!s2.startsWith("-") && !matcher.matches()) {
                                                                                                OPatchEnv.setArgumentError(true, "The pattern of the specified patch(es) are not allowed. Please enter valid patch(es).");
                                                                                                return null;
                                                                                            }
                                                                                        }
                                                                                        s2 = s2.replaceAll("/", "_");
                                                                                        OPatchEnv.setRollbackPatchid(s2);
                                                                                        String[] pIDs = new String[]{s2};
                                                                                        OPatchEnv.setUserSuppliedPatchIDs(pIDs);
                                                                                        break block534;
                                                                                    }
                                                                                    if (arg.equals("lspatches")) {
                                                                                        OPatchEnv.setArgumentError(true, "Please provide valid id for command 'lspatches'.");
                                                                                        return null;
                                                                                    }
                                                                                    int size = tk.countTokens();
                                                                                    patchIds = new ArrayList<String>();
                                                                                    i2 = 0;
                                                                                    break block537;
                                                                                }
                                                                                s2 = s2.replaceAll("/", "_");
                                                                                OPatchEnv.setRollbackPatchid(s2);
                                                                                break block534;
                                                                            }
                                                                            while (tk.hasMoreTokens()) {
                                                                                String pID2 = tk.nextToken();
                                                                                if (!OPatchEnv.isOPatchSDKMode()) {
                                                                                    Matcher matcher = pattern.matcher(pID2);
                                                                                    if (!pID2.startsWith("-") && !matcher.matches()) {
                                                                                        OPatchEnv.setArgumentError(true, "The pattern of the specified Patch(es) are not allowed. Please enter valid patch(es).");
                                                                                        return null;
                                                                                    }
                                                                                }
                                                                                if (!patchIds.contains(pID2 = pID2.replaceAll("/", "_"))) {
                                                                                    patchIds.add(pID2);
                                                                                }
                                                                                ++i2;
                                                                            }
                                                                            String[] pIDs = new String[patchIds.size()];
                                                                            patchIds.toArray(pIDs);
                                                                            OPatchEnv.setUserSuppliedPatchIDs(pIDs);
                                                                        }
                                                                        if (parser.getOptionValue(sid) != null) {
                                                                            s = (String)parser.getOptionValue(sid);
                                                                            StringTokenizer tk = new StringTokenizer(s, ",");
                                                                            HashSet<String> sidSet = new HashSet<String>();
                                                                            int i8 = 0;
                                                                            while (tk.hasMoreTokens()) {
                                                                                String sidElement = tk.nextToken();
                                                                                sidSet.add(sidElement);
                                                                                ++i8;
                                                                            }
                                                                            OPatchEnv.setSidInformation(sidSet);
                                                                        }
                                                                        if (parser.getOptionValue(patchloc) != null) {
                                                                            boolean chToPhbasefile;
                                                                            StringTokenizer st = new StringTokenizer((String)parser.getOptionValue(patchloc), ",");
                                                                            ArrayList<String> validPhs = new ArrayList<String>();
                                                                            StringBuffer invalid = new StringBuffer("Following patch location(s) are invalid and will be skipped: \n");
                                                                            int stn = st.countTokens();
                                                                            while (st.hasMoreTokens()) {
                                                                                String curToken = st.nextToken().trim();
                                                                                if (new File(curToken).exists()) {
                                                                                    validPhs.add(curToken);
                                                                                    continue;
                                                                                }
                                                                                invalid.append(curToken + "\n");
                                                                            }
                                                                            String[] validLocs = new String[validPhs.size()];
                                                                            validPhs.toArray(validLocs);
                                                                            boolean bl = chToPhbasefile = arg.equals("prereq") || arg.equals("util") || switchToUtil;
                                                                            if (validLocs.length == 0) {
                                                                                ZOPErrorMessage.printErrorMessage(50);
                                                                                OPatchEnv.setArgumentError(true, "Patch Location not valid");
                                                                                return null;
                                                                            }
                                                                            if (validLocs.length != stn && chToPhbasefile) {
                                                                                OLogger.println(invalid.toString());
                                                                            }
                                                                            if (validLocs.length == 1) {
                                                                                File tmpF = new File(validLocs[0]);
                                                                                try {
                                                                                    OPatchEnv.setPatchloc(tmpF.getCanonicalPath());
                                                                                }
                                                                                catch (IOException e10) {
                                                                                    OPatchEnv.setPatchloc(tmpF.getAbsolutePath());
                                                                                }
                                                                            } else {
                                                                                if (!chToPhbasefile) {
                                                                                    ZOPErrorMessage.printErrorMessage(50);
                                                                                    OPatchEnv.setArgumentError(true, "Patch Location not valid");
                                                                                    return null;
                                                                                }
                                                                                String psDir = OPatchEnv.getPatchStorageDirectoryPath(OPatchEnv.getOracleHome()) + File.separator + "prereq" + "_" + "phbasefile";
                                                                                try {
                                                                                    File basefile = new File(psDir);
                                                                                    if (!basefile.exists()) {
                                                                                        basefile.createNewFile();
                                                                                    }
                                                                                    BufferedWriter bw = new BufferedWriter(new FileWriter(basefile));
                                                                                    for (int i9 = 0; i9 < validLocs.length; ++i9) {
                                                                                        String line = validLocs[i9] + "\n";
                                                                                        bw.write(line, 0, line.length());
                                                                                    }
                                                                                    bw.flush();
                                                                                    bw.close();
                                                                                }
                                                                                catch (IOException e11) {
                                                                                    OPatchEnv.setArgumentError(true, "Can't create base file for incoming mutilple patch locations");
                                                                                    return null;
                                                                                }
                                                                                if (arg.equals("prereq")) {
                                                                                    PQSession.phbasefile(psDir);
                                                                                } else {
                                                                                    OUSession.phbasefile(psDir);
                                                                                }
                                                                            }
                                                                        }
                                                                        if (parser.getOptionValue(delay) != null) {
                                                                            OPatchEnv.setDelay((Integer)parser.getOptionValue(delay));
                                                                        }
                                                                        if (parser.getOptionValue(retry) != null) {
                                                                            OPatchEnv.setRetry((Integer)parser.getOptionValue(retry));
                                                                        }
                                                                        if (parser.getOptionValue(maxLockingWait) != null) {
                                                                            OPatchEnv.setMaxLockingWait((Integer)parser.getOptionValue(maxLockingWait));
                                                                        }
                                                                        if (parser.getOptionValue(cfs) != null) {
                                                                            OPatchEnv.setUserSuppliedCFS(true);
                                                                        }
                                                                        if (parser.getOptionValue(localNode) != null) {
                                                                            s = (String)parser.getOptionValue(localNode);
                                                                            OPatchEnv.setUserSuppliedLocalNode(s);
                                                                        }
                                                                        if (parser.getOptionValue(remoteNodes) != null) {
                                                                            s = (String)parser.getOptionValue(remoteNodes);
                                                                            StringTokenizer tk = new StringTokenizer(s, " ,");
                                                                            int size = tk.countTokens();
                                                                            String[] nodes = new String[size];
                                                                            int i10 = 0;
                                                                            while (tk.hasMoreTokens()) {
                                                                                nodes[i10] = tk.nextToken();
                                                                                ++i10;
                                                                            }
                                                                            OPatchEnv.setUserSuppliedRemoteNodes(nodes);
                                                                        }
                                                                        if (parser.getOptionValue(suppliedNodes) != null) {
                                                                            s = (String)parser.getOptionValue(suppliedNodes);
                                                                            StringTokenizer tk = new StringTokenizer(s, ",");
                                                                            int size = tk.countTokens();
                                                                            String[] nodes = new String[size];
                                                                            int i11 = 0;
                                                                            while (tk.hasMoreTokens()) {
                                                                                nodes[i11] = tk.nextToken().trim();
                                                                                ++i11;
                                                                            }
                                                                            OPatchEnv.setUserSuppliedNodes(nodes);
                                                                        }
                                                                        if (parser.getOptionValue(connStr) != null) {
                                                                            s = (String)parser.getOptionValue(connStr);
                                                                            StringTokenizer tk = new StringTokenizer(s, " ,");
                                                                            int manyConnectionsGiven = tk.countTokens();
                                                                            if (manyConnectionsGiven <= 0) {
                                                                                OPatchEnv.setArgumentError(true, "Empty connect string provided.");
                                                                                return null;
                                                                            }
                                                                            int size = tk.countTokens();
                                                                            ArrayList<String> connStrs = new ArrayList<String>();
                                                                            int i12 = 0;
                                                                            while (tk.hasMoreTokens()) {
                                                                                pID = tk.nextToken();
                                                                                if (!connStrs.contains(pID)) {
                                                                                    connStrs.add(pID);
                                                                                }
                                                                                ++i12;
                                                                            }
                                                                            String[] sids = new String[connStrs.size()];
                                                                            dbUserNames = new String[connStrs.size()];
                                                                            dbPasswords = new String[connStrs.size()];
                                                                            dbNodes = new String[connStrs.size()];
                                                                            for (cIter = 0; cIter < connStrs.size(); ++cIter) {
                                                                                conn = (String)connStrs.get(cIter);
                                                                                splittedStr = conn.split(":");
                                                                                if (splittedStr.length == 0) {
                                                                                    OPatchEnv.setArgumentError(true, "Empty connect string provided.");
                                                                                    return null;
                                                                                }
                                                                                if (splittedStr.length == 1) {
                                                                                    if ("".equals(splittedStr[0])) {
                                                                                        OPatchEnv.setArgumentError(true, "Empty SID cannot be a part of connect string.");
                                                                                        return null;
                                                                                    }
                                                                                    sids[cIter] = splittedStr[0];
                                                                                    dbUserNames[cIter] = "";
                                                                                    dbPasswords[cIter] = "";
                                                                                    dbNodes[cIter] = "";
                                                                                    continue;
                                                                                }
                                                                                if (splittedStr.length == 2) {
                                                                                    if ("".equals(splittedStr[0])) {
                                                                                        OPatchEnv.setArgumentError(true, "Empty SID cannot be a part of connect string.");
                                                                                        return null;
                                                                                    }
                                                                                    sids[cIter] = splittedStr[0];
                                                                                    dbUserNames[cIter] = splittedStr[1];
                                                                                    dbPasswords[cIter] = "";
                                                                                    dbNodes[cIter] = "";
                                                                                    continue;
                                                                                }
                                                                                if (splittedStr.length == 3) {
                                                                                    if ("".equals(splittedStr[0])) {
                                                                                        OPatchEnv.setArgumentError(true, "Empty SID cannot be a part of connect string.");
                                                                                        return null;
                                                                                    }
                                                                                    sids[cIter] = splittedStr[0];
                                                                                    dbUserNames[cIter] = splittedStr[1];
                                                                                    dbPasswords[cIter] = splittedStr[2];
                                                                                    dbNodes[cIter] = "";
                                                                                    continue;
                                                                                }
                                                                                if (splittedStr.length != 4) continue;
                                                                                if ("".equals(splittedStr[0])) {
                                                                                    OPatchEnv.setArgumentError(true, "Empty SID cannot be a part of connect string.");
                                                                                    return null;
                                                                                }
                                                                                sids[cIter] = splittedStr[0];
                                                                                dbUserNames[cIter] = splittedStr[1];
                                                                                dbPasswords[cIter] = splittedStr[2];
                                                                                dbNodes[cIter] = splittedStr[3];
                                                                            }
                                                                            OPatchEnv.setDBSids(sids);
                                                                            OPatchEnv.setDBUsers(dbUserNames);
                                                                            OPatchEnv.setDBPasswds(dbPasswords);
                                                                            OPatchEnv.setDBNodes(dbNodes);
                                                                        }
                                                                        if (parser.getOptionValue(runSql) != null) {
                                                                            OPatchEnv.setRunSql(true);
                                                                        }
                                                                        if (parser.getOptionValue(sqlScript) != null) {
                                                                            s = (String)parser.getOptionValue(sqlScript);
                                                                            File f4 = new File(s);
                                                                            if (f4 == null) {
                                                                                OPatchEnv.setArgumentError(true, "Given 'sqlScript' string is not recognised as a file.");
                                                                                return null;
                                                                            }
                                                                            String absSqlScriptFile = null;
                                                                            try {
                                                                                absSqlScriptFile = f4.getCanonicalPath();
                                                                            }
                                                                            catch (IOException e12) {
                                                                                StringBuffer errorMessage = new StringBuffer("Unable to get canonical path for the 'sqlScript' file\n");
                                                                                errorMessage.append(e12.getMessage());
                                                                                OPatchEnv.setArgumentError(true, errorMessage.toString());
                                                                                return null;
                                                                            }
                                                                            f4 = new File(absSqlScriptFile);
                                                                            if (!f4.exists() || !f4.canRead()) {
                                                                                OPatchEnv.setArgumentError(true, "Given 'sqlScript' file does not exists or is not readable.");
                                                                                return null;
                                                                            }
                                                                            if (f4.isDirectory()) {
                                                                                OPatchEnv.setArgumentError(true, "Given 'sqlScript' file is a directory and not a file.");
                                                                                return null;
                                                                            }
                                                                            OPatchEnv.setSqlScriptFilePath(absSqlScriptFile);
                                                                            OPatchEnv.setSqlScriptPresence(true);
                                                                        }
                                                                        if (parser.getOptionValue(lsp_bugs) != null) {
                                                                            OPatchEnv.setLsp_bugs(true);
                                                                        }
                                                                        if (parser.getOptionValue(lsp_required) != null) {
                                                                            OPatchEnv.setLsp_Required(true);
                                                                        }
                                                                        if (parser.getOptionValue(lsp_verify) != null) {
                                                                            OPatchEnv.setLsp_Verified(true);
                                                                        }
                                                                        if (parser.getOptionValue(lsp_qfile) != null) {
                                                                            String qfile = (String)parser.getOptionValue(lsp_qfile);
                                                                            File queryFile = new File(qfile);
                                                                            try {
                                                                                if (queryFile.isAbsolute()) {
                                                                                    OPatchEnv.setArgumentError(true, "Please provide a path that is relative to Oracle Home.");
                                                                                    return null;
                                                                                }
                                                                                queryFile = new File(OPatchEnv.getOracleHome() + File.separator + qfile);
                                                                                if (!queryFile.exists() || !queryFile.canRead()) {
                                                                                    OPatchEnv.setArgumentError(true, "Given queried file does not exist or is not readable.");
                                                                                    return null;
                                                                                }
                                                                                if (queryFile.isDirectory()) {
                                                                                    OPatchEnv.setArgumentError(true, "Given queried file is a directory and not a file.");
                                                                                    return null;
                                                                                }
                                                                                OPatchEnv.setLsp_queryfile(queryFile.getCanonicalPath());
                                                                            }
                                                                            catch (IOException e13) {
                                                                                OPatchEnv.setLsp_queryfile(queryFile.getAbsolutePath());
                                                                            }
                                                                        }
                                                                        if (parser.getOptionValue(all_subpatches) != null) {
                                                                            OPatchEnv.setAll_Subpatches(true);
                                                                        }
                                                                        if (debugStr != null && debugStr.compareToIgnoreCase("true") == 0 || parser.getOptionValue(logLevel) == null) break block538;
                                                                        String levelString = (String)parser.getOptionValue(logLevel);
                                                                        int val = -1;
                                                                        String logLevelOption = "";
                                                                        int consoleLogLevel = -1;
                                                                        int fileLogLevel = -1;
                                                                        String[] levels = new String[]{};
                                                                        levels = levelString.split(",");
                                                                        int alog = -1;
                                                                        if (levels.length > 2) {
                                                                            OPatchEnv.setArgumentError(true, "Given logLevel option contains too many levels.");
                                                                            return null;
                                                                        }
                                                                        for (int i13 = 0; i13 < levels.length; ++i13) {
                                                                            block541: {
                                                                                block539: {
                                                                                    block545: {
                                                                                        block544: {
                                                                                            block543: {
                                                                                                block542: {
                                                                                                    block540: {
                                                                                                        try {
                                                                                                            val = Integer.parseInt(levels[i13]);
                                                                                                        }
                                                                                                        catch (NumberFormatException e14) {
                                                                                                            logLevelOption = levels[i13];
                                                                                                            val = -1;
                                                                                                        }
                                                                                                        if (val == -1) break block539;
                                                                                                        if (val > OLogger.FINEST) break block540;
                                                                                                        alog = OLogger.FINEST;
                                                                                                        break block541;
                                                                                                    }
                                                                                                    if (val > OLogger.FINER) break block542;
                                                                                                    alog = OLogger.FINER;
                                                                                                    break block541;
                                                                                                }
                                                                                                if (val > OLogger.FINE) break block543;
                                                                                                alog = OLogger.FINE;
                                                                                                break block541;
                                                                                            }
                                                                                            if (val > OLogger.CONFIG) break block544;
                                                                                            alog = OLogger.CONFIG;
                                                                                            break block541;
                                                                                        }
                                                                                        if (val > OLogger.INFO) break block545;
                                                                                        alog = OLogger.INFO;
                                                                                        break block541;
                                                                                    }
                                                                                    if (val <= OLogger.WARNING) {
                                                                                        alog = OLogger.WARNING;
                                                                                        break block541;
                                                                                    } else if (val <= OLogger.SEVERE) {
                                                                                        alog = OLogger.SEVERE;
                                                                                    }
                                                                                    break block541;
                                                                                }
                                                                                if (!logLevelOption.equals("")) {
                                                                                    if (logLevelOption.equalsIgnoreCase("Finest")) {
                                                                                        alog = OLogger.FINEST;
                                                                                    } else if (logLevelOption.equalsIgnoreCase("Finer")) {
                                                                                        alog = OLogger.FINER;
                                                                                    } else if (logLevelOption.equalsIgnoreCase("Fine")) {
                                                                                        alog = OLogger.FINE;
                                                                                    } else if (logLevelOption.equalsIgnoreCase("Config")) {
                                                                                        alog = OLogger.CONFIG;
                                                                                    } else if (logLevelOption.equalsIgnoreCase("Info")) {
                                                                                        alog = OLogger.INFO;
                                                                                    } else if (logLevelOption.equalsIgnoreCase("Warning")) {
                                                                                        alog = OLogger.WARNING;
                                                                                    } else if (logLevelOption.equalsIgnoreCase("Severe")) {
                                                                                        alog = OLogger.SEVERE;
                                                                                    }
                                                                                }
                                                                            }
                                                                            if (i13 == 0) {
                                                                                consoleLogLevel = alog;
                                                                                continue;
                                                                            }
                                                                            fileLogLevel = alog;
                                                                        }
                                                                        if (consoleLogLevel == -1) {
                                                                            consoleLogLevel = OLogger.INFO;
                                                                        } else {
                                                                            OPatchEnv.setConsoleLogLevel(consoleLogLevel);
                                                                        }
                                                                        if (fileLogLevel == -1) {
                                                                            fileLogLevel = consoleLogLevel;
                                                                        } else {
                                                                            OPatchEnv.setFileLogLevel(fileLogLevel);
                                                                        }
                                                                        try {
                                                                            OPatchACL.invokeOLogger(new CmdLineParser(), "setLogLevel", new Object[]{consoleLogLevel});
                                                                            OPatchACL.invokeOLogger(new CmdLineParser(), "setLogFileLevel", new Object[]{fileLogLevel});
                                                                        }
                                                                        catch (IllegalAccessException e15) {
                                                                            RuntimeException rt = new RuntimeException(e15.getMessage());
                                                                            rt.setStackTrace(e15.getStackTrace());
                                                                            throw rt;
                                                                        }
                                                                    }
                                                                    if ((otherArgs = parser.getRemainingArgs()).length == 0) {
                                                                        return null;
                                                                    }
                                                                    arg = (otherArgs = CmdLineParser.processOPatchProperties(otherArgs))[0];
                                                                    if (arg.toLowerCase().equals("iscasrepospresent")) {
                                                                        arg = arg.toLowerCase();
                                                                    }
                                                                    if (arg.equals("apply")) {
                                                                        if (parser.getOptionValue(patchlocdir) != null) {
                                                                            return null;
                                                                        }
                                                                        if (parser.getOptionValue(patchlocfile) != null) {
                                                                            return null;
                                                                        }
                                                                    }
                                                                    if (arg.equals("util") || arg.equals("napply") || arg.equals("nrollback")) {
                                                                        try {
                                                                            CmdLineHelper.processRuntimeOptions("oracle.opatch.opatchutil.OUSession", parser, StringResource.UTIL_LITERAL_OPTIONS, StringResource.UTIL_OPTIONS, "defaultArgument");
                                                                        }
                                                                        catch (RuntimeException e16) {
                                                                            OLogger.println(e16.getMessage());
                                                                            e16.printStackTrace();
                                                                            throw e16;
                                                                        }
                                                                    }
                                                                    if (arg.equals("prereq")) {
                                                                        CmdLineHelper.processRuntimeOptions("oracle.opatch.opatchprereq.PQSession", parser, StringResource.PREREQ_LITERAL_OPTIONS, StringResource.PREREQ_OPTIONS, "defaultArgument");
                                                                    }
                                                                    if (switchToUtil) {
                                                                        try {
                                                                            CmdLineHelper.processRuntimeOptions("oracle.opatch.opatchutil.OUSession", parser, StringResource.UTIL_LITERAL_OPTIONS, StringResource.UTIL_OPTIONS, "defaultArgument");
                                                                        }
                                                                        catch (RuntimeException e17) {
                                                                            OLogger.println(e17.getMessage());
                                                                            e17.printStackTrace();
                                                                            throw e17;
                                                                        }
                                                                    }
                                                                    if (!switchToUtil && !supportedCommands.contains(arg)) {
                                                                        StringBuffer errMsg = new StringBuffer("Unrecognized Command or Option");
                                                                        errMsg.append(" (").append(arg).append(")");
                                                                        errMsg.append(": first argument must be one of the following:\n");
                                                                        errMsg.append("   ");
                                                                        Enumeration eOPatchCmds = printCommands.elements();
                                                                        while (true) {
                                                                            if (!eOPatchCmds.hasMoreElements()) {
                                                                                OPatchEnv.setSyntaxError(true, errMsg.toString());
                                                                                return null;
                                                                            }
                                                                            errMsg.append("   ").append(eOPatchCmds.nextElement()).append("\n");
                                                                        }
                                                                    }
                                                                    utilOption = "";
                                                                    boolean isGetAutoRollback = arg.equals("getautorollback");
                                                                    if (otherArgs.length >= 2 && arg.equals("util") && otherArgs[1].equals("getautorollback")) {
                                                                        if (!isGetAutoRollback) {
                                                                            // empty if block
                                                                        }
                                                                        isGetAutoRollback = true;
                                                                    }
                                                                    if (!arg.equals("napply") && (!isGetAutoRollback || !OPatchEnv.getPatchloc().equals(""))) break block546;
                                                                    compositeFilePath = "";
                                                                    if (otherArgs.length >= 2) {
                                                                        compositeFilePath = otherArgs[1];
                                                                    }
                                                                    if ((compositeFile = new File(compositeXmlLocation = CompositePatchObject.getCompositeFilePath(compositeFilePath))).exists()) {
                                                                        try {
                                                                            compositeXmlLocation = CompositePatchObject.validateComposite(compositeFilePath);
                                                                        }
                                                                        catch (RuntimeException e18) {
                                                                            OPatchEnv.setArgumentError(true, e18.getMessage());
                                                                            return null;
                                                                        }
                                                                        if (otherArgs.length != 2 || parser.getOptionValue(patchid) != null || parser.getOptionValue(skipSubset) != null || parser.getOptionValue(skipDuplicate) != null || parser.getOptionValue(idFile) != null) {
                                                                            OPatchEnv.setSyntaxError(true, OLogger.getString("OUI-67931"));
                                                                            return null;
                                                                        }
                                                                        if (!parser.validateTheOptions()) {
                                                                            StringBuffer eMsg = new StringBuffer("Invalid combination of options specified.\n");
                                                                            OPatchEnv.setSyntaxError(true, eMsg.toString());
                                                                            return null;
                                                                        }
                                                                        OUSession.phbasedir(compositeFilePath);
                                                                        OPatchEnv.setNApplyBaseDir(compositeFilePath);
                                                                        OPatchEnv.setSessionType("util");
                                                                        OPatchEnv.setUtilOption("napply");
                                                                        return OPatchSession.UTIL;
                                                                    }
                                                                    arg = "util";
                                                                    utilOption = isGetAutoRollback ? "getautorollback" : "napply";
                                                                    patchLocSpecified = false;
                                                                    break block547;
                                                                }
                                                                if (!arg.equals("nrollback")) break block548;
                                                                oracleHomePath = OPatchEnv.getOracleHome();
                                                                patchIDs = OPatchEnv.getUserSuppliedPatchIDs();
                                                                compositeList = new ArrayList<String>();
                                                                newPatchIDs = new ArrayList<String>();
                                                                break block549;
                                                            }
                                                            if (switchToUtil) {
                                                                utilOption = arg;
                                                                arg = "util";
                                                            }
                                                            break block532;
                                                        }
                                                        for (int i14 = 1; otherArgs != null && i14 < otherArgs.length; ++i14) {
                                                            String each = otherArgs[i14];
                                                            if (each == null) continue;
                                                            if (parser.getOptionValue(phase_two) != null) {
                                                                OPatchEnv.setArgumentError(true, "patch locations can't be combined with the option '-phase_two'");
                                                                return null;
                                                            }
                                                            File f5 = new File(each);
                                                            if (f5.exists() && f5.isDirectory()) {
                                                                cPath = "";
                                                                try {
                                                                    cPath = f5.getCanonicalPath();
                                                                }
                                                                catch (IOException e19) {
                                                                    cPath = each;
                                                                }
                                                                subDirs2 = f5.list();
                                                                hasEtc2 = false;
                                                                hasFile2 = false;
                                                            } else {
                                                                ZOPErrorMessage.printErrorMessage(50);
                                                                OPatchEnv.setArgumentError(true, "Patch Location not valid");
                                                                return null;
                                                            }
                                                            for (j2 = 0; subDirs2 != null && j2 < subDirs2.length; ++j2) {
                                                                entry = subDirs2[j2];
                                                                if (entry.indexOf("etc") != -1) {
                                                                    hasEtc2 = true;
                                                                    continue;
                                                                }
                                                                if (entry.indexOf("files") == -1) continue;
                                                                hasFile2 = true;
                                                            }
                                                            if (hasEtc2 && hasFile2) {
                                                                OPatchEnv.setPatchloc(cPath);
                                                                patchLocSpecified = true;
                                                                break;
                                                            }
                                                            OUSession.phbasedir(cPath);
                                                            OPatchEnv.setNApplyBaseDir(cPath);
                                                            patchLocSpecified = true;
                                                            break;
                                                        }
                                                        boolean isPhBaseFileSpecified = OUSession.isPatchBaseFileProvided();
                                                        boolean isPhBaseDirSpecified = OUSession.isPatchBaseDirProvided();
                                                        if (!patchLocSpecified && !isPhBaseFileSpecified && !isPhBaseDirSpecified && OPatchEnv.getPatchloc().equals("")) {
                                                            try {
                                                                File tmpF = new File(".");
                                                                cPath = tmpF.getCanonicalPath();
                                                                compositeXmlLocation = CompositePatchObject.getCompositeFilePath(cPath);
                                                                compositeFile = new File(compositeXmlLocation);
                                                                if (compositeFile.exists()) {
                                                                    try {
                                                                        compositeXmlLocation = CompositePatchObject.validateComposite(cPath);
                                                                    }
                                                                    catch (RuntimeException e20) {
                                                                        OPatchEnv.setArgumentError(true, e20.getMessage());
                                                                        return null;
                                                                    }
                                                                    String actualCompositeXmlLocation = CompositePatchObject.getCompositeFilePath(compositeFilePath);
                                                                    File actualCompositeFile = new File(actualCompositeXmlLocation);
                                                                    if (actualCompositeFile.exists() && otherArgs.length == 2 && parser.getOptionValue(patchid) == null && parser.getOptionValue(skipSubset) == null && parser.getOptionValue(skipDuplicate) == null && parser.getOptionValue(idFile) == null) {
                                                                        OUSession.phbasedir(cPath);
                                                                        OPatchEnv.setNApplyBaseDir(cPath);
                                                                        OPatchEnv.setSessionType("util");
                                                                        OPatchEnv.setUtilOption("napply");
                                                                        return OPatchSession.UTIL;
                                                                    }
                                                                    OPatchEnv.setSyntaxError(true, OLogger.getString("OUI-67931"));
                                                                    return null;
                                                                }
                                                                subDirs2 = tmpF.list();
                                                                hasEtc2 = false;
                                                                hasFile2 = false;
                                                                for (j2 = 0; subDirs2 != null && j2 < subDirs2.length; ++j2) {
                                                                    entry = subDirs2[j2];
                                                                    if (entry.indexOf("etc") != -1) {
                                                                        hasEtc2 = true;
                                                                        continue;
                                                                    }
                                                                    if (entry.indexOf("files") == -1) continue;
                                                                    hasFile2 = true;
                                                                }
                                                                if (hasEtc2 && hasFile2) {
                                                                    OPatchEnv.setPatchloc(cPath);
                                                                    patchLocSpecified = true;
                                                                    break block532;
                                                                }
                                                                OUSession.phbasedir(cPath);
                                                                OPatchEnv.setNApplyBaseDir(cPath);
                                                                patchLocSpecified = true;
                                                            }
                                                            catch (IOException e21) {
                                                                File tmpF = new File(".");
                                                                String cPath2 = tmpF.getAbsolutePath();
                                                                OUSession.phbasedir(cPath2);
                                                                OPatchEnv.setNApplyBaseDir(cPath2);
                                                            }
                                                        }
                                                        break block532;
                                                    }
                                                    for (int k4 = 0; k4 < patchIDs.length; ++k4) {
                                                        String rbPatchID = patchIDs[k4];
                                                        if (CompositePatchObject.getActiveField(oracleHomePath, rbPatchID) != null) {
                                                            String activeConstituent = CompositePatchObject.getActiveConstituent(oracleHomePath, rbPatchID);
                                                            if (!rbPatchID.equals(activeConstituent)) {
                                                                OPatchEnv.setArgumentError(true, "ERROR: OPatch would not rollback a sub-patch that is not active. The patch id " + rbPatchID + " is a sub-patch of the active composite " + activeConstituent + ". OPatch will not rollback patch(es) " + rbPatchID + " until you have rolled back " + activeConstituent + ".");
                                                                return null;
                                                            }
                                                            compositeList.add(activeConstituent);
                                                            String[] constituentsToRollback = null;
                                                            constituentsToRollback = CompositePatchObject.getConstituentsToRollback(oracleHomePath, rbPatchID);
                                                            for (int l2 = 0; l2 < constituentsToRollback.length; ++l2) {
                                                                newPatchIDs.add(constituentsToRollback[l2]);
                                                            }
                                                            try {
                                                                int all_subpatches_num = CompositePatchObject.getCompositeAutoRBOrder(rbPatchID, oracleHomePath).size();
                                                                if (constituentsToRollback.length == all_subpatches_num) {
                                                                    OPatchEnv.setInactivePSUTrainRollback(true);
                                                                }
                                                            }
                                                            catch (Exception ex) {
                                                                OPatchEnv.setInactivePSUTrainRollback(false);
                                                            }
                                                            OPatchEnv.setCompositeRollback(true);
                                                            OPatchEnv.setCompositeActiveID(activeConstituent);
                                                            continue;
                                                        }
                                                        newPatchIDs.add(rbPatchID);
                                                    }
                                                    if (compositeList.size() > 1) {
                                                        String errorMsg = OLogger.getString("OUI-67952", new Object[]{compositeList.toString()});
                                                        OPatchEnv.setArgumentError(true, errorMsg);
                                                        return null;
                                                    }
                                                    arg = "util";
                                                    utilOption = "nrollback";
                                                    String[] newPatchIDArray = new String[newPatchIDs.size()];
                                                    newPatchIDs.toArray(newPatchIDArray);
                                                    OPatchEnv.setUserSuppliedPatchIDs(newPatchIDArray);
                                                }
                                                OPatchEnv.setSessionType(arg);
                                                boolean combinationError = false;
                                                if (arg.equals("lspatches") && (OPatchEnv.isLsp_Required() || OPatchEnv.isLsp_Verified()) && parser.getOptionValue(patchid) == null && otherArgs.length != 2) {
                                                    combinationError = true;
                                                }
                                                if (!parser.validateTheOptions() || combinationError) {
                                                    StringBuffer eMsg = new StringBuffer("Invalid combination of options specified.\n");
                                                    OPatchEnv.setSyntaxError(true, eMsg.toString());
                                                    return null;
                                                }
                                                sType = OPatchEnv.getSessionType();
                                                isHelp = OPatchEnv.isHelp();
                                                isUtilReadOnly = false;
                                                if (sType.equals("compare")) {
                                                    return OPatchSession.COMPARE;
                                                }
                                                if ((sType.equals("apply") || sType.equals("rollback")) && !isHelp) {
                                                    if (OPatchEnv.isBeaHome()) {
                                                        if (OPatchEnv.getisAuto() ^ OPatchEnv.getFMWDomainName() != null && OPatchEnv.getFMWDomainName() != null) {
                                                            String errorMsg = OLogger.getString("OUI-67701", new Object[]{"domain", "auto"});
                                                            OPatchEnv.setSyntaxError(true, errorMsg);
                                                            return null;
                                                        }
                                                    } else if (OPatchEnv.getFMWDomainName() != null || OPatchEnv.getisAuto()) {
                                                        String errorMsg = OLogger.getString("OUI-67706");
                                                        OPatchEnv.setArgumentError(true, errorMsg);
                                                        return null;
                                                    }
                                                }
                                                if (!sType.equals("util") && !switchToUtil) break block550;
                                                if (otherArgs.length <= 1 && utilOption.equals("")) break block533;
                                                String opt = null;
                                                opt = !utilOption.equals("") ? utilOption : otherArgs[1];
                                                if (!UtilSession.isUtilOptionValid(opt)) {
                                                    StringBuffer eMsg = new StringBuffer("Unrecognized util command.\n");
                                                    OPatchEnv.setSyntaxError(true, eMsg.toString());
                                                    return null;
                                                }
                                                OPatchEnv.setUtilOption(opt);
                                                if ("stopComposite".equalsIgnoreCase(opt) || "startComposite".equalsIgnoreCase(opt) || "listComposites".equalsIgnoreCase(opt)) {
                                                    OPatchEnv.setFMWCmdTargetType("soaComposite");
                                                }
                                                if (otherArgs.length > 2) {
                                                    StringBuffer eMsg = new StringBuffer("Unrecognized Option for util.\n");
                                                    OPatchEnv.setSyntaxError(true, eMsg.toString());
                                                    return null;
                                                }
                                                if (SrvmUtil.checkMethod(opt)) {
                                                    OPatchEnv.setIsSrvmUtil(true);
                                                }
                                                if (OUSession.isReadOnly(opt)) {
                                                    isUtilReadOnly = true;
                                                }
                                                if (((idDefn = OPatchEnv.getUserSuppliedPatchIDs()) == null || idDefn.length == 0) && ((OPatchEnv.getPatchloc() == null || OPatchEnv.getPatchloc().equals("")) && opt.equals("deploy") || opt.equals("undeploy"))) {
                                                    String patchlocation = "";
                                                    if (otherArgs.length == 1) {
                                                        patchlocation = new File(".").getAbsolutePath();
                                                    } else if (otherArgs.length == 2) {
                                                        File temp = new File(otherArgs[1]);
                                                        if (!temp.exists()) {
                                                            ZOPErrorMessage.printErrorMessage(50);
                                                            OPatchEnv.setArgumentError(true, "Patch location not valid");
                                                            return null;
                                                        }
                                                        try {
                                                            patchlocation = temp.getCanonicalPath();
                                                        }
                                                        catch (IOException e22) {
                                                            patchlocation = otherArgs[1];
                                                        }
                                                    }
                                                    OPatchEnv.setPatchloc(patchlocation);
                                                }
                                                break block533;
                                            }
                                            if (!sType.equals("prereq") || isHelp) break block551;
                                            if (otherArgs.length > 1) {
                                                String opt = otherArgs[1];
                                                OLogger.println("PREREQ session");
                                                if (!PrereqSession.isPrereqOptionValid(opt)) {
                                                    StringBuffer eMsg = new StringBuffer("Unrecognized prereq check.\n");
                                                    OPatchEnv.setSyntaxError(true, eMsg.toString());
                                                    return null;
                                                }
                                                OPatchEnv.setPrereqOption(opt);
                                                if (otherArgs.length > 2) {
                                                    StringBuffer eMsg = new StringBuffer("Unrecognized Option for prereq.\n");
                                                    OPatchEnv.setSyntaxError(true, eMsg.toString());
                                                    return null;
                                                }
                                            }
                                            break block533;
                                        }
                                        if (!sType.equals("lsinventory") && !sType.equals("lsinv") || isHelp) break block552;
                                        if (otherArgs.length > 1) {
                                            if (!OPatchEnv.isLsinv_match()) {
                                                StringBuffer eMsg = new StringBuffer("Unrecognized Option for lsinventory.\n");
                                                OPatchEnv.setSyntaxError(true, eMsg.toString());
                                                return null;
                                            }
                                            String regExp = otherArgs[1];
                                            OPatchEnv.setLsInvRegExpression(regExp);
                                        }
                                        break block533;
                                    }
                                    if (!sType.equals("lspatches") || isHelp) break block553;
                                    String centralInvLoc = OPatchEnv.getCentralInvLoc();
                                    boolean badInvPtrFlag = false;
                                    if (centralInvLoc.equals("n/a")) {
                                        badInvPtrFlag = true;
                                    }
                                    if (badInvPtrFlag) {
                                        OPatchEnv.setArgumentError(true, "Oracle Home's central inventory is not found.");
                                        return null;
                                    }
                                    if (otherArgs.length == 1) break block533;
                                    if (otherArgs.length != 2) {
                                        OPatchEnv.setSyntaxError(true, "Unrecognized Option for lspatches");
                                        return null;
                                    }
                                    if (parser.getOptionValue(patchid) != null) {
                                        StringBuffer eMsg = new StringBuffer("Invalid combination of options specified.\n");
                                        OPatchEnv.setSyntaxError(true, eMsg.toString());
                                        return null;
                                    }
                                    File tmpF = new File(otherArgs[1]);
                                    if (!tmpF.exists() || !tmpF.canRead()) {
                                        OPatchEnv.setArgumentError(true, "Staged Patch Location \"" + otherArgs[1] + "\" does not exist or not readable.");
                                        return null;
                                    }
                                    tmpPatchLoc = "";
                                    if (!tmpF.isDirectory()) {
                                        String fileName = "";
                                        try {
                                            fileName = tmpF.getCanonicalPath();
                                        }
                                        catch (IOException e23) {
                                            fileName = tmpF.getAbsolutePath();
                                        }
                                        if (!fileName.endsWith(".zip")) {
                                            OPatchEnv.setArgumentError(true, "Staged Patch Location \"" + fileName + "\" is not valid");
                                            return null;
                                        }
                                        String extractLoc = OPatchEnv.getPatchUnzipLocation();
                                        String topLevelDir = ZipUtilities.unzip(fileName, extractLoc);
                                        String fullPath = extractLoc + File.separator + topLevelDir;
                                        File patchDir = new File(fullPath);
                                        if (!patchDir.exists() || !patchDir.isDirectory()) {
                                            RuntimeException re = new RuntimeException("Could not extract the given zip file \"" + fileName + "\"");
                                            throw re;
                                        }
                                        try {
                                            tmpPatchLoc = patchDir.getCanonicalPath();
                                        }
                                        catch (IOException e24) {
                                            tmpPatchLoc = patchDir.getAbsolutePath();
                                        }
                                    } else {
                                        try {
                                            tmpPatchLoc = tmpF.getCanonicalPath();
                                        }
                                        catch (IOException e25) {
                                            tmpPatchLoc = tmpF.getAbsolutePath();
                                        }
                                    }
                                    tmpPatchLocation = new File(tmpPatchLoc);
                                    subDirs = tmpPatchLocation.list();
                                    hasEtc = false;
                                    hasFile = false;
                                    hasBundle = false;
                                    break block554;
                                }
                                if (!sType.equals("query") || isHelp) break block555;
                                if (otherArgs.length > 1) {
                                    File tmpF = new File(otherArgs[1]);
                                    if (!tmpF.exists()) {
                                        ZOPErrorMessage.printErrorMessage(50);
                                        OPatchEnv.setArgumentError(true, "Patch Location not valid");
                                        return null;
                                    }
                                    OPatchEnv.setPatchloc(otherArgs[1]);
                                    break block533;
                                } else {
                                    try {
                                        File tmpF = new File(".");
                                        String tmpStr = tmpF.getCanonicalPath();
                                        OPatchEnv.setPatchloc(tmpStr);
                                    }
                                    catch (IOException e26) {
                                        File tmpF = new File(".");
                                        String tmpStr = tmpF.getAbsolutePath();
                                        OPatchEnv.setPatchloc(tmpStr);
                                    }
                                }
                                break block533;
                            }
                            if (!sType.equals("enablecas") || isHelp) break block556;
                            if (OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
                                OLogger.justlog(OLogger.INFO, " OPatch has already supported cas. No need to run enablecas.");
                            }
                            break block533;
                        }
                        if (!sType.equals("disablecas") || isHelp) break block557;
                        File casDir = new File(OPatchEnv.getOracleHome() + File.separator + ".cas");
                        if (casDir.exists()) {
                            String errMsg1 = "Cas directory exists in Oracle Home, please detach cas first.";
                            OPatchEnv.setArgumentError(true, errMsg1);
                            return null;
                        }
                        if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
                            OPatchEnv.setArgumentError(true, "This OPatch does not enables cas, no need to run disablecas.");
                            return null;
                        }
                        break block533;
                    }
                    if (!sType.equals("checkintegrity") || isHelp) break block558;
                    if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
                        OPatchEnv.setArgumentError(true, "CAS is not enabled - checkintegrity command is not supported");
                        return null;
                    }
                    break block533;
                }
                if (sType.equals("restoreintegrity") && !isHelp) {
                    if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
                        OPatchEnv.setArgumentError(true, "CAS is not enabled - restoreintegrity command is not supported");
                        return null;
                    }
                    break block533;
                } else {
                    if (sType.equals("apply") && !isHelp) {
                        if (otherArgs.length == 1) {
                            try {
                                File tmpF = new File(".");
                                String tmpStr = tmpF.getCanonicalPath();
                                if (!CmdLineParser.validateApplyPatch(tmpStr)) {
                                    ZOPErrorMessage.printErrorMessage(51);
                                    OPatchEnv.setArgumentError(true, "Patch location is not valid for apply");
                                    return null;
                                }
                                OUSession.phbasedir(tmpStr);
                                OPatchEnv.setNApplyBaseDir(tmpStr);
                                OPatchEnv.setSessionType("util");
                                OPatchEnv.setUtilOption("napply");
                                return OPatchSession.UTIL;
                            }
                            catch (IOException e27) {
                                File tmpF = new File(".");
                                String tmpStr = tmpF.getAbsolutePath();
                                if (!CmdLineParser.validateApplyPatch(tmpStr)) {
                                    ZOPErrorMessage.printErrorMessage(51);
                                    OPatchEnv.setArgumentError(true, "Patch location is not valid for apply");
                                    return null;
                                }
                                OUSession.phbasedir(tmpStr);
                                OPatchEnv.setNApplyBaseDir(tmpStr);
                                OPatchEnv.setSessionType("util");
                                OPatchEnv.setUtilOption("napply");
                                return OPatchSession.UTIL;
                            }
                        }
                        if (otherArgs.length != 2) {
                            OPatchEnv.setSyntaxError(true, "Unrecognized Option for Apply");
                            return null;
                        }
                        File tmpF = new File(otherArgs[1]);
                        if (!tmpF.exists()) {
                            ZOPErrorMessage.printErrorMessage(50);
                            OPatchEnv.setArgumentError(true, "Patch Location not valid");
                            return null;
                        }
                        try {
                            String tmpStr = tmpF.getCanonicalPath();
                            if (!CmdLineParser.validateApplyPatch(tmpStr)) {
                                ZOPErrorMessage.printErrorMessage(51);
                                OPatchEnv.setArgumentError(true, "Patch location is not valid for apply");
                                return null;
                            }
                            OUSession.phbasedir(tmpStr);
                            OPatchEnv.setNApplyBaseDir(tmpStr);
                            OPatchEnv.setSessionType("util");
                            OPatchEnv.setUtilOption("napply");
                            return OPatchSession.UTIL;
                        }
                        catch (IOException e28) {
                            String tmpStr = otherArgs[1];
                            if (!CmdLineParser.validateApplyPatch(tmpStr)) {
                                ZOPErrorMessage.printErrorMessage(51);
                                OPatchEnv.setArgumentError(true, "Patch location is not valid for apply");
                                return null;
                            }
                            OUSession.phbasedir(tmpStr);
                            OPatchEnv.setNApplyBaseDir(tmpStr);
                            OPatchEnv.setSessionType("util");
                            OPatchEnv.setUtilOption("napply");
                            return OPatchSession.UTIL;
                        }
                    }
                    if (OPatchEnv.getSessionType().equals("rollback") && !isHelp) {
                        if (otherArgs.length > 1) {
                            OPatchEnv.setSyntaxError(true, "Unrecognized Option for Rollback");
                            return null;
                        }
                        String s = (String)parser.getOptionValue(patchid);
                        String[] patchIDs = OPatchEnv.getUserSuppliedPatchIDs();
                        if (OPatchEnv.isAll_Subpatches() && OPatchEnv.isUserSuppliedPatchIDs()) {
                            s = patchIDs[0];
                        }
                        if (s == null) {
                            OPatchEnv.setSyntaxError(true, "Please provide valid Patch ID for rollback using 'id' option.");
                            return null;
                        }
                        StringTokenizer tk = new StringTokenizer(s, " ,");
                        int manyPatchesGiven = tk.countTokens();
                        if (manyPatchesGiven != 1) {
                            StringBuffer errMsg = new StringBuffer("Unrecognized Command or Option");
                            errMsg.append(". Please specify only one patch ID for rollback operation.\n");
                            errMsg.append("Your option is ").append(s).append("   \n");
                            OPatchEnv.setSyntaxError(true, errMsg.toString());
                            return null;
                        }
                        try {
                            String[] inputs;
                            int noTokens;
                            StringTokenizer tk2;
                            String oracleHomePath = OPatchEnv.getOracleHome();
                            String rbPatchID = OPatchEnv.getRollbackPatchid();
                            if (OPatchEnv.isAll_Subpatches()) {
                                rbPatchID = s;
                            }
                            if (rbPatchID == null || rbPatchID.equals("")) {
                                OPatchEnv.setSyntaxError(true, "Please provide valid Patch ID for rollback using 'id' option.");
                                return null;
                            }
                            String tmpStr = OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, rbPatchID);
                            boolean maybeLang = false;
                            if (tmpStr != null && (tk2 = new StringTokenizer(rbPatchID, "_")) != null && (noTokens = tk2.countTokens()) >= 2) {
                                maybeLang = true;
                            }
                            if (maybeLang) {
                                inputs = OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, rbPatchID, true);
                                tmpStr = inputs[0];
                                OPatchEnv.setRollbackPatchid(inputs[1]);
                            } else {
                                inputs = OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, rbPatchID + "_en", true);
                                String basePatchLoc = inputs[0];
                                File tmpF = new File(basePatchLoc);
                                if ((tmpF = tmpF.getCanonicalFile()).exists()) {
                                    tmpStr = inputs[0];
                                }
                            }
                            File tmpF = new File(tmpStr);
                            tmpF = tmpF.getCanonicalFile();
                            if (!tmpF.exists()) {
                                OPatchEnv.setArgumentError(true, OLogger.getString("OUI-67129"));
                                return null;
                            }
                            OPatchEnv.setPatchloc(tmpF.toString());
                            if (CompositePatchObject.getActiveField(oracleHomePath, rbPatchID) != null) {
                                String activeConstituent = CompositePatchObject.getActiveConstituent(oracleHomePath, rbPatchID);
                                if (!rbPatchID.equals(activeConstituent)) {
                                    OPatchEnv.setArgumentError(true, "ERROR: OPatch would not rollback a sub-patch that is not active. The patch id " + rbPatchID + " is a sub-patch of the active composite " + activeConstituent + ". OPatch will not rollback patch(es) " + rbPatchID + " until you have rolled back " + activeConstituent + ".");
                                    return null;
                                }
                                String[] constituentsToRollback = null;
                                if (OPatchEnv.isAll_Subpatches()) {
                                    ArrayList allSubPatches = CompositePatchObject.getCompositeAutoRBOrder(rbPatchID, oracleHomePath);
                                    constituentsToRollback = new String[allSubPatches.size()];
                                    allSubPatches.toArray(constituentsToRollback);
                                } else {
                                    constituentsToRollback = CompositePatchObject.getConstituentsToRollback(oracleHomePath, rbPatchID);
                                }
                                try {
                                    int all_subpatches_num = CompositePatchObject.getCompositeAutoRBOrder(rbPatchID, oracleHomePath).size();
                                    if (constituentsToRollback.length == all_subpatches_num) {
                                        OPatchEnv.setInactivePSUTrainRollback(true);
                                    }
                                }
                                catch (Exception ex) {
                                    OPatchEnv.setInactivePSUTrainRollback(false);
                                }
                                OPatchEnv.setUserSuppliedPatchIDs(constituentsToRollback);
                                OPatchEnv.setSessionType("util");
                                OPatchEnv.setUtilOption("nrollback");
                                OPatchEnv.setCompositeRollback(true);
                                OPatchEnv.setCompositeActiveID(activeConstituent);
                                return OPatchSession.UTIL;
                            }
                            if (OPatchEnv.isAll_Subpatches()) {
                                OPatchEnv.setSyntaxError(true, "ERROR: '-all_subpatches' option is only valid for composite patches.");
                            }
                            String[] rbPatchIDs = new String[]{rbPatchID};
                            OPatchEnv.setUserSuppliedPatchIDs(rbPatchIDs);
                            OPatchEnv.setSessionType("util");
                            OPatchEnv.setUtilOption("nrollback");
                            return OPatchSession.UTIL;
                        }
                        catch (Exception e29) {
                            OPatchEnv.setArgumentError(true, "Patch not present in the Oracle Home, Rollback cannot proceed");
                            return null;
                        }
                    }
                    if (OPatchEnv.getSessionType().equals("update")) {
                        return OPatchSession.UPDATE;
                    }
                    if (OPatchEnv.getSessionType().equals("createview")) {
                        if (!OPatchEnv.isHelp()) {
                            if (parser.getOptionValue(viewId) == null) {
                                OPatchEnv.setArgumentError(true, "Please specify a valid \"-view_id\" option.");
                                return null;
                            }
                            if (parser.getOptionValue(viewDir) == null) {
                                OPatchEnv.setArgumentError(true, "Please specify a valid \"-view_dir\" option.");
                                return null;
                            }
                            if (parser.getOptionValue(tagId) == null) {
                                OPatchEnv.setArgumentError(true, "Please specify a valid \"-tag_id\" option.");
                                return null;
                            }
                        }
                        return new CreateSession();
                    }
                    if (OPatchEnv.getSessionType().equals("lsviews")) {
                        return new ListSession();
                    }
                    if (OPatchEnv.getSessionType().equals("synchview")) {
                        if (!OPatchEnv.isHelp() && parser.getOptionValue(viewId) == null) {
                            OPatchEnv.setArgumentError(true, "Please specify a valid \"-view_id\" option.");
                            return null;
                        }
                        if (!OPatchEnv.isHelp() && parser.getOptionValue(tagId) == null) {
                            OPatchEnv.setArgumentError(true, "Please specify a valid \"-tag_id\" option.");
                            return null;
                        }
                        return new SynchSession();
                    }
                    if (OPatchEnv.getSessionType().equals("destroyview")) {
                        if (!OPatchEnv.isHelp() && parser.getOptionValue(viewId) == null) {
                            OPatchEnv.setArgumentError(true, "Please specify a valid \"-view_id\" option.");
                            return null;
                        }
                        return new DestroySession();
                    }
                    if (OPatchEnv.getSessionType().equals("detach")) {
                        return new DetachSession();
                    }
                    if (OPatchEnv.getSessionType().equals("attach")) {
                        return new AttachSession();
                    }
                    if (OPatchEnv.getSessionType().equals("tagbranch")) {
                        if (!OPatchEnv.isHelp() && parser.getOptionValue(tagId) == null) {
                            OPatchEnv.setArgumentError(true, "Please specify a valid \"-tag_id\" option.");
                            return null;
                        }
                        return new TagbranchSession();
                    }
                    if (OPatchEnv.getSessionType().equals("cleanup")) {
                        return new CleanupSession();
                    }
                    if (OPatchEnv.getSessionType().equals("iscasrepospresent")) {
                        return new IsCasReposPresentSession();
                    }
                }
                break block533;
            }
            for (int j3 = 0; subDirs != null && j3 < subDirs.length; ++j3) {
                String entry = subDirs[j3];
                if (entry.indexOf("etc") != -1) {
                    hasEtc = true;
                    continue;
                }
                if (entry.indexOf("files") != -1) {
                    hasFile = true;
                    continue;
                }
                if (entry.indexOf("bundle.xml") == -1) continue;
                hasBundle = true;
            }
            if (hasEtc && hasFile) {
                OPatchEnv.setPatchloc(tmpPatchLoc);
            } else if (hasBundle) {
                OPatchEnv.setPatchloc(tmpPatchLoc);
                boolean isEsysPatch = false;
                isEsysPatch = OPatchSessionHelper.checkIsEsysPatch(OPatchEnv.getPatchloc());
                if (isEsysPatch) {
                    OPatchEnv.setPatchFormat(4);
                } else {
                    OPatchEnv.setPatchFormat(3);
                }
            } else {
                String compositeXML = "";
                try {
                    compositeXML = CompositePatchObject.validateComposite(tmpPatchLoc);
                }
                catch (RuntimeException e30) {
                    OPatchEnv.setArgumentError(true, "Staged Patch Location \"" + tmpPatchLoc + "\" is not valid");
                    return null;
                }
                File compositeFile = new File(compositeXML);
                if (compositeFile.exists()) {
                    OPatchEnv.setPatchloc(tmpPatchLoc);
                    OPatchEnv.setPatchFormat(1);
                    OPatchEnv.setCompositeXMLPath(compositeXML);
                } else {
                    boolean mayBeNapplyBundle = false;
                    File[] subFiles = tmpPatchLocation.listFiles();
                    for (int i15 = 0; i15 < subFiles.length; ++i15) {
                        if (!subFiles[i15].isDirectory()) continue;
                        String[] grandDirs = subFiles[i15].list();
                        hasEtc = false;
                        hasFile = false;
                        for (int j4 = 0; grandDirs != null && j4 < grandDirs.length; ++j4) {
                            String entry = grandDirs[j4];
                            if (entry.indexOf("etc") != -1) {
                                hasEtc = true;
                                continue;
                            }
                            if (entry.indexOf("files") == -1) continue;
                            hasFile = true;
                        }
                        if (!hasEtc || !hasFile) continue;
                        mayBeNapplyBundle = true;
                        break;
                    }
                    if (!mayBeNapplyBundle) {
                        OPatchEnv.setArgumentError(true, "Staged Patch Location \"" + tmpPatchLoc + "\" is not valid");
                        return null;
                    }
                    OPatchEnv.setPatchloc(tmpPatchLoc);
                    OPatchEnv.setPatchFormat(2);
                }
            }
        }
        if (sType.equals("apply")) {
            if (OPatchEnv.getisAuto()) {
                return OPatchSession.APPLYDEPLOY;
            }
            return OPatchSession.APPLY;
        }
        if (sType.equals("rollback")) {
            if (OPatchEnv.getisAuto()) {
                return OPatchSession.ROLLBACKDEPLOY;
            }
            return OPatchSession.ROLLBACK;
        }
        if (sType.equals("version")) {
            return OPatchSession.VERSION;
        }
        if (sType.equals("lsinventory") || arg.equals("lsinv")) {
            return OPatchSession.LSINVENTORY;
        }
        if (sType.equals("lspatches")) {
            return OPatchSession.LSPATCHES;
        }
        if (sType.equals("query")) {
            return OPatchSession.QUERY;
        }
        if (sType.equals("fmw")) {
            return OPatchSession.FMW;
        }
        if (sType.equals("version")) {
            return null;
        }
        if (sType.equals("util")) {
            if (isUtilReadOnly) {
                OPatchSession.UTIL.setReadOnly(true);
            }
            return OPatchSession.UTIL;
        }
        if (sType.equals("prereq")) {
            return OPatchSession.PREREQ;
        }
        if (sType.equals("enablecas")) {
            return OPatchSession.ENABLECAS;
        }
        if (sType.equals("disablecas")) {
            return OPatchSession.DISABLECAS;
        }
        if (sType.equals("checkintegrity")) {
            return OPatchSession.CHECKINTEGRITY;
        }
        if (sType.equals("restoreintegrity")) {
            return OPatchSession.RESTOREINTEGRITY;
        }
        return null;
    }

    private static boolean validateApplyPatch(String patchLoc) {
        boolean hasEtc = false;
        boolean hasFile = false;
        boolean isComp = false;
        boolean isZip = false;
        File f2 = new File(patchLoc);
        isZip = patchLoc.endsWith(".zip");
        if (f2.exists() && f2.isDirectory()) {
            String[] subDirs = f2.list();
            for (int i2 = 0; subDirs != null && i2 < subDirs.length; ++i2) {
                String entry = subDirs[i2];
                if (entry.indexOf("etc") != -1) {
                    hasEtc = true;
                    continue;
                }
                if (entry.indexOf("files") == -1) continue;
                hasFile = true;
            }
        }
        String compositeXmlLocation = "";
        try {
            compositeXmlLocation = CompositePatchObject.validateComposite(patchLoc);
        }
        catch (RuntimeException e2) {
            OPatchEnv.setArgumentError(true, e2.getMessage());
            return false;
        }
        File compositeFile = new File(compositeXmlLocation);
        if (compositeFile.exists()) {
            isComp = true;
        }
        return isComp || hasEtc && hasFile || isZip;
    }

    private static String[] processOPatchProperties(String[] otherArgs) {
        OLogger.debug(new StringBuffer("CmdLineParser.processOPatchProperties() begins"));
        String[] nonPropArgs = new String[]{};
        if (otherArgs == null || otherArgs.length == 0) {
            OLogger.debug(new StringBuffer("CmdLineParser.processOPatchProperties() ends"));
            return nonPropArgs;
        }
        ArrayList<String> nonPropList = new ArrayList<String>();
        Properties cmdProp = OPatchEnv.getOPatchProperties();
        for (int i2 = 0; i2 < otherArgs.length; ++i2) {
            String s = otherArgs[i2];
            StringTokenizer tk = new StringTokenizer(s, "=");
            int size = tk.countTokens();
            String[] propertyPair = new String[2];
            propertyPair[1] = "";
            propertyPair[0] = "";
            int j2 = 0;
            while (tk.hasMoreTokens()) {
                if (j2 <= 1) {
                    propertyPair[j2] = tk.nextToken();
                } else {
                    StringBuffer tempBuff = new StringBuffer(propertyPair[1]);
                    tempBuff.append("=");
                    tempBuff.append(tk.nextToken());
                    propertyPair[1] = tempBuff.toString();
                }
                ++j2;
            }
            if (size >= 2) {
                StringBuffer buff = new StringBuffer("CmdLineParser detects (<Property>, <Value>) pair: (\"");
                buff.append(propertyPair[0]);
                buff.append("\", \"");
                buff.append(propertyPair[1]);
                buff.append("\")");
                OLogger.verbose(null, buff);
                cmdProp.setProperty(propertyPair[0], propertyPair[1]);
                continue;
            }
            nonPropList.add(otherArgs[i2]);
        }
        OPatchEnv.setOPatchProperties(cmdProp);
        if (nonPropList.size() > 0) {
            nonPropArgs = new String[nonPropList.size()];
            nonPropList.toArray(nonPropArgs);
        }
        OLogger.debug(new StringBuffer("CmdLineParser.processOPatchProperties() ends"));
        return nonPropArgs;
    }

    public static void main(String[] args) {
        CmdLineParser cmdParser = new CmdLineParser();
        CmdLineParser.parse(args);
    }
}

