/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import oracle.opatch.ConflictDetectable;
import oracle.opatch.JarActionHelper;
import oracle.opatch.JarActionTree;
import oracle.opatch.MultiJarUtil;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.RemoteShellPropagate;
import oracle.opatch.Restorable;
import oracle.opatch.SystemCall;
import oracle.opatch.Verifiable;
import oracle.opatch.opatchactions.OrderedPatchAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.ConflictHandler;

public class JarAction
extends OrderedPatchAction
implements Restorable,
RemoteShellPropagate,
ConflictDetectable,
Verifiable {
    private String jarName;
    private String jarPath;
    private String className;
    private String nonApplicableDesc;
    private String nonRollbackableDesc;
    private String backupForRollbackFailureDesc;
    private String errorMsg;
    private boolean builtFrom101 = false;
    private boolean isAlreadyPatched = false;
    private boolean isDuplicate = false;
    private boolean isTriedToBackUp = false;
    private String[] jarList;
    private String[] jarPathList;
    private String[] jarAbsPathList;

    public JarAction(PatchComponent pc, String jarName, String jarPath, String className, int lineNumber) throws NullPointerException, Exception {
        super(pc, lineNumber);
        if (jarName == null || jarPath == null || className == null) {
            String errMsg = "The jar action is null";
            if (jarName == null) {
                errMsg = errMsg + "The jar name is null";
            }
            if (jarPath == null) {
                errMsg = errMsg + "The file path is null";
            }
            if (className == null) {
                errMsg = errMsg + "The file name is null";
            }
            NullPointerException ne = new NullPointerException(errMsg);
            throw ne;
        }
        this.jarName = jarName;
        this.jarPath = PatchObjectUtil.filterString(jarPath);
        this.className = PatchObjectUtil.getPlatformDependentPath(className);
    }

    public String getJarName() {
        return this.jarName;
    }

    public void setDuplicate(boolean value) {
        this.isDuplicate = value;
    }

    public boolean isDuplicate() {
        return this.isDuplicate;
    }

    public String getJarPath() {
        return this.jarPath;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isMultiLevel() {
        return this.jarName.indexOf(":") != -1;
    }

    protected boolean isBuiltFrom101Home() {
        return this.builtFrom101;
    }

    public void setBuiltFrom101Home(boolean value) {
        this.builtFrom101 = value;
    }

    protected void setAlreadyPatched(boolean value) {
        this.isAlreadyPatched = true;
    }

    protected boolean isAlreadyPatched() {
        return this.isAlreadyPatched;
    }

    protected void setTriedToBackUp(boolean value) {
        this.isTriedToBackUp = true;
    }

    protected boolean isTriedToBackUp() {
        return this.isTriedToBackUp;
    }

    protected String getErrorMsg() {
        return this.errorMsg;
    }

    protected void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    protected String getRootJarName() {
        if (this.jarList != null && this.jarList[0] != null) {
            return this.jarList[0];
        }
        return "";
    }

    public boolean isNewFile(String oracleHomePath, String cookedPatchID, boolean beforeApply) {
        return false;
    }

    private boolean initializeJarListJarPathList(String oracleHomePath, String jarName, String jarPath, String className) {
        StringBuffer ap;
        StringBuffer buff = new StringBuffer("JarAction::processJarActionPaths()");
        OLogger.debug(buff);
        String[] tempJarList = jarName.split(":");
        String[] tempPathList = new String[tempJarList.length];
        String[] tempAbsPathList = new String[tempJarList.length];
        StringBuffer tmpB = null;
        if (tempJarList == null || tempJarList.length == 0) {
            buff = new StringBuffer("JarAction::processJarActionPaths(): tempJarList is NULL or zero, return false");
            OLogger.debug(buff);
            return false;
        }
        if (tempJarList.length > 0) {
            int i2;
            tempPathList[0] = this.getParentDirPath(oracleHomePath);
            tempAbsPathList[0] = this.getParentDirPath(oracleHomePath);
            String tmpClass = className;
            for (i2 = 0; i2 < tempJarList.length; ++i2) {
                tmpB = new StringBuffer(tempJarList[i2]);
                int lindex = tmpClass.indexOf(tmpB.toString());
                if (lindex == -1 || tmpClass.equals("")) {
                    buff = new StringBuffer("JarAction::processJarActionPaths(): Can't find substring \"");
                    buff.append(tmpB.toString());
                    buff.append("\" inside \"");
                    buff.append(tmpClass);
                    buff.append("\"");
                    buff.append(" or className is blank string. ");
                    OLogger.debug(buff);
                    return false;
                }
                String[] tmpPath = new String[2];
                tmpPath[0] = tmpClass.substring(0, lindex);
                if (tmpPath[0].endsWith(File.separator)) {
                    tmpPath[0] = tmpPath[0].length() > 1 ? tmpPath[0].substring(0, tmpPath[0].length() - 1) : "";
                }
                tmpPath[1] = tmpClass.substring(lindex + tmpB.toString().length());
                if (tmpPath.length <= 1) {
                    buff = new StringBuffer("JarAction::processJarActionPaths(): tmpPath length is <= 1, return false");
                    OLogger.debug(buff);
                    return false;
                }
                if (i2 == 0) {
                    tmpClass = tmpPath[1];
                    continue;
                }
                tempPathList[i2] = tmpPath[0];
                StringBuffer ap2 = new StringBuffer(tempAbsPathList[i2 - 1]);
                ap2.append(File.separator);
                ap2.append(tempPathList[i2]);
                tempAbsPathList[i2] = ap2.toString();
                tmpClass = tmpPath[1];
            }
            this.jarList = new String[tempJarList.length + 1];
            this.jarPathList = new String[tempJarList.length + 1];
            this.jarAbsPathList = new String[tempJarList.length + 1];
            for (i2 = 0; i2 < tempJarList.length; ++i2) {
                this.jarList[i2] = tempJarList[i2];
                this.jarPathList[i2] = tempPathList[i2];
                this.jarAbsPathList[i2] = tempAbsPathList[i2];
            }
            int lindex = tmpClass.lastIndexOf(File.separator);
            this.jarList[tempJarList.length] = tmpClass.substring(lindex + 1);
            this.jarPathList[tempJarList.length] = lindex >= 0 ? tmpClass.substring(0, lindex) : "";
            ap = new StringBuffer(this.jarAbsPathList[tempJarList.length - 1]);
            if (!this.jarPathList[tempJarList.length].equals("")) {
                ap.append(File.separator);
                ap.append(this.jarPathList[tempJarList.length]);
            }
        } else {
            buff = new StringBuffer("JarAction::processJarActionPaths(): tempJarList is <= zero, return false");
            OLogger.debug(buff);
            return false;
        }
        this.jarAbsPathList[tempJarList.length] = ap.toString();
        buff = new StringBuffer("JarAction::processJarActionPaths(): return true for successful parsing Jar path");
        OLogger.debug(buff);
        return true;
    }

    public String getChildPath() {
        String[] tempJarList = this.jarName.split(":");
        String[] tempChildClass = this.className.split(tempJarList[tempJarList.length - 1]);
        String childPath = tempChildClass[tempChildClass.length - 1];
        return childPath;
    }

    public String getCompleteFileListPath(String oracleHomePath) {
        if (!this.initializeJarListJarPathList(oracleHomePath, this.jarName, this.jarPath, this.className)) {
            StringBuffer buff = new StringBuffer("ProcessJarActionPaths() returned false");
            OLogger.debug(buff);
            return "";
        }
        StringBuffer buff = new StringBuffer(this.getParentFilePath(oracleHomePath));
        for (int i2 = 1; i2 < this.jarList.length - 1; ++i2) {
            buff.append(":");
            if (!this.jarPathList[i2].equals("") && !this.jarPathList[i2].startsWith(File.separator)) {
                buff.append(File.separator);
            }
            buff.append(this.jarPathList[i2]);
            if (!(this.jarList[i2].startsWith(File.separator) || !this.jarPathList[i2].equals("") && this.jarPathList[i2].endsWith(File.separator))) {
                buff.append(File.separator);
            }
            buff.append(this.jarList[i2]);
        }
        OLogger.debug(new StringBuffer("JarAction::getCompleteFileListPath() returns :" + buff.toString()));
        return buff.toString();
    }

    public String getParentFilePath(String oracleHomePath) {
        StringBuffer buff;
        if (!this.initializeJarListJarPathList(oracleHomePath, this.jarName, this.jarPath, this.className)) {
            buff = new StringBuffer("ProcessJarActionPaths() returned false");
            OLogger.debug(buff);
        }
        buff = new StringBuffer(this.getParentDirPath(oracleHomePath));
        buff.append(File.separator);
        buff.append(this.getRootJarName());
        return buff.toString();
    }

    public String getParentDirPath(String oracleHomePath) {
        StringBuffer tmpB = new StringBuffer();
        if (oracleHomePath == null) {
            oracleHomePath = "";
        }
        if (oracleHomePath.equals("") || !oracleHomePath.endsWith(File.separator)) {
            tmpB.append(oracleHomePath);
        }
        if (oracleHomePath.endsWith(File.separator)) {
            tmpB.append(oracleHomePath.substring(0, oracleHomePath.length()));
        }
        if (!this.jarPath.startsWith(File.separator)) {
            tmpB.append(File.separator);
            tmpB.append(this.jarPath);
        } else {
            tmpB.append(this.jarPath);
        }
        return tmpB.toString();
    }

    public ArrayList getFilesTouched(String oracleHomePath) {
        String[] s = new String[]{this.getChildPath(), this.getCompleteFileListPath(oracleHomePath)};
        ArrayList<String[]> a2 = new ArrayList<String[]>();
        a2.add(s);
        return a2;
    }

    public String getClassPath() {
        String temp = this.getChildPath();
        if (temp != null) {
            temp = temp.substring(1);
            if (File.separator.equals("\\")) {
                temp = temp.replace(File.separatorChar, '/');
            }
            return temp;
        }
        return "";
    }

    public String getSourceFile(String patchPath) {
        if (patchPath == null) {
            patchPath = File.separator;
        }
        StringBuffer buff = new StringBuffer(patchPath);
        buff.append(File.separator);
        buff.append("files");
        buff.append(File.separator);
        buff.append(this.className);
        return buff.toString();
    }

    public long getSpaceNeeded(String patchLocation) {
        File f2 = new File(this.getSourceFile(patchLocation));
        if (f2.exists()) {
            return f2.length();
        }
        return 0L;
    }

    public String toString() {
        int i2;
        StringBuffer buff = new StringBuffer();
        buff.append("[JarAction: jarName=\"");
        buff.append(this.jarName);
        buff.append("\", path=\"");
        buff.append(this.jarPath);
        buff.append("\", className=\"");
        buff.append(this.className);
        buff.append("\", lineNumber=\"");
        buff.append(this.lineNumber);
        buff.append("\", parentPath=\"");
        buff.append(this.getParentFilePath("%ORACLE_HOME%"));
        buff.append("\", childPath=\"");
        buff.append(this.getChildPath());
        buff.append("\", classPath=");
        buff.append(this.getClassPath());
        buff.append("\", jarList=\"");
        if (this.jarList == null) {
            buff.append("NULL jarList");
        } else {
            for (i2 = 0; i2 < this.jarList.length; ++i2) {
                buff.append("'");
                buff.append(this.jarList[i2]);
                buff.append("', ");
            }
        }
        buff.append("\", jarAbsPathList=\"");
        if (this.jarAbsPathList == null) {
            buff.append("NULL jarAbsPathList");
        } else {
            for (i2 = 0; i2 < this.jarAbsPathList.length; ++i2) {
                buff.append("'");
                buff.append(this.jarAbsPathList[i2]);
                buff.append("', ");
            }
        }
        buff.append("\", jarPathList=\"");
        if (this.jarPathList == null) {
            buff.append("NULL jarPathList");
        } else {
            for (i2 = 0; i2 < this.jarPathList.length; ++i2) {
                buff.append("'");
                buff.append(this.jarPathList[i2]);
                buff.append("', ");
            }
        }
        buff.append("\", sourcePath=\"");
        buff.append(this.getSourceFile("%patch_path%"));
        buff.append("\" rawJarAction=\" ");
        buff.append(this.getRawActionEntry());
        buff.append("\"]");
        return buff.toString();
    }

    public boolean restorable(String oracleHomePath, String cookedPatchID) {
        StringBuffer buff = new StringBuffer("JarAction::restorable()");
        OLogger.debug(buff);
        buff = new StringBuffer("  Action details: jarName = \"");
        buff.append(this.jarName);
        buff.append("\", jarPath = \"");
        buff.append(this.jarPath);
        buff.append("\", className = \"");
        buff.append(this.className);
        buff.append("\"");
        OLogger.debug(buff);
        if (!this.initializeJarListJarPathList(oracleHomePath, this.jarName, this.jarPath, this.className)) {
            buff = new StringBuffer("JarAction::restorable(): jarName = \"");
            buff.append(this.jarName);
            buff.append("\", jarPath = \"");
            buff.append(this.jarPath);
            buff.append("\", className = \"");
            buff.append(this.className);
            buff.append("\", return false.");
            OLogger.debug(buff);
            return false;
        }
        StringBuffer path = new StringBuffer(this.getParentDirPath(oracleHomePath));
        path.append(File.separator);
        path.append(this.jarList[0]);
        String src = path.toString();
        path = new StringBuffer(OPatchEnv.getBackupDirectoryPath(oracleHomePath, cookedPatchID));
        path.append(File.separator);
        path.append(this.jarPath);
        path.append(File.separator);
        path.append(this.jarName);
        String dst = path.toString();
        File srcFile = new File(src);
        File dstFile = new File(dst);
        if (srcFile.exists() && !srcFile.canRead() || srcFile.isDirectory()) {
            return false;
        }
        File parentFile = dstFile.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        return parentFile.exists() && parentFile.canWrite();
    }

    public void backupForRestore(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        StringBuffer buff = new StringBuffer("JarAction::backupForRestore()");
        OLogger.debug(buff);
        buff = new StringBuffer("JarAction::backupForRestore(): ");
        buff.append("jarName=\"");
        buff.append(this.jarName);
        buff.append("\", jarPath=\"");
        buff.append(this.jarPath);
        buff.append("\", className=\"");
        buff.append(this.className);
        buff.append("\"");
        OLogger.debug(buff);
        if (!this.initializeJarListJarPathList(oracleHomePath, this.jarName, this.jarPath, this.className)) {
            buff = new StringBuffer("JarAction::backupForRestore(): ");
            buff.append("Cannot parse the Jar path, jarName=\"");
            buff.append(this.jarName);
            buff.append("\", jarPath=\"");
            buff.append(this.jarPath);
            buff.append("\", className=\"");
            buff.append(this.className);
            buff.append("\"");
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
        StringBuffer path = new StringBuffer(this.getParentDirPath(oracleHomePath));
        path.append(File.separator);
        path.append(this.jarList[0]);
        String src = path.toString();
        path = new StringBuffer(OPatchEnv.getBackupDirectoryPath(oracleHomePath, cookedPatchID));
        path.append(File.separator);
        path.append(this.jarPath);
        path.append(File.separator);
        path.append(this.jarList[0]);
        String dst = path.toString();
        File srcFile = new File(src);
        File dstFile = new File(dst);
        if (!srcFile.exists() || !srcFile.canRead()) {
            buff = new StringBuffer("JarAction::backupForRestore(): source file \"");
            buff.append(src);
            buff.append("\" not exist, do not back up");
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
        buff = new StringBuffer("JarAction::backupForRestore(): copy file from \"");
        buff.append(src);
        buff.append("\" to \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        SystemCall.backupFile(srcFile, dstFile);
    }

    public void restore(String oracleHomePath, String sessionID, boolean apply, boolean rollback, String cookedPatchID) throws RuntimeException {
        if (!this.initializeJarListJarPathList(oracleHomePath, this.jarName, this.jarPath, this.className)) {
            return;
        }
        StringBuffer buff = new StringBuffer(OPatchEnv.getBackupDirectoryPath(oracleHomePath, sessionID));
        buff.append(File.separator);
        buff.append(this.jarPath);
        buff.append(File.separator);
        buff.append(this.getRootJarName());
        String src = buff.toString();
        buff = new StringBuffer(this.getParentDirPath(oracleHomePath));
        buff.append(File.separator);
        buff.append(this.getRootJarName());
        String dst = buff.toString();
        File srcFile = new File(src);
        File dstFile = new File(dst);
        try {
            if (srcFile.exists() && srcFile.canRead()) {
                SystemCall.backupFile(srcFile, dstFile);
            }
        }
        catch (RuntimeException e2) {
            OLogger.warn("OUI-67004", new Object[]{dstFile.toString(), srcFile.toString(), e2.getMessage()});
        }
    }

    public String getBackupForRestoreDesc(String oracleHomePath, String cookedPatchID) {
        StringBuffer buff = new StringBuffer();
        if (!this.initializeJarListJarPathList(oracleHomePath, this.jarName, this.jarPath, this.className)) {
            buff = new StringBuffer("JarAction::getBackupForRestoreDesc: jarName = \"");
            buff.append(this.jarName);
            buff.append("\", jarPath = \"");
            buff.append(this.jarPath);
            buff.append("\", className = \"");
            buff.append(this.className);
            buff.append("\", return false.");
            OLogger.debug(buff);
        }
        buff.append(this.getParentDirPath(oracleHomePath));
        buff.append(File.separator);
        buff.append(this.jarList[0]);
        return buff.toString();
    }

    public boolean rollbackable(String oracleHomePath, String cookedPatchID) {
        StringBuffer buff = new StringBuffer("JarAction::rollbackable()");
        OLogger.debug(buff);
        buff = new StringBuffer("  Action details: jarName = \"");
        if (this.jarName != null) {
            buff.append(this.jarName);
        }
        buff.append("\", jarPath = \"");
        if (this.jarPath != null) {
            buff.append(this.jarPath);
        }
        buff.append("\", className = \"");
        if (this.className != null) {
            buff.append(this.className);
        }
        buff.append("\"");
        OLogger.debug(buff);
        if (!this.initializeJarListJarPathList(oracleHomePath, this.jarName, this.jarPath, this.className)) {
            buff = new StringBuffer("JarAction::rollbackable(): jarName = \"");
            buff.append(this.jarName);
            buff.append("\", jarPath = \"");
            buff.append(this.jarPath);
            buff.append("\", className = \"");
            buff.append(this.className);
            buff.append("\", return false.");
            OLogger.debug(buff);
            return false;
        }
        if (this.isBuiltFrom101Home()) {
            String pathJarName = this.jarPath + File.separator + this.jarName;
            String justClassName = this.className.substring(pathJarName.length());
            StringBuffer path = new StringBuffer(oracleHomePath);
            path.append(File.separator);
            path.append(".patch_storage");
            path.append(File.separator);
            path.append(cookedPatchID);
            path.append(File.separator);
            path.append(this.jarPath);
            path.append(File.separator);
            path.append(justClassName);
            path.append("_");
            path.append(this.jarName);
            String preFileName = path.toString() + "_pre_" + cookedPatchID;
            File preF = new File(preFileName);
            if (preF.exists()) {
                if (!preF.canRead()) {
                    buff = new StringBuffer("Jar Action: Source file \"");
                    buff.append(preF.getAbsolutePath());
                    buff.append("\" is not readable.");
                    this.nonRollbackableDesc = buff.toString();
                    return false;
                }
                if (preF.isDirectory()) {
                    buff = new StringBuffer("Jar Action: Source file \"");
                    buff.append(preF.getAbsolutePath());
                    buff.append("\" is a directory.");
                    this.nonRollbackableDesc = buff.toString();
                    return false;
                }
            } else {
                String newFileName = path.toString() + "_opatch_new_" + cookedPatchID;
                File newF = new File(newFileName);
                if (!newF.exists()) {
                    buff = new StringBuffer("Jar Action: Source file \"");
                    buff.append(preF.getAbsolutePath());
                    buff.append("\" does not exists.");
                    this.nonRollbackableDesc = buff.toString();
                    return false;
                }
            }
            return true;
        }
        String psCookedPatchIDPath = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID);
        boolean isPSExist = this.checkPatchStorageExist(psCookedPatchIDPath);
        if (!isPSExist) {
            buff = new StringBuffer("Jar Action: Directory \"");
            buff.append(new File(psCookedPatchIDPath).getAbsolutePath());
            buff.append("\" does not exists or is not readable. ");
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        buff = new StringBuffer("JarAction::rollbackble() : calling OPatchEnv.getRollbackDirectoryPath()");
        OLogger.debug(buff);
        StringBuffer path = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        path.append(File.separator);
        path.append(this.className);
        buff = new StringBuffer("JarAction::rollbackable() : path = \"");
        buff.append(path);
        buff.append("\"");
        OLogger.debug(buff);
        String src = path.toString();
        String parentPath = this.getParentDirPath(oracleHomePath);
        buff = new StringBuffer("JarAction::rollbackable() : parentPath = \"");
        buff.append(parentPath);
        buff.append("\"");
        OLogger.debug(buff);
        path = new StringBuffer(parentPath);
        path.append(File.separator);
        path.append(this.jarList[0]);
        buff = new StringBuffer("JarAction::rollbackable() : parentPath changes to \"");
        buff.append(parentPath);
        buff.append("\"");
        OLogger.debug(buff);
        String dst = path.toString();
        File srcFile = new File(src);
        File dstFile = new File(dst);
        if (!dstFile.exists() || !dstFile.canRead()) {
            buff = new StringBuffer("Jar Action: Destination file \"");
            buff.append(dst);
            buff.append("\", does not exist or is not readable.");
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        if (dstFile.exists() && dstFile.isDirectory()) {
            buff = new StringBuffer("Jar Action: Destination file \"");
            buff.append(dstFile.getAbsolutePath());
            buff.append("\" is a directory.");
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        if (srcFile.exists() && !srcFile.canRead()) {
            buff = new StringBuffer("Jar Action: Source file \"");
            buff.append(src);
            buff.append("\", does not exist or is not readable.");
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        if (srcFile.isDirectory()) {
            buff = new StringBuffer("Jar Action: Source file \"");
            buff.append(dstFile.getAbsolutePath());
            buff.append("\" is a directory.");
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        File parentFile = srcFile.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        if (!parentFile.exists() || !parentFile.canRead()) {
            buff = new StringBuffer("Jar Action: Cannot mkdirs on \"");
            try {
                buff.append(parentFile.getCanonicalPath());
            }
            catch (Exception exception) {
                // empty catch block
            }
            buff.append("\".");
            this.nonRollbackableDesc = buff.toString();
            return false;
        }
        buff = new StringBuffer("JarAction::rollbackable() return true");
        OLogger.debug(buff);
        return true;
    }

    public String getRollbackScriptEntry(String oracleHomePath, String cookedPatchID) throws NullPointerException {
        StringBuffer buff = new StringBuffer("JarAction::getRollbackScriptEntry()");
        OLogger.debug(buff);
        buff = new StringBuffer("JarAction::getRollbackScriptEntry(): ");
        buff.append("jarName=\"");
        buff.append(this.jarName);
        buff.append("\", jarPath=\"");
        buff.append(this.jarPath);
        buff.append("\", className=\"");
        buff.append(this.className);
        buff.append("\"");
        OLogger.debug(buff);
        StringBuffer rollbackStr = new StringBuffer("\n");
        if (!this.initializeJarListJarPathList(oracleHomePath, this.jarName, this.jarPath, this.className)) {
            buff = new StringBuffer("JarAction::getRollbackScriptEntry(): ");
            buff.append("Cannot parse the Jar path, jarName=\"");
            buff.append(this.jarName);
            buff.append("\", jarPath=\"");
            buff.append(this.jarPath);
            buff.append("\", className=\"");
            buff.append(this.className);
            buff.append("\"");
            OLogger.debug(buff);
            return rollbackStr.toString();
        }
        boolean isWindow = OPatchEnv.isWindows();
        StringBuffer jarCommand = null;
        String[] systemCommand = null;
        File dstClassFile = null;
        StringBuffer path = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        path.append(File.separator);
        path.append(this.className);
        String src = path.toString();
        path = new StringBuffer(this.getParentDirPath(oracleHomePath));
        path.append(File.separator);
        path.append(this.jarList[0]);
        String dst = path.toString();
        File srcFile = new File(src);
        StringBuffer tmp = new StringBuffer("JarAction::getRollbackScriptEntry() extract file \"");
        tmp.append(src);
        tmp.append("\" to jar file ");
        tmp.append(dst);
        tmp.append("\"");
        OLogger.debug(tmp);
        systemCommand = new String[2];
        try {
            for (int i2 = 0; i2 < this.jarList.length - 1; ++i2) {
                jarCommand = new StringBuffer(OPatchEnv.getJarCommand_ExtractOption());
                if (!this.jarAbsPathList[i2].equals("")) {
                    jarCommand.append(this.jarAbsPathList[i2]);
                    jarCommand.append(File.separator);
                }
                jarCommand.append(this.jarList[i2]);
                jarCommand.append(" ");
                if (!this.jarPathList[i2 + 1].equals("")) {
                    jarCommand.append(this.jarPathList[i2 + 1]);
                    jarCommand.append(File.separator);
                }
                jarCommand.append(this.jarList[i2 + 1]);
                systemCommand[0] = jarCommand.toString();
                String runDir = this.jarAbsPathList[i2];
                rollbackStr.append("cd ");
                rollbackStr.append(runDir);
                rollbackStr.append("\n");
                rollbackStr.append(systemCommand[0]);
                rollbackStr.append("\n");
            }
            StringBuffer tmpJarPath = new StringBuffer(this.jarAbsPathList[this.jarList.length - 1]);
            tmpJarPath.append(File.separator);
            tmpJarPath.append(this.jarList[this.jarList.length - 1]);
            dstClassFile = new File(tmpJarPath.toString());
            if (isWindow) {
                rollbackStr.append("copy /Y ");
            } else {
                rollbackStr.append("\\cp -f ");
            }
            rollbackStr.append(srcFile.toString());
            rollbackStr.append(" ");
            rollbackStr.append(dstClassFile.toString());
            for (int i3 = this.jarList.length - 1; i3 > 0; --i3) {
                jarCommand = new StringBuffer(OPatchEnv.getJarCommand_UpdateOption());
                if (!this.jarAbsPathList[i3 - 1].equals("")) {
                    jarCommand.append(this.jarAbsPathList[i3 - 1]);
                    jarCommand.append(File.separator);
                }
                jarCommand.append(this.jarList[i3 - 1]);
                jarCommand.append(" -C ");
                jarCommand.append(this.jarAbsPathList[i3 - 1]);
                jarCommand.append(" ");
                if (!this.jarPathList[i3].equals("")) {
                    jarCommand.append(this.jarPathList[i3]);
                    jarCommand.append(File.separator);
                }
                jarCommand.append(this.jarList[i3]);
                systemCommand[0] = jarCommand.toString();
                String runDir = this.jarAbsPathList[i3 - 1];
                rollbackStr.append("\n");
                rollbackStr.append("cd ");
                rollbackStr.append(runDir);
                rollbackStr.append("\n");
                rollbackStr.append(systemCommand[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        OLogger.debug(new StringBuffer("JarAction::getRollbackScriptEntry() done"));
        return rollbackStr.toString();
    }

    protected String[] getJarList() {
        return this.jarList;
    }

    protected String[] getJarPathList() {
        return this.jarPathList;
    }

    public boolean applicable(String oracleHomePath, String patchLocation) {
        StringBuffer buff = new StringBuffer("JarAction::applicable() ");
        OLogger.debug(buff);
        buff = new StringBuffer("  class name = \"");
        buff.append(this.className);
        buff.append("\"");
        OLogger.debug(buff);
        if (!this.initializeJarListJarPathList(oracleHomePath, this.jarName, this.jarPath, this.className)) {
            buff = new StringBuffer("  processJarActionPaths() returns false");
            OLogger.debug(buff);
            buff = new StringBuffer("Jar action could not be processed, hence the action is not applicable.");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        String src = this.getSourceFile(patchLocation);
        StringBuffer tmpB = new StringBuffer(this.getParentDirPath(oracleHomePath));
        tmpB.append(File.separator);
        tmpB.append(this.jarList[0]);
        String dst = tmpB.toString();
        buff = new StringBuffer("  Action details: src = \"");
        buff.append(src);
        buff.append("\", dst = \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        File srcFile = new File(src);
        File dstFile = new File(dst);
        buff = new StringBuffer("  checking on source ");
        buff.append(src);
        OLogger.debug(buff);
        if (!srcFile.exists() || !srcFile.canRead()) {
            buff = new StringBuffer("Jar Action: Source File \"");
            buff.append(src);
            buff.append("\" does not exists or is not readable");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        if (srcFile.length() <= 0L) {
            buff = new StringBuffer("Jar Action: Source File \"");
            buff.append(src);
            buff.append("\" is a zero-byte file");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        buff = new StringBuffer("  checking on destination ");
        buff.append(dst);
        OLogger.debug(buff);
        if (!dstFile.exists() || !OPatchSessionHelper.CanWrite(oracleHomePath, dstFile)) {
            buff = new StringBuffer("Jar Action: Destination File \"");
            buff.append(dst);
            buff.append("\" does not exists or is not writeable");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        return true;
    }

    public static void dumpJarEntry(JarFile f2) {
        if (f2 != null) {
            StringBuffer buff = new StringBuffer("JarFile \"");
            buff.append(f2.getName());
            buff.append("\":");
            OLogger.printlnOnLog(OLogger.INFO, buff.toString());
            Enumeration<JarEntry> entries = f2.entries();
            while (entries.hasMoreElements()) {
                JarEntry obj = entries.nextElement();
                if (!(obj instanceof JarEntry)) continue;
                JarEntry je = obj;
                String name = je.getName();
                buff = new StringBuffer(" \"");
                buff.append(name);
                buff.append("\"");
                OLogger.printlnOnLog(OLogger.INFO, buff.toString());
            }
        }
    }

    public String getApplicableDesc(String oracleHomePath, String owningComp) {
        StringBuffer dst = new StringBuffer(oracleHomePath);
        dst.append(File.separator);
        dst.append(this.getJarPath());
        dst.append(File.separator);
        dst.append(this.getJarName());
        String src = this.getChildPath();
        String desc = this.nonApplicableDesc + "\n" + OLogger.getString("OUI-67153", new Object[]{owningComp, dst, src});
        return desc;
    }

    public String getRollbackableDesc(String oracleHomePath, String owningComp) {
        StringBuffer dst = new StringBuffer(oracleHomePath);
        dst.append(File.separator);
        dst.append(this.getJarPath());
        dst.append(File.separator);
        dst.append(this.getJarName());
        String src = this.getChildPath();
        String desc = this.nonRollbackableDesc + "\n" + OLogger.getString("OUI-67153", new Object[]{owningComp, dst, src});
        return desc;
    }

    public String getBackupForRollbackDesc(String oracleHomePath) {
        return this.backupForRollbackFailureDesc;
    }

    public void setBackupForRollbackDesc(String msg) {
        this.backupForRollbackFailureDesc = msg;
    }

    public String getFilePathToPropagate(String oracleHomePath) throws RuntimeException {
        return this.getParentFilePath(oracleHomePath);
    }

    public boolean conflictDetectable(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("JarAction::conflictDetectable()  ");
        boolean tmpB = this.initializeJarListJarPathList(oracleHomePath, this.jarName, this.jarPath, this.className);
        buff.append(tmpB);
        OLogger.debug(buff);
        return tmpB;
    }

    public String[] filesTouched(String oracleHomePath) throws RuntimeException {
        String[] filesList = new String[]{};
        if (!this.initializeJarListJarPathList(oracleHomePath, this.jarName, this.jarPath, this.className)) {
            return filesList;
        }
        if (this.jarPathList.length > 0) {
            filesList = new String[this.jarPathList.length];
            for (int i2 = 0; i2 < this.jarPathList.length; ++i2) {
                StringBuffer tmpS = new StringBuffer(this.jarPathList[i2]);
                tmpS.append(File.separator);
                tmpS.append(this.jarList[i2]);
                filesList[i2] = tmpS.toString();
            }
        }
        return filesList;
    }

    public String checkConflict(String oracleHomePath, OneOffEntry[] oneoffs) throws RuntimeException {
        return ConflictHandler.checkCommonConflict(oracleHomePath, oneoffs, this);
    }

    public boolean equals(Object o2) {
        if (o2 instanceof JarAction) {
            String myName = this.getJarName();
            String myPath = this.getJarPath();
            String myClass = this.getClassName();
            JarAction ja = (JarAction)o2;
            String itName = ja.getJarName();
            String itPath = ja.getJarPath();
            String itClass = ja.getClassName();
            if (myName.equals(itName) && myPath.equals(itPath) && myClass.equals(itClass)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.jarName.length();
        result = 37 * result + this.className.length();
        result = 37 * result + this.jarPath.length();
        return result;
    }

    public String getActionName() {
        return "JarAction";
    }

    public String getActionDesc() {
        return "Jar a file into jar/ear/war.";
    }

    public String getApplyDescription(String oracleHomePath) {
        return "Jar the given class file into the jar inside ORACLE_HOME.";
    }

    public String getRollbackDescription(String oracleHomePath) {
        return "Jar the backup file into the jar inside ORACLE_HOME.";
    }

    public int getBackupForRollbackFileNumber(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        return 1;
    }

    public void apply(String oracleHomePath, String patchLocation) throws RuntimeException {
        int i2;
        StringBuilder msg1 = new StringBuilder();
        msg1.append(this.getParentFilePath(oracleHomePath));
        OLogger.onlyLogInfo("OUI-67048", new Object[]{msg1.toString(), this.getClassName()});
        if (this.isDuplicate || this.isAlreadyPatched || !this.isAppliedOK()) {
            OLogger.printlnOnLogAndVerbose("This jar action is already considered as part of clubbed actions.");
            return;
        }
        OLogger.printlnOnLogAndVerbose("Going to patch Jar Action(s) in a consolidated mode.");
        StringBuffer dst = new StringBuffer(oracleHomePath);
        dst.append(File.separator);
        dst.append(this.getJarPath());
        dst.append(File.separator);
        dst.append(this.getRootJarName());
        OLogger.printlnOnLogAndVerbose("Jar Path -> " + dst.toString());
        String curJarPath = this.getJarPath();
        if (!curJarPath.startsWith(File.separator)) {
            curJarPath = File.separator + curJarPath;
        }
        JarActionTree.TreeNode curNode = new JarActionTree.TreeNode(0, this.getRootJarName(), curJarPath, null);
        boolean calledDirectly = JarActionTree.getRoot().isLeaf();
        if (calledDirectly) {
            JarActionTree.addJarActionNodes(oracleHomePath, this, JarActionTree.getRoot());
        }
        ArrayList childs = JarActionTree.getRoot().getChilds();
        ArrayList myList = new ArrayList();
        for (i2 = 0; i2 < childs.size(); ++i2) {
            JarActionTree.TreeNode topLevelNode = (JarActionTree.TreeNode)childs.get(i2);
            if (!topLevelNode.equals(curNode)) continue;
            MultiJarUtil.getAllLeavesForNode(topLevelNode, myList, MultiJarUtil.JarOperation.APPLY, false, "");
            break;
        }
        OLogger.printlnOnLogAndVerbose("--- Clubbed Actions for this Jar Path to patch NOW -> ");
        for (i2 = 0; i2 < myList.size(); ++i2) {
            JarAction ja = (JarAction)myList.get(i2);
            OLogger.justlog(OLogger.INFO, ja.getChildPath());
        }
        OLogger.logTime(new StringBuffer("Apply starts for the clubbed jars at --> "));
        HashMap failedMap = JarActionHelper.apply(oracleHomePath, patchLocation, this);
        OLogger.logTime(new StringBuffer("Apply ends for the clubbed jars at --> "));
        OLogger.printlnOnLog("");
        if (calledDirectly) {
            JarActionTree.getRoot().setChilds(null);
        }
        Iterator keys = failedMap.keySet().iterator();
        StringBuffer msg = new StringBuffer();
        while (keys.hasNext()) {
            String className = keys.next().toString();
            JarAction ja = (JarAction)failedMap.get(className);
            msg.append(OLogger.getString("OUI-67203", new Object[]{ja.getSourceFile(patchLocation), dst.toString(), ja.getErrorMsg()}) + "\n");
        }
        if (msg.length() > 0) {
            throw new RuntimeException(msg.toString());
        }
    }

    public HashMap backupForRollback(String oracleHomePath, String cookedPatchID, PatchObject po) throws RuntimeException {
        int i2;
        OLogger.printlnOnLogAndVerbose("Going to backup for rollback Jar Action(s) in a consolidated mode.");
        StringBuffer dst = new StringBuffer(oracleHomePath);
        dst.append(File.separator);
        dst.append(this.getJarPath());
        dst.append(File.separator);
        dst.append(this.getRootJarName());
        OLogger.printlnOnLogAndVerbose("Jar Path -> " + dst.toString());
        String curJarPath = this.getJarPath();
        if (!curJarPath.startsWith(File.separator)) {
            curJarPath = File.separator + curJarPath;
        }
        JarActionTree.TreeNode curNode = new JarActionTree.TreeNode(0, this.getRootJarName(), curJarPath, null);
        ArrayList childs = JarActionTree.getRoot().getChilds();
        ArrayList myList = new ArrayList();
        for (i2 = 0; i2 < childs.size(); ++i2) {
            JarActionTree.TreeNode topLevelNode = (JarActionTree.TreeNode)childs.get(i2);
            if (!topLevelNode.equals(curNode)) continue;
            MultiJarUtil.getAllLeavesForNode(topLevelNode, myList, MultiJarUtil.JarOperation.BACKUPFORROLLBACK, false, "");
            break;
        }
        OLogger.printlnOnLogAndVerbose("--- Clubbed Actions for this Jar Path to backup for rollback NOW -> ");
        for (i2 = 0; i2 < myList.size(); ++i2) {
            JarAction ja = (JarAction)myList.get(i2);
            OLogger.justlog(OLogger.INFO, ja.getChildPath());
        }
        OLogger.logTime(new StringBuffer("Backup For Rollback starts for the clubbed jars at --> "));
        HashMap failedMap = JarActionHelper.backupForRollBack(oracleHomePath, cookedPatchID, this);
        OLogger.logTime(new StringBuffer("Backup For Rollback ends for the clubbed jars at ---> "));
        OLogger.printlnOnLog("");
        return failedMap;
    }

    public void backupForRollback(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        if (JarActionTree.getRoot().isLeaf()) {
            JarActionTree.addJarActionNodes(oracleHomePath, this, JarActionTree.getRoot());
        }
        this.backupForRollback(oracleHomePath, cookedPatchID, new PatchObject());
        JarActionTree.getRoot().setChilds(null);
    }

    public void rollback(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        int i2;
        StringBuilder tmpB = new StringBuilder("JarAction::rollback()");
        tmpB.append(" executes Jar line ");
        tmpB.append(this.getLineNumber());
        OLogger.debug(tmpB.toString());
        if (this.isDuplicate() || this.isAlreadyPatched() || !this.isRollbackOK()) {
            StringBuffer fileToRollbackFrom = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
            fileToRollbackFrom.append(File.separator);
            fileToRollbackFrom.append(this.getClassName());
            OLogger.onlyLogInfo("OUI-67048", new Object[]{this.getParentFilePath(oracleHomePath), fileToRollbackFrom.toString()});
            OLogger.printlnOnLogAndVerbose("This jar action is already considered as part of clubbed actions.");
            return;
        }
        StringBuffer dst = new StringBuffer(oracleHomePath);
        dst.append(File.separator);
        dst.append(this.getJarPath());
        dst.append(File.separator);
        dst.append(this.getRootJarName());
        OLogger.printlnOnLogAndVerbose("Jar Path -> " + dst.toString());
        String curJarPath = this.getJarPath();
        if (!curJarPath.startsWith(File.separator)) {
            curJarPath = File.separator + curJarPath;
        }
        JarActionTree.TreeNode curNode = new JarActionTree.TreeNode(0, this.getRootJarName(), curJarPath, null);
        boolean calledDirectly = JarActionTree.getRoot().isLeaf();
        if (calledDirectly) {
            JarActionTree.addJarActionNodes(oracleHomePath, this, JarActionTree.getRoot());
        }
        ArrayList childs = JarActionTree.getRoot().getChilds();
        ArrayList myList = new ArrayList();
        for (i2 = 0; i2 < childs.size(); ++i2) {
            JarActionTree.TreeNode topLevelNode = (JarActionTree.TreeNode)childs.get(i2);
            if (!topLevelNode.equals(curNode)) continue;
            MultiJarUtil.getAllLeavesForNode(topLevelNode, myList, MultiJarUtil.JarOperation.ROLLBACK, false, "");
            break;
        }
        OLogger.printlnOnLogAndVerbose("--- Clubbed Actions for this Jar Path to patch NOW -> ");
        for (i2 = 0; i2 < myList.size(); ++i2) {
            JarAction ja = (JarAction)myList.get(i2);
            OLogger.justlog(OLogger.INFO, ja.getChildPath());
        }
        String rollbackPatchLocation = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID);
        OLogger.logTime(new StringBuffer("Rollback starts for the clubbed jars at --> "));
        StringBuffer fileToRollbackFrom = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        fileToRollbackFrom.append(File.separator);
        fileToRollbackFrom.append(this.getClassName());
        OLogger.onlyLogInfo("OUI-67048", new Object[]{this.getParentFilePath(oracleHomePath), fileToRollbackFrom.toString()});
        HashMap failedMap = JarActionHelper.rollback(oracleHomePath, cookedPatchID, this);
        OLogger.logTime(new StringBuffer("Rollback ends for the clubbed jars at --> "));
        OLogger.printlnOnLog("");
        if (calledDirectly) {
            JarActionTree.getRoot().setChilds(null);
        }
        Iterator keys = failedMap.keySet().iterator();
        StringBuffer msg = new StringBuffer();
        while (keys.hasNext()) {
            String className = keys.next().toString();
            JarAction ja = (JarAction)failedMap.get(className);
            fileToRollbackFrom = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
            fileToRollbackFrom.append(File.separator);
            fileToRollbackFrom.append(ja.getClassName());
            msg.append(OLogger.getString("OUI-67202", new Object[]{fileToRollbackFrom.toString(), dst.toString(), ja.getErrorMsg()}) + "\n");
        }
        if (msg.length() > 0) {
            throw new RuntimeException(msg.toString());
        }
    }

    public boolean verify(String oracleHomePath, String patchLocation) throws IOException {
        if (JarActionTree.getRoot().isLeaf()) {
            JarActionTree.addJarActionNodes(oracleHomePath, this, JarActionTree.getRoot());
        }
        HashMap failed = JarActionHelper.verify(oracleHomePath, patchLocation);
        JarActionTree.getRoot().setChilds(null);
        return failed.size() <= 0;
    }
}

