/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Serializable;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OUIReplacer;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchingModel;
import oracle.opatch.Rules;
import oracle.opatch.SystemCall;
import oracle.opatch.opatchlogger.OLogger;

public class PreScriptAction
extends PatchAction
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 3274365384114696148L;
    private File preScriptFile = null;
    private boolean realEmptyAction = true;
    private String preOptions;
    private String topLevelOperation;
    private String topLevelPatchID;

    public PreScriptAction() {
    }

    protected void makeNoOp() {
        this.noOp = true;
    }

    public boolean isRealEmpty() {
        return this.realEmptyAction;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public PreScriptAction(String preScriptLoc) {
        super(-1);
        if (PatchingModel.returnModelCode(OPatchEnv.getOracleHome()) == 2) {
            this.noOp = true;
            return;
        }
        try {
            this.preScriptFile = new File(preScriptLoc);
            if (!this.preScriptFile.exists()) {
                this.noOp = true;
            } else {
                this.noOp = false;
                this.realEmptyAction = false;
            }
        }
        catch (Exception e2) {
            OLogger.debug(new StringBuffer("PreScriptAction::PreScriptAction(): IOException, set to no-op"));
            this.noOp = true;
        }
    }

    public int process(String preOptions, String topLevelOperation, String topLevelPatchID) {
        boolean cont = Rules.SystemWrite_continue();
        if (!this.noOp) {
            StringBuffer ts = new StringBuffer("Start the Apply preScript at ");
            OLogger.logTime(ts);
            StringBuffer tmpB = new StringBuffer("Executing pre script file: ");
            tmpB.append(this.preScriptFile.toString());
            OLogger.debug(tmpB);
            SystemCall.ExecReturn ret = null;
            String[] systemCommand = new String[1];
            try {
                systemCommand[0] = OPatchEnv.isWindows() ? "cmd /C \"" + this.preScriptFile.getCanonicalPath() + "\" " + preOptions : "sh " + this.preScriptFile.getCanonicalPath() + " " + preOptions;
            }
            catch (Exception e2) {
                OLogger.error("OUI-67034", new Object[]{"getCanonicalPath", e2.getMessage()});
            }
            String runDir = this.preScriptFile.getParent();
            String[] envp = null;
            envp = topLevelOperation != null && topLevelPatchID != null ? new String[]{"OPATCH_OPERATION=" + topLevelOperation, "OPATCH_PATCHID=" + topLevelPatchID, "ORACLE_HOME=" + OPatchEnv.getOracleHome(), "PATH=" + System.getProperty("OPatch.PATH")} : (topLevelOperation == null && topLevelPatchID != null ? new String[]{"OPATCH_PATCHID=" + topLevelPatchID, "ORACLE_HOME=" + OPatchEnv.getOracleHome(), "PATH=" + System.getProperty("OPatch.PATH")} : (topLevelOperation != null && topLevelPatchID == null ? new String[]{"OPATCH_OPERATION=" + topLevelOperation, "ORACLE_HOME=" + OPatchEnv.getOracleHome(), "PATH=" + System.getProperty("OPatch.PATH")} : new String[]{"ORACLE_HOME=" + OPatchEnv.getOracleHome(), "PATH=" + System.getProperty("OPatch.PATH")}));
            if (!cont) {
                int i2;
                StringBuffer buff = new StringBuffer("REPORT: skips executing PreScriptAction::process()");
                OLogger.log(OLogger.FINEST, buff.toString());
                buff = new StringBuffer("Report: command is [");
                for (i2 = 0; systemCommand != null && i2 < systemCommand.length; ++i2) {
                    buff.append(systemCommand[i2]).append(", ");
                }
                buff.append("], env is [");
                for (i2 = 0; envp != null && i2 < envp.length; ++i2) {
                    buff.append(envp[i2]).append(", ");
                }
                buff.append("]");
                OLogger.println(buff.toString());
                return 0;
            }
            SystemCall.setConsoleOutput(true);
            StringBuffer buff = new StringBuffer("Output of pre script: ");
            buff.append(this.preScriptFile.toString());
            OLogger.debug(buff);
            String headerStr = OLogger.getString("OUI-67604", new Object[]{systemCommand[0]});
            OLogger.printlnOnLog(headerStr);
            ret = SystemCall.runtimeExec(systemCommand, envp, runDir);
            Integer tmpI = new Integer(ret.getReturnCode());
            String tailStr = OLogger.getString("OUI-67605", new Object[]{tmpI.toString()});
            OLogger.printlnOnLog(tailStr);
            SystemCall.setConsoleOutput(false);
            String outputStr = OLogger.getString("OUI-67102", new Object[]{systemCommand[0], ret.getNormalMessage(), tmpI.toString()});
            String envVal = OUIReplacer.getEnv("OPATCH_LOG_PREPOST_ARGS");
            Boolean boolVal = new Boolean(envVal);
            boolean isCmdToLog = boolVal;
            if (isCmdToLog) {
                OLogger.printlnOnLog(OLogger.INFO, outputStr);
            } else {
                String logStr = OLogger.getString("OUI-67102", new Object[]{" Command and arguments of pre/post scripts is restricted to be viewed in log file ", ret.getNormalMessage(), tmpI.toString()});
                OLogger.printlnOnLog(OLogger.INFO, logStr);
            }
            if (!ret.isOK()) {
                OLogger.info("OUI-67021", new Object[]{ret.getErrorMessage(), tmpI.toString()});
            }
            ts = new StringBuffer("Finish the Apply preScript at ");
            OLogger.logTime(ts);
            return ret.getReturnCode();
        }
        OLogger.debug(new StringBuffer("PreScriptAction::process() is a no-op"));
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String filePath = "n/a";
        if (this.preScriptFile != null) {
            filePath = this.preScriptFile.getPath();
        }
        String header = "[PreScriptAction:-------------------------------\n";
        StringBuffer sb = new StringBuffer(header);
        sb.append("no-op.=");
        sb.append(this.noOp);
        sb.append(", fileLoc=");
        sb.append(filePath);
        sb.append("\n");
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(new FileInputStream(this.preScriptFile)));
            String line = "";
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        catch (FileNotFoundException e2) {
            sb.append("Pre script is not present.");
        }
        catch (Exception e3) {
            sb.append("Error reading file ");
            sb.append(e3.getMessage());
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e4) {
                    sb.append("Error closing file ");
                    sb.append(e4.getMessage());
                }
            }
        }
        sb.append("-----------------------------------------------]\n");
        return sb.toString();
    }

    public String getChildPath() {
        return "";
    }

    public String getParentFilePath(String oracleHomePath) {
        return this.preScriptFile.getAbsolutePath();
    }

    public String getActionName() {
        return "PreScriptAction";
    }

    public String getActionDesc() {
        return "Run the pre script of the patch.";
    }

    public boolean isNewFile(String oracleHomePath, String cookedPatchID, boolean beforeApply) {
        return false;
    }

    public PreScriptAction setScriptArguments(String opt, String op, String patchId) {
        this.preOptions = opt;
        this.topLevelOperation = op;
        this.topLevelPatchID = patchId;
        return this;
    }

    public int process() {
        if (!this.realEmptyAction) {
            this.noOp = false;
        }
        return this.process(this.preOptions, this.topLevelOperation, this.topLevelPatchID);
    }

    public static void main(String[] args) {
        try {
            OPatchACL.invokeOLogger(new PreScriptAction(), "setDebug", new Object[]{true});
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        String fileLoc = "C:\\projects\\opatch\\patches\\300100\\custom\\scripts\\pre.bat";
        PreScriptAction preScriptAction = new PreScriptAction(fileLoc);
        int result = preScriptAction.process("-rollback 132334", "rollback", "12345");
        String postScriptContent = preScriptAction.toString();
        System.out.println(postScriptContent);
    }
}

