/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import oracle.opatch.Help;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSDK;
import oracle.opatch.OPatchSession;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.PrereqFailedException;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.IPM;
import oracle.opatch.opatchlogger.OLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VersionSession
extends OPatchSession
implements Help {
    private static boolean minVerSet = false;
    private static String version_v2c = "";

    protected VersionSession(String name, boolean readOnly) {
        super(name, readOnly);
    }

    public boolean isReadOnly() {
        this.readOnly = true;
        return true;
    }

    public void process(String oracleHomePath) throws RuntimeException {
        block37: {
            RuntimeException re = null;
            String tmpOracleHome = oracleHomePath;
            try {
                OPatchStateManagerFactory.getInstance().setCurrentState("OPatch version check");
                boolean optAll = OPatchEnv.isVersionAll();
                boolean optOhs = false;
                String[] filterOhStrs = OPatchEnv.getVersionOhs();
                if (!(optAll || filterOhStrs != null && filterOhStrs.length != 0 || oracleHomePath == null)) {
                    filterOhStrs = new String[]{oracleHomePath};
                }
                if (filterOhStrs != null && filterOhStrs.length != 0) {
                    optOhs = true;
                }
                if (!optAll && !optOhs) break block37;
                version_v2c = OPatchEnv.getVersionV2c();
                if (!version_v2c.equals("")) {
                    minVerSet = true;
                } else {
                    version_v2c = "0.0.0.0.0";
                }
                String patchloc = OPatchEnv.getPatchloc();
                if (!patchloc.equals("")) {
                    boolean isGIPatch = false;
                    try {
                        File patchTopLoc = new File(patchloc);
                        if (patchTopLoc.exists()) {
                            File[] files = patchTopLoc.listFiles();
                            for (int i2 = 0; i2 < files.length; ++i2) {
                                if (!files[i2].getName().equals("bundle.xml")) continue;
                                Document document = PatchObjectUtil.parseXMLFile(files[i2]);
                                NodeList entityList = document.getElementsByTagName("entity");
                                for (int j2 = 0; j2 < entityList.getLength(); ++j2) {
                                    Node entity = entityList.item(j2);
                                    String bundleLoc = patchTopLoc + File.separator + entity.getAttributes().item(0).getNodeValue();
                                    PatchObject po = PatchObject.getInstance(bundleLoc);
                                    String poMinReqVer = po.getPatchInventory().getMinOPatchVersion();
                                    if (poMinReqVer == null || poMinReqVer.equals("") || VersionSession.isGreaterDecimal(poMinReqVer, version_v2c) == -1) continue;
                                    version_v2c = poMinReqVer;
                                }
                                isGIPatch = true;
                                break;
                            }
                            if (!isGIPatch) {
                                PatchObject po = PatchObject.getInstance(patchloc);
                                String poMinReqVer = po.getPatchInventory().getMinOPatchVersion();
                                if (poMinReqVer == null || poMinReqVer.equals("")) {
                                    poMinReqVer = "0.0.0.0.0";
                                }
                                version_v2c = poMinReqVer;
                            }
                            if (!minVerSet && version_v2c.equals("0.0.0.0.0")) {
                                OPatchStateManagerFactory.getInstance().setErrorCode(31);
                                throw new PrereqFailedException(OLogger.getString("OUI-67734"));
                            }
                            minVerSet = true;
                        }
                    }
                    catch (PrereqFailedException e2) {
                        throw e2;
                    }
                    catch (Exception e3) {
                        throw new RuntimeException(OLogger.getString("OUI-67100", new Object[]{"OPatch", patchloc}), e3);
                    }
                }
                HashMap<String, String> goodVersionMap = new HashMap<String, String>();
                HashMap<String, String> ohDoNotExistMap = new HashMap<String, String>();
                HashMap<String, String> badVersionMap = new HashMap<String, String>();
                HashMap<String, String> opatchDoNotExistMap = new HashMap<String, String>();
                ArrayList<String> filterOhList = null;
                if (filterOhStrs != null) {
                    filterOhList = new ArrayList<String>();
                    for (int i3 = 0; i3 < filterOhStrs.length; ++i3) {
                        filterOhList.add(filterOhStrs[i3]);
                    }
                }
                IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
                boolean isLocked = readServices.isLocked();
                try {
                    block38: {
                        try {
                            int index;
                            if (!isLocked) {
                                readServices.lock(oracleHomePath);
                            }
                            OPatchSDK.OracleHome[] oracleHomes = readServices.getOracleHomes();
                            int ohLength = 0;
                            int ohSize = oracleHomes.length;
                            if (filterOhList != null) {
                                ohSize += filterOhList.size();
                            }
                            String[] preOracleHomes = new String[ohSize];
                            for (index = 0; index < oracleHomes.length; ++index) {
                                preOracleHomes[index] = oracleHomes[index].getLocation();
                            }
                            while (index < ohSize) {
                                preOracleHomes[index] = (String)filterOhList.get(index - oracleHomes.length);
                                ++index;
                            }
                            for (int i4 = 0; i4 < ohSize; ++i4) {
                                String loc = preOracleHomes[i4];
                                if (filterOhList != null && !filterOhList.contains(loc)) continue;
                                if (ohLength < loc.length()) {
                                    ohLength = loc.length();
                                }
                                tmpOracleHome = loc;
                                File OHFile = new File(loc);
                                if (!OHFile.exists()) {
                                    ohDoNotExistMap.put(loc, "n/a");
                                    continue;
                                }
                                String opatchVersion = VersionSession.retrieveSpecOPatchVersion(loc);
                                if (opatchVersion.equals("n/a")) {
                                    opatchDoNotExistMap.put(loc, opatchVersion);
                                    continue;
                                }
                                if (VersionSession.isGreaterDecimal(opatchVersion, version_v2c) != -1) {
                                    goodVersionMap.put(loc, opatchVersion);
                                    continue;
                                }
                                badVersionMap.put(loc, opatchVersion);
                            }
                            this.printWarnMsgForVersionNotFound(ohDoNotExistMap, opatchDoNotExistMap, badVersionMap);
                            VersionSession.sortAndPrintOPatchVersion(goodVersionMap, ohLength);
                            VersionSession.printBadVersionOH(ohDoNotExistMap, opatchDoNotExistMap, badVersionMap, ohLength);
                            if (badVersionMap.size() != 0) {
                                OPatchStateManagerFactory.getInstance().setErrorCode(31);
                                if (OPatchEnv.getVersionV2c().equals("")) {
                                    throw new PrereqFailedException(OLogger.getString("OUI-67731"));
                                }
                                throw new PrereqFailedException(OLogger.getString("OUI-67733"));
                            }
                            if (!minVerSet) break block38;
                            OLogger.printlnres("OUI-67732");
                        }
                        catch (RuntimeException e4) {
                            throw e4;
                        }
                        catch (Throwable t) {
                            throw t;
                        }
                    }
                    Object var25_36 = null;
                    if (!isLocked) {
                        readServices.release();
                    }
                }
                catch (Throwable throwable) {
                    Object var25_37 = null;
                    if (!isLocked) {
                        readServices.release();
                    }
                    throw throwable;
                }
            }
            catch (RuntimeException e5) {
                throw e5;
            }
            catch (Throwable t) {
                OLogger.error("OUI-67720", new Object[]{tmpOracleHome, "VersionSession::process()"});
                re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
        }
    }

    private void printWarnMsgForVersionNotFound(Map ohDoNotExistMap, Map opatchDoNotExistMap, Map badVersionMap) {
        int i2;
        StringBuffer buff = new StringBuffer("");
        if (ohDoNotExistMap.size() != 0) {
            Object[] locArray1 = new Object[ohDoNotExistMap.size()];
            locArray1 = ohDoNotExistMap.keySet().toArray();
            buff.append(OLogger.getString("OUI-67723"));
            for (i2 = 0; i2 < ohDoNotExistMap.size(); ++i2) {
                buff.append((String)locArray1[i2]);
                buff.append("\n");
            }
        }
        if (opatchDoNotExistMap.size() != 0) {
            Object[] locArray2 = new Object[opatchDoNotExistMap.size()];
            locArray2 = opatchDoNotExistMap.keySet().toArray();
            buff.append(OLogger.getString("OUI-67724"));
            for (i2 = 0; i2 < opatchDoNotExistMap.size(); ++i2) {
                buff.append((String)locArray2[i2]);
                buff.append("\n");
            }
        }
        if (badVersionMap.size() != 0) {
            Object[] locArray3 = new Object[badVersionMap.size()];
            locArray3 = badVersionMap.keySet().toArray();
            buff.append(OLogger.getString("OUI-67730", new Object[]{version_v2c}));
            for (i2 = 0; i2 < badVersionMap.size(); ++i2) {
                buff.append((String)locArray3[i2]);
                buff.append("\n");
            }
        }
        OLogger.printlnOnLog(OLogger.WARNING, buff.toString());
    }

    public boolean helpPresent() {
        return true;
    }

    public void displayHelp() {
        StringBuffer helpM = new StringBuffer("\n");
        String helpFile = "version_help.txt";
        try {
            String thisLine;
            InputStream is = this.getClass().getResourceAsStream(helpFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((thisLine = br.readLine()) != null) {
                helpM.append(thisLine);
                helpM.append("\n");
            }
            OLogger.println(helpM.toString());
        }
        catch (Exception e2) {
            String msg = OLogger.getString("OUI-67108", new Object[]{helpFile});
            OLogger.println(msg);
        }
    }

    private static String retrieveSpecOPatchVersion(String oracleHome) {
        String opatchVersion;
        block3: {
            RuntimeException re = null;
            opatchVersion = "n/a";
            JarFile opatchJarFile = null;
            JarEntry opatchJarEntry = null;
            BufferedReader br = null;
            String opatchJarFilePath = oracleHome + File.separator + "OPatch" + File.separator + "jlib" + File.separator + "opatch.jar";
            try {
                File tmpFile = new File(opatchJarFilePath);
                if (!tmpFile.exists() || (opatchJarFile = new JarFile(opatchJarFilePath)).size() == 0) break block3;
                String versionFilePath = "oracle/opatch/version.txt";
                opatchJarEntry = opatchJarFile.getJarEntry(versionFilePath);
                br = new BufferedReader(new InputStreamReader(opatchJarFile.getInputStream(opatchJarEntry)));
                String entry = null;
                while ((entry = br.readLine()) != null) {
                    StringTokenizer st;
                    if (!entry.startsWith("OPATCH_VERSION") || !(st = new StringTokenizer(entry, ":")).hasMoreTokens()) continue;
                    String str = st.nextToken();
                    if (!st.hasMoreTokens()) continue;
                    opatchVersion = st.nextToken();
                    opatchVersion = opatchVersion.trim();
                    break;
                }
            }
            catch (Throwable t) {
                OLogger.error("OUI-67720", new Object[]{oracleHome, "VersionSession::retrieveSpecOPatchVersion()"});
                re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
        }
        return opatchVersion;
    }

    private static void printBadVersionOH(Map ohDoNotExistMap, Map opatchDoNotExistMap, Map badVersionMap, int ohLength) {
        StringBuffer buff = new StringBuffer("");
        if (ohDoNotExistMap.size() != 0 || opatchDoNotExistMap.size() != 0 || badVersionMap.size() != 0) {
            int tmpGap1;
            int i2;
            Object[] locArray1 = new Object[ohDoNotExistMap.size()];
            Object[] locArray2 = new Object[opatchDoNotExistMap.size()];
            Object[] locArray3 = new Object[badVersionMap.size()];
            Object[] versionArray3 = new Object[badVersionMap.size()];
            locArray1 = ohDoNotExistMap.keySet().toArray();
            locArray2 = opatchDoNotExistMap.keySet().toArray();
            locArray3 = badVersionMap.keySet().toArray();
            versionArray3 = badVersionMap.values().toArray();
            if (badVersionMap.size() != 0) {
                VersionSession.QuickSort(versionArray3, locArray3, 0, badVersionMap.size());
            }
            int col1 = ohLength;
            int gap1 = 5;
            int headerGap = col1 + gap1 - 8;
            if (badVersionMap.size() != 0) {
                buff.append(OLogger.getString("OUI-67730", new Object[]{version_v2c}));
                buff.append("Location" + OPatchEnv.getSpaceString(headerGap) + "Version\n");
            }
            for (i2 = 0; i2 < badVersionMap.size(); ++i2) {
                buff.append((String)locArray3[i2]);
                tmpGap1 = col1 + gap1 - ((String)locArray3[i2]).length();
                buff.append(OPatchEnv.getSpaceString(tmpGap1));
                buff.append((String)versionArray3[i2]);
                buff.append("\n");
            }
            if (ohDoNotExistMap.size() != 0 || opatchDoNotExistMap.size() != 0) {
                buff.append(OLogger.getString("OUI-67722"));
                buff.append("Location" + OPatchEnv.getSpaceString(headerGap) + "Version\n");
            }
            for (i2 = 0; i2 < ohDoNotExistMap.size(); ++i2) {
                buff.append((String)locArray1[i2]);
                tmpGap1 = col1 + gap1 - ((String)locArray1[i2]).length();
                buff.append(OPatchEnv.getSpaceString(tmpGap1));
                buff.append("n/a");
                buff.append("\n");
            }
            for (i2 = 0; i2 < opatchDoNotExistMap.size(); ++i2) {
                buff.append((String)locArray2[i2]);
                tmpGap1 = col1 + gap1 - ((String)locArray2[i2]).length();
                buff.append(OPatchEnv.getSpaceString(tmpGap1));
                buff.append("n/a");
                buff.append("\n");
            }
            OLogger.println(buff.toString());
        }
    }

    private static void sortAndPrintOPatchVersion(Map goodVersionMap, int ohLength) {
        StringBuffer buff = new StringBuffer(OLogger.getString("OUI-67721"));
        int mapSize = goodVersionMap.size();
        if (mapSize == 0) {
            return;
        }
        Object[] locArray = new Object[mapSize];
        Object[] verArray = new Object[mapSize];
        locArray = goodVersionMap.keySet().toArray();
        verArray = goodVersionMap.values().toArray();
        VersionSession.QuickSort(verArray, locArray, 0, mapSize);
        int col1 = ohLength;
        int gap1 = 5;
        int headerGap = col1 + gap1 - 8;
        buff.append("Location" + OPatchEnv.getSpaceString(headerGap) + "Version\n");
        for (int i2 = 0; i2 < mapSize; ++i2) {
            buff.append((String)locArray[i2]);
            int tmpGap1 = col1 + gap1 - ((String)locArray[i2]).length();
            buff.append(OPatchEnv.getSpaceString(tmpGap1));
            buff.append((String)verArray[i2]);
            buff.append("\n");
        }
        OLogger.println(buff.toString());
    }

    public static void QuickSort(Object[] pData, Object[] sData, int left, int right) {
        int i2 = left;
        int j2 = right;
        String middle = (String)pData[left];
        String secMiddle = (String)sData[left];
        while (true) {
            if (++i2 < right - 1 && VersionSession.isGreaterDecimal((String)pData[i2], middle) == 1) {
                continue;
            }
            while (--j2 > left && VersionSession.isGreaterDecimal((String)pData[j2], middle) == -1) {
            }
            if (i2 >= j2) break;
            String temp = (String)pData[i2];
            pData[i2] = pData[j2];
            pData[j2] = temp;
            temp = (String)sData[i2];
            sData[i2] = sData[j2];
            sData[j2] = temp;
        }
        pData[left] = pData[j2];
        pData[j2] = middle;
        sData[left] = sData[j2];
        sData[j2] = secMiddle;
        if (left < j2) {
            VersionSession.QuickSort(pData, sData, left, j2);
        }
        if (right > i2) {
            VersionSession.QuickSort(pData, sData, i2, right);
        }
    }

    public static int isGreaterDecimal(String firstDecimal, String secondDecimal) {
        String[] secondNoParts;
        if (firstDecimal == null) {
            firstDecimal = "";
        }
        if (secondDecimal == null) {
            secondDecimal = "";
        }
        if (firstDecimal.trim().equals(secondDecimal.trim())) {
            return 0;
        }
        if (firstDecimal.trim().equals("")) {
            return -1;
        }
        if (secondDecimal.trim().equals("")) {
            return 1;
        }
        String firstNo = firstDecimal;
        String secondNo = secondDecimal;
        String[] firstNoParts = firstNo.split("\\.");
        int length = firstNoParts.length < (secondNoParts = secondNo.split("\\.")).length ? firstNoParts.length : secondNoParts.length;
        for (int j2 = 0; j2 < length; ++j2) {
            int firstIntLength = firstNoParts[j2].length();
            int secondIntLength = secondNoParts[j2].length();
            String zeroStr = VersionSession.getExtraZeroes(Math.abs(firstIntLength - secondIntLength));
            if (firstIntLength > secondIntLength) {
                secondNoParts[j2] = zeroStr + secondNoParts[j2];
            } else if (firstIntLength < secondIntLength) {
                firstNoParts[j2] = zeroStr + firstNoParts[j2];
            }
            for (int i2 = 0; i2 < firstNoParts[j2].length(); ++i2) {
                char y;
                int yInt;
                char x = firstNoParts[j2].charAt(i2);
                int xInt = x - 48;
                if (xInt > (yInt = (y = secondNoParts[j2].charAt(i2)) - 48)) {
                    return 1;
                }
                if (xInt >= yInt) continue;
                return -1;
            }
        }
        if (firstNoParts.length < secondNoParts.length) {
            return -1;
        }
        if (firstNoParts.length > secondNoParts.length) {
            return 1;
        }
        return 0;
    }

    private static String getExtraZeroes(int length) {
        String zeroStr = "";
        for (int i2 = 0; i2 < length; ++i2) {
            zeroStr = zeroStr + "0";
        }
        return zeroStr;
    }
}

