/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter.selectbetterpatch;

import java.util.ArrayList;
import java.util.HashMap;
import oracle.opatch.OneOffEntry;
import oracle.opatch.conflicttextualinterpreter.selectbetterpatch.IBuildRelationMap;
import oracle.opatch.conflicttextualinterpreter.selectbetterpatch.IndexKeyPair;
import oracle.opatch.conflicttextualinterpreter.selectbetterpatch.IndexKeyTriple;
import oracle.opatch.opatchlogger.OLogger;

public class BuildRelationPatchMap
implements IBuildRelationMap {
    public HashMap buildDuplicatePiMap(OneOffEntry[] pIs) {
        Object filteredPis = null;
        StringBuffer buff = new StringBuffer("BuildRelationPatchMap::buildDuplicatePiMap()");
        OLogger.debug(buff);
        buff.setLength(0);
        if (pIs == null || pIs.length == 0) {
            String msg = "Empty List of incoming patches.";
            OLogger.debug(buff.append(msg));
            return null;
        }
        HashMap<IndexKeyPair, ArrayList> dupHm = new HashMap<IndexKeyPair, ArrayList>();
        for (OneOffEntry pi : pIs) {
            ArrayList list;
            String[] bugs;
            IndexKeyPair dupKeyPair;
            String langPi = pi.getPatchLanguage();
            if ("".equals(langPi)) {
                langPi = "en";
            }
            if (dupHm.containsKey(dupKeyPair = new IndexKeyPair(langPi, bugs = pi.getBugIDsFixed()))) {
                list = (ArrayList)dupHm.get(dupKeyPair);
                list.add(pi);
                dupHm.put(dupKeyPair, list);
                continue;
            }
            list = new ArrayList();
            list.add(pi);
            dupHm.put(dupKeyPair, list);
        }
        return dupHm;
    }

    public HashMap buildDuplicatePohMap(OneOffEntry[] pOHs) {
        StringBuffer buff = new StringBuffer("BuildRelationPatchMap::buildDuplicatePohMap()");
        OLogger.debug(buff);
        HashMap<IndexKeyPair, OneOffEntry> hm = new HashMap<IndexKeyPair, OneOffEntry>();
        buff.setLength(0);
        for (OneOffEntry poh : pOHs) {
            if (poh == null) continue;
            String id = this.norm(poh.getID());
            String lang = this.norm(poh.getPatchLanguage());
            if (lang == "") {
                lang = "en";
            }
            String[] bugs = poh.getBugIDsFixed();
            String uid = this.norm(poh.getPSENumber());
            IndexKeyPair ohKeyPair = new IndexKeyPair(lang, bugs);
            if ("".equals(ohKeyPair)) continue;
            hm.put(ohKeyPair, poh);
        }
        return hm;
    }

    public HashMap buildIdenticalPohMap(OneOffEntry[] pOHs) {
        StringBuffer buff = new StringBuffer("BuildRelationPatchMap::buildIdenticalPohMap()");
        OLogger.debug(buff);
        HashMap<IndexKeyTriple, OneOffEntry> hm = new HashMap<IndexKeyTriple, OneOffEntry>();
        buff.setLength(0);
        for (OneOffEntry poh : pOHs) {
            if (poh == null) continue;
            String id = this.norm(poh.getID());
            String lang = this.norm(poh.getPatchLanguage());
            if (lang == "") {
                lang = "en";
            }
            String[] bugs = poh.getBugIDsFixed();
            String uid = this.norm(poh.getPSENumber());
            IndexKeyTriple ohKeyPair = new IndexKeyTriple(id, lang, bugs);
            if ("".equals(ohKeyPair)) continue;
            hm.put(ohKeyPair, poh);
        }
        return hm;
    }

    public HashMap buildIdenticalPiMap(OneOffEntry[] pIs) {
        StringBuffer buff = new StringBuffer("BuildRelationPatchMap::buildIdenticalPiMap()");
        OLogger.debug(buff);
        buff.setLength(0);
        if (pIs == null || pIs.length == 0) {
            String msg = "Empty List of incoming patches.";
            OLogger.debug(buff.append(msg));
            return null;
        }
        HashMap<String, ArrayList> dupHm = new HashMap<String, ArrayList>();
        for (OneOffEntry pi : pIs) {
            ArrayList list;
            String dupKeyPair;
            String langPi = pi.getPatchLanguage();
            if ("".equals(langPi)) {
                langPi = "en";
            }
            if (dupHm.containsKey(dupKeyPair = pi.getPatchID() + "_" + langPi)) {
                list = (ArrayList)dupHm.get(dupKeyPair);
                list.add(pi);
                dupHm.put(dupKeyPair, list);
                continue;
            }
            list = new ArrayList();
            list.add(pi);
            dupHm.put(dupKeyPair, list);
        }
        return dupHm;
    }

    private String norm(String s) {
        return s == null ? "" : s.trim();
    }
}

