/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.ipm;

import oracle.opatch.OPatchEnv;
import oracle.opatch.ipm.IIPMAuxServices;
import oracle.opatch.opatchlogger.OLogger;
import oracle.sysman.oii.oiic.OiicInventoryOperationHelper;
import oracle.sysman.oii.oiix.OiixFunctionOps;

public class IPMAuxServices
implements IIPMAuxServices {
    private static IPMAuxServices instance = null;

    private IPMAuxServices() {
    }

    protected static synchronized IPMAuxServices getInstance() {
        if (instance == null) {
            instance = new IPMAuxServices();
        }
        return instance;
    }

    public String[] symbolResolve(String componentName, String componenentVersion, String symbolName) {
        return null;
    }

    public String getCentralInventoryLocation() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void attachHome(String oracleHomePath, String oracleHomeName, String strArgs) {
        String[] params = OiixFunctionOps.explodeString((String)strArgs, (String)" ");
        int retry = OPatchEnv.getRetry();
        int delay = OPatchEnv.getDelay();
        boolean isRetry = OPatchEnv.isRetry();
        if (isRetry) {
            OLogger.debug("IPMAuxServices::attachHome() will retry " + retry + "  times with " + delay + " second(s) interval.");
        } else {
            OLogger.debug("IPMAuxServices::attachHome() has no retry.");
        }
        int count = 0;
        long startTime = System.currentTimeMillis();
        int maxWait = OPatchEnv.getMaxLockingWait();
        while (true) {
            try {
                OLogger.debug("IPMAuxServices::attachHome() try round # " + ++count);
                boolean isConsoleOutputDisabled = OLogger.isConsoleOutputDisabled();
                boolean isEnabledForAttachHome = true;
                try {
                    if (!isConsoleOutputDisabled) {
                        OLogger.disableConsoleOutput(false);
                        isEnabledForAttachHome = false;
                    }
                    OiicInventoryOperationHelper.attachHome((String)oracleHomePath, (String)oracleHomeName, (String[])params);
                    Object var16_20 = null;
                    if (isEnabledForAttachHome) return;
                }
                catch (Throwable throwable) {
                    Object var16_21 = null;
                    if (isEnabledForAttachHome) throw throwable;
                    OLogger.enableConsoleOutput(false);
                    throw throwable;
                }
                OLogger.enableConsoleOutput(false);
                return;
            }
            finally {
                Throwable t;
                if (!isRetry) {
                    RuntimeException re = new RuntimeException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    throw re;
                }
                if (--retry < 0) {
                    isRetry = false;
                    RuntimeException re = new RuntimeException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    throw re;
                }
                long now = System.currentTimeMillis();
                int differenceInSeconds = (int)((startTime - now) / 1000L);
                OLogger.debug("  attachHome starts at " + startTime + ", now is " + now + ", " + differenceInSeconds + " second(s) has passed.");
                if (differenceInSeconds >= maxWait) {
                    String log = "Cannot attach Oracle Home. Total retry time has exceeded " + maxWait + " second(s) allowed.";
                    RuntimeException re = new RuntimeException(log);
                    re.setStackTrace(t.getStackTrace());
                    OLogger.debug(log + " attachHome started at " + startTime + " and now is " + now + "(" + differenceInSeconds + " second(s) has passed)");
                    throw re;
                }
                OLogger.printlnOnLog("OPatch will sleep for some time, before re-trying to attach Oracle Home");
                try {
                    OLogger.debug("IPMAuxServices::attachHome() failed.  Will sleep for " + delay + " second(s).");
                    Thread.sleep(delay * 1000);
                }
                catch (InterruptedException interruptedException) {}
                if (isRetry) continue;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void detachHome(String oracleHomePath, String oracleHomeName, String strArgs) {
        String[] params = OiixFunctionOps.explodeString((String)strArgs, (String)" ");
        int retry = OPatchEnv.getRetry();
        int delay = OPatchEnv.getDelay();
        boolean isRetry = OPatchEnv.isRetry();
        if (isRetry) {
            OLogger.debug("IPMAuxServices::detachHome() will retry " + retry + "  times with " + delay + " second(s) interval.");
        } else {
            OLogger.debug("IPMAuxServices::detachHome() has no retry.");
        }
        int count = 0;
        long startTime = System.currentTimeMillis();
        int maxWait = OPatchEnv.getMaxLockingWait();
        while (true) {
            try {
                OLogger.debug("IPMAuxServices::detachHome() try round # " + ++count);
                boolean isConsoleOutputDisabled = OLogger.isConsoleOutputDisabled();
                boolean isEnabledForDetachHome = true;
                try {
                    if (!isConsoleOutputDisabled) {
                        OLogger.disableConsoleOutput(false);
                        isEnabledForDetachHome = false;
                    }
                    OiicInventoryOperationHelper.detachHome((String)oracleHomePath, (String)oracleHomeName, (String[])params);
                    Object var16_20 = null;
                    if (isEnabledForDetachHome) return;
                }
                catch (Throwable throwable) {
                    Object var16_21 = null;
                    if (isEnabledForDetachHome) throw throwable;
                    OLogger.enableConsoleOutput(false);
                    throw throwable;
                }
                OLogger.enableConsoleOutput(false);
                return;
            }
            finally {
                Throwable t;
                if (!isRetry) {
                    RuntimeException re = new RuntimeException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    throw re;
                }
                if (--retry < 0) {
                    isRetry = false;
                    RuntimeException re = new RuntimeException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    throw re;
                }
                long now = System.currentTimeMillis();
                int differenceInSeconds = (int)((startTime - now) / 1000L);
                OLogger.debug("  detachHome starts at " + startTime + ", now is " + now + ", " + differenceInSeconds + " second(s) has passed.");
                if (differenceInSeconds >= maxWait) {
                    String log = "Cannot detach Oracle Home. Total retry time has exceeded " + maxWait + " second(s) allowed.";
                    RuntimeException re = new RuntimeException(log);
                    re.setStackTrace(t.getStackTrace());
                    OLogger.debug(log + " detachHome started at " + startTime + " and now is " + now + "(" + differenceInSeconds + " second(s) has passed)");
                    throw re;
                }
                OLogger.printlnOnLog("OPatch will sleep for some time, before re-trying to detach Oracle Home");
                try {
                    OLogger.debug("IPMAuxServices::detachHome() failed.  Will sleep for " + delay + " second(s).");
                    Thread.sleep(delay * 1000);
                }
                catch (InterruptedException interruptedException) {}
                if (isRetry) continue;
            }
            break;
        }
    }

    public static void destroyObject() {
        if (instance != null) {
            instance = null;
        }
    }
}

