/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.ipm;

import com.oracle.cie.gdr.external.Component;
import com.oracle.cie.gdr.external.OracleHomeInventory;
import java.io.File;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Vector;
import oracle.glcm.opatch.common.api.Patch;
import oracle.glcm.opatch.common.api.PatchCheckResults;
import oracle.opatch.NGOUIInventoryFactory;
import oracle.opatch.OPatchEnv;
import oracle.opatch.StringResource;
import oracle.opatch.ipm.IPMReadServices;
import oracle.opatch.opatchlogger.OLogger;
import oracle.sysman.nextgen.NextGenPatching;
import oracle.sysman.oii.oiii.OiiiCompInstallID;

public class IPMUtil {
    public static String getCompsXMLLocation(String baseDir) {
        if (baseDir == null) {
            return "";
        }
        String contentsXML = IPMUtil.getContentsXMLLocation(baseDir);
        StringBuffer buff = new StringBuffer(contentsXML);
        buff.append(File.separator);
        buff.append("comps.xml");
        return buff.toString();
    }

    public static String getOneoffsLocation(String baseDir) {
        if (baseDir == null) {
            return "";
        }
        StringBuffer buff = new StringBuffer(baseDir);
        buff.append(File.separator);
        buff.append("inventory");
        buff.append(File.separator);
        buff.append("oneoffs");
        return buff.toString();
    }

    public static String getOneoffsLocation(String baseDir, String patchId) {
        if (baseDir == null) {
            return "";
        }
        StringBuffer buff = new StringBuffer(IPMUtil.getOneoffsLocation(baseDir));
        buff.append(File.separator);
        buff.append(patchId);
        return buff.toString();
    }

    private static String getContentsXMLLocation(String baseDir) {
        if (baseDir == null) {
            return "";
        }
        StringBuffer buff = new StringBuffer(baseDir);
        buff.append(File.separator);
        buff.append("inventory");
        buff.append(File.separator);
        buff.append("ContentsXML");
        return buff.toString();
    }

    public static boolean canGetLangsForInvEntry() {
        try {
            Class<?> chkClass = Class.forName("oracle.sysman.oii.oiii.OiiiOneoffInvEntry");
            boolean getLang = false;
            if (chkClass != null) {
                Method[] methods = chkClass.getMethods();
                for (int i2 = 0; i2 < methods.length; ++i2) {
                    if (!methods[i2].getName().equals("getLangs")) continue;
                    getLang = true;
                    break;
                }
            }
            return getLang;
        }
        catch (ClassNotFoundException e2) {
            return false;
        }
    }

    public static boolean canGetDescForInvEntry() {
        try {
            Class<?> chkClass = Class.forName("oracle.sysman.oii.oiii.OiiiOneoffInvEntry");
            boolean getLang = false;
            if (chkClass != null) {
                Method[] methods = chkClass.getMethods();
                for (int i2 = 0; i2 < methods.length; ++i2) {
                    if (!methods[i2].getName().equals("setDescription")) continue;
                    getLang = true;
                    break;
                }
            }
            return getLang;
        }
        catch (ClassNotFoundException e2) {
            return false;
        }
    }

    public static boolean canSetSubsetPatchesForInvEntry() {
        try {
            Class<?> chkClass = Class.forName("oracle.sysman.oii.oiii.OiiiInstallOneoffInvEntry");
            boolean setSupercede = false;
            if (chkClass != null) {
                Method[] methods = chkClass.getMethods();
                for (int i2 = 0; i2 < methods.length; ++i2) {
                    if (!methods[i2].getName().equals("setSupersededOneOffsList")) continue;
                    setSupercede = true;
                    break;
                }
            }
            return setSupercede;
        }
        catch (ClassNotFoundException e2) {
            return false;
        }
    }

    public static boolean canGetUniqueIDForInvEntry() {
        try {
            Class<?> chkClass = Class.forName("oracle.sysman.oii.oiii.OiiiOneoffInvEntry");
            boolean getUniq = false;
            if (chkClass != null) {
                Method[] methods = chkClass.getMethods();
                for (int i2 = 0; i2 < methods.length; ++i2) {
                    if (!methods[i2].getName().equals("getUniqID")) continue;
                    getUniq = true;
                    break;
                }
            }
            return getUniq;
        }
        catch (ClassNotFoundException e2) {
            return false;
        }
    }

    public static boolean isGridHome(String oracleHomePath) {
        String crsctlCmd = oracleHomePath + File.separator + StringResource.CRSCTL_COMMAND;
        crsctlCmd = OPatchEnv.isWindows() ? crsctlCmd + ".exe" : crsctlCmd + ".bin";
        File crsctl = new File(crsctlCmd);
        return crsctl.exists();
    }

    public static boolean isDBHome(String oracleHomePath) {
        IPMReadServices readServices = new IPMReadServices();
        readServices.lock(oracleHomePath);
        if (OPatchEnv.isNextGen()) {
            try {
                OracleHomeInventory gdrInv = NGOUIInventoryFactory.getOracleHomeInventory(readServices.getRawInventory().getOracleHomePath());
                for (Component comp : gdrInv.getComponents()) {
                    String name = comp.getName();
                    if (name == null || !name.equals("oracle.server") && !name.equals("oracle.client") && !name.equals("oracle.crs")) continue;
                    return true;
                }
                return false;
            }
            catch (Throwable e2) {
                OLogger.debug("Could not get oracle home component to check if Home is DB Home using NextGen APIs. Continuing with legacy OUI APIs." + e2.getMessage());
            }
        } else {
            Vector<OiiiCompInstallID> topLevelComps = readServices.getRawInventory().getTopLevelComps();
            for (OiiiCompInstallID topLevelComp : topLevelComps) {
                String name = topLevelComp.getName();
                if (name == null || !name.equals("oracle.server") && !name.equals("oracle.client") && !name.equals("oracle.crs")) continue;
                return true;
            }
        }
        readServices.release();
        return false;
    }

    public static String getLocalHostName(boolean isFullyQualified) {
        String hostName;
        block4: {
            hostName = null;
            try {
                InetAddress ia = InetAddress.getLocalHost();
                if (ia == null) break block4;
                if (isFullyQualified) {
                    if ((ia = InetAddress.getByName(ia.getHostAddress())) != null) {
                        return ia.getHostName();
                    }
                    break block4;
                }
                return ia.getHostName();
            }
            catch (UnknownHostException e2) {
                OLogger.debug("Could not get local host name.");
            }
        }
        return hostName;
    }

    public static boolean isNextGenUpgradePatchingSupported() {
        if (OPatchEnv.isNextGen()) {
            try {
                NextGenPatching.class.getDeclaredMethod("processPatch", Patch.class, Boolean.TYPE, List.class, PatchCheckResults.class);
                NextGenPatching.class.getDeclaredMethod("getPatchCheckResults", Patch.class, Boolean.TYPE);
                return true;
            }
            catch (Throwable e2) {
                return false;
            }
        }
        return false;
    }
}

