/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import oracle.opatch.fmwclient.FMWClient;
import oracle.opatch.opatchfafmw.Domain;
import oracle.opatch.opatchfafmw.LifecycleOpThread;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.PostTimeoutThread;
import oracle.opatch.opatchsdk.OPatchJEELifecycleAction;
import weblogic.management.runtime.ServerLifeCycleTaskRuntimeMBean;

public class MultiClient {
    List clients = new ArrayList(10);
    List actionObjs = new ArrayList(10);
    String oracleHome;
    String timestamp;
    LifecycleOpThread[] thread;
    public static final int timeout = 5400;
    boolean start;

    public void addClient(FMWClient client, OPatchJEELifecycleAction action) {
        this.clients.add(client);
        this.actionObjs.add(action);
    }

    public void setLogPath(String oracleHome, String timestamp) {
        this.oracleHome = oracleHome;
        this.timestamp = timestamp;
    }

    public void run(boolean start) {
        int k2;
        int i2;
        this.start = start;
        int size = this.clients.size();
        this.thread = new LifecycleOpThread[size];
        if (start) {
            Logger.log("Number of requests for parallel start operation: " + size);
        } else {
            Logger.log("Number of requests for parallel stop operation: " + size);
        }
        Logger.log("\n");
        FMWClient client = null;
        HashMap<String, ArrayList<FMWClient>> domainClientMap = new HashMap<String, ArrayList<FMWClient>>(size);
        ArrayList<FMWClient> domainClients = null;
        OPatchJEELifecycleAction action = null;
        HashMap<String, ArrayList<OPatchJEELifecycleAction>> domainActionMap = new HashMap<String, ArrayList<OPatchJEELifecycleAction>>(size);
        ArrayList<OPatchJEELifecycleAction> domainActions = null;
        String domain = "";
        for (int i3 = 0; i3 < this.clients.size(); ++i3) {
            client = (FMWClient)this.clients.get(i3);
            Domain d2 = client.getDomain();
            domain = d2.getProtocol() + "://" + d2.getHost() + ":" + d2.getPort();
            domainClients = (ArrayList<FMWClient>)domainClientMap.get(domain);
            if (domainClients == null) {
                domainClients = new ArrayList<FMWClient>(size / 2);
            }
            domainClients.add(client);
            domainClientMap.put(domain, domainClients);
        }
        Logger.log("Number of threads to be created: " + domainClientMap.size());
        LifecycleOpThread[] thread = new LifecycleOpThread[domainClientMap.size()];
        for (int i4 = 0; i4 < this.actionObjs.size(); ++i4) {
            action = (OPatchJEELifecycleAction)this.actionObjs.get(i4);
            domain = action.getBoundDomain().getWLAdminServer().getURL() + ":" + action.getBoundDomain().getWLAdminServer().getPort();
            domainActions = (ArrayList<OPatchJEELifecycleAction>)domainActionMap.get(domain);
            if (domainActions == null) {
                domainActions = new ArrayList<OPatchJEELifecycleAction>(size / 2);
            }
            domainActions.add(action);
            domainActionMap.put(domain, domainActions);
        }
        List list = null;
        List list1 = null;
        int j2 = 0;
        for (String d3 : domainClientMap.keySet()) {
            thread[j2] = new LifecycleOpThread(start, this.oracleHome, this.timestamp);
            list = (List)domainClientMap.get(d3);
            list1 = (List)domainActionMap.get(d3);
            for (i2 = 0; i2 < list.size(); ++i2) {
                thread[j2].addClient((FMWClient)list.get(i2));
            }
            for (i2 = 0; i2 < list1.size(); ++i2) {
                thread[j2].addAction((OPatchJEELifecycleAction)list1.get(i2));
            }
            ++j2;
        }
        for (k2 = 0; k2 < thread.length; ++k2) {
            thread[k2].setName("Thread-" + k2);
            thread[k2].start();
        }
        for (k2 = 0; k2 < thread.length; ++k2) {
            try {
                thread[k2].join();
                continue;
            }
            catch (InterruptedException ie) {
                RuntimeException re = new RuntimeException(ie);
                throw re;
            }
        }
        HashMap<String, ServerLifeCycleTaskRuntimeMBean> timeoutMap = new HashMap<String, ServerLifeCycleTaskRuntimeMBean>(this.clients.size() + 1, 1.0f);
        for (int l2 = 0; l2 < this.clients.size(); ++l2) {
            Map<String, ServerLifeCycleTaskRuntimeMBean> tMap = ((FMWClient)this.clients.get(l2)).getServerLifeCycleTaskRuntimeMBeanMap();
            if (tMap == null) continue;
            timeoutMap.putAll(tMap);
        }
        if (timeoutMap.size() == 0) {
            return;
        }
        Logger.log("\n");
        Logger.debug("Begin Max Timeout of 5400 seconds.");
        block16: for (i2 = 0; i2 < 5400; i2 += 5) {
            try {
                TimeUnit.SECONDS.sleep(5L);
            }
            catch (Exception e2) {
                Logger.loge(e2);
            }
            for (String server : timeoutMap.keySet()) {
                if (!((ServerLifeCycleTaskRuntimeMBean)timeoutMap.get(server)).isRunning()) continue;
                Logger.debug("Some of the tasks are still in RUNNING state.");
                Logger.debug("Timeout check continues with " + (5400 - i2) + " seconds");
                continue block16;
            }
        }
        Logger.debug("End Timeout");
        try {
            TimeUnit.SECONDS.sleep(20L);
        }
        catch (Exception e3) {
            Logger.loge(e3);
        }
        PostTimeoutThread timeoutThread = new PostTimeoutThread(this.clients, start);
        timeoutThread.start();
        try {
            timeoutThread.join();
        }
        catch (InterruptedException ie1) {
            RuntimeException re1 = new RuntimeException(ie1);
            Logger.loge("Unexpected error at post Timeout operation.");
            throw re1;
        }
    }
}

