/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import java.io.File;
import oracle.integration.platform.blocks.deploy.patch.PatchStatus;
import oracle.opatch.OPatchEnv;
import oracle.opatch.opatchfafmw.FMWContext;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.OPatchSOAStep;
import oracle.opatch.opatchfafmw.Operation;
import oracle.opatch.opatchfafmw.SOAComposite;
import oracle.opatch.opatchfafmw.SOACompositeManager;
import oracle.opatch.opatchfafmw.Util;
import oracle.opatch.opatchfafmw.rb.RB;
import oracle.opatch.opatchsdk.OPatchFAStep;

final class SingleAPISOACompositeDeploy
implements Operation {
    SingleAPISOACompositeDeploy() {
    }

    public void run(FMWContext c2) {
        SOACompositeManager scm = c2.getDomain().getSOACompositeManager();
        SOAComposite sc = c2.getSOAComposite();
        boolean report = OPatchEnv.isReport();
        if (sc == null) {
            return;
        }
        String path = sc.getPath();
        String name = sc.getName();
        String revision = sc.getRevision();
        String errorMsg = "";
        String revBeforeDeploy = "";
        String revAfterDeploy = "";
        if (!Util.existFile(path)) {
            errorMsg = Logger.getString(RB.Entry.SOA_COMPOSITE_NOT_EXIST, path, name);
            RuntimeException re = new RuntimeException(errorMsg);
            Logger.loge(errorMsg);
            throw re;
        }
        try {
            revBeforeDeploy = scm.getDefaultRevision(name);
            sc.setDefaultRevisionBeforeDeploy(revBeforeDeploy);
            Logger.logi("[SOA COMPOSITE] Default revision of composite before deployment [" + revBeforeDeploy + "]");
            if (report) {
                OPatchSOAStep connectPromptStep = new OPatchSOAStep(OPatchFAStep.SOA_WLST_SERVER_CONNECT);
                connectPromptStep.setStepDescription("[Connects WLST to a WebLogic Server instance as online model, this step is need by following WLST commands but not done here]");
                connectPromptStep.setSuccess(true);
                c2.getContextBuilder().addExecutionStep(connectPromptStep);
            }
            Logger.logi("Path where the jar is taken is -> " + path);
            String jarName = new File(path).getName();
            String tempLocation = Util.getTempLocation(c2.getTempLocation(), name);
            String jarWithPlan = tempLocation + System.getProperty("file.separator") + jarName;
            Util.deleteFile(jarWithPlan);
            if (!Util.copyFile(path, jarWithPlan)) {
                errorMsg = "OPatch was not able to copy composite jar to the temporary location";
                Logger.loge(errorMsg);
                RuntimeException re1 = new RuntimeException(errorMsg);
                throw re1;
            }
            OPatchSOAStep singleDeployStep = new OPatchSOAStep(OPatchFAStep.SOA_SINGLE_DEPLOY);
            singleDeployStep.setSarFile(jarWithPlan);
            boolean noneConfigPlan = c2.isNoneConfigPlan();
            if (noneConfigPlan) {
                Logger.logi("OPatch uses configplan=\"none\" for composite deployment");
            } else {
                Logger.logi("OPatch uses config plan from base composite for deployment");
            }
            if (!report) {
                singleDeployStep.setStepDescription("composite deployment with single coarse api");
                PatchStatus status = scm.singleDeploy(jarWithPlan, noneConfigPlan, c2.getLogFileLocation() + ".merge");
                c2.getContextBuilder().setSOAOpResult(status);
                Logger.logi("Summary of the execution Steps:");
                Logger.logi(status.getStepInfoSummary());
                if (status.getState() == PatchStatus.PATCH_STATE.patchSuccess) {
                    Logger.logi("Composite deployment successful.");
                    singleDeployStep.setSuccess(true);
                } else {
                    singleDeployStep.setSuccess(false);
                    singleDeployStep.setErrorMessage("Composite deployment failed. " + status.getStepInfoSummary());
                }
            } else {
                singleDeployStep.setStepDescription("[skip] composite deployment with single coarse api");
                singleDeployStep.setSuccess(true);
            }
            c2.getContextBuilder().addExecutionStep(singleDeployStep);
            revAfterDeploy = scm.getDefaultRevision(name);
            sc.setDefaultRevisionAfterDeploy(revAfterDeploy);
            Logger.logi("[SOA COMPOSITE] Default revision of composite after deployment [" + revAfterDeploy + "]");
        }
        catch (Exception e2) {
            Logger.loge(e2);
            RuntimeException re = new RuntimeException(e2);
            throw re;
        }
    }
}

