/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import java.util.Vector;
import oracle.opatch.OPatchACL;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.PrereqResult;

public class checkInstalledOneOffs {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void checkInstalledOneOffs(String srcHome, String[] oracleHomes, String[] patchIDs, String mwHome, boolean isAll) throws RuntimeException {
        StringBuffer buff = new StringBuffer("checkInstalledOneOffs::checkInstalledOneOffs()");
        OLogger.debug(buff);
        if (patchIDs == null || patchIDs.length == 0) {
            buff = new StringBuffer("Please supply Patch IDs using 'id' option separated by commas.");
            throw new RuntimeException(buff.toString());
        }
        boolean failFlag = false;
        buff = new StringBuffer();
        try {
            OPatchACL.releaseLock(new checkInstalledOneOffs());
        }
        catch (Throwable t) {
            RuntimeException e2 = new RuntimeException(t.getMessage());
            e2.setStackTrace(t.getStackTrace());
            throw e2;
        }
        for (int i2 = 0; i2 < oracleHomes.length; ++i2) {
            String homePath = oracleHomes[i2];
            Vector installedPatchIDs = new Vector();
            Vector notInstalledPatchIDs = new Vector();
            StringBuffer debugBuff = new StringBuffer("Checking if given oneoffs are installed on Oracle Home \"" + homePath + "\"...");
            OLogger.debug(debugBuff);
            PrereqResult oneOffRes = PrereqAPI.checkInstalledOneOffs(homePath, patchIDs, installedPatchIDs, notInstalledPatchIDs);
            if (oneOffRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || oneOffRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                failFlag = true;
                buff.append("\n\"checkInstalledOneOffs\" failed for Oracle Home \"" + homePath + "\".");
                if (notInstalledPatchIDs != null && notInstalledPatchIDs.size() != 0) {
                    buff.append("\nNot Installed Patch IDs: " + notInstalledPatchIDs.toString() + "\n");
                } else {
                    buff.append(oneOffRes.toString());
                }
            } else {
                buff.append("\n\"checkInstalledOneOffs\" passed for Oracle Home \"" + homePath + "\".");
                buff.append(oneOffRes.toString());
            }
            try {
                OPatchACL.releaseLock(new checkInstalledOneOffs());
                continue;
            }
            catch (Throwable t) {
                RuntimeException e3 = new RuntimeException(t.getMessage());
                e3.setStackTrace(t.getStackTrace());
                throw e3;
            }
        }
        if (failFlag) {
            if (mwHome == null || mwHome.equals("")) throw new RuntimeException(buff.toString());
            OLogger.println(buff.toString());
            OLogger.warn("OUI-67124", new Object[]{"Some of the Oracle Homes under the Middleware Home \"" + mwHome + "\" have failed this check."});
            return;
        } else {
            OLogger.println(buff.toString());
        }
    }
}

