/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchprereq;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import oracle.opatch.OneOffEntry;
import oracle.opatch.opatchlogger.OLogger;

public class PrereqSet {
    private Vector elements;

    public PrereqSet() {
        this.elements = new Vector();
    }

    public PrereqSet(Vector input) {
        this.elements = input;
    }

    public PrereqSet(OneOffEntry[] oneOffs) {
        this.elements = new Vector();
        for (int i2 = 0; i2 < oneOffs.length; ++i2) {
            if (this.elements.contains(oneOffs[i2])) continue;
            this.elements.add(oneOffs[i2]);
        }
    }

    public void add(OneOffEntry ele) {
        if (!this.elements.contains(ele)) {
            this.elements.add(ele);
        }
    }

    public OneOffEntry getElement(int i2) {
        return (OneOffEntry)this.elements.elementAt(i2);
    }

    public void retain(PrereqSet pSet) {
        Vector inElements = pSet.elements;
        this.elements.retainAll(inElements);
    }

    public boolean isIntersect(PrereqSet pSet) {
        Vector inElements = new Vector(pSet.elements);
        Vector myElements = new Vector(this.elements);
        boolean isChanged = inElements.retainAll(myElements);
        if (inElements.size() == 0) {
            isChanged = false;
        }
        boolean isSame = ((inElements = new Vector(pSet.elements)).containsAll(myElements = new Vector(this.elements)) || myElements.containsAll(inElements)) && inElements.size() != 0 && myElements.size() != 0;
        return isChanged || isSame;
    }

    public OneOffEntry[] getAllElements() {
        OneOffEntry[] oneOffs = new OneOffEntry[this.elements.size()];
        for (int i2 = 0; i2 < this.elements.size(); ++i2) {
            oneOffs[i2] = (OneOffEntry)this.elements.elementAt(i2);
        }
        return oneOffs;
    }

    public boolean contains(OneOffEntry ele) {
        return this.elements.contains(ele);
    }

    public boolean contains(PrereqSet pSet) {
        Vector incomingEle = pSet.elements;
        return this.elements.containsAll(incomingEle);
    }

    public boolean contains(String patchID) {
        for (int i2 = 0; i2 < this.elements.size(); ++i2) {
            OneOffEntry o2 = (OneOffEntry)this.elements.get(i2);
            if (!patchID.equals(o2.getID())) continue;
            return true;
        }
        return false;
    }

    public void delete(int i2) {
        this.elements.remove(i2);
    }

    public void delete(String patchID) {
        for (int i2 = 0; i2 < this.elements.size(); ++i2) {
            OneOffEntry o2 = (OneOffEntry)this.elements.get(i2);
            if (!patchID.equals(o2.getID())) continue;
            this.elements.remove(i2);
            return;
        }
    }

    public void delete(String[] patchIDs) {
        for (int i2 = 0; i2 < patchIDs.length; ++i2) {
            this.delete(patchIDs[i2]);
        }
    }

    public void delete(OneOffEntry oneOff) {
        if (this.elements.contains(oneOff)) {
            this.elements.remove(oneOff);
        }
    }

    public PrereqSet delete(PrereqSet set) {
        PrereqSet tmpSet = new PrereqSet(this.getAllElements());
        for (int i2 = 0; i2 < set.size(); ++i2) {
            if (!tmpSet.contains(set.getElement(i2))) continue;
            tmpSet.delete(set.getElement(i2));
        }
        return tmpSet;
    }

    public PrereqSet add(PrereqSet set) {
        PrereqSet tmpSet = new PrereqSet(this.getAllElements());
        for (int i2 = 0; i2 < set.size(); ++i2) {
            if (tmpSet.contains(set.getElement(i2))) continue;
            tmpSet.add(set.getElement(i2));
        }
        return tmpSet;
    }

    public int size() {
        return this.elements.size();
    }

    public boolean isIn(String[] patchIDs) {
        if (this.elements.size() == 0) {
            return false;
        }
        for (int i2 = 0; i2 < this.elements.size(); ++i2) {
            boolean present = false;
            for (int j2 = 0; j2 < patchIDs.length; ++j2) {
                OneOffEntry o2 = (OneOffEntry)this.elements.get(i2);
                if (!patchIDs[j2].equals(o2.getID())) continue;
                present = true;
            }
            if (present) continue;
            return false;
        }
        return true;
    }

    public OneOffEntry[] intersectOneOffs(String[] patchIDs) {
        if (this.elements.size() == 0) {
            return new OneOffEntry[1];
        }
        PrereqSet newElem = new PrereqSet();
        for (int i2 = 0; i2 < this.elements.size(); ++i2) {
            for (int j2 = 0; j2 < patchIDs.length; ++j2) {
                OneOffEntry o2 = (OneOffEntry)this.elements.get(i2);
                if (!patchIDs[j2].equals(o2.getID())) continue;
                newElem.add(o2);
            }
        }
        return newElem.getAllElements();
    }

    public String[] intersect(String[] patchIDs) {
        ArrayList<String> aList = new ArrayList<String>();
        for (int i2 = 0; i2 < patchIDs.length; ++i2) {
            if (!this.contains(patchIDs[i2])) continue;
            aList.add(patchIDs[i2]);
        }
        String[] str = new String[aList.size()];
        aList.toArray(str);
        return str;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("[ ");
        for (int i2 = 0; i2 < this.elements.size(); ++i2) {
            OneOffEntry o2 = (OneOffEntry)this.elements.get(i2);
            buff.append(o2.getID() + " ");
        }
        buff.append(" ]\n");
        return buff.toString();
    }

    public void print(String name) {
        OneOffEntry[] eles;
        OLogger.debug("SETNAME=" + name);
        for (OneOffEntry entry : eles = this.getAllElements()) {
            OLogger.debug("PID=" + entry.getID());
        }
        OLogger.debug("END OF=" + name);
    }

    public void sort() {
        Collections.sort(this.elements, new Comparator(){

            public int compare(Object p1, Object p2) {
                int p2Len;
                int p1Len = ((OneOffEntry)p1).getID().length();
                if (p1Len < (p2Len = ((OneOffEntry)p2).getID().length())) {
                    return -1;
                }
                if (p1Len > p2Len) {
                    return 1;
                }
                return ((OneOffEntry)p1).getID().compareTo(((OneOffEntry)p2).getID());
            }
        });
    }
}

