/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchutil;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import oracle.opatch.ApplySession;
import oracle.opatch.Bug;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.CopyAction;
import oracle.opatch.ExitOPatchException;
import oracle.opatch.MergedPatchObject;
import oracle.opatch.OCMException;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchOverCAS;
import oracle.opatch.OPatchOverCASUtil;
import oracle.opatch.OPatchSession;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.OneOffEntry;
import oracle.opatch.OnlinePatchException;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchValidationException;
import oracle.opatch.PatchingModel;
import oracle.opatch.PatchmdXml;
import oracle.opatch.PrereqFailedException;
import oracle.opatch.PrereqSession;
import oracle.opatch.Rac;
import oracle.opatch.RacFileCreator;
import oracle.opatch.RacProcessor;
import oracle.opatch.Rules;
import oracle.opatch.SymbolFailureException;
import oracle.opatch.UtilSession;
import oracle.opatch.conflicttextualinterpreter.OracleHomeConflictMap;
import oracle.opatch.ipm.IIPMRWServices;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.napplyhelper.BuildComposite;
import oracle.opatch.napplyhelper.CheckDuplicate;
import oracle.opatch.napplyhelper.CheckInterConflict;
import oracle.opatch.napplyhelper.CheckIntraConflict;
import oracle.opatch.napplyhelper.CheckMissingComps;
import oracle.opatch.napplyhelper.ConflictReporter;
import oracle.opatch.napplyhelper.CreateMergedPatch;
import oracle.opatch.napplyhelper.EnvValidation;
import oracle.opatch.napplyhelper.GetFinalList;
import oracle.opatch.napplyhelper.NApplyData;
import oracle.opatch.napplyhelper.NApplyDataSerializer;
import oracle.opatch.napplyhelper.PatchValidation;
import oracle.opatch.napplyhelper.PrintApplyReport;
import oracle.opatch.napplyhelper.ProcessLists;
import oracle.opatch.napplyhelper.RunConsolidatedScripts;
import oracle.opatch.napplyhelper.RunInit;
import oracle.opatch.opatchactions.DeleteAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.CheckNoOpPatchesOption;
import oracle.opatch.opatchprereq.ConflictMatrixOutput;
import oracle.opatch.opatchprereq.PQSession;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.PrereqFilterDuplicatePatch;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.opatch.opatchprereq.PrereqSet;
import oracle.opatch.opatchprereq.ProcessFileVersions;
import oracle.opatch.opatchsdk.FailedPrereqException;
import oracle.opatch.opatchsdk.OPatchPatchPrereq;
import oracle.opatch.opatchsdk.OPatchTarget;
import oracle.opatch.opatchutil.NSession;
import oracle.opatch.opatchutil.OPatchUtilHelper;
import oracle.opatch.opatchutil.OUSession;
import oracle.opatch.ops.Feature;
import oracle.opatch.ops.OPS;
import oracle.opatch.twophase.ExitTwoPhaseException;
import oracle.opatch.twophase.TwoPhaseOperations;

public class NApply
extends NSession {
    private static final String sessionName = OPatchEnv.getNApplySessionName();

    private NApply() {
    }

    private static void checkEmptyPatchList(OneOffEntry[] patchesToApply) {
        if (patchesToApply == null || patchesToApply.length == 0) {
            StringBuffer buff = new StringBuffer(OLogger.getString("OUI-67306", new Object[]{"NApply", "apply"}));
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
    }

    private static String getNApplyCmdToRunAgain(String[] list) {
        String patchLoc = OUSession.getPatchBaseDir();
        StringBuffer tryAgainCmd = new StringBuffer("<ORACLE_HOME>/OPatch/opatch napply ");
        tryAgainCmd.append(patchLoc);
        tryAgainCmd.append(" -id ");
        for (int i2 = 0; i2 < list.length; ++i2) {
            String id = list[i2];
            if (i2 != 0) {
                tryAgainCmd.append(",");
            }
            tryAgainCmd.append(id);
        }
        String orgCmd = OPatchEnv.getOriginalCommand();
        StringTokenizer tk = new StringTokenizer(orgCmd);
        int i3 = 1;
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken();
            if (i3 > 2) {
                if (token.equals("-id")) {
                    tk.nextToken();
                } else {
                    tryAgainCmd.append(" ").append(token);
                }
            }
            ++i3;
        }
        StringBuffer buff = new StringBuffer();
        buff.append("Conflict with patches in OracleHome detected. Please run OPatch again as\n");
        buff.append(tryAgainCmd.toString());
        buff.append("\n\nIf the command is too long, please paste the patch id list in a file and");
        buff.append("\ninvoke with 'idfile' option. Please refer 'opatch napply -help' for ");
        buff.append("\n'idfile' option.");
        return buff.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void process(String oracleHomePath) throws RuntimeException, Error, FailedPrereqException {
        if (OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS) && !OPatchEnv.isReport()) {
            OPatchEnv.setCASFlow(true);
            OLogger.printlnOnLog("NApply::CAS enabled, OPatch runs with two-phase patching.");
            try {
                block10: {
                    try {
                        if (OPatchEnv.isCASPhase1()) {
                            OLogger.printlnOnLog("NApply:: OPatch runs phase one.");
                            OPatchOverCAS.INSTANCE.prepareTwoPhasePatching(TwoPhaseOperations.NAPPLY);
                        }
                        if (!OPatchEnv.isCASPhase2()) break block10;
                        OLogger.printlnOnLog("NApply:: OPatch runs phase two.");
                        OPatchOverCAS.INSTANCE.commitTwoPhasePatching();
                        OPatchOverCASUtil.cleanupCache(oracleHomePath);
                    }
                    catch (Exception e2) {
                        if (!(e2 instanceof ExitTwoPhaseException)) {
                            RuntimeException re = new RuntimeException(e2.getMessage());
                            re.setStackTrace(e2.getStackTrace());
                            throw re;
                        }
                        OLogger.printlnOnLog(e2.getMessage());
                        if (!OPatchEnv.isOPatchSDKMode()) {
                            NApply.legacy_process(oracleHomePath);
                        }
                        Object var4_2 = null;
                        OPatchEnv.unsetCASPhase1();
                        OPatchEnv.unsetCASPhase2();
                        OPatchEnv.setCASFlow(false);
                        if (!OPatchEnv.isCASCleanupNeeded()) return;
                        OPatchOverCAS.INSTANCE.cleanupCAS();
                        return;
                    }
                }
                Object var4_1 = null;
                OPatchEnv.unsetCASPhase1();
                OPatchEnv.unsetCASPhase2();
                OPatchEnv.setCASFlow(false);
                if (!OPatchEnv.isCASCleanupNeeded()) return;
                OPatchOverCAS.INSTANCE.cleanupCAS();
                return;
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                OPatchEnv.unsetCASPhase1();
                OPatchEnv.unsetCASPhase2();
                OPatchEnv.setCASFlow(false);
                if (!OPatchEnv.isCASCleanupNeeded()) throw throwable;
                OPatchOverCAS.INSTANCE.cleanupCAS();
                throw throwable;
            }
        }
        OPatchEnv.setCASFlow(false);
        if (OPatchEnv.isReport()) {
            OLogger.printlnOnLog("NApply::Report mode, OPatch runs with legacy process.");
        } else {
            OLogger.printlnOnLog("NApply::no CAS enabled, OPatch runs with legacy process.");
        }
        NApply.legacy_process(oracleHomePath);
    }

    public static NApplyData legacy_process(String oracleHomePath) throws RuntimeException, Error, FailedPrereqException {
        if (OPatchEnv.isReport()) {
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Napply session in report mode - Start");
        }
        NApplyData data = null;
        if (OPatchEnv.isOPatchSDKMode()) {
            List<PatchObject> pos = NApplyData.getPrereqPatchObject();
            PatchObject[] patchObjs = pos == null ? null : pos.toArray(new PatchObject[pos.size()]);
            data = NApply.legacy_process(oracleHomePath, patchObjs);
        } else {
            data = NApply.legacy_process(oracleHomePath, null);
        }
        if (OPatchEnv.isReport()) {
            OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Napply session in report mode - End");
        }
        return data;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NApplyData legacy_process(String oracleHomePath, PatchObject[] piList) throws RuntimeException, Error, FailedPrereqException {
        RuntimeException re;
        RuntimeException re2;
        StringBuffer buff = new StringBuffer("NApply::process() on \"");
        buff.append(oracleHomePath);
        buff.append("\"");
        OLogger.debug(buff);
        if (OPatchEnv.isReport() && OPatchEnv.isCASFlow() && OPatchEnv.isOPatchSDKMode() && OUSession.isPhaseOneReport()) {
            NApply.runPreSKDApplyPrereqs(oracleHomePath, piList);
        }
        NApplyData data = new NApplyData();
        NApplyDataSerializer serializer = new NApplyDataSerializer();
        ProcessFileVersions proc = new ProcessFileVersions();
        OPatchEnv.setNApply(true);
        OneOffEntry[] patchesToApply = new OneOffEntry[]{};
        OneOffEntry[] OHOneOffs = new OneOffEntry[]{};
        PatchObject[] apPatchObjects = new PatchObject[]{};
        IIPMRWServices rwServices = null;
        RacProcessor.MinDowntimeNodeSelection selects = null;
        PrereqSet patchesToBeMerged = new PrereqSet();
        PrereqSet patchesNotNeeded = new PrereqSet();
        PrereqSet patchesThatCanGoNow = new PrereqSet();
        PrereqSet patchesToBeRolledBack = new PrereqSet();
        boolean isLocal = OPatchEnv.isLocal();
        OLogger.println(OLogger.getString("OUI-67910"));
        StringBuffer dBuff = new StringBuffer("N-Apply: lock Oracle Home to get inventory.");
        OLogger.debug(dBuff);
        if (Rules.OUIRead_continue()) {
            OLogger.log(OLogger.FINE, "Lock the home to access inventory.");
            try {
                rwServices = UtilSession.getRWServices(oracleHomePath);
            }
            catch (Throwable t) {
                RuntimeException e2 = new RuntimeException(t.getMessage());
                e2.setStackTrace(e2.getStackTrace());
                throw e2;
            }
            if (!rwServices.isInventoryLoaded()) {
                buff = new StringBuffer("NApply was not able to get an Inventory Session.");
                throw new RuntimeException(buff.toString());
            }
        } else {
            dBuff = new StringBuffer("N-Apply: OUIRead_continue = false, ");
            dBuff.append("No home locking, Inventory not created.");
            OLogger.debug(dBuff);
        }
        data.setModelCode(PatchingModel.returnModelCode(oracleHomePath));
        int modelCode = data.getModelCode();
        boolean fc = OPatchEnv.isForceConflict();
        if (fc) {
            try {
                OHOneOffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
                data.setBeforePohs(OHOneOffs);
            }
            catch (Throwable e3) {
                OLogger.debug(new StringBuffer("Converting Throwable to RuntimeException"));
                re2 = new RuntimeException(e3.getMessage());
                re2.setStackTrace(e3.getStackTrace());
            }
        }
        OLogger.justlog(OLogger.INFO, "[OPSR-TIME] Running prerequisite checks");
        if (OPatchEnv.isSkipDuplicate() || OPatchEnv.isSkipSubset()) {
            OLogger.warn("OUI-67738");
        }
        EnvValidation.validate(oracleHomePath);
        try {
            dBuff = new StringBuffer("N-Apply: get a list of patches.");
            OLogger.debug(dBuff);
            if (piList == null) {
                patchesToApply = OPatchUtilHelper.getPatchesToApply(oracleHomePath, sessionName);
            } else {
                OneOffEntry[] inPatch = new OneOffEntry[piList.length];
                for (int i3 = 0; i3 < piList.length; ++i3) {
                    inPatch[i3] = piList[i3].toOneOffEntry(oracleHomePath);
                }
                patchesToApply = inPatch;
            }
            data.setPatchesToApply(patchesToApply);
            if (OPS.INSTANCE.getSupportServices().isSupport(Feature.FA_TWO_PHASE)) {
                OPatchEnv.setFATwoPhase();
                if (proc.validateResult(oracleHomePath, OHOneOffs, patchesToApply)) {
                    OPatchEnv.setHashMatch();
                    OLogger.printlnOnLogAndVerbose("NApply SDK:Hash matches for FA snowball two-phase patching. Use pre-computed FVs.\n");
                }
            }
            PatchValidation pv = new PatchValidation(data);
            pv.validatePatch(data);
            BuildComposite bc = new BuildComposite(data);
            bc.checkComposite(data);
            if (data.isComposite()) {
                bc.buildCompositeArray(data);
                data.setCompositeIdenticalPatches(CompositePatchObject.GetIdenticalPatch(data.getCompositeSubArray(), oracleHomePath));
            }
        }
        catch (Exception e4) {
            if (e4 instanceof OnlinePatchException) {
                throw (OnlinePatchException)e4;
            }
            if (e4 instanceof SymbolFailureException) {
                throw (SymbolFailureException)e4;
            }
            if (e4 instanceof PatchValidationException) {
                throw (PatchValidationException)e4;
            }
            re2 = new RuntimeException(e4.getMessage());
            re2.setStackTrace(e4.getStackTrace());
            OPatchStateManagerFactory.getInstance().setErrorCode(215);
            throw re2;
        }
        if (data.isComposite() && modelCode == 2) {
            String errorBuff = OLogger.getString("OUI-67927");
            throw new RuntimeException(errorBuff);
        }
        HashSet[] filteredPatchActions = null;
        filteredPatchActions = new HashSet[patchesToApply.length];
        for (int i4 = 0; i4 < patchesToApply.length; ++i4) {
            filteredPatchActions[i4] = new HashSet();
        }
        data.setPatchActions(filteredPatchActions);
        try {
            PatchObject[] initialApplyPatchObjects = OPatchUtilHelper.getPatchesToApply(oracleHomePath, patchesToApply, sessionName);
            OPatchSessionHelper.checkIfSidAddition(oracleHomePath, initialApplyPatchObjects);
            OPatchSessionHelper.getWlsPatchProfile(initialApplyPatchObjects);
            patchesToApply = PrereqFilterDuplicatePatch.filterDupPi(patchesToApply);
            data.setPatchesToApply(patchesToApply);
        }
        catch (Exception e5) {
            RuntimeException re3 = new RuntimeException(e5.getMessage());
            re3.setStackTrace(e5.getStackTrace());
            throw re3;
        }
        CheckIntraConflict intra = new CheckIntraConflict(data);
        intra.doIntraCheck(oracleHomePath, data);
        CheckMissingComps checkMc = new CheckMissingComps(data);
        boolean b2 = checkMc.doMcCheck(oracleHomePath, data);
        if (b2) {
            return data;
        }
        patchesToApply = data.getPatchesToApply();
        CheckInterConflict inter = new CheckInterConflict(data);
        boolean sc = OPatchEnv.isIgnoreConflict();
        boolean checkAgain = true;
        boolean showCanGo = false;
        OPatchEnv.setForceConflict(false);
        inter.getAllRes(oracleHomePath, data);
        ConflictMatrixOutput interOutput = data.getInterOutput();
        patchesToBeMerged = new PrereqSet(interOutput.getListOfPatchesToBeMerged());
        ArrayList<OneOffEntry> patchesCanGoForDup = new ArrayList<OneOffEntry>(Arrays.asList(interOutput.getListOfPatchesThatCanGoNow()));
        ArrayList<String> worsePatchesForDup = new ArrayList<String>(interOutput.getListOfWorsePatches());
        ArrayList<OneOffEntry> patchesToApplyForDup = new ArrayList<OneOffEntry>();
        for (OneOffEntry patchToApply : patchesToApply) {
            if (!patchToApply.getIsComposite() && patchesCanGoForDup.contains(patchToApply) && worsePatchesForDup.contains(patchToApply.getID())) continue;
            patchesToApplyForDup.add(patchToApply);
        }
        OneOffEntry[] patchesToApplyForDupArr = new OneOffEntry[patchesToApplyForDup.size()];
        patchesToApplyForDup.toArray(patchesToApplyForDupArr);
        NApplyData dataToCheckDup = new NApplyData();
        dataToCheckDup.setModelCode(data.getModelCode());
        dataToCheckDup.setPatchesToApply(patchesToApplyForDupArr);
        try {
            BuildComposite bcDup = new BuildComposite(dataToCheckDup);
            bcDup.checkComposite(dataToCheckDup);
            if (dataToCheckDup.isComposite()) {
                bcDup.buildCompositeArray(dataToCheckDup);
                dataToCheckDup.setCompositeIdenticalPatches(CompositePatchObject.GetIdenticalPatch(dataToCheckDup.getCompositeSubArray(), oracleHomePath));
            }
        }
        catch (Exception e6) {
            RuntimeException re4 = new RuntimeException(e6.getMessage());
            re4.setStackTrace(e6.getStackTrace());
            OPatchStateManagerFactory.getInstance().setErrorCode(215);
            throw re4;
        }
        CheckDuplicate dup = new CheckDuplicate(dataToCheckDup);
        if (dup.check(oracleHomePath, dataToCheckDup) && patchesToApplyForDupArr.length == patchesToApply.length) {
            return data;
        }
        if (interOutput.getResult().equals(PrereqResult.ExecuteStatus.FAILED) && !fc) {
            ConflictReporter.processFailUI(data);
            ConflictReporter.processFailMessage(data);
        } else if (interOutput.getResult().equals(PrereqResult.ExecuteStatus.PASSED)) {
            checkAgain = false;
        }
        if (checkAgain) {
            ConflictReporter.processFailUI(data);
            if (!OPatchEnv.proceedWithOperationDefaultYes(new StringBuffer())) {
                buff = new StringBuffer("NApply stops on user's request.");
                throw new PrereqFailedException(buff.toString());
            }
            OPatchEnv.setForceConflict(fc);
            boolean passed = inter.doInterCheck(oracleHomePath, data);
            if (!passed) {
                ConflictReporter.processFailMessage(data);
            }
        }
        if (!checkAgain) {
            ConflictReporter.processSucceedUI(data, checkAgain);
        }
        if (!data.getCanGoFlag()) {
            return data;
        }
        boolean needMergeRequest = data.getMergedFlag();
        boolean hasNotNeededPatch = data.getNotNeedFlag();
        boolean hasPatchToApply = data.getCanGoFlag();
        boolean hasAutoRollback = data.getRollbackFlag();
        if (OPatchEnv.isFATwoPhase()) {
            try {
                OLogger.printlnOnLog("NApply: Parsed cached FVs for copying files in ApplySession...\n");
                CopyAction.setHashMapEnv(new HashMap<String, String>(serializer.deserializeFileVersion(OPatchEnv.getPrereqResultFileLoc(oracleHomePath) + File.separator + "fv_delta.txt")));
                DeleteAction.setEnvDeleteActVer(new HashMap<String, List<String>>(serializer.deserializeFileVersionList(OPatchEnv.getPrereqResultFileLoc(oracleHomePath) + File.separator + "fv_delta_delete.txt")));
                CopyAction.setHashMap(new HashMap<String, String>(serializer.deserializeFileVersion(OPatchEnv.getPrereqResultFileLoc(oracleHomePath) + File.separator + "fv_oh.txt")));
                CopyAction.setIHashMap(new HashMap<String, String>(serializer.deserializeFileVersion(OPatchEnv.getPrereqResultFileLoc(oracleHomePath) + File.separator + "fv_pi_merge.txt")));
                DeleteAction.setiDeleteActVer(new HashMap<String, List<String>>(serializer.deserializeFileVersionList(OPatchEnv.getPrereqResultFileLoc(oracleHomePath) + File.separator + "fv_pi_delete.txt")));
            }
            catch (Exception e7) {
                e7.printStackTrace();
                OLogger.printlnOnLog("NApply: Unable to read file/versions data from cached files, unset two-phase patching mode");
                OPatchEnv.unsetFATwoPhase();
            }
        }
        OPatchSessionHelper.validateOCMOption(oracleHomePath, rwServices);
        if (!OPatchEnv.isCASFlow()) {
            RunInit init = new RunInit(data);
            init.runInit(oracleHomePath, data);
        }
        ProcessLists pl = new ProcessLists(data);
        pl.processRollback(oracleHomePath, data);
        pl.processCanGo(data);
        if (hasPatchToApply) {
            dBuff = new StringBuffer("These patches can be applied:");
            dBuff.append(data.getProceedList());
            OLogger.debug(dBuff);
        }
        if (hasAutoRollback) {
            dBuff = new StringBuffer("If OPatch proceeds, these patches ");
            dBuff.append("will be rolled back:").append(data.getHasAutoRollbackMsg());
            OLogger.debug(dBuff);
        }
        dBuff = new StringBuffer("N-Apply: get the PatchObjects");
        OLogger.debug(dBuff);
        GetFinalList gf = new GetFinalList(data);
        gf.getFinal(oracleHomePath, data);
        try {
            PatchObject[] filteredPatchObjects = data.getApPatchObjects();
            String[] filteredPatchLocs = OPatchUtilHelper.getPatchLocs(filteredPatchObjects);
            patchesToApply = data.getPatchesToApply();
            buff = new StringBuffer("Run all the prereqs related to apply.");
            OLogger.debug(buff);
            OPatchSessionHelper.runApplyPrereqs(oracleHomePath, patchesToApply, filteredPatchObjects, filteredPatchLocs);
        }
        catch (FailedPrereqException fpe) {
            throw fpe;
        }
        catch (Exception e8) {
            RuntimeException re5 = new RuntimeException(e8.getMessage());
            re5.setStackTrace(e8.getStackTrace());
            throw re5;
        }
        if (hasPatchToApply) {
            OUSession.addNApplyPatchesToReport(data.getApPatchObjects());
            OLogger.println("OPatch continues with these patches: " + data.getFinalList());
        }
        if (OPatchSessionHelper.hasNonHotPatch(data.getCanGoPatches()) && OPatchSessionHelper.hasHotPatch(data.getRollbackPatches())) {
            String msg = OLogger.getString("OUI-67279", new Object[]{OPatchSessionHelper.getHotPatchIDs(data.getRollbackPatches()), OPatchSessionHelper.getPatchIDs(data.getCanGoPatches())});
            PrereqFailedException re6 = new PrereqFailedException(msg);
            throw re6;
        }
        if (!OPatchEnv.proceedWithOperationDefaultYes(new StringBuffer())) {
            buff = new StringBuffer("NApply stops on user's request.");
            throw new ExitOPatchException(buff.toString());
        }
        CreateMergedPatch cmp = new CreateMergedPatch(data);
        cmp.merge(oracleHomePath, data);
        MergedPatchObject mPo = data.getMpo();
        PatchObject[] arbPatchObjects = data.getArbPatchObjects();
        ArrayList patchesMerged = data.getPatchesMerged();
        buff = new StringBuffer("\n");
        buff.append(sessionName);
        buff.append(": backed-up files are under \"");
        String loc = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, data.getMpo().getCookedPatchID());
        buff.append(loc);
        buff.append("\"\n");
        OLogger.log(OLogger.FINE, buff.toString());
        if (!OPatchEnv.isCASFlow()) {
            RunConsolidatedScripts rcs = new RunConsolidatedScripts(data);
            rcs.runScripts(oracleHomePath, data);
        }
        dBuff = new StringBuffer("N-Apply: step 7, do remaining Prereqs except ");
        dBuff.append("component checking.");
        OLogger.debug(dBuff);
        OneOffEntry[] autorbOneOffs = OPatchUtilHelper.getAutoRollbackOneOffs();
        if (autorbOneOffs != null && autorbOneOffs.length > 0) {
            buff = new StringBuffer("Run all the prereqs related to autorollback");
            OLogger.debug(buff);
            OPatchSessionHelper.runAutoRollbackPrereqs(oracleHomePath, OPatchUtilHelper.getAutoRollbackOneOffs(), OPatchUtilHelper.getAutoRollbackPatchObjects(oracleHomePath), data.getApOneOffs());
        }
        OLogger.printlnOnConsole(OLogger.getString("OUI-67911"));
        OLogger.justlog(OLogger.INFO, "[OPSR-TIME] " + OLogger.getString("OUI-67911"));
        try {
            OPatchSessionHelper.processOCM(rwServices, oracleHomePath);
        }
        catch (OCMException excep) {
            throw excep;
        }
        catch (Exception excep) {
            // empty catch block
        }
        dBuff = new StringBuffer("N-Apply: step 8, prompt for shutdown ");
        OLogger.debug(dBuff);
        try {
            selects = mPo.promptForShutdown(oracleHomePath, rwServices);
        }
        catch (ExitOPatchException e9) {
            buff = new StringBuffer("UtilSession: NApply exits on user's request.");
            OLogger.println(buff.toString());
            throw e9;
        }
        catch (RuntimeException e10) {
            throw e10;
        }
        String cookedPatchID = mPo.getCookedPatchID();
        OLogger.println(OLogger.getString("OUI-67912"));
        OPatchUtilHelper.createUtilSessionPatchStorageLocation(oracleHomePath, cookedPatchID);
        ArrayList<String> patchListToApply = new ArrayList<String>();
        ArrayList<String> patchListToRollback = new ArrayList<String>();
        for (OneOffEntry patchToApply : data.getCanGoPatches().getAllElements()) {
            patchListToApply.add(patchToApply.getTripletID());
        }
        for (OneOffEntry patchToRollback : data.getRollbackPatches().getAllElements()) {
            patchListToRollback.add(patchToRollback.getTripletID());
        }
        if (!OPatchEnv.isCASFlow()) {
            mPo.backupForRestore(oracleHomePath, rwServices, patchListToApply.toArray(new String[0]), patchListToRollback.toArray(new String[0]));
        }
        OPatchUtilHelper.setupRLibBackupDir(oracleHomePath, cookedPatchID);
        apPatchObjects = data.getApPatchObjects();
        if (Rules.SystemWrite_continue() || Rules.OUIWrite_continue()) {
            String[] patchIDs = new String[apPatchObjects.length];
            for (int i5 = 0; i5 < apPatchObjects.length; ++i5) {
                patchIDs[i5] = apPatchObjects[i5].getPatchID();
            }
            String[] triggeredPatchIDs = new String[arbPatchObjects.length];
            for (int j2 = 0; j2 < arbPatchObjects.length; ++j2) {
                triggeredPatchIDs[j2] = arbPatchObjects[j2].getPatchID();
            }
            OPatchSessionHelper.createSessionProperties(oracleHomePath, sessionName, mPo.getCookedPatchID(), patchIDs, triggeredPatchIDs);
        }
        try {
            OPatchACL.setLocal(new NApply(), true);
        }
        catch (IllegalAccessException patchIDs) {
            // empty catch block
        }
        String psLoc = OPatchUtilHelper.getUtilSessionPatchStorageLocation(oracleHomePath, mPo.getCookedPatchID());
        buff = new StringBuffer("\nNApply: begins applying each patch...");
        OLogger.debug(buff);
        boolean doRestore = false;
        dBuff = new StringBuffer("N-Apply: Step 10) Create interim_inventory.txt ");
        OLogger.debug(dBuff);
        String sInterim = OPatchEnv.getInterimInventoryFileLoc(oracleHomePath);
        String rInterim = OPatchEnv.getRecordInventoryFileLoc(oracleHomePath);
        File fInterim = null;
        fInterim = new File(sInterim);
        if (fInterim.exists()) {
            fInterim.delete();
        }
        File frInterim = null;
        frInterim = new File(rInterim);
        if (frInterim.exists()) {
            frInterim.delete();
        }
        FileWriter fw = null;
        BufferedWriter interimWrite = null;
        try {
            String bID;
            Bug[] bugs;
            String id;
            PatchObject po;
            StringBuffer line;
            OPatchSessionHelper.writeRecordedEntries(fInterim, "napply", rwServices);
            OPatchSessionHelper.writeRecordedEntries(frInterim, "napply", rwServices);
            fw = new FileWriter(fInterim, true);
            interimWrite = new BufferedWriter(fw);
            String comment = "# napply: list of patches to be applied.\n";
            interimWrite.write(comment);
            for (int i6 = 0; i6 < apPatchObjects.length; ++i6) {
                line = new StringBuffer();
                po = apPatchObjects[i6];
                id = po.getPatchID();
                line.append(id).append(":apply:");
                bugs = po.getBugsToFix();
                for (int j3 = 0; j3 < bugs.length; ++j3) {
                    bID = bugs[j3].getBugID();
                    line.append(bID);
                    if (j3 >= bugs.length - 1) continue;
                    line.append(",");
                }
                line.append("\n");
                interimWrite.write(line.toString());
                interimWrite.flush();
            }
            comment = "# napply: list of patches to be auto-rolled back.\n";
            interimWrite.write(comment);
            for (int i2 = 0; i2 < arbPatchObjects.length; ++i2) {
                line = new StringBuffer();
                po = arbPatchObjects[i2];
                id = po.getPatchID();
                line.append(id).append(":rollback:");
                bugs = po.getBugsToFix();
                for (int j2 = 0; j2 < bugs.length; ++j2) {
                    bID = bugs[j2].getBugID();
                    line.append(bID);
                    if (j2 >= bugs.length - 1) continue;
                    line.append(",");
                }
                line.append("\n");
                interimWrite.write(line.toString());
                interimWrite.flush();
            }
            interimWrite.close();
            fw.close();
        }
        catch (Exception comment) {
            // empty catch block
        }
        dBuff = new StringBuffer("N-Apply: Step 11, apply each patch ");
        OLogger.debug(dBuff);
        for (int i7 = 0; i7 < apPatchObjects.length; ++i7) {
            InterruptedException interruptedException2;
            Object var66_135;
            String msg;
            if (i7 > 0) {
                doRestore = true;
            }
            PatchObject po = apPatchObjects[i7];
            String patchID = po.getPatchID();
            String patchLoc = po.getPatchLocation();
            po.disableFuserCheck();
            po.disablePromptForShutdown();
            po.disablePromptForStartup();
            po.disableRestoreFileCreation();
            po.disableSystemCommandCheck();
            buff = new StringBuffer("\nUser specify system property APPLY_MAKE, ");
            buff.append("OPatch won't disableMakeAction or disableRenerateLibrary ");
            buff.append("for NApply.\n");
            OLogger.debug(buff);
            if (!OPatchEnv.isApplyMake()) {
                po.disableMakeAction();
                po.disableRegenerateLibrary();
            }
            if (OPatchEnv.isCASFlow()) {
                po.disablePrePostInit();
                buff = new StringBuffer("N-Apply: Disable all pre/post/init of patch if CAS is enabled. ");
                OLogger.debug(buff);
            }
            buff = new StringBuffer("\nApplying patch ");
            buff.append(patchID);
            buff.append("...\n");
            OLogger.justlog(OLogger.INFO, buff.toString());
            Bug[] bugsToFix = po.getBugsToFix();
            if (bugsToFix.length == 0) {
                dBuff = new StringBuffer("N-Apply: patch ").append(patchID);
                dBuff.append(" has no basebug info.");
                OLogger.debug(dBuff);
                msg = OLogger.getString("OUI-67132");
                RuntimeException re7 = new RuntimeException(msg);
                throw re7;
            }
            StringBuffer tBuf23332 = new StringBuffer();
            for (int nBugs = 0; nBugs < bugsToFix.length; ++nBugs) {
                Bug b3 = bugsToFix[nBugs];
                tBuf23332.append("   ");
                tBuf23332.append(b3.getBugID());
                tBuf23332.append(": ");
                tBuf23332.append(b3.getDesc());
                tBuf23332.append("\n");
            }
            msg = OLogger.getString("OUI-67216", new Object[]{po.getPatchID(), tBuf23332.toString()});
            OLogger.verbose(OPatchSession.UTIL, new StringBuffer(msg));
            buff = new StringBuffer("calling ApplySession::process() ");
            buff.append(" with a PatchObject.");
            OLogger.debug(buff);
            try {
                OPatchUtilHelper.createAndUpdatePatchList(oracleHomePath, mPo.getCookedPatchID(), po, sessionName);
            }
            catch (Exception tBuf23332) {
                // empty catch block
            }
            ApplySession applySession = OPatchSession.APPLY;
            try {
                try {
                    OPatchACL.processApply(new NApply(), applySession, patchLoc, oracleHomePath, po, new HashSet());
                }
                catch (IllegalAccessException e11) {
                    buff = new StringBuffer("NApply doesn't have permission to invoke ApplySession::process(). ");
                    buff.append(e11.getMessage());
                    RuntimeException re8 = new RuntimeException(buff.toString());
                    re8.setStackTrace(e11.getStackTrace());
                    throw re8;
                }
                catch (RuntimeException e12) {
                    OLogger.warn("OUI-67124", new Object[]{e12.getMessage()});
                    if (!doRestore) throw e12;
                    buff = new StringBuffer("Some patches have been processed --> treat as Error.");
                    OLogger.debug(buff);
                    boolean ok = mPo.restoreOH(oracleHomePath, data.getCanGoPatches().getAllElements());
                    OPatchUtilHelper.warnRestoreMessage(sessionName, psLoc, ok);
                    if (ok) throw e12;
                    Error err = new Error(e12.getMessage());
                    err.setStackTrace(e12.getStackTrace());
                    throw err;
                }
                catch (Error e13) {
                    OLogger.warn("OUI-67124", new Object[]{e13.getMessage()});
                    boolean ok = mPo.restoreOH(oracleHomePath, data.getCanGoPatches().getAllElements());
                    OPatchUtilHelper.warnRestoreMessage(sessionName, psLoc, ok);
                    if (!ok) {
                        throw e13;
                    }
                    RuntimeException re9 = new RuntimeException(e13.getMessage());
                    re9.setStackTrace(e13.getStackTrace());
                    throw re9;
                }
                var66_135 = null;
                {
                }
            }
            catch (Throwable throwable) {
                var66_135 = null;
                try {
                    Thread.sleep(1000L);
                    throw throwable;
                }
                catch (InterruptedException interruptedException2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (InterruptedException interruptedException2) {}
            Thread.sleep(1000L);
        }
        OLogger.log(OLogger.FINE, "\nDone applying all patches.\n");
        if (!OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
            ApplySession applySession = OPatchSession.APPLY;
            try {
                OPatchACL.verifyApply(new NApply(), applySession, rwServices, oracleHomePath, apPatchObjects);
            }
            catch (IllegalAccessException e14) {
                buff = new StringBuffer("NApply doesn't have permission to invoke ApplySession::process(). ");
                buff.append(e14.getMessage());
                re = new RuntimeException(buff.toString());
                re.setStackTrace(e14.getStackTrace());
                throw re;
            }
            catch (RuntimeException e15) {
                OLogger.warn("OUI-67124", new Object[]{e15.getMessage()});
                throw e15;
            }
            catch (Error e16) {
                OLogger.warn("OUI-67124", new Object[]{e16.getMessage()});
                boolean ok = mPo.restoreOH(oracleHomePath, data.getCanGoPatches().getAllElements());
                OPatchUtilHelper.warnRestoreMessage(sessionName, psLoc, ok);
                if (!ok) {
                    throw e16;
                }
                RuntimeException re10 = new RuntimeException(e16.getMessage());
                re10.setStackTrace(e16.getStackTrace());
                throw re10;
            }
        }
        if (!OPatchEnv.isApplyMake() && !OPatchEnv.isCASFlow()) {
            dBuff = new StringBuffer("N-Apply: Step 12, ");
            dBuff.append(" run all consolidated makes.");
            dBuff.append(" OPatch run this step only when user doesn't specify 'APPLY_MAKE' ");
            OLogger.debug(dBuff);
            try {
                PatchObject[] patchesTouched = new PatchObject[patchesMerged.size()];
                patchesMerged.toArray(patchesTouched);
                mPo.invokeConsolidatedMake(oracleHomePath, apPatchObjects);
            }
            catch (Throwable e17) {
                boolean ok = mPo.restoreOH(oracleHomePath);
                OPatchUtilHelper.warnRestoreMessage(sessionName, psLoc, ok);
                if (!ok) {
                    Error err = new Error(e17.getMessage());
                    err.setStackTrace(e17.getStackTrace());
                    throw err;
                }
                re = new RuntimeException(e17.getMessage());
                re.setStackTrace(e17.getStackTrace());
                throw re;
            }
            dBuff = new StringBuffer("N-Apply: Step 12.5, ");
            dBuff.append(" run all consolidated library regenerations.");
            dBuff.append(" OPatch run this step only when user doesn't specify 'APPLY_MAKE' ");
            OLogger.debug(dBuff);
            mPo.invokeConsolidatedRLib(oracleHomePath, apPatchObjects);
        }
        for (int i2 = 0; i2 < arbPatchObjects.length && OPatchEnv.isRunSql(); ++i2) {
            String originalPatchLoc = OPatchEnv.getPatchBackupDirectoryPath(oracleHomePath, arbPatchObjects[i2].getCookedPatchID());
            PatchmdXml rollbackSql = new PatchmdXml(oracleHomePath, originalPatchLoc, false, arbPatchObjects[i2].getAllIncludedCopyActions(), arbPatchObjects[i2].getPatchID());
            String rollbackSqlPath = rollbackSql.getSqlPath();
            if (rollbackSqlPath == null || rollbackSqlPath.equals("")) continue;
            try {
                OLogger.println(OLogger.getString("OUI-67272", new Object[]{"auto-rollback", rollbackSqlPath, arbPatchObjects[i2].getPatchID()}));
                OPatchSessionHelper.runSqlScript(rollbackSqlPath, arbPatchObjects[i2].getPatchInventory().isSqlMigrate());
                continue;
            }
            catch (RuntimeException e18) {
                OLogger.printStackTrace(e18);
                OLogger.printlnOnLog(OLogger.INFO, e18.getMessage());
                OLogger.warn(OLogger.getString("OUI-67273", new Object[]{"auto-rollback", rollbackSqlPath, arbPatchObjects[i2].getPatchID()}));
            }
        }
        for (int i3 = 0; i3 < apPatchObjects.length && OPatchEnv.isRunSql(); ++i3) {
            String pLoc = apPatchObjects[i3].getPatchLocation();
            PatchmdXml applySql = new PatchmdXml(oracleHomePath, pLoc, true, apPatchObjects[i3].getAllIncludedCopyActions(), apPatchObjects[i3].getPatchID());
            String applySqlPath = applySql.getSqlPath();
            if (applySqlPath == null || applySqlPath.equals("")) continue;
            try {
                OLogger.println(OLogger.getString("OUI-67272", new Object[]{"apply", applySqlPath, apPatchObjects[i3].getPatchID()}));
                OPatchSessionHelper.runSqlScript(applySqlPath, apPatchObjects[i3].getPatchInventory().isSqlMigrate());
                continue;
            }
            catch (RuntimeException e19) {
                OLogger.printStackTrace(e19);
                OLogger.printlnOnLog(OLogger.INFO, e19.getMessage());
                OLogger.warn(OLogger.getString("OUI-67273", new Object[]{"apply", applySqlPath, apPatchObjects[i3].getPatchID()}));
            }
        }
        try {
            OPatchSession.runCustomScript();
        }
        catch (RuntimeException e20) {
            OLogger.printStackTrace(e20);
            OLogger.printlnOnLog(OLogger.INFO, e20.getMessage());
            OLogger.warn("OUI-67266", new Object[]{OPatchEnv.getSqlScriptFilePath()});
        }
        if (OPatchEnv.isRunSql()) {
            for (int i8 = 0; i8 < arbPatchObjects.length; ++i8) {
                if (!arbPatchObjects[i8].isSqlRelatedActions()) continue;
                OPatchSessionHelper.removeSidFromSqlPropertyFile(oracleHomePath, arbPatchObjects[i8].getCookedPatchID());
            }
        }
        String[] sidArray = OPatchEnv.getDBSIDs();
        String[] dbNodes = OPatchEnv.getDBNodes();
        String lNode = OPatchEnv.getLocalNode();
        StringBuffer sidValue = new StringBuffer("");
        for (int sidCount = 0; sidArray != null && sidCount < sidArray.length; ++sidCount) {
            if (!dbNodes[sidCount].equals(lNode) && !dbNodes[sidCount].equals("")) continue;
            sidValue.append(sidArray[sidCount]);
            if (sidCount == sidArray.length - 1) continue;
            sidValue.append(",");
        }
        if (sidValue.toString().endsWith(",")) {
            String temp = sidValue.toString().substring(0, sidValue.toString().length() - 1);
            sidValue = new StringBuffer(temp);
        }
        for (int i9 = 0; i9 < apPatchObjects.length; ++i9) {
            Properties prop = new Properties();
            if (OPatchEnv.isRunSql() && apPatchObjects[i9].isSqlRelatedActions()) {
                prop.setProperty("RUNSQL", "true");
                prop.setProperty("SID", sidValue.toString());
            } else {
                prop.setProperty("RUNSQL", "unknown");
            }
            OPatchSessionHelper.setSqlPropertyToFile(prop, oracleHomePath, apPatchObjects[i9].getCookedPatchID());
        }
        Properties onlineProp = OPatchSessionHelper.getOnlinePropertyFromFile(oracleHomePath);
        OPatchSessionHelper.removeOnlineRollbackSids(onlineProp, arbPatchObjects, OPatchEnv.getLocalNode(), oracleHomePath);
        for (int i10 = 0; i10 < apPatchObjects.length; ++i10) {
            if (!apPatchObjects[i10].isOnlinePatch()) continue;
            OPatchSessionHelper.setOnlinePropertyToFile(oracleHomePath, OPatchEnv.getLocalNode(), apPatchObjects[i10].getPatchID());
        }
        if (Rules.SystemWrite_continue() && data.isComposite()) {
            try {
                CompositePatchObject.updateActiveXMLField(data.getCompositeIdenticalPatches(), oracleHomePath, data.getActivePatch());
            }
            catch (RuntimeException e21) {
                buff = new StringBuffer("Some patches have been processed --> treat as Error.");
                OLogger.debug(buff);
                boolean ok = mPo.restoreOH(oracleHomePath, data.getCanGoPatches().getAllElements());
                OPatchUtilHelper.warnRestoreMessage(sessionName, psLoc, ok);
                if (ok) throw e21;
                Error err = new Error(e21.getMessage());
                err.setStackTrace(e21.getStackTrace());
                throw err;
            }
        }
        dBuff = new StringBuffer("N-Apply: Step 14, prompt for start-up");
        OLogger.debug(dBuff);
        mPo.promptForStartup(oracleHomePath, rwServices);
        try {
            OPatchACL.setLocal(new NApply(), isLocal);
        }
        catch (IllegalAccessException e21) {
            // empty catch block
        }
        dBuff = new StringBuffer("N-Apply: calling processRemote()");
        OLogger.debug(dBuff);
        NApply.processRemote(oracleHomePath, selects, apPatchObjects, arbPatchObjects, mPo);
        OPatchSessionHelper.cleanup(oracleHomePath);
        if (rwServices.isLocked()) {
            try {
                dBuff = new StringBuffer("N-Apply: release() the home");
                OLogger.debug(dBuff);
                rwServices.release();
            }
            catch (Throwable t) {
                RuntimeException re11 = new RuntimeException(t.getMessage());
                re11.setStackTrace(t.getStackTrace());
                throw re11;
            }
        }
        dBuff = new StringBuffer("N-Apply: process() done.");
        OLogger.debug(dBuff);
        if (fc) {
            try {
                OHOneOffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
                data.setAfterPohs(OHOneOffs);
            }
            catch (Throwable e22) {
                OLogger.debug(new StringBuffer("Converting Throwable to RuntimeException"));
                RuntimeException re12 = new RuntimeException(e22.getMessage());
                re12.setStackTrace(e22.getStackTrace());
            }
        }
        PrintApplyReport pa = new PrintApplyReport(data);
        pa.printAppliedPatches(data);
        if (fc && !OPatchEnv.isReport()) {
            pa.printBugsReport(data);
        }
        OracleHomeConflictMap.printToInActivePatchMessage();
        if (OPatchEnv.isFATwoPhase()) {
            if (!OPatchEnv.isReport()) {
                proc.updateCachedFiles(oracleHomePath);
                proc.cleanCachedFiles(oracleHomePath);
            }
            OPatchEnv.unsetHashMatch();
            OPatchEnv.unsetFATwoPhase();
        }
        data.setBeforePohs(new OneOffEntry[0]);
        data.setAfterPohs(new OneOffEntry[0]);
        return data;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NApplyData legacy_process_binary(String oracleHomePath, PatchObject[] piList) throws RuntimeException, Error {
        int i2;
        StringBuffer buff = new StringBuffer("NApply::processBinary() on \"");
        buff.append(oracleHomePath);
        buff.append("\"");
        OLogger.debug(buff);
        ProcessFileVersions proc = new ProcessFileVersions();
        OPatchEnv.setNApply(true);
        boolean isLocal = OPatchEnv.isLocal();
        IIPMRWServices rwServices = null;
        StringBuffer dBuff = new StringBuffer("N-Apply: lock Oracle Home to get inventory.");
        OLogger.debug(dBuff);
        if (Rules.OUIRead_continue()) {
            OLogger.log(OLogger.FINE, "Lock the home to access inventory.");
            try {
                rwServices = UtilSession.getRWServices(oracleHomePath);
            }
            catch (Throwable t) {
                RuntimeException e2 = new RuntimeException(t.getMessage());
                e2.setStackTrace(e2.getStackTrace());
                throw e2;
            }
            if (!rwServices.isInventoryLoaded()) {
                buff = new StringBuffer("NApply was not able to get an Inventory Session.");
                throw new RuntimeException(buff.toString());
            }
        } else {
            dBuff = new StringBuffer("N-Apply: OUIRead_continue = false, ");
            dBuff.append("No home locking, Inventory not created.");
            OLogger.debug(dBuff);
        }
        OPatchSessionHelper.validateOCMOption(oracleHomePath, rwServices);
        try {
            OPatchSessionHelper.processOCM(rwServices, oracleHomePath);
        }
        catch (OCMException excep) {
            throw excep;
        }
        catch (Exception excep) {
            // empty catch block
        }
        NApplyData data = OPatchEnv.getNapplyData();
        OneOffEntry[] patchesToApply = new OneOffEntry[]{};
        dBuff = new StringBuffer("N-Apply: get a list of patches.");
        OLogger.debug(dBuff);
        OneOffEntry[] inPatch = new OneOffEntry[piList.length];
        for (int i3 = 0; i3 < piList.length; ++i3) {
            inPatch[i3] = piList[i3].toOneOffEntry(oracleHomePath);
        }
        patchesToApply = inPatch;
        data.setPatchesToApply(patchesToApply);
        boolean fc = OPatchEnv.isForceConflict();
        if (fc) {
            try {
                OneOffEntry[] OHOneOffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
                data.setBeforePohs(OHOneOffs);
            }
            catch (Throwable e3) {
                OLogger.debug(new StringBuffer("Converting Throwable to RuntimeException"));
                RuntimeException re = new RuntimeException(e3.getMessage());
                re.setStackTrace(e3.getStackTrace());
            }
        }
        RacProcessor.MinDowntimeNodeSelection selects = null;
        MergedPatchObject mPo = data.getMpo();
        dBuff = new StringBuffer("N-Apply: step 8, prompt for shutdown ");
        OLogger.debug(dBuff);
        try {
            selects = mPo.promptForShutdown(oracleHomePath, rwServices);
        }
        catch (ExitOPatchException e4) {
            buff = new StringBuffer("UtilSession: NApply exits on user's request.");
            OLogger.println(buff.toString());
            throw e4;
        }
        catch (RuntimeException e5) {
            throw e5;
        }
        OLogger.println(OLogger.getString("OUI-67912"));
        try {
            OPatchACL.setLocal(new NApply(), true);
        }
        catch (IllegalAccessException e5) {
            // empty catch block
        }
        String psLoc = OPatchUtilHelper.getUtilSessionPatchStorageLocation(oracleHomePath, data.getMpo().getCookedPatchID());
        buff = new StringBuffer("\nNApply: begins applying each patch...");
        OLogger.debug(buff);
        boolean doRestore = false;
        PatchObject[] apPatchObjects_total = data.getApPatchObjects();
        ArrayList<PatchObject> applyPatchList_total = new ArrayList<PatchObject>(Arrays.asList(apPatchObjects_total));
        ArrayList<PatchObject> applyPatchList = new ArrayList<PatchObject>(Arrays.asList(piList));
        applyPatchList.retainAll(applyPatchList_total);
        PatchObject[] apPatchObjects = applyPatchList.toArray(new PatchObject[applyPatchList.size()]);
        if (apPatchObjects.length == 0) {
            return data;
        }
        String msg = "";
        dBuff = new StringBuffer("N-Apply: Step 11, apply each patch ");
        OLogger.debug(dBuff);
        for (int i4 = 0; i4 < apPatchObjects.length; ++i4) {
            InterruptedException interruptedException2;
            Object var30_66;
            if (i4 > 0) {
                doRestore = true;
            }
            PatchObject po = apPatchObjects[i4];
            String patchID = po.getPatchID();
            String patchLoc = po.getPatchLocation();
            po.disableFuserCheck();
            po.disablePromptForShutdown();
            po.disablePromptForStartup();
            po.disableRestoreFileCreation();
            po.disableSystemCommandCheck();
            buff = new StringBuffer("\nUser specify system property APPLY_MAKE, ");
            buff.append("OPatch won't disableMakeAction or disableRenerateLibrary ");
            buff.append("for NApply.\n");
            OLogger.debug(buff);
            if (!OPatchEnv.isApplyMake()) {
                po.disableMakeAction();
                po.disableRegenerateLibrary();
            }
            if (OPatchEnv.isCASFlow()) {
                po.disablePrePostInit();
                buff = new StringBuffer("N-Apply: Disable all pre/post/init of patch if CAS is enabled. ");
                OLogger.debug(buff);
            }
            buff = new StringBuffer("\nApplying patch ");
            buff.append(patchID);
            buff.append("...\n");
            OLogger.justlog(OLogger.INFO, buff.toString());
            Bug[] bugsToFix = po.getBugsToFix();
            if (bugsToFix.length == 0) {
                dBuff = new StringBuffer("N-Apply: patch ").append(patchID);
                dBuff.append(" has no basebug info.");
                OLogger.debug(dBuff);
                msg = OLogger.getString("OUI-67132");
                RuntimeException re = new RuntimeException(msg);
                throw re;
            }
            StringBuffer tBuf23332 = new StringBuffer();
            for (int nBugs = 0; nBugs < bugsToFix.length; ++nBugs) {
                Bug b2 = bugsToFix[nBugs];
                tBuf23332.append("   ");
                tBuf23332.append(b2.getBugID());
                tBuf23332.append(": ");
                tBuf23332.append(b2.getDesc());
                tBuf23332.append("\n");
            }
            msg = OLogger.getString("OUI-67216", new Object[]{po.getPatchID(), tBuf23332.toString()});
            OLogger.verbose(OPatchSession.UTIL, new StringBuffer(msg));
            buff = new StringBuffer("calling ApplySession::process() ");
            buff.append(" with a PatchObject.");
            OLogger.debug(buff);
            try {
                OPatchUtilHelper.createAndUpdatePatchList(oracleHomePath, mPo.getCookedPatchID(), po, sessionName);
            }
            catch (Exception tBuf23332) {
                // empty catch block
            }
            ApplySession applySession = OPatchSession.APPLY;
            try {
                try {
                    OPatchACL.processApply(new NApply(), applySession, patchLoc, oracleHomePath, po, new HashSet());
                }
                catch (IllegalAccessException e6) {
                    buff = new StringBuffer("NApply doesn't have permission to invoke ApplySession::process(). ");
                    buff.append(e6.getMessage());
                    RuntimeException re = new RuntimeException(buff.toString());
                    re.setStackTrace(e6.getStackTrace());
                    throw re;
                }
                catch (RuntimeException e7) {
                    OLogger.warn("OUI-67124", new Object[]{e7.getMessage()});
                    if (!doRestore) throw e7;
                    buff = new StringBuffer("Some patches have been processed --> treat as Error.");
                    OLogger.debug(buff);
                    boolean ok = mPo.restoreOH(oracleHomePath, data.getCanGoPatches().getAllElements());
                    OPatchUtilHelper.warnRestoreMessage(sessionName, psLoc, ok);
                    if (ok) throw e7;
                    Error err = new Error(e7.getMessage());
                    err.setStackTrace(e7.getStackTrace());
                    throw err;
                }
                catch (Error e8) {
                    OLogger.warn("OUI-67124", new Object[]{e8.getMessage()});
                    boolean ok = mPo.restoreOH(oracleHomePath, data.getCanGoPatches().getAllElements());
                    OPatchUtilHelper.warnRestoreMessage(sessionName, psLoc, ok);
                    if (!ok) {
                        throw e8;
                    }
                    RuntimeException re = new RuntimeException(e8.getMessage());
                    re.setStackTrace(e8.getStackTrace());
                    throw re;
                }
                var30_66 = null;
                {
                }
            }
            catch (Throwable throwable) {
                var30_66 = null;
                try {
                    Thread.sleep(1000L);
                    throw throwable;
                }
                catch (InterruptedException interruptedException2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (InterruptedException interruptedException2) {}
            Thread.sleep(1000L);
        }
        OLogger.log(OLogger.FINE, "\nDone applying all patches.\n");
        ApplySession applySession = OPatchSession.APPLY;
        try {
            OPatchACL.verifyApply(new NApply(), applySession, rwServices, oracleHomePath, apPatchObjects);
        }
        catch (IllegalAccessException e9) {
            buff = new StringBuffer("NApply doesn't have permission to invoke ApplySession::process(). ");
            buff.append(e9.getMessage());
            RuntimeException re = new RuntimeException(buff.toString());
            re.setStackTrace(e9.getStackTrace());
            throw re;
        }
        catch (RuntimeException e10) {
            OLogger.warn("OUI-67124", new Object[]{e10.getMessage()});
            throw e10;
        }
        catch (Error e11) {
            OLogger.warn("OUI-67124", new Object[]{e11.getMessage()});
            boolean ok = mPo.restoreOH(oracleHomePath, data.getCanGoPatches().getAllElements());
            OPatchUtilHelper.warnRestoreMessage(sessionName, psLoc, ok);
            if (!ok) {
                throw e11;
            }
            RuntimeException re = new RuntimeException(e11.getMessage());
            re.setStackTrace(e11.getStackTrace());
            throw re;
        }
        PatchObject[] arbPatchObjects = data.getArbPatchObjects();
        for (i2 = 0; i2 < arbPatchObjects.length && OPatchEnv.isRunSql(); ++i2) {
            String originalPatchLoc = OPatchEnv.getPatchBackupDirectoryPath(oracleHomePath, arbPatchObjects[i2].getCookedPatchID());
            PatchmdXml rollbackSql = new PatchmdXml(oracleHomePath, originalPatchLoc, false, arbPatchObjects[i2].getAllIncludedCopyActions(), arbPatchObjects[i2].getPatchID());
            String rollbackSqlPath = rollbackSql.getSqlPath();
            if (rollbackSqlPath == null || rollbackSqlPath.equals("")) continue;
            try {
                OLogger.println(OLogger.getString("OUI-67272", new Object[]{"auto-rollback", rollbackSqlPath, arbPatchObjects[i2].getPatchID()}));
                OPatchSessionHelper.runSqlScript(rollbackSqlPath, arbPatchObjects[i2].getPatchInventory().isSqlMigrate());
                continue;
            }
            catch (RuntimeException e12) {
                OLogger.printStackTrace(e12);
                OLogger.printlnOnLog(OLogger.INFO, e12.getMessage());
                OLogger.warn(OLogger.getString("OUI-67273", new Object[]{"auto-rollback", rollbackSqlPath, arbPatchObjects[i2].getPatchID()}));
            }
        }
        for (i2 = 0; i2 < apPatchObjects.length && OPatchEnv.isRunSql(); ++i2) {
            String pLoc = apPatchObjects[i2].getPatchLocation();
            PatchmdXml applySql = new PatchmdXml(oracleHomePath, pLoc, true, apPatchObjects[i2].getAllIncludedCopyActions(), apPatchObjects[i2].getPatchID());
            String applySqlPath = applySql.getSqlPath();
            if (applySqlPath == null || applySqlPath.equals("")) continue;
            try {
                OLogger.println(OLogger.getString("OUI-67272", new Object[]{"apply", applySqlPath, apPatchObjects[i2].getPatchID()}));
                OPatchSessionHelper.runSqlScript(applySqlPath, apPatchObjects[i2].getPatchInventory().isSqlMigrate());
                continue;
            }
            catch (RuntimeException e13) {
                OLogger.printStackTrace(e13);
                OLogger.printlnOnLog(OLogger.INFO, e13.getMessage());
                OLogger.warn(OLogger.getString("OUI-67273", new Object[]{"apply", applySqlPath, apPatchObjects[i2].getPatchID()}));
            }
        }
        try {
            OPatchSession.runCustomScript();
        }
        catch (RuntimeException e14) {
            OLogger.printStackTrace(e14);
            OLogger.printlnOnLog(OLogger.INFO, e14.getMessage());
            OLogger.warn("OUI-67266", new Object[]{OPatchEnv.getSqlScriptFilePath()});
        }
        if (OPatchEnv.isRunSql()) {
            for (int i5 = 0; i5 < arbPatchObjects.length; ++i5) {
                if (!arbPatchObjects[i5].isSqlRelatedActions()) continue;
                OPatchSessionHelper.removeSidFromSqlPropertyFile(oracleHomePath, arbPatchObjects[i5].getCookedPatchID());
            }
        }
        String[] sidArray = OPatchEnv.getDBSIDs();
        String[] dbNodes = OPatchEnv.getDBNodes();
        String lNode = OPatchEnv.getLocalNode();
        StringBuffer sidValue = new StringBuffer("");
        for (int sidCount = 0; sidArray != null && sidCount < sidArray.length; ++sidCount) {
            if (!dbNodes[sidCount].equals(lNode) && !dbNodes[sidCount].equals("")) continue;
            sidValue.append(sidArray[sidCount]);
            if (sidCount == sidArray.length - 1) continue;
            sidValue.append(",");
        }
        if (sidValue.toString().endsWith(",")) {
            String temp = sidValue.toString().substring(0, sidValue.toString().length() - 1);
            sidValue = new StringBuffer(temp);
        }
        for (int i6 = 0; i6 < apPatchObjects.length; ++i6) {
            Properties prop = new Properties();
            if (OPatchEnv.isRunSql() && apPatchObjects[i6].isSqlRelatedActions()) {
                prop.setProperty("RUNSQL", "true");
                prop.setProperty("SID", sidValue.toString());
            } else {
                prop.setProperty("RUNSQL", "unknown");
            }
            OPatchSessionHelper.setSqlPropertyToFile(prop, oracleHomePath, apPatchObjects[i6].getCookedPatchID());
        }
        Properties onlineProp = OPatchSessionHelper.getOnlinePropertyFromFile(oracleHomePath);
        OPatchSessionHelper.removeOnlineRollbackSids(onlineProp, arbPatchObjects, OPatchEnv.getLocalNode(), oracleHomePath);
        for (int i7 = 0; i7 < apPatchObjects.length; ++i7) {
            if (!apPatchObjects[i7].isOnlinePatch()) continue;
            OPatchSessionHelper.setOnlinePropertyToFile(oracleHomePath, OPatchEnv.getLocalNode(), apPatchObjects[i7].getPatchID());
        }
        if (Rules.SystemWrite_continue() && data.isComposite()) {
            try {
                CompositePatchObject.updateActiveXMLField(data.getCompositeIdenticalPatches(), oracleHomePath, data.getActivePatch());
            }
            catch (RuntimeException e15) {
                buff = new StringBuffer("Some patches have been processed --> treat as Error.");
                OLogger.debug(buff);
                boolean ok = mPo.restoreOH(oracleHomePath, data.getCanGoPatches().getAllElements());
                OPatchUtilHelper.warnRestoreMessage(sessionName, psLoc, ok);
                if (ok) throw e15;
                Error err = new Error(e15.getMessage());
                err.setStackTrace(e15.getStackTrace());
                throw err;
            }
        }
        dBuff = new StringBuffer("N-Apply: Step 14, prompt for start-up");
        OLogger.debug(dBuff);
        mPo.promptForStartup(oracleHomePath, rwServices);
        try {
            OPatchACL.setLocal(new NApply(), isLocal);
        }
        catch (IllegalAccessException e15) {
            // empty catch block
        }
        dBuff = new StringBuffer("N-Apply: calling processRemote()");
        OLogger.debug(dBuff);
        NApply.processRemote(oracleHomePath, selects, apPatchObjects, arbPatchObjects, mPo);
        OPatchSessionHelper.cleanup(oracleHomePath);
        if (rwServices.isLocked()) {
            try {
                dBuff = new StringBuffer("N-Apply: release() the home");
                OLogger.debug(dBuff);
                rwServices.release();
            }
            catch (Throwable t) {
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
        }
        dBuff = new StringBuffer("N-Apply: process() done.");
        OLogger.debug(dBuff);
        if (fc) {
            try {
                OneOffEntry[] OHOneOffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
                data.setAfterPohs(OHOneOffs);
            }
            catch (Throwable e16) {
                OLogger.debug(new StringBuffer("Converting Throwable to RuntimeException"));
                RuntimeException re = new RuntimeException(e16.getMessage());
                re.setStackTrace(e16.getStackTrace());
            }
        }
        OneOffEntry[] apOneOffsTotal = data.getApOneOffs();
        ArrayList<OneOffEntry> apOneOffsTotalList = new ArrayList<OneOffEntry>(Arrays.asList(apOneOffsTotal));
        ArrayList<OneOffEntry> incomingOneOffList = new ArrayList<OneOffEntry>(piList.length);
        for (int piIndex = 0; piIndex < piList.length; ++piIndex) {
            incomingOneOffList.add(piList[piIndex].toOneOffEntry(oracleHomePath));
        }
        incomingOneOffList.retainAll(apOneOffsTotalList);
        data.setApOneOffs(incomingOneOffList.toArray(new OneOffEntry[incomingOneOffList.size()]));
        PrintApplyReport pa = new PrintApplyReport(data);
        pa.printAppliedPatches(data);
        if (fc && !OPatchEnv.isReport()) {
            pa.printBugsReport(data);
        }
        OracleHomeConflictMap.printToInActivePatchMessage();
        data.setApOneOffs(apOneOffsTotal);
        if (!OPatchEnv.isFATwoPhase()) return data;
        if (!OPatchEnv.isReport()) {
            proc.updateCachedFiles(oracleHomePath);
            proc.cleanCachedFiles(oracleHomePath);
        }
        OPatchEnv.unsetHashMatch();
        OPatchEnv.unsetFATwoPhase();
        return data;
    }

    protected static void processRemote(String oracleHomePath, RacProcessor.MinDowntimeNodeSelection selects, PatchObject[] applyPatchObjects, PatchObject[] autoRolledBackPatchObjects, MergedPatchObject mPo) throws RuntimeException {
        block24: {
            StringBuffer buff = new StringBuffer("NApply::processRemote()");
            OLogger.debug(buff);
            OPatchSessionHelper.loadRACRelatedLibFile();
            Rac.RacType racType = null;
            boolean autoRollBack = OPatchUtilHelper.isAutoRollbackNeeded();
            String cookedPatchID = mPo.getCookedPatchID();
            IIPMReadServices readServices = null;
            try {
                readServices = PrereqSession.getReadServices(oracleHomePath);
                if (!readServices.isInventoryLoaded()) {
                    buff.append(" needs a non-null Inventory and patchObject");
                    OLogger.debug(buff);
                    throw new RuntimeException(buff.toString());
                }
                racType = Rules.OUIRead_continue() ? Rac.getInstance(readServices, true) : Rac.getInstance(null);
                if (!Rac.shouldPropagate(racType) && !Rac.shouldRemoteRun(racType)) {
                    buff = new StringBuffer(" not a RAC system, no-op for NApply::processRemote()");
                    OLogger.debug(buff);
                    break block24;
                }
                buff = new StringBuffer("NApply::processRemote() will apply the patch on the following nodes: ");
                String localNode = racType.getLocalNode();
                String[] remoteNodes = racType.getRemoteNodes();
                try {
                    OPatchUtilHelper.generateRacFiles(oracleHomePath, applyPatchObjects, cookedPatchID, sessionName);
                }
                catch (IOException e2) {
                    RuntimeException re = new RuntimeException(e2.getMessage());
                    re.setStackTrace(e2.getStackTrace());
                    throw re;
                }
                if (remoteNodes != null) {
                    for (int i2 = 0; i2 < remoteNodes.length; ++i2) {
                        String node = remoteNodes[i2];
                        buff.append(" (node ");
                        buff.append(node);
                        buff.append(")");
                    }
                }
                buff.append(".  RAC mode is: ");
                buff.append(racType.getDetail());
                boolean local = OPatchEnv.isLocal();
                boolean minDT = OPatchEnv.isMinDowntime();
                boolean allNode = OPatchEnv.isAllNode();
                boolean rolling = mPo.isRolling();
                boolean shutdown = mPo.isShutdown();
                boolean silent = OPatchEnv.isSilent();
                try {
                    if (mPo.forceAllNodeMode() && !allNode && (rolling || minDT)) {
                        allNode = true;
                        OPatchACL.setAllNode(new NApply(), true);
                        OLogger.info("OUI-67250");
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                Rules.RacPatchOrder order = Rules.getRacPatchOrder(racType, local, rolling, minDT, allNode, silent);
                buff.append(".  Applying order is: ");
                buff.append(order.toString());
                OLogger.debug(buff);
                try {
                    String FP = null;
                    String DP = null;
                    String FR = null;
                    String DR = null;
                    String MP = null;
                    String RC = null;
                    String patchStorageRac = "";
                    try {
                        patchStorageRac = OPatchEnv.getPatchStorageRacDirectoryPath(oracleHomePath, cookedPatchID);
                        boolean createRacFile = OPatchEnv.isCreateRacFile();
                        File f2 = new File(patchStorageRac);
                        if (!createRacFile && !f2.exists()) {
                            buff = new StringBuffer("NApply::processRemote() was not able to locate the ");
                            buff.append("directory containing listed files/dirs to be propagated/removed on remote nodes.  ");
                            buff.append("Moreover, since users request that no RAC listed files be generated, ");
                            buff.append("OPatch cannot go on patching remote nodes.  ");
                            OLogger.println(buff.toString());
                            return;
                        }
                        RacFileCreator.checkPsRac(patchStorageRac);
                        FP = RacFileCreator.getFPFinalName(patchStorageRac);
                        DP = RacFileCreator.getDPFinalName(patchStorageRac);
                        RC = RacFileCreator.getRCFinalName(patchStorageRac);
                        if (autoRollBack) {
                            FR = RacFileCreator.getFRFinalName(patchStorageRac);
                            DR = RacFileCreator.getDRFinalName(patchStorageRac);
                        }
                        MP = RacFileCreator.getMPFinalName(patchStorageRac);
                    }
                    catch (IOException e3) {
                        RuntimeException re = new RuntimeException(e3.getMessage());
                        re.setStackTrace(e3.getStackTrace());
                        throw re;
                    }
                    StringBuffer report = new StringBuffer("OPatch will use the following files to patch remote nodes:\n");
                    if (FP != null) {
                        report.append("   \"");
                        report.append(FP);
                        report.append("\"\n");
                    }
                    if (RC != null) {
                        report.append("   \"");
                        report.append(RC);
                        report.append("\"\n");
                    }
                    if (DP != null) {
                        report.append("   \"");
                        report.append(DP);
                        report.append("\"\n");
                    }
                    if (FR != null) {
                        report.append("   \"");
                        report.append(FR);
                        report.append("\"\n");
                    }
                    if (DR != null) {
                        report.append("   \"");
                        report.append(DR);
                        report.append("\"\n");
                    }
                    if (MP != null) {
                        report.append("   \"");
                        report.append(MP);
                        report.append("\"\n");
                    }
                    OLogger.log(OLogger.FINE, report.toString());
                    boolean apply = true;
                    boolean rollback = false;
                    RacProcessor.patchRemoteNodes(oracleHomePath, remoteNodes, order, FP, DP, FR, DR, MP, RC, shutdown, sessionName, selects, apply, rollback, autoRollBack, patchStorageRac, mPo.getShutdownMsg(), applyPatchObjects, autoRolledBackPatchObjects, localNode, Rac.shouldPropagate(racType), Rac.shouldRemoteRun(racType));
                }
                catch (RuntimeException e4) {
                    throw e4;
                }
                catch (Error e5) {
                    throw e5;
                }
            }
            catch (Throwable t) {
                RuntimeException e6 = new RuntimeException(t.getMessage());
                e6.setStackTrace(e6.getStackTrace());
                throw e6;
            }
        }
    }

    private static void runPrereqs(String oracleHomePath, OneOffEntry[] apOneOffs, PatchObject[] apPatchObjects, String[] apPatchLocs) throws PrereqFailedException {
        String patchID;
        PatchObject po;
        StringBuffer buff = new StringBuffer();
        boolean runPrereq = true;
        boolean bl = runPrereq = Rules.SystemWrite_continue() || OPatchEnv.isReport();
        if (runPrereq) {
            PrereqResult sysSpaceRes = PrereqAPI.checkSystemSpace(oracleHomePath, apOneOffs, apPatchLocs);
            if (sysSpaceRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || sysSpaceRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                buff = new StringBuffer("\nPre-requiste \"CheckSystemSpace\" failed.");
                buff.append(sysSpaceRes.toString());
                OLogger.println(buff.toString());
                PrereqFailedException pe = new PrereqFailedException("Prereq checkSystemSpace failed.");
                throw pe;
            }
            OLogger.log(OLogger.FINE, "Enough system space is available.");
        }
        boolean bl2 = runPrereq = Rules.OUIRead_continue() || OPatchEnv.isReport();
        if (runPrereq) {
            PrereqResult platRes = PrereqAPI.checkPatchApplicableOnCurrentPlatform(oracleHomePath, apPatchObjects);
            if (platRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || platRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                buff = new StringBuffer("\nPre-requiste \"CheckPatchApplicableOnCurrentPlatform\" failed.");
                buff.append(platRes.toString());
                OLogger.println(buff.toString());
                PrereqFailedException pe = new PrereqFailedException("Prereq checkPatchApplicableOnCurrentPlatform failed.");
                throw pe;
            }
            OLogger.log(OLogger.FINE, "All the given patches are applicable on the current platform.");
        }
        boolean bl3 = runPrereq = Rules.SystemWrite_continue() || OPatchEnv.isReport();
        if (runPrereq) {
            for (int i2 = 0; i2 < apOneOffs.length; ++i2) {
                po = apPatchObjects[i2];
                patchID = po.getPatchID();
                buff = new StringBuffer("checkSystemCommandAvailable for patch ");
                buff.append(patchID);
                OLogger.debug(buff);
                String[] executables = po.getExecutables(oracleHomePath);
                PrereqResult sysCmdRes = PrereqAPI.checkSystemCommandAvailable(oracleHomePath, apOneOffs[i2], executables);
                if (sysCmdRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || sysCmdRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                    buff = new StringBuffer("\nPre-requiste \"CheckSystemCommandAvailable\" failed ");
                    buff.append(" on patch ").append(patchID);
                    buff.append(sysCmdRes.toString());
                    OLogger.println(buff.toString());
                    PrereqFailedException pe = new PrereqFailedException("Prereq checkSystemCommandAvailable failed.");
                    throw pe;
                }
                OLogger.log(OLogger.FINE, "All the required system commands are present.");
            }
        }
        boolean bl4 = runPrereq = Rules.SystemWrite_continue() || OPatchEnv.isReport();
        if (runPrereq) {
            for (int i3 = 0; i3 < apPatchObjects.length; ++i3) {
                po = apPatchObjects[i3];
                patchID = po.getPatchID();
                buff = new StringBuffer("checkActiveFilesAndExecutables for patch ");
                buff.append(patchID);
                OLogger.debug(buff);
                PrereqResult activeFilesRes = PrereqAPI.checkActiveFilesAndExecutables(oracleHomePath, po);
                if (activeFilesRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || activeFilesRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                    buff = new StringBuffer("\nPre-requiste \"CheckActiveFilesAndExecutables\" failed ");
                    buff.append("on patch ").append(patchID).append(", ");
                    buff.append(activeFilesRes.toString());
                    OLogger.println(buff.toString());
                    PrereqFailedException pe = new PrereqFailedException("Prereq checkActiveFilesAndExecutables failed.");
                    throw pe;
                }
                OLogger.log(OLogger.FINE, "None of the executables are active.");
            }
        }
        boolean bl5 = runPrereq = Rules.OUIRead_continue() && Rules.SystemWrite_continue() || OPatchEnv.isReport();
        if (runPrereq) {
            PrereqResult applicableRes = PrereqAPI.checkApplicableIgnoreMisingOptionalComp(oracleHomePath, apPatchObjects);
            if (applicableRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || applicableRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                buff = new StringBuffer("\nPre-requiste \"CheckApplicable\" failed.");
                buff.append(applicableRes.toString());
                OLogger.println(buff.toString());
                PrereqFailedException pe = new PrereqFailedException("Prereq checkApplicable failed.");
                throw pe;
            }
            OLogger.log(OLogger.FINE, "All the actions of the given patches are applicable.");
        }
    }

    protected static boolean shouldConsiderNoBugSuperSet(OneOffEntry[] notNeededOneOffs, OneOffEntry[] autoRollbackOneOffs) {
        for (int i2 = 0; i2 < autoRollbackOneOffs.length; ++i2) {
            String autoRollbackID = autoRollbackOneOffs[i2].getID();
            for (int j2 = 0; j2 < notNeededOneOffs.length; ++j2) {
                if (!autoRollbackID.equals(notNeededOneOffs[j2].getID())) continue;
                return true;
            }
        }
        return false;
    }

    private static ArrayList intersect(ArrayList tmp, ArrayList current) {
        current.retainAll(tmp);
        return current;
    }

    protected static String getMsgForNoBugSuperSet(String oracleHomePath, ConflictMatrixOutput cOutput, OneOffEntry[] samePatchSuperset) {
        int i2;
        OneOffEntry[] notNeededOneOffs = cOutput.getListOfPatchesNotNeeded();
        OneOffEntry[] autoRollbackOneOffs = cOutput.getListOfPatchesThatNeedToBeRollback();
        ArrayList<String> ohOneOffs = new ArrayList<String>();
        for (int i3 = 0; autoRollbackOneOffs != null && i3 < autoRollbackOneOffs.length; ++i3) {
            String autoRollbackID = autoRollbackOneOffs[i3].getID();
            for (int j2 = 0; notNeededOneOffs != null && j2 < notNeededOneOffs.length; ++j2) {
                if (!autoRollbackID.equals(notNeededOneOffs[j2].getID())) continue;
                ohOneOffs.add(autoRollbackID);
            }
        }
        int rowLength = cOutput.getRowLength();
        int colLength = cOutput.getColumnLength();
        StringBuffer tmpS = new StringBuffer();
        for (i2 = 0; i2 < rowLength; ++i2) {
            String superSetID = cOutput.getRowPatchID(i2, 0);
            boolean success = false;
            if (ohOneOffs.contains(superSetID)) continue;
            StringBuffer buff = new StringBuffer();
            for (int j3 = 0; j3 < colLength; ++j3) {
                String subSetID = cOutput.getColumnPatchID(i2, j3);
                if (cOutput.getConflictType(i2, j3) != ConflictMatrixOutput.ConflictType.BUG_SUPERSET || !ohOneOffs.contains(subSetID)) continue;
                success = true;
                buff.append(subSetID);
                buff.append(" ");
            }
            if (!success) continue;
            tmpS.append(OLogger.getString("OUI-67078", new Object[]{superSetID, buff.toString(), oracleHomePath}));
            tmpS.append("\n");
        }
        for (i2 = 0; samePatchSuperset != null && i2 < samePatchSuperset.length; ++i2) {
            String patchID = samePatchSuperset[i2].getID();
            tmpS.append(OLogger.getString("OUI-67078", new Object[]{patchID, patchID, oracleHomePath}));
            tmpS.append("\n");
        }
        return tmpS.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void runPreSKDApplyPrereqs(String oracleHomePath, PatchObject[] pos) throws FailedPrereqException, RuntimeException {
        RuntimeException rex = null;
        List<PatchObject> patchObjects = pos == null || pos.length == 0 ? null : Arrays.asList(pos);
        try {
            try {
                PrereqResult pRes;
                OPatchTarget.StatusCheck checkResult;
                ArrayList pResArray;
                try {
                    pResArray = PQSession.checkActiveFilesAndExecutablesAndPrint(oracleHomePath, patchObjects);
                    OUSession.addPrereqResultArray(OPatchPatchPrereq.CHECK_ACTIVE_FILES_AND_EXECUTABLES, pResArray);
                }
                catch (FailedPrereqException fpe) {
                    throw fpe;
                }
                catch (Exception e2) {
                    checkResult = new OPatchTarget.StatusCheck(2, e2.getMessage());
                    OUSession.addApplyPrereqResultStatus(OPatchPatchPrereq.CHECK_ACTIVE_FILES_AND_EXECUTABLES, checkResult);
                }
                OUSession.addApplyPrereqResult(OPatchPatchPrereq.CHECK_WINDOWS_ACTIVE_SERVICES_FROM_ORACLE_HOME, PrereqAPI.checkActiveServices(oracleHomePath));
                try {
                    pResArray = PQSession.checkApplicableAndPrint(oracleHomePath, patchObjects);
                    OUSession.addPrereqResultArray(OPatchPatchPrereq.CHECK_PATCH_APPLICABLE, pResArray);
                }
                catch (FailedPrereqException fpe) {
                    throw fpe;
                }
                catch (Exception e3) {
                    checkResult = new OPatchTarget.StatusCheck(2, e3.getMessage());
                    OUSession.addApplyPrereqResultStatus(OPatchPatchPrereq.CHECK_PATCH_APPLICABLE, checkResult);
                }
                OUSession.addApplyPrereqResult(OPatchPatchPrereq.CHECK_CENTRAL_INVENTORY_FOR_ORACLE_HOME, PrereqAPI.checkCentralInventoryForOH(oracleHomePath));
                OUSession.addApplyPrereqResult(OPatchPatchPrereq.CHECK_CENTRAL_INVENTORY_FOR_READ_WRITE_SESSION, PrereqAPI.checkCentralInventoryForRWSession(oracleHomePath));
                OUSession.addApplyPrereqResult(OPatchPatchPrereq.CHECK_CENTRAL_INVENTORY_LOCATION, PQSession.checkCentralInventoryLocationAndPrint());
                try {
                    OPatchEnv.setSessionType("prereq");
                    pRes = PQSession.checkConflictAgainstOHWithDetailAndPrint(oracleHomePath, patchObjects);
                    OUSession.addApplyPrereqResult(OPatchPatchPrereq.CHECK_CONFLICT_AMONG_PATCHES_AND_AGAINST_ORACLE_HOME, pRes);
                }
                catch (FailedPrereqException fpe) {
                    throw fpe;
                }
                catch (Exception e4) {
                    OLogger.printStackTrace(e4);
                    checkResult = new OPatchTarget.StatusCheck(2, e4.getMessage());
                    OUSession.addApplyPrereqResultStatus(OPatchPatchPrereq.CHECK_CONFLICT_AMONG_PATCHES_AND_AGAINST_ORACLE_HOME, checkResult);
                }
                try {
                    OPatchEnv.setSessionType("prereq");
                    pRes = PQSession.checkConflictAmongPatchesAndPrint(oracleHomePath, patchObjects);
                    OUSession.addApplyPrereqResult(OPatchPatchPrereq.CHECK_CONFLICT_AMONG_PATCHES, pRes);
                }
                catch (FailedPrereqException fpe) {
                    throw fpe;
                }
                catch (Exception e5) {
                    checkResult = new OPatchTarget.StatusCheck(2, e5.getMessage());
                    OUSession.addApplyPrereqResultStatus(OPatchPatchPrereq.CHECK_CONFLICT_AMONG_PATCHES, checkResult);
                }
                OUSession.addApplyPrereqResult(OPatchPatchPrereq.CHECK_IF_ORACLE_HOME_ALREADY_LOCKED_FOR_PATCHING, PrereqAPI.checkIfOHLockedForPatching(oracleHomePath));
                OUSession.addApplyPrereqResult(OPatchPatchPrereq.CHECK_ORACLE_HOME_SANITY, PrereqAPI.checkOracleHome(oracleHomePath));
                OUSession.addApplyPrereqResult(OPatchPatchPrereq.CHECK_CENTRAL_INVENTORY_POINTER_FILE, PrereqAPI.checkOraInstLocation(OPatchEnv.getInvPtrLoc()));
                OUSession.addApplyPrereqResult(OPatchPatchPrereq.CHECK_OUI_LOCATION, PrereqAPI.checkOUILocation(oracleHomePath));
                OUSession.addApplyPrereqResult(OPatchPatchPrereq.CHECK_OUI_VERSION_COMPATIBLE, PrereqAPI.checkOUIVersionCompatible(oracleHomePath));
                try {
                    pResArray = PQSession.checkPatchShipHomeAndPrint(patchObjects);
                    OUSession.addPrereqResultArray(OPatchPatchPrereq.CHECK_PATCH_SHIPHOME, pResArray);
                }
                catch (FailedPrereqException fpe) {
                    throw fpe;
                }
                catch (Throwable t) {
                    checkResult = new OPatchTarget.StatusCheck(2, t.getMessage());
                    OUSession.addApplyPrereqResultStatus(OPatchPatchPrereq.CHECK_PATCH_SHIPHOME, checkResult);
                }
                OUSession.addApplyPrereqResult(OPatchPatchPrereq.CHECK_REQUIRED_LIBRARIES, PQSession.checkRequiredLibsAndPrint(oracleHomePath));
                OUSession.addApplyPrereqResult(OPatchPatchPrereq.CHECK_IF_ALL_NO_OPERATION_PATCHES, PQSession.checkForNooppatchesAndPrint(oracleHomePath, CheckNoOpPatchesOption.IF_ALL_NO_OPS, patchObjects));
                OUSession.addApplyPrereqResult(OPatchPatchPrereq.CHECK_IF_SOME_NO_OPERATION_PATCHES, PQSession.checkForNooppatchesAndPrint(oracleHomePath, CheckNoOpPatchesOption.IF_SOME_NO_OPS, patchObjects));
                OUSession.addApplyPrereqResult(OPatchPatchPrereq.CHECK_NO_OPERATION_PATCHES, PQSession.checkForNooppatchesAndPrint(oracleHomePath, CheckNoOpPatchesOption.IF_NONE_NO_OPS, patchObjects));
                OUSession.addApplyPrereqResult(OPatchPatchPrereq.CHECK_IF_REQUIRED_DELETE_ACTION_EXIST, PQSession.checkIfRequiredDeleteActionExistAndPrint(oracleHomePath, patchObjects));
                try {
                    OPatchEnv.setSessionType("prereq");
                    pRes = PQSession.checkForIdenticalPatchInOracleHomeAndPrint(oracleHomePath, patchObjects);
                    OUSession.addApplyPrereqResult(OPatchPatchPrereq.CHECK_FOR_IDENTICAL_PATCHES_IN_ORACLE_HOME, pRes);
                }
                catch (FailedPrereqException fpe) {
                    throw fpe;
                }
                catch (Throwable t) {
                    checkResult = new OPatchTarget.StatusCheck(2, t.getMessage());
                    OUSession.addApplyPrereqResultStatus(OPatchPatchPrereq.CHECK_FOR_IDENTICAL_PATCHES_IN_ORACLE_HOME, checkResult);
                }
                try {
                    pRes = PQSession.checkForInputValuesAndPrint(oracleHomePath, patchObjects);
                    OUSession.addApplyPrereqResult(OPatchPatchPrereq.CHECK_FOR_INPUT_VALUES, pRes);
                }
                catch (FailedPrereqException fpe) {
                    throw fpe;
                }
                catch (Throwable t) {
                    checkResult = new OPatchTarget.StatusCheck(2, t.getMessage());
                    OUSession.addApplyPrereqResultStatus(OPatchPatchPrereq.CHECK_FOR_INPUT_VALUES, checkResult);
                }
                OUSession.addApplyPrereqResult(OPatchPatchPrereq.CHECK_USER_ADMIN_PRIVILEGE, PrereqAPI.checkUserAdminPrivilege(oracleHomePath));
            }
            catch (FailedPrereqException fpe) {
                throw fpe;
            }
            catch (Exception e6) {
                rex = new RuntimeException(e6);
                rex.setStackTrace(e6.getStackTrace());
                Object var8_24 = null;
                if (rex == null) return;
                OLogger.printStackTrace(rex);
                throw rex;
            }
            Object var8_23 = null;
            if (rex == null) return;
        }
        catch (Throwable throwable) {
            Object var8_25 = null;
            if (rex != null) {
                OLogger.printStackTrace(rex);
                throw rex;
            }
            throw throwable;
        }
        OLogger.printStackTrace(rex);
        throw rex;
    }

    private static void runPreSKDApplyPrereqs(String oracleHomePath) throws FailedPrereqException, RuntimeException {
        NApply.runPreSKDApplyPrereqs(oracleHomePath, null);
    }
}

