/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchutil;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import oracle.opatch.Bug;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.ExitOPatchException;
import oracle.opatch.MergedPatchObject;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchFmwEnv;
import oracle.opatch.OPatchOverCAS;
import oracle.opatch.OPatchOverCASUtil;
import oracle.opatch.OPatchSession;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchingModel;
import oracle.opatch.PatchmdXml;
import oracle.opatch.PrereqFailedException;
import oracle.opatch.PrereqSession;
import oracle.opatch.Rac;
import oracle.opatch.RacFileCreator;
import oracle.opatch.RacProcessor;
import oracle.opatch.RollbackSession;
import oracle.opatch.Rules;
import oracle.opatch.UtilSession;
import oracle.opatch.conflicttextualinterpreter.OracleHomeConflictMap;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.opatch.opatchprereq.PrereqSet;
import oracle.opatch.opatchsdk.OPatchPatchPrereq;
import oracle.opatch.opatchutil.NSession;
import oracle.opatch.opatchutil.OPatchUtilHelper;
import oracle.opatch.opatchutil.OUSession;
import oracle.opatch.ops.Feature;
import oracle.opatch.ops.OPS;
import oracle.opatch.twophase.TwoPhaseOperations;

public class NRollback
extends NSession {
    private static final String sessionName = OPatchEnv.getNRollbackSessionName();
    static OPatchSession NRollbackSession = OPatchSession.UTIL;

    private NRollback() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void process(String oracleHomePath) throws RuntimeException, Error {
        if (OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS) && !OPatchEnv.isReport()) {
            OLogger.printlnOnLog("NRollback::CAS enabled, OPatch runs with two-phase patching.");
            OPatchEnv.setCASFlow(true);
            try {
                block10: {
                    try {
                        if (OPatchEnv.isCASPhase1()) {
                            OLogger.printlnOnLog("NRollback::OPatch runs phase one.");
                            OPatchOverCAS.INSTANCE.prepareTwoPhasePatching(TwoPhaseOperations.NROLLBACK);
                        }
                        if (!OPatchEnv.isCASPhase2()) break block10;
                        OLogger.printlnOnLog("NRollback::OPatch runs phase two.");
                        OPatchOverCAS.INSTANCE.commitTwoPhasePatching();
                        OPatchOverCASUtil.cleanupCache(oracleHomePath);
                    }
                    catch (Exception e2) {
                        RuntimeException re = new RuntimeException(e2.getMessage());
                        re.setStackTrace(e2.getStackTrace());
                        throw re;
                    }
                }
                Object var4_1 = null;
                OPatchEnv.unsetCASPhase1();
                OPatchEnv.unsetCASPhase2();
                OPatchEnv.setCASFlow(false);
                if (!OPatchEnv.isCASCleanupNeeded()) return;
                OPatchOverCAS.INSTANCE.cleanupCAS();
                return;
            }
            catch (Throwable throwable) {
                Object var4_2 = null;
                OPatchEnv.unsetCASPhase1();
                OPatchEnv.unsetCASPhase2();
                OPatchEnv.setCASFlow(false);
                if (!OPatchEnv.isCASCleanupNeeded()) throw throwable;
                OPatchOverCAS.INSTANCE.cleanupCAS();
                throw throwable;
            }
        }
        OPatchEnv.setCASFlow(false);
        if (OPatchEnv.isReport()) {
            OLogger.printlnOnLog("NRollback::Report mode, OPatch runs with legacy process.");
        } else {
            OLogger.printlnOnLog("NRollback::no CAS enabled, OPatch runs with legacy process.");
        }
        StringBuffer buff = new StringBuffer("NRollback::process() on \"");
        buff.append(oracleHomePath);
        buff.append("\"");
        OLogger.debug(buff);
        String[] patchesToRollback = null;
        try {
            buff = new StringBuffer(" getting a list of patches to be n-rolled back.");
            OLogger.debug(buff);
            patchesToRollback = OPatchUtilHelper.getPatchesToRollback();
        }
        catch (RuntimeException e3) {
            buff = new StringBuffer("You need to specify a list of patch ID ");
            buff.append("separated by commas.  For example: ");
            buff.append("-id 1,2,3,4");
            OLogger.debug(buff);
            RuntimeException re = new RuntimeException(buff.toString());
            re.setStackTrace(e3.getStackTrace());
            throw re;
        }
        NRollback.legacy_process(oracleHomePath, patchesToRollback);
    }

    public static void legacy_process(String oracleHomePath, String[] patchesToRollback) throws RuntimeException, Error {
        RuntimeException re;
        int i2;
        RuntimeException re2;
        StringBuffer buff = new StringBuffer("NRollback::legacy_process() on \"");
        buff.append(oracleHomePath);
        buff.append("\"");
        OLogger.debug(buff);
        IIPMReadServices rwServices = null;
        RacProcessor.MinDowntimeNodeSelection selects = null;
        OPatchEnv.setNRollback(true);
        boolean isLocal = OPatchEnv.isLocal();
        if (OPatchFmwEnv.isAuto() && !OPatchEnv.isOPatchSDKMode()) {
            String autoErrorMsg = OLogger.getString("OUI-67331", new Object[]{"nrollback"});
            throw new RuntimeException(autoErrorMsg);
        }
        NRollback.validateConnectStringNodes(oracleHomePath);
        String[] rbPatchIDs = new String[]{};
        PatchObject[] rbPatchObjects = new PatchObject[]{};
        if (patchesToRollback == null || patchesToRollback.length == 0) {
            buff = new StringBuffer(OLogger.getString("OUI-67306", new Object[]{"NRollback", "rollback"}));
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
        TreeSet<String> set = new TreeSet<String>();
        for (int i3 = 0; i3 < patchesToRollback.length; ++i3) {
            String id = patchesToRollback[i3];
            buff = new StringBuffer("Patch to roll back: ");
            buff.append(id);
            OLogger.log(OLogger.FINE, buff.toString());
            if (set.contains(id)) {
                buff = new StringBuffer("You have specified patch ID ");
                buff.append(id);
                buff.append(" more than once.");
                OLogger.debug(buff);
                throw new RuntimeException(buff.toString());
            }
            set.add(id);
        }
        if (Rules.OUIRead_continue()) {
            OLogger.log(OLogger.FINE, "Lock the home to access inventory.");
            try {
                rwServices = UtilSession.getRWServices(oracleHomePath);
            }
            catch (Throwable t) {
                RuntimeException e2 = new RuntimeException(t.getMessage());
                e2.setStackTrace(e2.getStackTrace());
                throw e2;
            }
            if (!rwServices.isInventoryLoaded()) {
                buff = new StringBuffer("NRollback::process() was not able to get a Session.");
                OLogger.debug(buff);
                throw new RuntimeException(buff.toString());
            }
            OLogger.log(OLogger.FINE, "Running pre-requisite checks on patches to be rolled back.");
            Vector notInstalledPatches = new Vector();
            Vector installedPatches = new Vector();
            PrereqResult result = PrereqAPI.checkInstalledOneOffs(oracleHomePath, patchesToRollback, installedPatches, notInstalledPatches);
            OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_INSTALLED_ONE_OFFS, result);
            if (result == null || result.getResult() == null) {
                buff = new StringBuffer("NRollback::process(): PrereqResult is NULL.");
                OLogger.debug(buff);
                throw new RuntimeException("Prereq checkInstalledOneOffs returned null.");
            }
            if (result.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                Vector detail = result.getResultDetails();
                OPatchUtilHelper.processPrereqNotExecuted(detail);
            } else if (result.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                int size = notInstalledPatches.size();
                if (size > 0) {
                    StringBuffer inactive_buff = new StringBuffer("");
                    StringBuffer uninst_buff = new StringBuffer("");
                    OneOffEntry[] inactiveOneOffs = rwServices.getInactivePatches();
                    for (int i4 = 0; i4 < size; ++i4) {
                        Object obj = notInstalledPatches.get(i4);
                        if (!(obj instanceof String)) continue;
                        String patchID = (String)obj;
                        boolean inactive = false;
                        for (int j2 = 0; j2 < inactiveOneOffs.length; ++j2) {
                            OneOffEntry inactive_oneoff = inactiveOneOffs[j2];
                            String inactiveID = inactive_oneoff.getID();
                            if (!inactiveID.equalsIgnoreCase(patchID)) continue;
                            inactive = true;
                            break;
                        }
                        if (inactive) {
                            inactive_buff.append(patchID).append(",");
                            continue;
                        }
                        uninst_buff.append(patchID).append(",");
                    }
                    if (uninst_buff.length() > 0) {
                        String msg = OLogger.getString("OUI-67307", new Object[]{uninst_buff.substring(0, uninst_buff.length() - 1)});
                        OLogger.println(msg);
                    }
                    if (inactive_buff.length() > 0) {
                        String msg = OLogger.getString("OUI-67637", new Object[]{inactive_buff.substring(0, inactive_buff.length() - 1)});
                        OLogger.println(msg);
                    }
                } else {
                    OLogger.println("Prereq. API failed but no detail is available.");
                    RuntimeException re3 = new RuntimeException("NRollback failed in prereq phase. ");
                    throw re3;
                }
            }
            if (!OPatchEnv.isCompositeRollback()) {
                // empty if block
            }
            if (installedPatches == null || installedPatches.size() == 0) {
                buff = new StringBuffer("Prereq. API succeeds but no patch ");
                buff.append("is available for rollback.");
                OLogger.debug(buff);
                RuntimeException e3 = new RuntimeException(buff.toString());
                throw e3;
            }
            rbPatchIDs = new String[installedPatches.size()];
            for (int i5 = 0; i5 < installedPatches.size(); ++i5) {
                Object obj = installedPatches.get(i5);
                if (obj instanceof String) {
                    OneOffEntry oneoff;
                    String patchID;
                    rbPatchIDs[i5] = patchID = (String)obj;
                    PatchObject po = null;
                    try {
                        po = PatchObject.getInstance(oracleHomePath, patchID);
                    }
                    catch (Exception e4) {
                        OLogger.printStackTrace(e4);
                    }
                    if (po == null || !po.getPatchInventory().mayBeTranslation() || (oneoff = rwServices.getLatestTranslationPatch(po.getOriginalPatchID(), po.getPatchInventory().getPatchLanguage())) == null) continue;
                    rbPatchIDs[i5] = oneoff.getID();
                    continue;
                }
                buff = new StringBuffer("Prereq vector does not contain patchID.");
                OLogger.debug(buff);
                RuntimeException e5 = new RuntimeException(buff.toString());
                throw e5;
            }
        } else {
            rbPatchIDs = patchesToRollback;
        }
        if (OPatchEnv.needRollbackInactivePSUTrain()) {
            OneOffEntry[] inactivePsuTrain = rwServices.getInactivePSUTrain();
            ArrayList<Object> mergedRollbackIds = new ArrayList<Object>();
            for (OneOffEntry subpatch : inactivePsuTrain) {
                mergedRollbackIds.add(subpatch.getPatchID());
            }
            for (String id : rbPatchIDs) {
                mergedRollbackIds.add(id);
            }
            rbPatchIDs = new String[mergedRollbackIds.size()];
            mergedRollbackIds.toArray(rbPatchIDs);
        }
        int modelCode = PatchingModel.returnModelCode(oracleHomePath);
        OracleHomeConflictMap conflictMap = null;
        if (modelCode == 1) {
            List<String> extendRollbackList;
            conflictMap = OracleHomeConflictMap.getInstance(rwServices.getInstalledPatchesIncludeInactive(), oracleHomePath);
            if (OPatchEnv.isAutoRollbackSubsets() && (extendRollbackList = conflictMap.addSubsetsRecursively(Arrays.asList(rbPatchIDs))).size() > rbPatchIDs.length) {
                rbPatchIDs = new String[extendRollbackList.size()];
                extendRollbackList.toArray(rbPatchIDs);
            }
            if ((extendRollbackList = conflictMap.addConflictsWithToActivePatch(Arrays.asList(rbPatchIDs))).size() > rbPatchIDs.length) {
                rbPatchIDs = new String[extendRollbackList.size()];
                extendRollbackList.toArray(rbPatchIDs);
            }
        }
        if (OPatchEnv.isOptimize()) {
            Object[] dependents = OPatchSessionHelper.getCompleteDependentRollbackList(oracleHomePath, rbPatchIDs);
            String[] rollbackPatchIds = new String[dependents.length];
            if (dependents.length > rbPatchIDs.length) {
                for (int i6 = 0; i6 < dependents.length; ++i6) {
                    rollbackPatchIds[i6] = ((OneOffEntry)dependents[i6]).getPatchID();
                }
                rbPatchIDs = rollbackPatchIds;
            }
        }
        buff = new StringBuffer("Construct a list of patch objects to roll back...");
        OLogger.log(OLogger.FINE, buff.toString());
        OLogger.log(OLogger.FINE, "Loading patches from Oracle Home inventory.");
        try {
            rbPatchObjects = OPatchUtilHelper.getPatchesToRollback(oracleHomePath, rbPatchIDs, sessionName);
            for (PatchObject po : rbPatchObjects) {
                if (!po.getPatchType().equals("snowball")) continue;
                throw new RuntimeException(OLogger.getString("OUI-67656"));
            }
            if (modelCode == 1) {
                rbPatchObjects = OPatchSessionHelper.sortOnOverlay(rbPatchObjects, false);
                OPatchSessionHelper.groupCompositeByNeighbor(rbPatchObjects);
                if (OPatchEnv.isAll_Subpatches() && !OPatchSessionHelper.validateRollbackOrder(rbPatchObjects)) {
                    rbPatchObjects = OPatchSessionHelper.sortOnOverlay(rbPatchObjects, false);
                }
            }
        }
        catch (RuntimeException e6) {
            throw e6;
        }
        catch (Exception e7) {
            RuntimeException re4 = new RuntimeException(e7.getMessage());
            re4.setStackTrace(e7.getStackTrace());
            throw re4;
        }
        OneOffEntry[] oneoffs = OPatchUtilHelper.getOneOffObjects(oracleHomePath, rbPatchObjects);
        OneOffEntry[] sortOneoffs = new OneOffEntry[1];
        if (modelCode == 2) {
            sortOneoffs = OPatchSessionHelper.sortForRollbackSnowballs(oneoffs);
            PatchObject[] sortPo = new PatchObject[sortOneoffs.length];
            for (int k2 = 0; k2 < sortOneoffs.length; ++k2) {
                OneOffEntry o2 = sortOneoffs[k2];
                for (int q2 = 0; q2 < rbPatchObjects.length; ++q2) {
                    PatchObject po = rbPatchObjects[q2];
                    if (!o2.getID().equals(po.getPatchID()) || !o2.getPatchLanguage().equalsIgnoreCase(po.getPatchInventory().getPatchLanguage())) continue;
                    sortPo[k2] = po;
                }
            }
            rbPatchObjects = sortPo;
        } else {
            sortOneoffs = oneoffs;
        }
        OUSession.addNRollbackPatchesToReport(rbPatchObjects, false);
        buff = new StringBuffer("");
        for (int i7 = 0; i7 < sortOneoffs.length; ++i7) {
            buff.append("   ");
            buff.append(sortOneoffs[i7].getID());
        }
        String msg = OLogger.getString("OUI-67322", new Object[]{buff.toString()});
        OLogger.println(msg);
        PrereqSet patchesToRollbackSet = new PrereqSet(sortOneoffs);
        if (OPatchSessionHelper.hasHotPatch(patchesToRollbackSet) && OPatchSessionHelper.hasNonHotPatch(patchesToRollbackSet)) {
            re2 = new RuntimeException(OLogger.getString("OUI-67321", new Object[]{OPatchSessionHelper.getHotPatchIDs(patchesToRollbackSet), OPatchSessionHelper.getNonHotPatchIDs(patchesToRollbackSet), "nrollback"}));
            throw re2;
        }
        if (OPatchSessionHelper.hasMiniPatchset(patchesToRollbackSet) && OPatchSessionHelper.hasNormalOneoffs(patchesToRollbackSet)) {
            re2 = new RuntimeException(OLogger.getString("OUI-67327", new Object[]{OPatchSessionHelper.getNonMiniPatchSetIDs(patchesToRollbackSet), OPatchSessionHelper.getMiniPatchSetIDs(patchesToRollbackSet), "nrollback"}));
            throw re2;
        }
        try {
            OPatchUtilHelper.validateRunSqlOption(oracleHomePath, rbPatchObjects, "rollback");
        }
        catch (RuntimeException e8) {
            throw new RuntimeException("NRollback: " + e8.getMessage(), e8);
        }
        MergedPatchObject mPo = new MergedPatchObject(sessionName);
        StringBuffer rbListMsg = new StringBuffer("The following patch(es) will be rolled back: ");
        for (int i8 = 0; i8 < rbPatchObjects.length; ++i8) {
            PatchObject po = rbPatchObjects[i8];
            if (po == null) {
                buff = new StringBuffer("NRollback: a PatchObject is Null.");
                throw new RuntimeException(buff.toString());
            }
            OLogger.log(OLogger.FINE, "Create a merged patch using patch " + po.getPatchID());
            mPo.merge(oracleHomePath, po, true);
            String id = po.getPatchID();
            rbListMsg.append(id).append("  ");
        }
        String[] constituentsToUpdate = new String[]{};
        String[] constituentsToRollback = new String[]{};
        if (OPatchEnv.isCompositeRollback() && !OPatchEnv.isAll_Subpatches()) {
            constituentsToUpdate = CompositePatchObject.getConstituentsToNotRollback(oracleHomePath, OPatchEnv.getCompositeActiveID());
            constituentsToRollback = CompositePatchObject.getConstituentsToRollback(oracleHomePath, OPatchEnv.getCompositeActiveID());
        }
        buff = new StringBuffer("\n");
        buff.append(sessionName);
        buff.append(": backed-up files are under \"");
        String loc = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, mPo.getCookedPatchID());
        buff.append(loc);
        buff.append("\"\n");
        OLogger.log(OLogger.FINE, buff.toString());
        buff = new StringBuffer("Run all the prereqs related to rollback.");
        OLogger.debug(buff);
        OPatchSessionHelper.runRollbackPrereqs(oracleHomePath, rbPatchObjects);
        try {
            OLogger.println(rbListMsg.toString());
            if (OPatchEnv.isCompositeRollback()) {
                if (constituentsToUpdate.length > 0) {
                    int x;
                    String nonRollbackPatches = "";
                    String rollbackPatches = "";
                    for (x = 0; x < constituentsToUpdate.length; ++x) {
                        nonRollbackPatches = nonRollbackPatches + "," + constituentsToUpdate[x];
                    }
                    for (x = 0; x < constituentsToRollback.length; ++x) {
                        rollbackPatches = rollbackPatches + "," + constituentsToRollback[x];
                    }
                    OLogger.println(OLogger.getString("OUI-67929", new Object[]{nonRollbackPatches.substring(1), rollbackPatches.substring(1)}));
                } else {
                    OLogger.println(OLogger.getString("OUI-67930"));
                }
            }
            if (OPatchEnv.isOptimize() || OPatchEnv.isCompositeRollback()) {
                String bugsToRollbackList = "";
                HashSet<String> bugsFixedSet = new HashSet<String>();
                for (int x = 0; x < rbPatchObjects.length; ++x) {
                    Bug[] bugsFixed = rbPatchObjects[x].getBugsToFix();
                    for (int y = 0; y < bugsFixed.length; ++y) {
                        if (!bugsFixedSet.contains(bugsFixed[y].getBugID())) {
                            bugsToRollbackList = bugsToRollbackList + "," + bugsFixed[y].getBugID();
                        }
                        bugsFixedSet.add(bugsFixed[y].getBugID());
                    }
                }
                bugsToRollbackList = bugsToRollbackList.substring(1);
                OLogger.println(OLogger.getString("OUI-67928", new Object[]{bugsToRollbackList}));
            }
            selects = mPo.promptForShutdown(oracleHomePath, rwServices);
        }
        catch (ExitOPatchException e9) {
            buff = new StringBuffer("UtilSession: NRollback exits on user's request.");
            OLogger.println(buff.toString());
            throw e9;
        }
        catch (RuntimeException e10) {
            throw e10;
        }
        String sInterim = OPatchEnv.getInterimInventoryFileLoc(oracleHomePath);
        String rInterim = OPatchEnv.getRecordInventoryFileLoc(oracleHomePath);
        File fInterim = null;
        fInterim = new File(sInterim);
        if (fInterim.exists()) {
            fInterim.delete();
        }
        File frInterim = null;
        frInterim = new File(rInterim);
        if (frInterim.exists()) {
            frInterim.delete();
        }
        FileWriter fw = null;
        BufferedWriter interimWrite = null;
        try {
            OPatchSessionHelper.writeRecordedEntries(fInterim, "nrollback", rwServices);
            OPatchSessionHelper.writeRecordedEntries(frInterim, "nrollback", rwServices);
            fw = new FileWriter(fInterim, true);
            interimWrite = new BufferedWriter(fw);
            String comment = "# nrollback: list of patches to be rolled back.\n";
            interimWrite.write(comment);
            for (int i9 = 0; i9 < rbPatchObjects.length; ++i9) {
                StringBuffer line = new StringBuffer();
                PatchObject po = rbPatchObjects[i9];
                String id = po.getPatchID();
                line.append(id).append(":rollback:");
                Bug[] bugs = po.getBugsToFix();
                for (int j3 = 0; j3 < bugs.length; ++j3) {
                    String bID = bugs[j3].getBugID();
                    line.append(bID);
                    if (j3 >= bugs.length - 1) continue;
                    line.append(",");
                }
                line.append("\n");
                interimWrite.write(line.toString());
                interimWrite.flush();
            }
            interimWrite.close();
            fw.close();
        }
        catch (Exception comment) {
            // empty catch block
        }
        String cookedPatchID = mPo.getCookedPatchID();
        OPatchUtilHelper.createUtilSessionPatchStorageLocation(oracleHomePath, cookedPatchID);
        mPo.backupForRestore(oracleHomePath, rwServices);
        OPatchUtilHelper.setupRLibBackupDir(oracleHomePath, cookedPatchID);
        if (Rules.SystemWrite_continue() || Rules.OUIWrite_continue()) {
            String[] patchIDs = new String[rbPatchObjects.length];
            for (int i10 = 0; i10 < rbPatchObjects.length; ++i10) {
                patchIDs[i10] = rbPatchObjects[i10].getPatchID();
            }
            String[] triggeredPatchIDs = null;
            OPatchSessionHelper.createSessionProperties(oracleHomePath, sessionName, mPo.getCookedPatchID(), patchIDs, triggeredPatchIDs);
        }
        try {
            OPatchACL.setLocal(new NRollback(), true);
        }
        catch (IllegalAccessException patchIDs) {
            // empty catch block
        }
        String psLoc = OPatchUtilHelper.getUtilSessionPatchStorageLocation(oracleHomePath, mPo.getCookedPatchID());
        buff = new StringBuffer("\nNRollback: begins rolling back each patch...");
        OLogger.debug(buff);
        boolean doRestore = false;
        for (i2 = 0; i2 < rbPatchObjects.length; ++i2) {
            if (i2 > 0) {
                doRestore = true;
            }
            PatchObject po = rbPatchObjects[i2];
            String patchID = po.getPatchID();
            String patchLoc = po.getPatchLocation();
            po.disableFuserCheck();
            po.disableMakeAction();
            po.disablePromptForShutdown();
            po.disablePromptForStartup();
            po.disableRestoreFileCreation();
            po.disableSystemCommandCheck();
            po.disableRegenerateLibrary();
            if (OPatchEnv.isCASFlow()) {
                po.disablePrePostInit();
                buff = new StringBuffer("N-Apply: Disable all pre/post/init of patch if CAS is enabled. ");
                OLogger.debug(buff);
            }
            buff = new StringBuffer("\nRolling back patch ");
            buff.append(patchID);
            buff.append("...\n");
            OLogger.println(buff.toString());
            buff = new StringBuffer("Calling RollbackSession::process() ");
            buff.append(" with a PatchObject.");
            OLogger.debug(buff);
            try {
                OPatchUtilHelper.createAndUpdatePatchList(oracleHomePath, mPo.getCookedPatchID(), po, sessionName);
            }
            catch (Exception bID) {
                // empty catch block
            }
            RollbackSession rollbackSession = OPatchSession.ROLLBACK;
            try {
                OPatchACL.processRollback(new NRollback(), rollbackSession, patchLoc, patchID, oracleHomePath, po);
                continue;
            }
            catch (IllegalAccessException e11) {
                buff = new StringBuffer("NRollback doesn't have permission to invoke RollbckSession::process(). ");
                buff.append(e11.getMessage());
                RuntimeException re5 = new RuntimeException(buff.toString());
                re5.setStackTrace(e11.getStackTrace());
                throw re5;
            }
            catch (RuntimeException e12) {
                if (doRestore) {
                    buff = new StringBuffer("Some patches have been processed --> treat as Error.");
                    OLogger.debug(buff);
                    boolean ok = mPo.restoreOH(oracleHomePath);
                    OPatchUtilHelper.warnRestoreMessage(sessionName, psLoc, ok);
                    if (!ok) {
                        Error err = new Error(e12.getMessage());
                        err.setStackTrace(e12.getStackTrace());
                        throw err;
                    }
                    throw e12;
                }
                throw e12;
            }
            catch (Error e13) {
                boolean ok = mPo.restoreOH(oracleHomePath);
                OPatchUtilHelper.warnRestoreMessage(sessionName, psLoc, ok);
                if (!ok) {
                    throw e13;
                }
                RuntimeException re6 = new RuntimeException(e13.getMessage());
                re6.setStackTrace(e13.getStackTrace());
                throw re6;
            }
        }
        OLogger.log(OLogger.FINE, "\nDone with rolling back all patches.\n");
        OPatchUtilHelper.setNRollbackOneOffs(rbPatchObjects, oracleHomePath);
        if (!OPatchEnv.isCASFlow()) {
            try {
                mPo.invokeConsolidatedMake(oracleHomePath, rbPatchObjects);
            }
            catch (Throwable e14) {
                boolean ok = mPo.restoreOH(oracleHomePath);
                OPatchUtilHelper.warnRestoreMessage(sessionName, psLoc, ok);
                if (!ok) {
                    Error err = new Error(e14.getMessage());
                    err.setStackTrace(e14.getStackTrace());
                    throw err;
                }
                re = new RuntimeException(e14.getMessage());
                re.setStackTrace(e14.getStackTrace());
                throw re;
            }
            mPo.invokeConsolidatedRLib(oracleHomePath, rbPatchObjects);
        }
        for (i2 = 0; i2 < rbPatchObjects.length && OPatchEnv.isRunSql(); ++i2) {
            String originalPatchLoc = OPatchEnv.getPatchBackupDirectoryPath(oracleHomePath, rbPatchObjects[i2].getCookedPatchID());
            PatchmdXml rollbackSql = new PatchmdXml(oracleHomePath, originalPatchLoc, false, rbPatchObjects[i2].getAllIncludedCopyActions(), rbPatchObjects[i2].getPatchID());
            String rollbackSqlPath = rollbackSql.getSqlPath();
            if (rollbackSqlPath == null || rollbackSqlPath.equals("")) continue;
            try {
                OLogger.println(OLogger.getString("OUI-67272", new Object[]{"rollback", rollbackSqlPath, rbPatchObjects[i2].getPatchID()}));
                OPatchSessionHelper.runSqlScript(rollbackSqlPath, rbPatchObjects[i2].getPatchInventory().isSqlMigrate());
                continue;
            }
            catch (RuntimeException e15) {
                OLogger.printStackTrace(e15);
                OLogger.printlnOnLog(OLogger.INFO, e15.getMessage());
                OLogger.warn(OLogger.getString("OUI-67273", new Object[]{"rollback", rollbackSqlPath, rbPatchObjects[i2].getPatchID()}));
            }
        }
        try {
            OPatchSession.runCustomScript();
        }
        catch (RuntimeException e16) {
            OLogger.printStackTrace(e16);
            OLogger.printlnOnLog(OLogger.INFO, e16.getMessage());
            OLogger.warn("OUI-67266", new Object[]{OPatchEnv.getSqlScriptFilePath()});
        }
        Properties onlineProp = OPatchSessionHelper.getOnlinePropertyFromFile(oracleHomePath);
        if (!OPatchEnv.isReport()) {
            OPatchSessionHelper.removeOnlineRollbackSids(onlineProp, rbPatchObjects, OPatchEnv.getLocalNode(), oracleHomePath);
        }
        if (OPatchEnv.isRunSql()) {
            for (int i11 = 0; i11 < rbPatchObjects.length; ++i11) {
                if (!rbPatchObjects[i11].isSqlRelatedActions()) continue;
                OPatchSessionHelper.removeSidFromSqlPropertyFile(oracleHomePath, rbPatchObjects[i11].getCookedPatchID());
            }
        }
        if (Rules.SystemWrite_continue()) {
            for (int i12 = 0; i12 < constituentsToUpdate.length; ++i12) {
                try {
                    CompositePatchObject.subtractActiveXMLField(oracleHomePath, constituentsToUpdate[i12]);
                    continue;
                }
                catch (RuntimeException e17) {
                    buff = new StringBuffer("Some patches have been processed --> treat as Error.");
                    OLogger.debug(buff);
                    boolean ok = mPo.restoreOH(oracleHomePath);
                    OPatchUtilHelper.warnRestoreMessage(sessionName, psLoc, ok);
                    if (!ok) {
                        Error err = new Error(e17.getMessage());
                        err.setStackTrace(e17.getStackTrace());
                        throw err;
                    }
                    throw e17;
                }
            }
        }
        mPo.promptForStartup(oracleHomePath, rwServices);
        try {
            OPatchACL.setLocal(new NRollback(), isLocal);
        }
        catch (IllegalAccessException i12) {
            // empty catch block
        }
        NRollback.processRemote(oracleHomePath, selects, rbPatchObjects, mPo);
        OracleHomeConflictMap.printToActivePatchMessage();
        OPatchSessionHelper.cleanup(oracleHomePath);
        if (rwServices.isLocked()) {
            try {
                rwServices.release();
            }
            catch (Throwable t) {
                re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
        }
    }

    protected static void processRemote(String oracleHomePath, RacProcessor.MinDowntimeNodeSelection selects, PatchObject[] rollbackPatchObjects, MergedPatchObject mPo) throws RuntimeException {
        StringBuffer buff = new StringBuffer("NRollback::processRemote()");
        OLogger.debug(buff);
        OPatchSessionHelper.loadRACRelatedLibFile();
        IIPMReadServices readServices = null;
        String cookedPatchID = mPo.getCookedPatchID();
        Rac.RacType racType = null;
        try {
            readServices = PrereqSession.getReadServices(oracleHomePath);
        }
        catch (Throwable t) {
            RuntimeException e2 = new RuntimeException(t.getMessage());
            e2.setStackTrace(e2.getStackTrace());
            throw e2;
        }
        if ((Rules.OUIRead_continue() && !readServices.isOracleHomeInfoExist() || rollbackPatchObjects == null) && !readServices.isInventoryLoaded()) {
            buff.append(" needs a non-null Inventory and patchObject");
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
        racType = Rules.OUIRead_continue() ? Rac.getInstance(readServices, true) : Rac.getInstance(null);
        if (!Rac.shouldPropagate(racType) && !Rac.shouldRemoteRun(racType)) {
            buff = new StringBuffer(" not a RAC system, no-op for NRollback::processRemote()");
            OLogger.debug(buff);
        } else {
            buff = new StringBuffer("NRollback::processRemote() will roll back the patch on the following nodes: ");
            String localNode = racType.getLocalNode();
            String[] remoteNodes = racType.getRemoteNodes();
            try {
                OPatchUtilHelper.generateRacFiles(oracleHomePath, rollbackPatchObjects, cookedPatchID, sessionName);
            }
            catch (IOException e3) {
                RuntimeException re = new RuntimeException(e3.getMessage());
                re.setStackTrace(e3.getStackTrace());
                throw re;
            }
            if (remoteNodes != null) {
                for (int i2 = 0; i2 < remoteNodes.length; ++i2) {
                    String node = remoteNodes[i2];
                    buff.append(" (node ");
                    buff.append(node);
                    buff.append(")");
                }
            }
            buff.append(".  RAC mode is: ");
            buff.append(racType.getDetail());
            boolean local = OPatchEnv.isLocal();
            boolean minDT = OPatchEnv.isMinDowntime();
            boolean rolling = mPo.isRolling();
            boolean shutdown = mPo.isShutdown();
            boolean allNode = OPatchEnv.isAllNode();
            boolean silent = OPatchEnv.isSilent();
            try {
                if (mPo.forceAllNodeMode() && !allNode && (rolling || minDT)) {
                    allNode = true;
                    OPatchACL.setAllNode(new NRollback(), true);
                    OLogger.info("OUI-67250");
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            Rules.RacPatchOrder order = Rules.getRacPatchOrder(racType, local, rolling, minDT, allNode, silent);
            buff.append(".  Patching order is: ");
            buff.append(order.toString());
            OLogger.debug(buff);
            try {
                String FP = null;
                String DP = null;
                String FR = null;
                String DR = null;
                String MP = null;
                String RC = null;
                String patchStorageRac = "";
                try {
                    patchStorageRac = OPatchEnv.getPatchStorageRacDirectoryPath(oracleHomePath, cookedPatchID);
                    boolean createRacFile = OPatchEnv.isCreateRacFile();
                    File f2 = new File(patchStorageRac);
                    if (!createRacFile && !f2.exists()) {
                        buff = new StringBuffer("NRollback::processRemote() was not able to locate the ");
                        buff.append("directory containing listed files/dirs to be propagated/removed on remote nodes.  ");
                        buff.append("Moreover, since users request that no RAC listed files be generated, ");
                        buff.append("OPatch cannot go on patching remote nodes.  ");
                        OLogger.println(buff.toString());
                        return;
                    }
                    RacFileCreator.checkPsRac(patchStorageRac);
                    FP = RacFileCreator.getFPFinalName(patchStorageRac);
                    DP = RacFileCreator.getDPFinalName(patchStorageRac);
                    FR = RacFileCreator.getFRFinalName(patchStorageRac);
                    DR = RacFileCreator.getDRFinalName(patchStorageRac);
                    MP = RacFileCreator.getMPFinalName(patchStorageRac);
                    RC = RacFileCreator.getRCFinalName(patchStorageRac);
                }
                catch (IOException e4) {
                    RuntimeException re = new RuntimeException(e4.getMessage());
                    re.setStackTrace(e4.getStackTrace());
                    throw re;
                }
                StringBuffer report = new StringBuffer("OPatch will use the following files to patch remote nodes:\n");
                if (FP != null) {
                    report.append("   \"");
                    report.append(FP);
                    report.append("\"\n");
                }
                if (RC != null) {
                    report.append("   \"");
                    report.append(RC);
                    report.append("\"\n");
                }
                if (DP != null) {
                    report.append("   \"");
                    report.append(DP);
                    report.append("\"\n");
                }
                if (FR != null) {
                    report.append("   \"");
                    report.append(FR);
                    report.append("\"\n");
                }
                if (DR != null) {
                    report.append("   \"");
                    report.append(DR);
                    report.append("\"\n");
                }
                if (MP != null) {
                    report.append("   \"");
                    report.append(MP);
                    report.append("\"\n");
                }
                OLogger.log(OLogger.FINE, report.toString());
                boolean apply = false;
                boolean rollback = true;
                boolean autoRollBack = false;
                RacProcessor.patchRemoteNodes(oracleHomePath, remoteNodes, order, FP, DP, FR, DR, MP, RC, shutdown, sessionName, selects, apply, rollback, autoRollBack, patchStorageRac, mPo.getShutdownMsg(), rollbackPatchObjects, null, localNode, Rac.shouldPropagate(racType), Rac.shouldRemoteRun(racType));
            }
            catch (RuntimeException e5) {
                throw e5;
            }
            catch (Error e6) {
                throw e6;
            }
        }
    }

    private static void runPrereqs(String oracleHomePath, PatchObject[] rbPatchObjects) throws PrereqFailedException {
        int i2;
        StringBuffer buff = new StringBuffer();
        if (Rules.SystemWrite_continue()) {
            for (i2 = 0; i2 < rbPatchObjects.length; ++i2) {
                PrereqResult sysCmdRes = PrereqAPI.checkSystemCommandAvailable(oracleHomePath, rbPatchObjects[i2].toOneOffEntry(oracleHomePath), rbPatchObjects[i2].getExecutables(oracleHomePath));
                if (sysCmdRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || sysCmdRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                    buff = new StringBuffer("\nPre-requiste \"CheckSystemCommandAvailable\" failed.");
                    buff.append(sysCmdRes.toString());
                    OLogger.println(buff.toString());
                    PrereqFailedException pe = new PrereqFailedException("Prereq checkSystemCommandAvailable failed.");
                    throw pe;
                }
                OLogger.log(OLogger.FINE, "All the required system commands are present.");
            }
        }
        if (Rules.SystemWrite_continue()) {
            for (i2 = 0; i2 < rbPatchObjects.length; ++i2) {
                PrereqResult activeFilesRes = PrereqAPI.checkActiveFilesAndExecutables(oracleHomePath, rbPatchObjects[i2]);
                if (activeFilesRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || activeFilesRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                    buff = new StringBuffer("\nPre-requiste \"CheckActiveFilesAndExecutables\" failed.");
                    buff.append(activeFilesRes.toString());
                    OLogger.println(buff.toString());
                    PrereqFailedException pe = new PrereqFailedException("Prereq checkActiveFilesAndExecutables failed.");
                    throw pe;
                }
                OLogger.log(OLogger.FINE, "None of the executables are active.");
            }
        }
        if (Rules.OUIRead_continue() && Rules.SystemWrite_continue()) {
            PrereqResult applicableRes = PrereqAPI.checkRollbackable(oracleHomePath, rbPatchObjects);
            if (applicableRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || applicableRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                buff = new StringBuffer("\nPre-requiste \"CheckApplicable\" failed.");
                buff.append(applicableRes.toString());
                OLogger.println(buff.toString());
                PrereqFailedException pe = new PrereqFailedException("Prereq checkApplicable failed.");
                throw pe;
            }
            OLogger.log(OLogger.FINE, "All the actions of the given patches are applicable.");
        }
    }
}

