/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.twophase;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.opatch.PatchObject;
import oracle.opatch.cas.OPatchPatchKey;
import oracle.opatch.twophase.INonBinaryPatchAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PatchActions
extends LinkedHashMap<OPatchPatchKey, INonBinaryPatchAction[]>
implements Serializable {
    private static final long serialVersionUID = -1060340034891786050L;

    public void run(OPatchPatchKey key) {
        INonBinaryPatchAction[] pre;
        for (INonBinaryPatchAction act : pre = (INonBinaryPatchAction[])this.get(key)) {
            try {
                act.run();
            }
            catch (Exception e2) {
                RuntimeException re = new RuntimeException(e2.getMessage());
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
        }
    }

    public boolean hasAnyActions() {
        for (OPatchPatchKey key : this.keySet()) {
            INonBinaryPatchAction[] pre = (INonBinaryPatchAction[])this.get(key);
            if (pre.length == 0) continue;
            return true;
        }
        return false;
    }

    public void save(String prefix, String postfix, Map<OPatchPatchKey, PatchObject[]> patchMap) throws IOException {
        this.build(patchMap);
        String fileName = this.getFileName(prefix, postfix);
        FileOutputStream f_out = new FileOutputStream(fileName);
        ObjectOutputStream obj_out = new ObjectOutputStream(f_out);
        obj_out.writeObject(this);
        f_out.close();
    }

    public void load(String prefix, String postfix) throws IOException, ClassNotFoundException {
        String fileName = this.getFileName(prefix, postfix);
        if (!this.isExist(fileName)) {
            return;
        }
        FileInputStream f_in = new FileInputStream(fileName);
        ObjectInputStream obj_in = new ObjectInputStream(f_in);
        Object obj = obj_in.readObject();
        this.putAll((PatchActions)obj);
        f_in.close();
    }

    public abstract String getFileName(String var1, String var2);

    public abstract INonBinaryPatchAction getAction(PatchObject var1);

    protected void build(Map<OPatchPatchKey, PatchObject[]> patchMap) {
        for (OPatchPatchKey key : patchMap.keySet()) {
            PatchObject[] listOfPatches = patchMap.get(key);
            INonBinaryPatchAction[] pres = this.getActions(listOfPatches);
            this.put(key, pres);
        }
    }

    private INonBinaryPatchAction[] getActions(PatchObject[] patches) {
        ArrayList<INonBinaryPatchAction> actions = new ArrayList<INonBinaryPatchAction>();
        for (PatchObject p2 : patches) {
            INonBinaryPatchAction action = this.getAction(p2);
            if (action == null || action.isRealEmpty()) continue;
            actions.add(action);
        }
        INonBinaryPatchAction[] res = new INonBinaryPatchAction[actions.size()];
        actions.toArray(res);
        return res;
    }

    private boolean isExist(String file) {
        File f2 = new File(file);
        return f2.exists();
    }
}

