/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.twophase;

import java.io.Serializable;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.PatchObject;
import oracle.opatch.PostScriptAction;
import oracle.opatch.twophase.INonBinaryPatchAction;
import oracle.opatch.twophase.PatchActions;
import oracle.opatch.twophase.PhaseTwoPostScriptAction;

public class PostScriptPatchActions
extends PatchActions
implements Serializable {
    private static final long serialVersionUID = 1L;

    public INonBinaryPatchAction getAction(PatchObject p2) {
        PostScriptAction action = p2.getPostScriptAction();
        if (action != null) {
            String args = null;
            String operation = null;
            String patchId = p2.getPatchID();
            if (OPatchEnv.isApplyOrNApplySession()) {
                args = OPatchSessionHelper.getPostScriptActionArgument(patchId);
                operation = "apply";
            } else {
                args = OPatchSessionHelper.getPostScriptActionArgumentForRollBack(patchId);
                operation = "rollback";
            }
            action.setScriptArguments(args, operation, patchId);
            return new PhaseTwoPostScriptAction(action);
        }
        return null;
    }

    public String getFileName(String prefix, String postfix) {
        return prefix + ".post." + postfix;
    }
}

