/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.twophase;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import oracle.opatch.JarAction;
import oracle.opatch.MakeAction;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchingModel;
import oracle.opatch.SystemCall;
import oracle.opatch.opatchlogger.OLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwoPhasePatchingHelper {
    public static Map<Path, String> getBaseCopy(String oh) {
        HashMap<Path, String> copy = new HashMap<Path, String>();
        String contents = "inventory" + File.separator + "ContentsXML";
        Path pc = Paths.get(contents, new String[0]);
        String oneoffs = "inventory" + File.separator + "oneoffs";
        Path po = Paths.get(oneoffs, new String[0]);
        copy.put(pc, contents);
        copy.put(po, oneoffs);
        return copy;
    }

    public static Map<Path, String> getCopiedFiles(String oh, PatchObject[] patches) {
        MakeAction[] makes;
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: PhaseOneOperator::getCopiedFiles (String oh, PatchObject[] patches)");
        if (patches == null || patches.length == 0) {
            return new HashMap<Path, String>();
        }
        HashMap<Path, String> copy = new HashMap<Path, String>();
        HashSet<String> patchfiles = new HashSet<String>();
        OneOffEntry[] oneoffs = new OneOffEntry[patches.length];
        for (int i2 = 0; i2 < patches.length; ++i2) {
            oneoffs[i2] = patches[i2].toOneOffEntry(oh);
            String[][] filesTouched = oneoffs[i2].getFilesTouched(oh);
            OLogger.justlog(OLogger.INFO, "Getting list of files touched by patch " + oneoffs[i2].getPatchID());
            for (int x = 0; x < filesTouched.length; ++x) {
                String touchfile = filesTouched[x][1];
                patchfiles.add(touchfile);
                OLogger.justlog(OLogger.INFO, MessageFormat.format("file \"{0}\" touched by the patch, adding to copy list. \n", touchfile));
            }
            ListIterator iter = patches[i2].getAllIncludedJarActions();
            while (iter.hasNext()) {
                String[] jarfiles;
                JarAction a2 = (JarAction)iter.next();
                for (String jarfile : jarfiles = a2.filesTouched(oh)) {
                    patchfiles.add(jarfile);
                    OLogger.justlog(OLogger.INFO, MessageFormat.format("multi-layer container file \"{0}\" touched by patch, adding to copy list. \n", jarfile));
                }
            }
            for (String patchfile : patchfiles) {
                File file = new File(patchfile);
                if (!file.exists()) continue;
                patchfile = patchfile.substring(oh.length() + 1, patchfile.length());
                Path p1 = Paths.get(patchfile, new String[0]);
                OLogger.justlog(OLogger.INFO, MessageFormat.format("file \"{0}\" touched by the patch and existed in OH, adding to copy list. \n", patchfile));
                copy.put(p1, patchfile);
            }
        }
        for (MakeAction m2 : makes = OPatchSessionHelper.getIncludedMakeActions(oh, patches)) {
            String makefile = m2.getMakeFile();
            String changedir = m2.getChangeDirectory();
            makefile = changedir + File.separator + makefile;
            Path p2 = Paths.get(makefile, new String[0]);
            copy.put(p2, makefile);
            OLogger.justlog(OLogger.INFO, MessageFormat.format("make file \"{0}\" needed for relink, adding to copy list. \n", makefile));
        }
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: PhaseOneOperator::getCopiedFiles (String oh, PatchObject[] patches)");
        return copy;
    }

    public static void addCopiedFilesForPatchStorage(Map<Path, String> copy, String oh, PatchObject[] patches) {
        String patchStorage = OPatchEnv.getPatchStorageName();
        if (PatchingModel.returnModelCode(oh) == 1) {
            for (PatchObject po : patches) {
                String patchInPS = patchStorage + File.separator + po.getCookedPatchID();
                copy.put(Paths.get(patchInPS, new String[0]), patchInPS);
            }
            String interimInventory = patchStorage + File.separator + "interim_inventory.txt";
            String latestOPatchSession = patchStorage + File.separator + "LatestOPatchSession.properties";
            String recordInventory = patchStorage + File.separator + "record_inventory.txt";
            String napplyDirectory = patchStorage + File.separator + "NApply";
            String nrollbackDirectory = patchStorage + File.separator + "NRollback";
            String fileToPropogate = patchStorage + File.separator + "prereq_testing.txt";
            String verifyDirectory = patchStorage + File.separator + "verify";
            copy.put(Paths.get(interimInventory, new String[0]), interimInventory);
            copy.put(Paths.get(latestOPatchSession, new String[0]), latestOPatchSession);
            copy.put(Paths.get(recordInventory, new String[0]), recordInventory);
            copy.put(Paths.get(napplyDirectory, new String[0]), napplyDirectory);
            copy.put(Paths.get(nrollbackDirectory, new String[0]), nrollbackDirectory);
            copy.put(Paths.get(fileToPropogate, new String[0]), fileToPropogate);
            copy.put(Paths.get(verifyDirectory, new String[0]), verifyDirectory);
        }
    }

    public static void addCopiedFilesForSparceCopy(Map<Path, String> copy, String oh, PatchObject[] patches) {
        HashMap<String, String> workingAppDirs = new HashMap<String, String>();
        if (OPatchEnv.isSparseCopy()) {
            for (PatchObject pObject : patches) {
                if (!pObject.isSparseCopy()) continue;
                ArrayList appDirs = pObject.getApplicationDirs();
                for (int i2 = 0; i2 < appDirs.size(); ++i2) {
                    String appDir = (String)appDirs.get(i2);
                    File latestFile = OPatchEnv.getLatestFileWtihStartString(oh, appDir, "latest-ptr-");
                    if (latestFile != null) {
                        String workingDirName = latestFile.getName().substring("latest-ptr-".length());
                        String relativeWorkingDir = appDir + File.separator + workingDirName;
                        workingAppDirs.put(appDir, relativeWorkingDir);
                    } else {
                        workingAppDirs.put(appDir, "");
                    }
                    copy.put(Paths.get(appDir, new String[0]), appDir);
                }
            }
            OPatchEnv.setApplicationWorkingDirectory(workingAppDirs);
            OLogger.justlog(OLogger.INFO, "casPrepare::the working application directories for each application are " + workingAppDirs);
        }
    }

    public static void doTheCopy(Map<Path, String> copy, String oh, String soh) {
        Path ohPath = Paths.get(oh, new String[0]);
        Path sohPath = Paths.get(soh, new String[0]);
        for (Path path : copy.keySet()) {
            File src = ohPath.resolve(path).toFile();
            File dest = sohPath.resolve(path).toFile();
            if (!src.exists()) continue;
            if (src.isDirectory()) {
                try {
                    TwoPhasePatchingHelper.doCopyDirectory(src, dest);
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                continue;
            }
            SystemCall.copyFile(src, dest);
        }
    }

    private static void doCopyDirectory(File srcDir, File destDir) throws IOException {
        File[] srcFiles = srcDir.listFiles();
        if (destDir.exists()) {
            if (!destDir.isDirectory()) {
                throw new IOException("Destination '" + destDir + "' exists but is not a directory");
            }
        } else if (!destDir.mkdirs() && !destDir.isDirectory()) {
            throw new IOException("Destination '" + destDir + "' directory cannot be created");
        }
        if (!destDir.canWrite()) {
            throw new IOException("Destination '" + destDir + "' cannot be written to");
        }
        for (File srcFile : srcFiles) {
            File dstFile = new File(destDir, srcFile.getName());
            if (srcFile.isDirectory()) {
                TwoPhasePatchingHelper.doCopyDirectory(srcFile, dstFile);
                continue;
            }
            SystemCall.copyFile(srcFile, dstFile);
        }
    }
}

