/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.sysman.oii.oiix.OiixJarResourceIF;
import oracle.sysman.oii.oiix.OiixLanguage;

public class OiixBaseResourceBundle
implements OiixJarResourceIF {
    protected String m_sResourceName = null;
    protected ResourceBundle m_rb = null;
    private ResourceBundle m_enrb = null;

    public OiixBaseResourceBundle(String sResourceName) {
        this(sResourceName, null);
    }

    public OiixBaseResourceBundle(String sResourceName, Locale loc) {
        this.m_sResourceName = sResourceName;
        this.m_rb = this.getBundle(loc);
    }

    public synchronized String getString(String key) {
        try {
            return this.m_rb.getString(key);
        }
        catch (MissingResourceException e2) {
            return this.getEnglishString(key);
        }
    }

    public synchronized String getString(String key, Object[] args) {
        String str = key;
        try {
            str = MessageFormat.format(this.getString(key), args);
        }
        catch (IllegalArgumentException e2) {
            str = key;
        }
        return str;
    }

    public synchronized Object getObject(String key) {
        try {
            return this.m_rb.getObject(key);
        }
        catch (MissingResourceException e2) {
            return this.getEnglishString(key);
        }
    }

    public synchronized Object getObject(String key, Object defVal) {
        try {
            return this.getObject(key);
        }
        catch (MissingResourceException e2) {
            return defVal;
        }
    }

    public String getString(String key, String defVal) {
        return (String)this.getObject(key, defVal);
    }

    public ResourceBundle getJarBundle() {
        return this.getBundle();
    }

    public ResourceBundle getBundle() {
        return this.m_rb;
    }

    private ResourceBundle getBundle(Locale loc) {
        if (loc == null) {
            return ResourceBundle.getBundle(this.m_sResourceName);
        }
        return ResourceBundle.getBundle(this.m_sResourceName, loc);
    }

    public ResourceBundle getEnglishBundle() {
        if (this.m_enrb == null) {
            this.m_enrb = this.getBundle(OiixLanguage.ENGLISH);
        }
        return this.m_enrb;
    }

    private String getEnglishString(String key) {
        try {
            return this.getEnglishBundle().getString(key);
        }
        catch (MissingResourceException mse) {
            return key;
        }
    }

    public void setLocale(Locale loc) {
        this.m_rb = this.getBundle(loc);
    }
}

