/*
 * Decompiled with CFR 0.152.
 */
import java.net.InetAddress;
import java.util.Vector;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.winsecurity.Group;
import oracle.cluster.winsecurity.WinSecurityFactory;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.ops.mgmt.cluster.Version;
import oracle.sysman.oii.oiil.OiilAction;
import oracle.sysman.oii.oiil.OiilActionCloneCapable;
import oracle.sysman.oii.oiil.OiilActionClusterOps;
import oracle.sysman.oii.oiil.OiilActionException;
import oracle.sysman.oii.oiil.OiilActionInputElement;
import oracle.sysman.oii.oiil.OiilCommitException;
import oracle.sysman.oii.oiil.OiilDeinstallException;
import oracle.sysman.oii.oiil.OiilUndoException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixInstantiateString;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class CreateOSGroup
implements OiilAction,
OiilActionCloneCapable,
OiilActionClusterOps {
    private Object retItem(Vector inputs, String param) {
        int pos = OiixVectorOps.vectIndexOf((Vector)inputs, (Object)param);
        if (pos == -1) {
            return null;
        }
        OiilActionInputElement aie = (OiilActionInputElement)inputs.elementAt(pos);
        return aie.getObject();
    }

    public void installAction(Vector inputs, Vector outLogObjects) throws OiilActionException {
        String groupName = (String)this.retItem(inputs, "groupName");
        String oracleHomeBin = (String)this.retItem(inputs, "OracleHomeBin");
        try {
            Version m_version = new Version();
            WinSecurityFactory m_winSecFactory = WinSecurityFactory.getInstance((String)oracleHomeBin, null);
            Group m_group = m_winSecFactory.getGroup(groupName, m_version);
            m_group.create(groupName);
        }
        catch (WindowsSecurityException we) {
            String[] variables = new String[1];
            String[] values = new String[1];
            variables[0] = new String("%1%");
            values[0] = new String(groupName);
            String errString = OiActionIniRes.getString("GroupCreationException_desc");
            String exString = OiixInstantiateString.processString((String)errString, (String[])variables, (String[])values);
            String exName = new String("WindowsSecurityException has occurred");
            OiiolTextLogger.appendText((String)exName);
            OiiolTextLogger.appendException((Throwable)we);
            throw new OiilActionException(exName, exString);
        }
        catch (Exception e) {
            String excepStr = OiActionIniRes.getString("Exception_desc");
            OiiolTextLogger.appendText((String)excepStr);
            OiiolTextLogger.appendException((Throwable)e);
            throw new OiilActionException(excepStr, e.getMessage());
        }
    }

    public void clusterInstallAction(Vector inputs, Vector inLogObjects) throws OiilActionException {
        String machineName = new String();
        try {
            machineName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        String[] remoteNodes = (String[])this.retItem(inputs, "remoteNodes");
        if (remoteNodes != null && remoteNodes.length > 0) {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText((String)("***Create OS Group on  node:" + OiixFunctionOps.implodeList((String[])remoteNodes, (String)",")));
            }
            String groupName = (String)this.retItem(inputs, "groupName");
            String oracleHomeBin = (String)this.retItem(inputs, "OracleHomeBin");
            try {
                Version m_version = new Version();
                WinSecurityFactory m_winSecFactory = WinSecurityFactory.getInstance((String)oracleHomeBin, null);
                Group m_group = m_winSecFactory.getGroup(groupName, m_version);
                m_group.create(groupName, machineName, remoteNodes);
            }
            catch (CompositeOperationException ce) {
                String[] variables = new String[1];
                String[] values = new String[1];
                variables[0] = new String("%1%");
                values[0] = new String(groupName);
                String errString = OiActionIniRes.getString("GroupCreationException_desc");
                String exString = OiixInstantiateString.processString((String)errString, (String[])variables, (String[])values);
                String exName = new String("CompositeOperationException has occurred");
                OiiolTextLogger.appendText((String)exName);
                OiiolTextLogger.appendException((Throwable)ce);
                throw new OiilActionException(exName, exString);
            }
            catch (WindowsSecurityException we) {
                String[] variables = new String[1];
                String[] values = new String[1];
                variables[0] = new String("%1%");
                values[0] = new String(groupName);
                String errString = OiActionIniRes.getString("GroupCreationException_desc");
                String exString = OiixInstantiateString.processString((String)errString, (String[])variables, (String[])values);
                String exName = new String("WindowsSecurityException has occurred");
                OiiolTextLogger.appendText((String)exName);
                OiiolTextLogger.appendException((Throwable)we);
                throw new OiilActionException(exName, exString);
            }
            catch (Exception e) {
                String excepStr = OiActionIniRes.getString("Exception_desc");
                OiiolTextLogger.appendText((String)excepStr);
                OiiolTextLogger.appendException((Throwable)e);
                throw new OiilActionException(excepStr, e.getMessage());
            }
        }
    }

    public void cloneAction(Vector inputs, Vector outLogObjects) throws OiilActionException {
        this.installAction(inputs, outLogObjects);
    }

    public String getDescription(Vector inputs) {
        return null;
    }

    public void saveAndInstallAction(Vector vector, Vector vector1, Vector vector2) throws OiilActionException {
    }

    public void deinstallAction(Vector vector, Vector vector1) throws OiilDeinstallException {
    }

    public void clusterDeinstallAction(Vector vector, Vector vector1) throws OiilDeinstallException {
    }

    public void saveAndDeinstallAction(Vector vector, Vector vector1, Vector vector2, Vector vector3) throws OiilDeinstallException {
    }

    public void undoInstallAction(Vector vector, Vector vector1, Vector vector2) throws OiilUndoException {
    }

    public void undoDeinstallAction(Vector vector, Vector vector1, Vector vector2, Vector vector3) throws OiilUndoException {
    }

    public void commitInstallAction(Vector vector, Vector vector1, Vector vector2, Vector vector3) throws OiilCommitException {
    }

    public void commitDeinstallAction(Vector vector, Vector vector1, Vector vector2) throws OiilCommitException {
    }

    public static void main(String[] args) {
        CreateOSGroup atodg = new CreateOSGroup();
        Vector<OiilActionInputElement> i = new Vector<OiilActionInputElement>();
        Vector olo = new Vector();
        i.addElement(new OiilActionInputElement("groupName", (Object)"ORA_INSTALL"));
        i.addElement(new OiilActionInputElement("OracleHome", (Object)"C:\\ADE\\jaikrish_instcomp\\oracle\\bin"));
        try {
            atodg.installAction(i, olo);
        }
        catch (OiilActionException ne) {
            ne.printStackTrace();
            System.out.println(ne.getExceptionName());
        }
    }
}

