/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipcp;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.sysman.oii.oiix.OiixInvalidDataException;
import oracle.sysman.oii.oiix.OiixSet;
import oracle.sysman.oip.oipc.oipcp.OipcpIPrereq;

public class OipcpPrerequisiteSet
implements OipcpIPrereq {
    private String m_sName;
    private List m_oPrereqChecks = null;
    private Map m_oChecksErrorLevelMap;

    public OipcpPrerequisiteSet(String sName) {
        this.m_sName = sName;
        this.m_oPrereqChecks = new ArrayList();
    }

    public OipcpPrerequisiteSet(String sName, List oPrereqs) {
        this.m_sName = sName;
        this.m_oPrereqChecks = oPrereqs;
    }

    public List getPrereqs() {
        return this.m_oPrereqChecks;
    }

    protected void setPrereqs(List oPrereqList) {
        this.m_oPrereqChecks = oPrereqList;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String sName) {
        this.m_sName = sName;
    }

    public Iterator getPrereqsIterator() {
        return this.m_oPrereqChecks.listIterator();
    }

    public void addPrereq(OipcpIPrereq oPrereq) {
        this.m_oPrereqChecks.add(oPrereq);
    }

    public void removePrereqCheck(OipcpIPrereq oPrereq) {
        this.m_oPrereqChecks.remove(oPrereq);
    }

    @Override
    public OiixSet getContainedChecks() {
        OiixSet oSet = null;
        try {
            oSet = new OiixSet("oracle.sysman.oip.oipc.oipcp.OipcpPrerequisiteCheck");
            Iterator iter = this.getPrereqsIterator();
            while (iter.hasNext()) {
                OipcpIPrereq oPrereq = (OipcpIPrereq)iter.next();
                if (!oPrereq.isComposite()) {
                    oSet.addElement((Object)oPrereq);
                    continue;
                }
                this.mergeSets(oSet, oPrereq.getContainedChecks());
            }
        }
        catch (OiixInvalidDataException ie) {
            ie.printStackTrace();
        }
        return oSet;
    }

    private void mergeSets(OiixSet oSet1, OiixSet oSet2) {
        if (oSet1 != null && oSet2 != null) {
            Enumeration en = oSet2.elements();
            while (en.hasMoreElements()) {
                try {
                    oSet1.addElement(en.nextElement());
                }
                catch (OiixInvalidDataException ie) {
                    ie.printStackTrace();
                }
            }
        }
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean isEmpty() {
        return this.getName().length() == 0 || this.getPrereqs().isEmpty();
    }

    public boolean equals(OipcpPrerequisiteSet oSet) {
        boolean bEqual = false;
        if (this == oSet) {
            bEqual = true;
        } else if (oSet != null) {
            bEqual = oSet.getName().equalsIgnoreCase(this.getName()) && oSet.getPrereqs().equals(this.getPrereqs());
        }
        return bEqual;
    }
}

