/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipcr;

import java.io.IOException;
import java.util.Collection;
import javax.xml.parsers.ParserConfigurationException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipcr.OipcrRule;
import oracle.sysman.oip.oipc.oipcr.OipcrRuleMap;
import oracle.sysman.oip.oipc.oipcr.OipcrRuleSet;
import oracle.sysman.oix.oixd.OixdDOMReader;
import oracle.sysman.oix.oixd.OixdInvalidDocumentException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OipcrRuleMapReader {
    private static final String S_RULEMAP = "RULEMAP";
    private static final String S_RULESET = "RULESET";
    private static final String S_RULE = "RULE";
    private static final String S_RULESET_NAME = "name";
    private static final String S_RULESET_CLASS_NAME = "class";
    private static final String S_RULE_NAME = "name";
    private static final String S_RULE_METHOD_NAME = "method";
    private OipcrRuleMap m_oRuleMap = null;
    private Collection m_oFileNames = null;

    protected OipcrRuleMapReader(Collection oFileNames) {
        this.m_oFileNames = oFileNames;
    }

    static OipcrRuleMapReader getReader(Collection oFileNames) {
        return new OipcrRuleMapReader(oFileNames);
    }

    void build() throws IOException, SAXException, ParserConfigurationException, OixdInvalidDocumentException {
        this.m_oRuleMap = new OipcrRuleMap();
        for (String sFileName : this.m_oFileNames) {
            Document oDoc = OixdDOMReader.getDocument((String)sFileName);
            if (oDoc == null) continue;
            this.build(this.m_oRuleMap, oDoc, sFileName);
        }
    }

    private void build(OipcrRuleMap oRuleMap, Document oDoc, String sFileName) throws OixdInvalidDocumentException {
        Element root = oDoc.getDocumentElement();
        if (!root.getTagName().equalsIgnoreCase(S_RULEMAP)) {
            Object[] args = new String[]{sFileName};
            throw new OixdInvalidDocumentException("OUI-15011", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15011", (Object[])args));
        }
        NodeList oRuleSetNodes = root.getChildNodes();
        if (oRuleSetNodes != null) {
            int nRuleSets = oRuleSetNodes.getLength();
            OipcrRuleSet oRuleSet = null;
            OipcrRule oRule = null;
            Node oAttrib = null;
            for (int i = 0; i < nRuleSets; ++i) {
                Object[] args;
                Node oRuleSetNode = oRuleSetNodes.item(i);
                if (oRuleSetNode.getNodeType() != 1 || !oRuleSetNode.getNodeName().equalsIgnoreCase(S_RULESET)) continue;
                NamedNodeMap oRuleSetAttribs = oRuleSetNode.getAttributes();
                if (oRuleSetAttribs == null) {
                    args = new String[]{sFileName};
                    throw new OixdInvalidDocumentException("OUI-15012", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15012", (Object[])args));
                }
                oAttrib = oRuleSetAttribs.getNamedItem("name");
                if (oAttrib == null) {
                    args = new String[]{sFileName};
                    throw new OixdInvalidDocumentException("OUI-15014", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15014", (Object[])args));
                }
                String sRuleSetName = oAttrib.getNodeValue();
                oAttrib = oRuleSetAttribs.getNamedItem(S_RULESET_CLASS_NAME);
                if (oAttrib == null) {
                    args = new String[]{sFileName, sRuleSetName};
                    throw new OixdInvalidDocumentException("OUI-15015", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15015", (Object[])args));
                }
                String sClass = oAttrib.getNodeValue();
                oRuleSet = new OipcrRuleSet(sRuleSetName, sClass);
                NodeList oRuleNodes = oRuleSetNode.getChildNodes();
                if (oRuleNodes != null) {
                    int nRules = oRuleNodes.getLength();
                    for (int j = 0; j < nRules; ++j) {
                        Node oRuleNode = oRuleNodes.item(j);
                        if (oRuleNode.getNodeType() != 1) continue;
                        NamedNodeMap oRuleAttribs = oRuleNode.getAttributes();
                        if (oRuleAttribs == null) {
                            Object[] args2 = new String[]{sFileName, sRuleSetName};
                            throw new OixdInvalidDocumentException("OUI-15013", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15013", (Object[])args2));
                        }
                        oAttrib = oRuleAttribs.getNamedItem("name");
                        if (oAttrib == null) {
                            Object[] args3 = new String[]{sFileName, sRuleSetName};
                            throw new OixdInvalidDocumentException("OUI-15016", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15016", (Object[])args3));
                        }
                        String sRuleName = oAttrib.getNodeValue();
                        oAttrib = oRuleAttribs.getNamedItem(S_RULE_METHOD_NAME);
                        if (oAttrib == null) {
                            Object[] args4 = new String[]{sFileName, sRuleName, sRuleSetName};
                            throw new OixdInvalidDocumentException("OUI-15017", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15017", (Object[])args4));
                        }
                        String sMethod = oAttrib.getNodeValue();
                        oRule = new OipcrRule(sRuleName, sMethod, oRuleSet);
                        oRuleSet.addRule(oRule);
                    }
                }
                oRuleMap.addRuleSet(oRuleSet);
            }
        }
    }

    OipcrRuleMap getRuleMap() {
        return this.m_oRuleMap;
    }
}

