/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipcr;

import java.util.Iterator;
import oracle.sysman.oii.oiix.OiixAssert;
import oracle.sysman.oii.oiix.OiixInvalidDataException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixSet;
import oracle.sysman.oip.oipc.oipcr.OipcrRule;
import oracle.sysman.oip.oipc.oipcr.OipcrRuleNotFoundException;

public class OipcrRuleSet {
    private String m_sClass = null;
    private String m_sName = null;
    private OiixSet m_oRules = null;
    private static final String RULE_CLASSNAME = "oracle.sysman.oip.oipc.oipcr.OipcrRule";
    private Class m_oClass = null;

    OipcrRuleSet(String sName, String sClass) {
        this.m_sName = sName;
        this.m_sClass = sClass;
    }

    String getClassName() {
        return this.m_sClass;
    }

    String getName() {
        return this.m_sName;
    }

    Iterator getRules() {
        Iterator oRules = null;
        try {
            oRules = this.m_oRules == null ? new OiixSet(RULE_CLASSNAME).elementsVect().iterator() : this.m_oRules.elementsVect().iterator();
        }
        catch (OiixInvalidDataException e) {
            OiixAssert.assertion((boolean)false, (String)("Unexpected invalid data exception encountered:" + e.getMessage()));
        }
        return oRules;
    }

    OipcrRule getRule(String sRule) throws OipcrRuleNotFoundException {
        OipcrRule oRule = null;
        if (this.m_oRules != null) {
            oRule = (OipcrRule)this.m_oRules.getElementLike((Object)sRule);
        }
        if (oRule == null) {
            Object[] args = new String[]{sRule};
            throw new OipcrRuleNotFoundException("OUI-15002", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15002", (Object[])args));
        }
        return oRule;
    }

    OipcrRule addRule(OipcrRule rule) {
        if (rule != null) {
            try {
                if (this.m_oRules == null) {
                    this.m_oRules = new OiixSet(RULE_CLASSNAME);
                }
                rule = (OipcrRule)this.m_oRules.addElement((Object)rule);
            }
            catch (OiixInvalidDataException e) {
                OiixAssert.assertion((boolean)false, (String)("Unexpected invalid data exception encountered:" + e.getMessage()));
            }
        }
        return rule;
    }

    private Class getClassObject(String p1) {
        return this.m_oClass;
    }

    public boolean equals(Object o) {
        boolean bResult = false;
        if (o != null) {
            if (o == this) {
                bResult = true;
            } else if (o instanceof OipcrRuleSet) {
                OipcrRuleSet other = (OipcrRuleSet)o;
                bResult = this.getName().equalsIgnoreCase(other.getName());
            } else if (o instanceof String) {
                String other = (String)o;
                bResult = this.getName().equalsIgnoreCase(other);
            }
        }
        return bResult;
    }

    public int hashCode() {
        return this.m_sName.toLowerCase().hashCode();
    }
}

