/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipf.oipfg;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.Locale;
import java.util.Vector;
import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.dataSource.ArrayTwoDDataSource;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridEvent;
import oracle.ewt.grid.GridRowSelectListener;
import oracle.ewt.grid.GridSelection;
import oracle.ewt.grid.SingleRowSelection;
import oracle.ewt.header.Header;
import oracle.ewt.header.NullItemSelection;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextArea;
import oracle.ewt.meter.BoundedRangeModelImpl;
import oracle.ewt.meter.ProgressBar;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.table.TableScrollBox;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiif.oiifb.OiifbStackLayout;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipcp.OipcpIPrereqResultsSummary;
import oracle.sysman.oip.oipc.oipcp.OipcpIProgressUIListener;
import oracle.sysman.oip.oipc.oipcp.OipcpPrerequisiteCheck;
import oracle.sysman.oip.oipc.oipcp.OipcpPrerequisiteResult;
import oracle.sysman.oip.oipf.oipfg.OipfgPrereqDisplayData;
import oracle.sysman.oip.oipf.oipfg.OipfgPrereqSpreadTable;

public class OipfgPrereqProgressRemotePanel
extends LWContainer
implements GridRowSelectListener {
    private OipfgPrereqSpreadTable m_table;
    private ArrayTwoDDataSource m_dataModel;
    private ArrayOneDDataSource m_headerSource = null;
    private Vector m_vChecks;
    private static int INSET = 5;
    private int m_nFailedStartIndex = -1;
    private DetailsArea m_oDetailsArea;
    private LWContainer m_cardPanel;
    private ProgressBar m_progressbar;
    private BoundedRangeModelImpl m_oRangemodel;
    private static final String LINE = "==============================================================";
    private LWLabel m_summaryText;
    private OipcpIProgressUIListener m_oProgressUIListener;
    private OipcpIPrereqResultsSummary m_ResultSummary;
    private int m_iFailures = 0;
    private int m_iWarnings = 0;
    private int m_iRequireVerification = 0;
    private String m_ErrText = null;
    private int m_guimode = 0;

    public OipfgPrereqProgressRemotePanel(OipcpIPrereqResultsSummary vSummary) {
        this.m_ResultSummary = vSummary;
        this.m_vChecks = vSummary.getAllPrereqChecks();
    }

    public OipfgPrereqProgressRemotePanel(String text) {
        this.m_ErrText = text;
    }

    public void rowSelecting(GridEvent oGridEvent) {
    }

    public void rowSelected(GridEvent oGridEvent) {
        int selectedIndex = this.getSelectedRowIndex();
        if (selectedIndex != -1) {
            this.m_oDetailsArea.scrollToIndex(selectedIndex);
        }
    }

    public void rowDeselecting(GridEvent oGridEvent) {
    }

    public void rowDeselected(GridEvent oGridEvent) {
    }

    private void setSelectedRow(int nRowIndex, boolean bSelected) {
        Grid oGrid = this.m_table.getGrid();
        oGrid.getGridSelection().setRowSelected(nRowIndex, bSelected);
        if (bSelected) {
            oGrid.scrollRowIntoView(nRowIndex);
        }
    }

    private void setSelectedRow(int nRowIndex) {
        this.setSelectedRow(nRowIndex, true);
    }

    private int getSelectedRowIndex() {
        Grid oGrid = this.m_table.getGrid();
        int[] rows = oGrid.getGridSelection().getSelectedRows();
        return rows != null && rows.length > 0 ? rows[0] : -1;
    }

    private void setEmptySelection() {
    }

    private OipfgPrereqDisplayData getCheckData(int nRowIndex) {
        OipfgPrereqDisplayData oData = (OipfgPrereqDisplayData)this.m_dataModel.getData(0, nRowIndex);
        return oData;
    }

    private void createDataSources() {
        Object[] headerItems = new String[]{OiixResourceBundle.getString((String)"oracle.sysman.oip.oipf.oipfg.resources.OipfgRuntimeRes", (String)"OIPFG0110"), OiixResourceBundle.getString((String)"oracle.sysman.oip.oipf.oipfg.resources.OipfgRuntimeRes", (String)"OIPFG0111"), "", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipf.oipfg.resources.OipfgRuntimeRes", (String)"OIPFG0112")};
        this.m_headerSource = new ArrayOneDDataSource(headerItems);
        this.m_dataModel = new ArrayTwoDDataSource(4, this.m_vChecks.size());
        int nCount = this.m_vChecks.size();
        for (int i = 0; i < nCount; ++i) {
            OipcpPrerequisiteCheck oCheck = (OipcpPrerequisiteCheck)this.m_vChecks.elementAt(i);
            OipfgPrereqDisplayData oData = new OipfgPrereqDisplayData(oCheck);
            this.m_dataModel.setData(0, i, (Object)oData);
            this.m_dataModel.setData(3, i, (Object)oData);
            this.m_dataModel.setData(1, i, (Object)oData);
            this.m_dataModel.setData(2, i, (Object)Boolean.FALSE);
            oData.setStatus(this.getStatus(oCheck));
        }
    }

    public void createPanelComponents() {
        this.setLayout(new BorderLayout(6, 6));
        this.setBorderPainter((BorderPainter)new FixedBorderPainter(INSET, INSET, INSET, INSET));
        String sHeader = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipf.oipfg.resources.OipfgRuntimeRes", (String)"OIPFG0114");
        MultiLineLabel descLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), sHeader);
        descLabel.setPreferredAspectRatio(0.0f);
        LWContainer tablePanel = this.createChecksPanel();
        LWContainer detailsPanel = this.createDetailsPanel();
        this.add((Component)tablePanel, "Center");
        this.add((Component)detailsPanel, "South");
    }

    private LWContainer createChecksPanel() {
        LWContainer panel = new LWContainer();
        this.createDataSources();
        this.m_table = new OipfgPrereqSpreadTable((TwoDDataSource)this.m_dataModel, (OneDDataSource)this.m_headerSource, null);
        this.m_table.setScrollByRow(true);
        this.m_table.setScrollByColumn(false);
        Grid grid = this.m_table.getGrid();
        grid.addRowSelectListener((GridRowSelectListener)this);
        SingleRowSelection rowSelObj = new SingleRowSelection();
        rowSelObj.setParent(grid);
        grid.setGridSelection((GridSelection)rowSelObj);
        this.m_table.setColumnWidth(2, 20);
        this.m_table.setColumnWidth(0, 385);
        this.m_table.setColumnWidth(3, 115);
        this.m_table.setColumnWidth(1, 75);
        Header header = this.m_table.getColumnHeader();
        header.setHeaderSelection(NullItemSelection.getHeaderSelection());
        header.setCanMoveItems(false);
        header.setCanResizeItems(true);
        panel.setLayout((LayoutManager)new BorderLayout());
        LWContainer tmpPanel = new LWContainer((LayoutManager)new OiifbStackLayout(1));
        panel.add((Component)tmpPanel, (Object)"Center");
        TableScrollBox tableScroll = new TableScrollBox((Component)((Object)this.m_table), 0, 0);
        if (this.getGUImode() == 1) {
            tmpPanel.add("Top Left HEIGHT=140 WIDTH=600 ".toUpperCase(Locale.ENGLISH), (Component)tableScroll);
        } else {
            tmpPanel.add("Top Left HEIGHT=100 WIDTH=570 ".toUpperCase(Locale.ENGLISH), (Component)tableScroll);
        }
        tmpPanel.add("Top Left Wide".toUpperCase(Locale.ENGLISH), (Component)this.createProgressPanel());
        return panel;
    }

    private LWContainer createProgressPanel() {
        this.m_oRangemodel = new BoundedRangeModelImpl(0, this.m_vChecks.size(), 0);
        this.m_summaryText = new LWLabel();
        this.m_cardPanel = new LWContainer((LayoutManager)new CardLayout(INSET, INSET));
        this.m_cardPanel.add((Component)this.m_summaryText, (Object)"summary");
        return this.m_cardPanel;
    }

    private LWContainer createDetailsPanel() {
        LWContainer panel = new LWContainer((LayoutManager)new BorderLayout());
        this.m_oDetailsArea = new DetailsArea("");
        if (this.getGUImode() == 0) {
            this.m_oDetailsArea.setRows(3);
        } else {
            this.m_oDetailsArea.setRows(5);
        }
        this.m_oDetailsArea.setTextWrapper(WordWrapper.getTextWrapper());
        this.m_oDetailsArea.setEditable(false);
        ScrollBox scroll = new ScrollBox((Component)((Object)this.m_oDetailsArea), 2, 1);
        this.m_oDetailsArea.setScrollBox(scroll);
        panel.add((Component)scroll, (Object)"Center");
        return panel;
    }

    public void updateStatus() {
        int numRows = this.m_dataModel.getRowCount();
        for (int i = 0; i < numRows; ++i) {
            OipfgPrereqDisplayData oData = (OipfgPrereqDisplayData)this.m_dataModel.getData(0, i);
            this.m_dataModel.setData(2, i, (Object)Boolean.TRUE);
            String sMsg = oData.getTitle();
            this.m_oDetailsArea.append(System.getProperty("\n"));
            this.m_oDetailsArea.append(sMsg);
            this.m_oDetailsArea.append(System.getProperty("\n"));
            this.m_oDetailsArea.append(LINE);
            this.m_oDetailsArea.append(oData.getResultText());
            this.incrementProgress();
        }
        this.m_iRequireVerification = this.m_ResultSummary.getUserVerifyCount();
        this.m_iFailures = this.m_ResultSummary.getFailedCount();
        this.m_iWarnings = this.m_ResultSummary.getWarningsCount();
        this.m_summaryText.setText(this.getSummaryText());
    }

    private void incrementProgress() {
        this.m_oRangemodel.setValue(this.m_oRangemodel.getValue() + 1);
    }

    private int getStatus(OipcpPrerequisiteCheck oCheck) {
        OipcpPrerequisiteResult oResult = oCheck.getResult();
        int status = 0;
        switch (oResult.getResult()) {
            case 7: {
                if (oCheck.isRequired()) {
                    status = 3;
                    break;
                }
                status = 6;
                break;
            }
            case 3: {
                status = 4;
                break;
            }
            case 1: {
                status = 2;
            }
        }
        return status;
    }

    private String getSummaryText() {
        if (this.m_iFailures > 0) {
            if (this.m_iWarnings > 0) {
                Object[] sArgs = new String[]{new Integer(this.m_iFailures).toString(), new Integer(this.m_iWarnings).toString(), new Integer(this.m_iRequireVerification).toString()};
                return OiixResourceBundle.getString((String)"oracle.sysman.oip.oipf.oipfg.resources.OipfgRuntimeRes", (String)"OIPFG0130", (Object[])sArgs);
            }
            Object[] sArgs = new String[]{new Integer(this.m_iFailures).toString(), new Integer(this.m_iRequireVerification).toString()};
            return OiixResourceBundle.getString((String)"oracle.sysman.oip.oipf.oipfg.resources.OipfgRuntimeRes", (String)"OIPFG0126", (Object[])sArgs);
        }
        if (this.m_iWarnings > 0) {
            Object[] sArgs = new String[]{new Integer(this.m_iWarnings).toString(), new Integer(this.m_iRequireVerification).toString()};
            return OiixResourceBundle.getString((String)"oracle.sysman.oip.oipf.oipfg.resources.OipfgRuntimeRes", (String)"OIPFG0131", (Object[])sArgs);
        }
        Object[] sArgs = new String[]{new Integer(this.m_iRequireVerification).toString()};
        return OiixResourceBundle.getString((String)"oracle.sysman.oip.oipf.oipfg.resources.OipfgRuntimeRes", (String)"OIPFG0127", (Object[])sArgs);
    }

    public void setLabelForFailingNode() {
        this.setLayout(new BorderLayout(6, 6));
        this.setBorderPainter((BorderPainter)new FixedBorderPainter(INSET, INSET, INSET, INSET));
        LWContainer panel2 = new LWContainer();
        panel2.setLayout((LayoutManager)new BorderLayout());
        LWLabel mErrText = new LWLabel(this.m_ErrText);
        panel2.add((Component)mErrText, (Object)"North");
        this.add((Component)panel2, "North");
    }

    public int getGUImode() {
        return this.m_guimode;
    }

    public void setGUImode(int mode) {
        this.m_guimode = mode;
    }

    private class DetailsArea
    extends LWTextArea {
        private ScrollBox m_scrollPane;
        private Point[] m_scrollPoints;
        private Object m_lock;

        DetailsArea(String sText) {
            super(sText);
            this.m_lock = new Object();
            this.m_scrollPoints = new Point[OipfgPrereqProgressRemotePanel.this.m_dataModel.getRowCount()];
        }

        public DetailsArea(String sText, int rows, int columns) {
            super(sText, rows, columns);
            this.m_lock = new Object();
            this.m_scrollPoints = new Point[OipfgPrereqProgressRemotePanel.this.m_dataModel.getRowCount()];
        }

        public Object getLock() {
            return this.m_lock;
        }

        void setScrollBox(ScrollBox scrollBox) {
            this.m_scrollPane = scrollBox;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startOutput(int nIndex) {
            OipfgPrereqDisplayData oData = OipfgPrereqProgressRemotePanel.this.getCheckData(nIndex);
            String sMsg = oData.getTitle() + System.getProperty("line.separator", "\n");
            Object object = this.getLock();
            synchronized (object) {
                this.append(sMsg);
            }
            this.updateScrollPointForCheck(nIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void endOutput(int nIndex) {
            OipfgPrereqDisplayData oData = OipfgPrereqProgressRemotePanel.this.getCheckData(nIndex);
            Object object = this.getLock();
            synchronized (object) {
                this.append("==============================================================\n\n");
            }
        }

        private void updateScrollPointForCheck(int nIndex) {
            Point p;
            this.m_scrollPoints[nIndex] = p = this.m_scrollPane.getScrollPosition();
        }

        void scrollToIndex(int nIndex) {
            Point p = this.m_scrollPoints[nIndex];
            if (p != null) {
                this.m_scrollPane.setScrollPosition(p);
            }
        }
    }
}

