/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWPasswordField;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;

public class OiMultiItemPanel
extends OiifpWizPanel {
    public static final String POPDOWN = "POPDOWN";
    public static final String SECURE = "SECURE";
    public static final String TEXTFIELD = "TEXTFIELD";
    private static final int INSETS = 5;
    private static final String DEFAULT_TITLE = OiStdDialogRes.getString("MultiItem_DefaultTitle");
    private static final String DEFAULT_PROMPT = OiStdDialogRes.getString("MultiItem_DefaultPrompt");
    private GridBagLayout gridbag;
    private GridBagConstraints c;
    private MultiLineLabel _prompt = new MultiLineLabel(WordWrapper.getTextWrapper(), DEFAULT_PROMPT);
    private LWLabel[] _labels;
    private LWComponent[] _items;
    private String[] _choices;
    private Color _promptColor;
    private Color _itemColor;

    public OiMultiItemPanel() {
        super(DEFAULT_TITLE);
        this.mainPanel.add((Component)this._prompt, (Object)"North");
        this.gridbag = new GridBagLayout();
        this.dlgPanel.setLayout((LayoutManager)this.gridbag);
        this.c = new GridBagConstraints();
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.anchor = 18;
        this.c.fill = 2;
        this._labels = new LWLabel[0];
        this._items = new LWComponent[0];
        this._choices = new String[0];
        this._promptColor = this._prompt.getBackground();
        this._itemColor = this.getBackground();
        this.validate();
    }

    public String getPrompt() {
        return this._prompt.getText();
    }

    public String[] getLabels() {
        int n = this._labels.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this._labels[i].getText();
        }
        return stringArray;
    }

    public String[] getSelections() {
        int n = this._items.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            LWComponent lWComponent = this._items[i];
            if (lWComponent instanceof LWChoice) {
                stringArray[i] = ((LWChoice)lWComponent).getSelectedItem();
                continue;
            }
            if (lWComponent instanceof LWPasswordField) {
                stringArray[i] = ((LWPasswordField)lWComponent).getText();
                continue;
            }
            if (!(lWComponent instanceof LWTextField)) continue;
            stringArray[i] = ((LWTextField)lWComponent).getText();
        }
        return stringArray;
    }

    public String[] getTypes() {
        int n = this._items.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            LWComponent lWComponent = this._items[i];
            if (lWComponent instanceof LWChoice) {
                stringArray[i] = POPDOWN;
                continue;
            }
            if (lWComponent instanceof LWPasswordField) {
                stringArray[i] = SECURE;
                continue;
            }
            if (!(lWComponent instanceof LWTextField)) continue;
            stringArray[i] = TEXTFIELD;
        }
        return stringArray;
    }

    public String[] getChoices() {
        return this._choices;
    }

    public void setPrompt(String string) {
        this.invalidate();
        this._prompt.setText(string);
        this.validate();
    }

    public void setLabels(String[] stringArray) {
        this.removeLabels();
        if (stringArray != null) {
            this._labels = new LWLabel[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = i == stringArray.length - 1;
                this._labels[i] = new LWLabel(stringArray[i]);
                this.addLabel(this._labels[i], i, bl);
            }
            this.updateLabelsAssociation();
        }
    }

    private void removeLabels() {
        this.invalidate();
        if (this._labels != null) {
            for (int i = 0; i < this._labels.length; ++i) {
                this.dlgPanel.remove((Component)this._labels[i]);
            }
            this._labels = new LWLabel[0];
        }
        this.validate();
    }

    private void addLabel(LWLabel lWLabel, int n, boolean bl) {
        this.invalidate();
        this.c.weighty = bl ? 1.0 : 0.0;
        this.c.gridx = 0;
        this.c.gridy = n;
        this.c.weightx = 0.01;
        this.c.gridwidth = 1;
        this.gridbag.setConstraints((Component)lWLabel, this.c);
        this.dlgPanel.add((Component)lWLabel);
        this.validate();
    }

    public void setTypes(String[] stringArray) {
        this.removeItems();
        if (stringArray != null) {
            this._items = new LWComponent[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = i == stringArray.length - 1;
                this._items[i] = this.createComponent(stringArray[i]);
                this.addItem(this._items[i], i, bl);
            }
            this.refreshChoices();
            this.updateLabelsAssociation();
        }
    }

    private void removeItems() {
        this.invalidate();
        if (this._items != null) {
            for (int i = 0; i < this._items.length; ++i) {
                this.dlgPanel.remove((Component)this._items[i]);
            }
            this._items = new LWComponent[0];
        }
        this.validate();
    }

    private LWComponent createComponent(String string) {
        Object object = null;
        object = string.equalsIgnoreCase(POPDOWN) ? new LWChoice() : (string.equalsIgnoreCase(SECURE) ? new LWPasswordField() : new LWTextField());
        return object;
    }

    public boolean isProtected(String string) {
        if (string.equalsIgnoreCase("Selections")) {
            for (LWComponent lWComponent : this._items) {
                if (!(lWComponent instanceof LWPasswordField)) continue;
                return true;
            }
        }
        return false;
    }

    private void addItem(LWComponent lWComponent, int n, boolean bl) {
        this.invalidate();
        this.c.weighty = bl ? 1.0 : 0.0;
        this.c.gridx = 1;
        this.c.gridy = n;
        this.c.weightx = 0.99;
        this.c.gridwidth = 0;
        this.gridbag.setConstraints((Component)lWComponent, this.c);
        this.dlgPanel.add((Component)lWComponent);
        this.validate();
    }

    public void setSelections(String[] stringArray) {
        int n = this._items.length;
        if (stringArray.length < this._items.length) {
            n = stringArray.length;
        }
        for (int i = 0; i < n; ++i) {
            LWComponent lWComponent = this._items[i];
            if (lWComponent instanceof LWChoice) {
                ((LWChoice)lWComponent).select(stringArray[i]);
                continue;
            }
            if (lWComponent instanceof LWPasswordField) {
                ((LWPasswordField)lWComponent).setText(stringArray[i]);
                continue;
            }
            if (!(lWComponent instanceof LWTextField)) continue;
            ((LWTextField)lWComponent).setText(stringArray[i]);
        }
    }

    public void setChoices(String[] stringArray) {
        this._choices = stringArray;
        this.refreshChoices();
    }

    private void refreshChoices() {
        int n;
        LWChoice lWChoice = null;
        for (n = 0; n < this._items.length; ++n) {
            if (!(this._items[n] instanceof LWChoice)) continue;
            lWChoice = (LWChoice)this._items[n];
            break;
        }
        if (lWChoice != null && this._choices != null) {
            this.invalidate();
            lWChoice.removeAll();
            for (n = 0; n < this._choices.length; ++n) {
                lWChoice.addItem(this._choices[n]);
            }
            this.validate();
        }
    }

    public void markPrompt() {
        this._prompt.setBackground(this._markColor);
    }

    public void markLabels() {
        for (int i = 0; i < this._labels.length; ++i) {
            this._labels[i].setBackground(this._markColor);
        }
    }

    public void markTypes() {
        for (int i = 0; i < this._items.length; ++i) {
            this._items[i].setBackground(this._markColor);
        }
    }

    public void markSelections() {
        this.markTypes();
    }

    public void markChoices() {
        for (int i = 0; i < this._items.length; ++i) {
            if (!(this._items[i] instanceof LWChoice)) continue;
            this._items[i].setBackground(this._markColor);
            break;
        }
    }

    public void unmarkPrompt() {
        this._prompt.setBackground(this._promptColor);
    }

    public void unmarkLabels() {
        for (int i = 0; i < this._labels.length; ++i) {
            this._labels[i].setBackground(this._itemColor);
        }
    }

    public void unmarkTypes() {
        for (int i = 0; i < this._items.length; ++i) {
            this._items[i].setBackground(this._itemColor);
        }
    }

    public void unmarkSelections() {
        this.unmarkTypes();
    }

    public void unmarkChoices() {
        for (int i = 0; i < this._items.length; ++i) {
            if (!(this._items[i] instanceof LWChoice)) continue;
            this._items[i].setBackground(this._itemColor);
            break;
        }
    }

    private void updateLabelsAssociation() {
        if (this._labels != null && this._items != null) {
            int n = this._labels.length;
            if (this._items.length < this._labels.length) {
                n = this._items.length;
            }
            for (int i = 0; i < n; ++i) {
                this._labels[i].setLabelFor((Component)this._items[i]);
            }
        }
    }
}

