/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import oracle.bali.share.nls.StringUtils;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWList;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiif.oiifm.OiifmMnemonicOps;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiSingleSelectPanel
extends OiifpWizPanel {
    private static final int INSETS = 5;
    private static final int NUM_VISIBLE = 10;
    private static final int MAX_RADIO_ITEMS = 5;
    private static final String DEFAULT_TITLE = OiStdDialogRes.getString("SingleSelect_DefaultTitle");
    private static final String DEFAULT_PROMPT = OiStdDialogRes.getString("SingleSelect_DefaultPrompt");
    private MultiLineLabel _textLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), DEFAULT_PROMPT);
    private LWList _list;
    private LWCheckbox[] _radio;
    private MultiLineLabel[] _radioDesc;
    private LWCheckboxGroup _radioButtonGroup;
    private GridBagLayout gridbag;
    private GridBagConstraints c;
    private boolean _isList;
    private String[] _choices;
    private String[] _choiceDescriptions;
    private Color _textLabelColor;
    private Color _listColor;
    private Color _radioColor;

    public OiSingleSelectPanel() {
        super(DEFAULT_TITLE);
        this._textLabel.setPreferredAspectRatio(0.0f);
        this.mainPanel.add((Component)this._textLabel, (Object)"North");
        this.gridbag = new GridBagLayout();
        this.dlgPanel.setLayout((LayoutManager)this.gridbag);
        this.c = new GridBagConstraints();
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.fill = 2;
        this.c.anchor = 18;
        this.c.gridwidth = 0;
        this.c.weightx = 1.0;
        this._textLabelColor = this._textLabel.getBackground();
        this._listColor = this.getBackground();
        this._radioColor = this.getBackground();
        this.validate();
    }

    public void setDescriptions(String[] stringArray) {
        this._choiceDescriptions = stringArray;
        if (this._choices != null) {
            this.updatePanel();
        }
    }

    public void setChoices(String[] stringArray) {
        this._choices = stringArray;
        this.updatePanel();
    }

    private void updatePanel() {
        this.invalidate();
        this.removeChoices();
        if (this._choices != null) {
            int n = this._choices.length;
            if (n > 5) {
                this._isList = true;
                this.c.weighty = 1.0;
                this.c.anchor = 18;
                this._list = new LWList(10, false);
                this.gridbag.setConstraints((Component)this._list, this.c);
                for (int i = 0; i < n; ++i) {
                    this._list.add(StringUtils.stripMnemonic((String)this._choices[i]));
                }
                this.dlgPanel.add((Component)this._list);
            } else {
                TextWrapper textWrapper = WordWrapper.getTextWrapper();
                Font font = new Font(OiixResourceBundle.getFont(), 0, 11);
                Font font2 = new Font(OiixResourceBundle.getFont(), 0, 14);
                this._isList = false;
                this.c.anchor = 18;
                this.c.fill = 1;
                this.c.insets.top = 0;
                this.c.insets.left = 0;
                this.c.insets.bottom = 10;
                this._radioButtonGroup = new LWCheckboxGroup();
                this._radio = new LWCheckbox[n];
                this._radioDesc = new MultiLineLabel[n];
                for (int i = 0; i < n; ++i) {
                    this._radio[i] = new LWCheckbox(this._choices[i], this._radioButtonGroup, false);
                    OiifmMnemonicOps.processMnemonic((LWCheckbox)this._radio[i]);
                    this._radio[i].setFont(font2);
                    String string = this.getDescription(i);
                    this._radio[i].getAccessibleContext().setAccessibleDescription(string);
                    this.c.insets.top = 5;
                    this.c.insets.left = 0;
                    this.c.insets.bottom = 5;
                    this.c.weighty = 0.0;
                    this.gridbag.setConstraints((Component)this._radio[i], this.c);
                    this.dlgPanel.add((Component)this._radio[i]);
                    this.c.weightx = 1.0;
                    this.c.insets.top = 0;
                    this.c.insets.left = 15;
                    this.c.insets.bottom = 5;
                    this.c.gridwidth = 0;
                    this._radioDesc[i] = new MultiLineLabel(textWrapper, string);
                    this._radioDesc[i].setPreferredAspectRatio(0.0f);
                    this._radioDesc[i].setFont(font);
                    this.c.weighty = i == n - 1 ? 1.0 : 0.0;
                    this.gridbag.setConstraints((Component)this._radioDesc[i], this.c);
                    this.dlgPanel.add((Component)this._radioDesc[i]);
                }
            }
            if (n > 0) {
                this.setSelectedIndex(new Integer(0));
            }
        }
        this.validate();
    }

    private String getDescription(int n) {
        if (this._choiceDescriptions == null || this._choiceDescriptions.length < n) {
            return "";
        }
        return this._choiceDescriptions[n].trim();
    }

    private void removeChoices() {
        if (this._isList) {
            if (this._list != null) {
                this.dlgPanel.remove((Component)this._list);
                this._list = null;
            }
        } else {
            int n;
            if (this._radio != null) {
                for (n = 0; n < this._radio.length; ++n) {
                    this.dlgPanel.remove((Component)this._radio[n]);
                }
                this._radio = null;
            }
            if (this._radioDesc != null) {
                for (n = 0; n < this._radioDesc.length; ++n) {
                    if (this._radioDesc[n] == null) continue;
                    this.dlgPanel.remove((Component)this._radioDesc[n]);
                }
                this._radioDesc = null;
            }
        }
    }

    public String[] getChoices() {
        return this._choices;
    }

    public String[] getDescriptions() {
        return this._choiceDescriptions;
    }

    public void setSelectedIndex(Integer n) {
        if (n != null) {
            int n2 = n;
            if (this._isList) {
                this._list.select(n2);
            } else if (this._radio != null && this._radio.length > n2 && n2 >= 0) {
                this._radioButtonGroup.setSelectedCheckbox(this._radio[n2]);
            }
        }
    }

    public Integer getSelectedIndex() {
        if (this._isList) {
            return new Integer(this._list.getSelectedIndex());
        }
        if (this._radio != null) {
            LWCheckbox lWCheckbox = this._radioButtonGroup.getSelectedCheckbox();
            for (int i = 0; i < this._radio.length; ++i) {
                if (!this._radio[i].equals(lWCheckbox)) continue;
                return new Integer(i);
            }
        }
        return new Integer(-1);
    }

    public String getPrompt() {
        return this._textLabel.getText();
    }

    public void setPrompt(String string) {
        this.invalidate();
        this._textLabel.setText(string);
        this.validate();
    }

    public void markPrompt() {
        this._textLabel.setBackground(this._markColor);
    }

    public void unmarkPrompt() {
        this._textLabel.setBackground(this._textLabelColor);
    }

    public void markChoices() {
        if (this._list != null) {
            this._list.setBackground(this._markColor);
        }
        if (this._radio != null) {
            int n = this._radio.length;
            for (int i = 0; i < n; ++i) {
                this._radio[i].setBackground(this._markColor);
            }
        }
        if (this._list == null && this._radio == null) {
            this.dlgPanel.setBackground(this._markColor);
        }
    }

    public void unmarkChoices() {
        this.dlgPanel.setBackground(Color.white);
        if (this._list != null) {
            this._list.setBackground(this._listColor);
        }
        if (this._radio != null) {
            int n = this._radio.length;
            for (int i = 0; i < n; ++i) {
                this._radio[i].setBackground(this._radioColor);
            }
        }
    }

    public void markSelectedIndex() {
        this.markChoices();
    }

    public void unmarkSelectedIndex() {
        this.unmarkChoices();
    }
}

